/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.screenrecording;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.screenrecording.BaseScreenRecordingOptions;
import io.appium.java_client.screenrecording.ScreenRecordingUploadOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public abstract class BaseStartScreenRecordingOptions<T extends BaseStartScreenRecordingOptions<T>>
extends BaseScreenRecordingOptions<BaseStartScreenRecordingOptions<T>> {
    private Boolean forceRestart;
    private Duration timeLimit;

    @Override
    public T withUploadOptions(ScreenRecordingUploadOptions uploadOptions) {
        return (T)((BaseStartScreenRecordingOptions)super.withUploadOptions(uploadOptions));
    }

    public T withTimeLimit(Duration timeLimit) {
        this.timeLimit = (Duration)Preconditions.checkNotNull((Object)timeLimit);
        return (T)this;
    }

    public T enableForcedRestart() {
        this.forceRestart = true;
        return (T)this;
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.build());
        Optional.ofNullable(this.timeLimit).map(x -> builder.put((Object)"timeLimit", (Object)x.getSeconds()));
        Optional.ofNullable(this.forceRestart).map(x -> builder.put((Object)"forceRestart", x));
        return builder.build();
    }
}

