/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.google.api.client.auth.oauth.OAuthHmacSigner;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.auth.oauth.OAuthRsaSigner;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.http.GenericUrl;
import com.kms.katalon.core.model.SSLClientCertificateSettings;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.impl.HttpFormDataBodyContent;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.webservice.common.HttpUtil;
import com.kms.katalon.core.webservice.common.PrivateKeyReader;
import com.kms.katalon.core.webservice.common.Requestor;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public abstract class BasicRequestor
implements Requestor {
    protected String projectDir;
    protected ProxyInformation proxyInformation;
    protected WebServiceSettingStore settingStore;

    public BasicRequestor(String projectDir, ProxyInformation proxyInformation) {
        this.projectDir = projectDir;
        this.proxyInformation = proxyInformation;
    }

    @Override
    public ResponseObject send(RequestObject requestObject) throws Exception {
        HttpUriRequest httpRequest = this.buildHttpRequest(requestObject);
        long startTime = System.currentTimeMillis();
        HttpResponse httpResponse = HttpUtil.sendRequest(httpRequest, requestObject.isFollowRedirects(), this.proxyInformation, requestObject.getConnectionTimeout(), requestObject.getSocketTimeout(), requestObject.getMaxResponseSize(), this.getSslCertificateOption(), this.getSSLSettings(), requestObject.getRequestAuthorization());
        long waitingTime = System.currentTimeMillis() - startTime;
        ResponseObject responseObject = this.toResponseObject(httpResponse);
        responseObject.setWaitingTime(waitingTime);
        return responseObject;
    }

    protected abstract HttpUriRequest buildHttpRequest(RequestObject var1) throws Exception;

    protected SSLCertificateOption getSslCertificateOption() throws IOException {
        return this.getSettingStore().getSSLCertificateOption();
    }

    protected SSLClientCertificateSettings getSSLSettings() throws IOException {
        return this.getSettingStore().getClientCertificateSettings();
    }

    protected void setHttpConnectionHeaders(HttpRequest httpRequest, RequestObject request) throws GeneralSecurityException, IOException {
        List<TestObjectProperty> headers = this.getRequestHeaders(request);
        headers.forEach(header -> {
            if (request.getBodyContent() instanceof HttpFormDataBodyContent && header.getName().equalsIgnoreCase("Content-Type")) {
                httpRequest.addHeader(header.getName(), request.getBodyContent().getContentType());
            } else {
                httpRequest.addHeader(header.getName(), header.getValue());
            }
        });
    }

    protected List<TestObjectProperty> getRequestHeaders(RequestObject request) throws GeneralSecurityException, IOException {
        ArrayList<TestObjectProperty> headers = new ArrayList<TestObjectProperty>(request.getHttpHeaderProperties());
        List<TestObjectProperty> complexAuthAttributes = request.getHttpHeaderProperties().stream().filter(header -> StringUtils.startsWith((String)header.getName(), (String)"Authorization:")).collect(Collectors.toList());
        if (!complexAuthAttributes.isEmpty()) {
            headers.removeAll(complexAuthAttributes);
            String authorizationValue = BasicRequestor.generateAuthorizationHeader(this.getRequestUrl(request), complexAuthAttributes, request);
            if (!authorizationValue.isEmpty()) {
                headers.add(new TestObjectProperty("Authorization", ConditionType.EQUALS, authorizationValue));
            }
        }
        return headers;
    }

    private String getRequestUrl(RequestObject request) {
        return StringUtils.equals((String)request.getServiceType(), (String)"RESTful") ? request.getRestUrl() : request.getWsdlAddress();
    }

    private static String generateAuthorizationHeader(String requestUrl, List<TestObjectProperty> complexAuthAttributes, RequestObject request) throws GeneralSecurityException, IOException {
        Map<String, String> map = complexAuthAttributes.stream().collect(Collectors.toMap(TestObjectProperty::getName, TestObjectProperty::getValue));
        String authType = map.get("Authorization:type");
        if (StringUtils.isBlank((String)authType)) {
            return "";
        }
        if ("OAuth 1.0".equals(authType)) {
            if (StringUtils.equals((String)request.getServiceType(), (String)"SOAP")) {
                return BasicRequestor.createOAuth1AuthorizationHeaderValue(requestUrl, map, "POST");
            }
            return BasicRequestor.createOAuth1AuthorizationHeaderValue(requestUrl, map, request.getRestRequestMethod());
        }
        return "";
    }

    public static String createOAuth1AuthorizationHeaderValue(String requestUrl, Map<String, String> map, String requestMethod) throws GeneralSecurityException, IOException {
        String realm;
        String tokenSecret;
        String consumerSecret;
        OAuthParameters params = new OAuthParameters();
        params.consumerKey = map.getOrDefault("Authorization:oauth_consumer_key", "");
        String signatureMethod = map.getOrDefault("Authorization:oauth_signature_method", "");
        OAuthSigner signer = BasicRequestor.getSigner(signatureMethod, consumerSecret = map.getOrDefault("Authorization:oauth_consumer_secret", ""), tokenSecret = map.getOrDefault("Authorization:oauth_token_secret", ""));
        if (signer == null) {
            return "";
        }
        params.signer = signer;
        params.computeNonce();
        params.computeTimestamp();
        params.version = "1.0";
        String token = map.getOrDefault("Authorization:oauth_token", "");
        if (StringUtils.isNotBlank((String)token)) {
            params.token = token;
        }
        if (StringUtils.isNotBlank((String)(realm = map.getOrDefault("Authorization:realm", "")))) {
            params.realm = realm;
        }
        params.computeSignature(requestMethod, new GenericUrl(requestUrl));
        return params.getAuthorizationHeader();
    }

    private static OAuthSigner getSigner(String signatureMethod, String consumerSecret, String tokenSecret) throws IOException, GeneralSecurityException {
        if (StringUtils.equals((String)signatureMethod, (String)"HMAC-SHA1")) {
            OAuthHmacSigner signer = new OAuthHmacSigner();
            signer.clientSharedSecret = consumerSecret;
            if (StringUtils.isNotBlank((String)tokenSecret)) {
                signer.tokenSharedSecret = tokenSecret;
            }
            return signer;
        }
        if (StringUtils.equals((String)signatureMethod, (String)"RSA-SHA1")) {
            OAuthRsaSigner signer = new OAuthRsaSigner();
            signer.privateKey = PrivateKeyReader.getPrivateKey(consumerSecret);
            return signer;
        }
        return null;
    }

    protected ResponseObject toResponseObject(HttpResponse httpResponse) {
        long startTime = System.currentTimeMillis();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        long contentDownloadTime = 0L;
        String responseBody = "";
        long bodyLength = 0L;
        HttpEntity responseEntity = httpResponse.getEntity();
        if (responseEntity != null) {
            bodyLength = responseEntity.getContentLength();
            startTime = System.currentTimeMillis();
            try {
                responseBody = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                responseBody = ExceptionUtils.getFullStackTrace((Throwable)e);
            }
            contentDownloadTime = System.currentTimeMillis() - startTime;
        }
        long headerLength = WebServiceCommonHelper.calculateHeaderLength(httpResponse);
        ResponseObject responseObject = new ResponseObject(responseBody);
        responseObject.setContentType(this.getResponseContentType(httpResponse));
        responseObject.setHeaderFields(this.getResponseHeaderFields(httpResponse));
        responseObject.setStatusCode(statusCode);
        responseObject.setResponseBodySize(bodyLength);
        responseObject.setResponseHeaderSize(headerLength);
        responseObject.setContentDownloadTime(contentDownloadTime);
        this.setResponseBodyContent(httpResponse, responseBody, responseObject);
        return responseObject;
    }

    protected void setResponseBodyContent(HttpResponse httpResponse, String responseBody, ResponseObject responseObject) {
        String contentTypeHeader;
        String contentType = contentTypeHeader = this.getResponseContentType(httpResponse);
        String charset = "UTF-8";
        if (contentTypeHeader != null && contentTypeHeader.contains(";")) {
            contentType = contentTypeHeader.split(";")[0].trim();
            int charsetIdx = contentTypeHeader.lastIndexOf("charset=");
            if (charsetIdx >= 0) {
                int separatorIdx = StringUtils.indexOf((String)contentTypeHeader, (String)";", (int)charsetIdx);
                if (separatorIdx < 0) {
                    separatorIdx = contentTypeHeader.length();
                }
                charset = contentTypeHeader.substring(charsetIdx + "charset=".length(), separatorIdx).trim().replace("\"", "");
            }
        }
        HttpTextBodyContent textBodyContent = new HttpTextBodyContent(responseBody, charset, contentType);
        responseObject.setBodyContent((HttpBodyContent)textBodyContent);
        responseObject.setContentCharset(charset);
    }

    protected String getResponseContentType(HttpResponse httpResponse) {
        Header contentTypeHeader = httpResponse.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    protected Map<String, List<String>> getResponseHeaderFields(HttpResponse httpResponse) {
        Header[] headers;
        HashMap<String, List<String>> headerFields = new HashMap<String, List<String>>();
        Header[] headerArray = headers = httpResponse.getAllHeaders();
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String name = header.getName();
            if (!headerFields.containsKey(name)) {
                headerFields.put(name, new ArrayList());
            }
            ((List)headerFields.get(name)).add(header.getValue());
            ++n2;
        }
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine != null) {
            headerFields.put("#status#", Arrays.asList(String.valueOf(statusLine)));
        }
        return headerFields;
    }

    public WebServiceSettingStore getSettingStore() {
        if (this.settingStore == null) {
            this.settingStore = WebServiceSettingStore.create(this.projectDir);
        }
        return this.settingStore;
    }

    public void setSettingStore(WebServiceSettingStore store) {
        this.settingStore = store;
    }
}

