/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarPostDataParam;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.core.har.HarTimings;
import net.lightbody.bmp.exception.UnsupportedCharsetException;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import org.apache.commons.lang3.StringUtils;

public class HarConverter {
    private Har har;
    private HarEntry harEntry;
    private HarRequest harRequest;
    private HarResponse harResponse;
    private Date startTime;
    private Date endTime;

    public void initHarFile() {
        this.har = new Har();
        this.har.setLog(new HarLog());
        this.harEntry = new HarEntry();
        this.har.getLog().addEntry(this.harEntry);
        this.startTime = new Date();
    }

    public Har endHar(RequestObject request, ResponseObject response) {
        this.endTime = new Date();
        if (request != null) {
            this.convertToHarRequest(request);
        }
        if (response != null) {
            this.convertToHarResponse(response);
        }
        this.captureHarTimings(this.startTime, this.endTime);
        return this.har;
    }

    private void convertToHarRequest(RequestObject request) {
        this.harRequest = this.createHarRequest(request);
        this.harEntry.setRequest(this.harRequest);
        this.captureQueryParameters(request);
        this.captureRequestHeaders(request);
        if (this.requestHasBody(request)) {
            this.captureRequestContent(request);
        }
    }

    private void convertToHarResponse(ResponseObject response) {
        this.harResponse = new HarResponse(response.getStatusCode(), "", "");
        this.harEntry.setResponse(this.harResponse);
        this.captureResponseMimeType(response);
        this.captureResponseHeaders(response);
        this.captureResponseHeaderSize(response);
        this.captureResponseContent(response);
        this.captureResponseBodySize(response);
    }

    private void captureHarTimings(Date startTime, Date endTime) {
        this.harEntry.setStartedDateTime(startTime);
        HarTimings timings = new HarTimings();
        timings.setConnect(endTime.getTime() - startTime.getTime(), TimeUnit.MILLISECONDS);
        this.harEntry.setTimings(timings);
    }

    private HarRequest createHarRequest(RequestObject request) {
        String url = this.getUrl(request);
        String requestMethod = this.getRequestMethod(request);
        return new HarRequest(requestMethod, url, "");
    }

    private String getUrl(RequestObject request) {
        if ("SOAP".equals(request.getServiceType())) {
            return request.getWsdlAddress();
        }
        return request.getRestUrl();
    }

    private String getRequestMethod(RequestObject request) {
        if ("SOAP".equals(request.getServiceType())) {
            return request.getSoapRequestMethod();
        }
        return request.getRestRequestMethod();
    }

    private void captureQueryParameters(RequestObject request) {
        String url = this.getUrl(request);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(url, StandardCharsets.UTF_8);
        try {
            for (Map.Entry entry : queryStringDecoder.parameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    this.harEntry.getRequest().getQueryString().add(new HarNameValuePair((String)entry.getKey(), value));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.harEntry.setComment("Unable to decode query parameters on URI: " + url);
        }
    }

    private void captureRequestHeaders(RequestObject request) {
        List headers = request.getHttpHeaderProperties();
        for (TestObjectProperty header : headers) {
            this.harEntry.getRequest().getHeaders().add(new HarNameValuePair(header.getName(), header.getValue()));
        }
    }

    private boolean requestHasBody(RequestObject request) {
        boolean hasBody = false;
        hasBody = "SOAP".equals(request.getServiceType()) ? !StringUtils.isBlank((CharSequence)request.getSoapBody()) : request.getBodyContent() != null;
        return hasBody;
    }

    private void captureRequestContent(RequestObject request) {
        Charset charset;
        String contentType = this.findContentTypeHeader(request.getHttpHeaderProperties());
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = "application/octet-stream";
        }
        HarPostData postData = new HarPostData();
        this.harEntry.getRequest().setPostData(postData);
        postData.setMimeType(contentType);
        boolean urlEncoded = contentType.startsWith("application/x-www-form-urlencoded");
        try {
            charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader((String)contentType);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return;
        }
        if (charset == null) {
            charset = BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
        }
        byte[] requestContentByteArray = this.getRequestContentByteArray(request);
        if (urlEncoded) {
            String textContents = BrowserMobHttpUtil.getContentAsString((byte[])requestContentByteArray, (Charset)charset);
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(textContents, charset, false);
            ArrayList<HarPostDataParam> postDataParams = new ArrayList<HarPostDataParam>();
            for (Map.Entry entry : queryStringDecoder.parameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    postDataParams.add(new HarPostDataParam((String)entry.getKey(), value));
                }
            }
            this.harEntry.getRequest().getPostData().setParams(postDataParams);
        } else {
            String postBody = BrowserMobHttpUtil.getContentAsString((byte[])requestContentByteArray, (Charset)charset);
            this.harEntry.getRequest().getPostData().setText(postBody);
        }
    }

    private byte[] getRequestContentByteArray(RequestObject request) {
        if ("SOAP".equals(request.getServiceType())) {
            return request.getSoapBody().getBytes(StandardCharsets.UTF_8);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            request.getBodyContent().writeTo((OutputStream)os);
            return os.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    private String findContentTypeHeader(List<TestObjectProperty> headers) {
        return headers.stream().filter(h -> h.getName().startsWith("Content-Type")).findAny().map(h -> h.getValue()).orElse(null);
    }

    private void captureResponseMimeType(ResponseObject response) {
        String contentType = response.getContentType();
        if (!StringUtils.isBlank((CharSequence)contentType)) {
            this.harEntry.getResponse().getContent().setMimeType(contentType);
        }
    }

    private void captureResponseHeaderSize(ResponseObject response) {
        this.harEntry.getResponse().setHeadersSize(response.getResponseHeaderSize());
    }

    private void captureResponseHeaders(ResponseObject response) {
        for (Map.Entry entry : response.getHeaderFields().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.harEntry.getResponse().getHeaders().add(new HarNameValuePair((String)entry.getKey(), value));
            }
        }
    }

    private void captureResponseContent(ResponseObject response) {
        Charset charset;
        String contentType = response.getContentType();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = "application/octet-stream";
        }
        try {
            charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader((String)contentType);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return;
        }
        if (charset == null) {
            charset = BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            response.getBodyContent().writeTo((OutputStream)os);
        }
        catch (IOException iOException) {
            return;
        }
        String text = BrowserMobHttpUtil.getContentAsString((byte[])os.toByteArray(), (Charset)charset);
        this.harEntry.getResponse().getContent().setText(text);
        this.harEntry.getResponse().getContent().setSize((long)os.toByteArray().length);
    }

    private void captureResponseBodySize(ResponseObject response) {
        this.harEntry.getResponse().setBodySize(response.getResponseBodySize());
    }
}

