/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.control.ImageButton;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.testcase.ast.dialogs.IAstDialogBuilder;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapEntryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.framework.FrameworkUtil;

public class WindowsTestObjectBuilderDialog
extends TreeEntitySelectionDialog
implements IAstDialogBuilder {
    private static final InputValueType[] defaultInputValueTypes = new InputValueType[]{InputValueType.Variable, InputValueType.GlobalVariable};
    private static final InputValueType[] defaultVariableInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Map);
    private static final String DEFAULT_VARIABLE_NAME = "variable";
    private static final String pluginId = FrameworkUtil.getBundle(WindowsTestObjectBuilderDialog.class).getSymbolicName();
    private static final String OBJECT_FINDER_TAB_NAME = TreeEntityUtil.getReadableKeywordName((String)InputValueType.WindowsObject.getName());
    private static final String[] TEST_OBJECT_TABS = new String[]{OBJECT_FINDER_TAB_NAME, ComposerTestcaseMessageConstants.DIA_TAB_OTHER};
    private WindowsTestObjectBuilderDialog _instance;
    private TableViewer tableViewer;
    private ExpressionWrapper objectExpressionWrapper;
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean haveOtherTypes;
    private StackLayout stackLayout;
    private Composite objectFinderComposite;
    private Composite otherTypesInputTableComposite;
    private Composite comboComposite;
    private Composite testObjectVariablesComposite;
    private Combo combo;
    private Label lblVariables;
    private Composite compositeVariables;
    private Composite compositeVariablesDetails;
    private StackLayout compositeVariablesDetailsLayout;
    private ImageButton btnExpandVariablesComposite;
    private TableViewer variableTableViewer;
    private MapExpressionWrapper variableMaps = null;
    private WindowsElementEntity initialSelectedTestObject = null;
    private WindowsElementEntity selectedWebElement = null;
    private List<MapEntryExpressionWrapper> initialVariableMapEntries = null;
    private boolean isVariablesCompositeExpanded = true;
    private Listener layoutExecutionCompositeListener = new Listener(){

        public void handleEvent(Event event) {
            WindowsTestObjectBuilderDialog.this.isVariablesCompositeExpanded = !WindowsTestObjectBuilderDialog.this.isVariablesCompositeExpanded;
            WindowsTestObjectBuilderDialog.this.layoutExecutionInfo();
        }
    };
    private ITestCasePart testCasePart;

    public WindowsTestObjectBuilderDialog(Shell parentShell, ExpressionWrapper objectExpressionWrapper, boolean haveOtherTypes) {
        super(parentShell, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new WindowsTreeEntityViewerFilter(new EntityProvider()));
        this._instance = this;
        this.haveOtherTypes = haveOtherTypes;
        this.objectExpressionWrapper = objectExpressionWrapper.clone();
        this.initVariableMap();
        this.setAllowMultiple(false);
        this.setShellStyle(0x10860 | WindowsTestObjectBuilderDialog.getDefaultOrientation());
        try {
            this.setInput(TreeEntityUtil.getChildren(null, (FolderEntity)FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject())));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.refreshSelectionTree();
        this.initialVariableMapEntries = new ArrayList<MapEntryExpressionWrapper>(this.variableMaps != null ? this.variableMaps.getMapEntryExpressions() : new ArrayList());
    }

    public void setTestCasePart(ITestCasePart testCasePart) {
        this.testCasePart = testCasePart;
    }

    public ITestCasePart getTestCasePart() {
        return this.testCasePart;
    }

    private void initVariableMap() {
        if (!this.isObjectExpressionFindTestObjectMethodCall()) {
            return;
        }
        MethodCallExpressionWrapper methodCallObjectExpression = (MethodCallExpressionWrapper)this.objectExpressionWrapper;
        if (methodCallObjectExpression.getArguments().getExpressions().size() <= 1) {
            this.variableMaps = new MapExpressionWrapper((ASTNodeWrapper)methodCallObjectExpression.getArguments());
            return;
        }
        ExpressionWrapper secondParam = methodCallObjectExpression.getArguments().getExpressions().get(1);
        if (!(secondParam instanceof MapExpressionWrapper)) {
            this.variableMaps = new MapExpressionWrapper((ASTNodeWrapper)methodCallObjectExpression.getArguments());
            return;
        }
        this.variableMaps = (MapExpressionWrapper)secondParam;
    }

    protected void refreshSelectionTree() {
        String testObjectId = null;
        if (this.isObjectExpressionFindTestObjectMethodCall()) {
            testObjectId = AstEntityInputUtil.findWindowsTestObjectIdFromFindTestObjectMethodCall((MethodCallExpressionWrapper)this.objectExpressionWrapper);
        }
        if (testObjectId == null) {
            return;
        }
        WindowsElementEntity selectedWebElement = null;
        FolderEntity objectRepositoryRoot = null;
        try {
            selectedWebElement = WindowsElementController.getInstance().getWindowsElementByDisplayId(testObjectId);
            objectRepositoryRoot = FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (selectedWebElement == null || objectRepositoryRoot == null) {
            return;
        }
        this.setInitialSelection(new WindowsElementTreeEntity(selectedWebElement, WindowsTestObjectBuilderDialog.createSelectedTreeEntityHierachy(selectedWebElement.getParentFolder(), objectRepositoryRoot)));
        this.initialSelectedTestObject = selectedWebElement;
    }

    private void createTopCompiste(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        topComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.comboComposite = new Composite(topComposite, 0);
        this.comboComposite.setLayout((Layout)new GridLayout(2, false));
        Label comboLabel = new Label(this.comboComposite, 0);
        comboLabel.setText(ComposerTestcaseMessageConstants.DIA_COL_OBJ_TYPE);
        this.combo = new Combo(this.comboComposite, 4);
        this.combo.setItems(TEST_OBJECT_TABS);
        this.comboComposite.setVisible(this.haveOtherTypes);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createTopCompiste(container);
        Composite stackComposite = new Composite(container, 0);
        WindowsTestObjectBuilderDialog.applyDialogFont((Control)stackComposite);
        this.stackLayout = new StackLayout();
        stackComposite.setLayout((Layout)this.stackLayout);
        stackComposite.setLayoutData((Object)new GridData(1808));
        this.objectFinderComposite = new Composite(stackComposite, 0);
        this.objectFinderComposite.setLayout((Layout)new GridLayout(1, false));
        TreeViewer treeViewer = this.createTreeViewer(this.objectFinderComposite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (TreeEntityUtil.isValidTreeEntitySelectionType((Object[])selection, (String)StringConstants.TREE_OBJECT_TYPE_NAME)) {
                    return new Status(0, pluginId, 0, null, null);
                }
                return new Status(4, pluginId, 4, null, null);
            }
        });
        treeWidget.setEnabled(true);
        this.createVariableComposite();
        this.stackLayout.topControl = this.objectFinderComposite;
        if (this.haveOtherTypes) {
            this.createOtherTypesTab(stackComposite);
            if (this.isObjectExpressionFindTestObjectMethodCall()) {
                this.combo.select(0);
                this.stackLayout.topControl = this.objectFinderComposite;
            } else {
                this.combo.select(1);
                this.stackLayout.topControl = this.otherTypesInputTableComposite;
            }
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof TreeSelection)) {
                    return;
                }
                TreeSelection treeSelection = (TreeSelection)event.getSelection();
                Object selection = treeSelection.getFirstElement();
                if (!(selection instanceof ITreeEntity)) {
                    return;
                }
                if (!(selection instanceof WindowsElementTreeEntity)) {
                    WindowsTestObjectBuilderDialog.this.selectedWebElement = null;
                    WindowsTestObjectBuilderDialog.this.compositeVariablesDetailsLayout.topControl = null;
                } else {
                    WindowsElementEntity webElement;
                    try {
                        webElement = ((WindowsElementTreeEntity)selection).getObject();
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        return;
                    }
                    WindowsElementEntity previousSelectedElement = WindowsTestObjectBuilderDialog.this.selectedWebElement;
                    WindowsTestObjectBuilderDialog.this.selectedWebElement = webElement;
                    if (previousSelectedElement == WindowsTestObjectBuilderDialog.this.selectedWebElement) {
                        return;
                    }
                    WindowsTestObjectBuilderDialog.this.changeVariablesCompositeForSelectedEntity((WindowsElementTreeEntity)selection);
                }
            }
        });
        this.refresh();
        return container;
    }

    private void createVariableComposite() {
        this.compositeVariables = new Composite(this.objectFinderComposite, 0);
        this.compositeVariables.setBackground(ColorUtil.getCompositeBackgroundColor());
        GridLayout glCompositeExecution = new GridLayout(1, true);
        glCompositeExecution.verticalSpacing = 0;
        glCompositeExecution.horizontalSpacing = 0;
        glCompositeExecution.marginHeight = 0;
        glCompositeExecution.marginWidth = 0;
        this.compositeVariables.setLayout((Layout)glCompositeExecution);
        this.compositeVariables.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeExecutionCompositeHeader = new Composite(this.compositeVariables, 0);
        compositeExecutionCompositeHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeExecutionCompositeHeader = new GridLayout(3, false);
        glCompositeExecutionCompositeHeader.marginHeight = 0;
        glCompositeExecutionCompositeHeader.marginWidth = 0;
        compositeExecutionCompositeHeader.setLayout((Layout)glCompositeExecutionCompositeHeader);
        compositeExecutionCompositeHeader.setCursor(compositeExecutionCompositeHeader.getDisplay().getSystemCursor(21));
        compositeExecutionCompositeHeader.setCursor(compositeExecutionCompositeHeader.getDisplay().getSystemCursor(21));
        this.btnExpandVariablesComposite = new ImageButton(compositeExecutionCompositeHeader, 0);
        this.redrawBtnExpandExecutionInfo();
        this.lblVariables = new Label(compositeExecutionCompositeHeader, 0);
        this.lblVariables.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblVariables.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.lblVariables.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_LABEL);
        this.lblVariables.addListener(3, this.layoutExecutionCompositeListener);
        this.btnExpandVariablesComposite.addListener(3, this.layoutExecutionCompositeListener);
        this.compositeVariablesDetails = new Composite(this.compositeVariables, 0);
        this.compositeVariablesDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.compositeVariablesDetailsLayout = new StackLayout();
        this.compositeVariablesDetails.setLayout((Layout)this.compositeVariablesDetailsLayout);
        this.testObjectVariablesComposite = this.createTestObjectVariablesComposite(this.compositeVariablesDetails);
    }

    private void changeVariablesCompositeForSelectedEntity(WindowsElementTreeEntity treeEntity) {
        WindowsElementEntity entity;
        try {
            entity = treeEntity.getObject();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return;
        }
        this.changeVariablesCompositeForTestObject(entity);
        this.compositeVariablesDetails.getParent().layout(true, true);
    }

    private void changeVariablesCompositeForTestObject(WindowsElementEntity entity) {
        this.variableMaps.clearExpressions();
        if (this.initialSelectedTestObject == entity) {
            List<MapEntryExpressionWrapper> variableMapEntries = this.initialVariableMapEntries.stream().map(MapEntryExpressionWrapper::clone).collect(Collectors.toList());
            this.variableMaps.addExpressions(variableMapEntries);
        }
        this.compositeVariablesDetailsLayout.topControl = this.testObjectVariablesComposite;
        this.variableTableViewer.refresh();
    }

    private Composite createTestObjectVariablesComposite(Composite parent) {
        Composite composite = new Composite(this.compositeVariablesDetails, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(composite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddVariable = new ToolItem(toolBar, 0);
        tltmAddVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsTestObjectBuilderDialog.this.addVariable();
            }
        });
        tltmAddVariable.setText(GlobalMessageConstants.ADD);
        tltmAddVariable.setImage(ImageConstants.IMG_16_ADD);
        final ToolItem tltmRemove = new ToolItem(toolBar, 0);
        tltmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsTestObjectBuilderDialog.this.removeVariables();
            }
        });
        tltmRemove.setText(GlobalMessageConstants.DELETE);
        tltmRemove.setImage(ImageConstants.IMG_16_REMOVE);
        tltmRemove.setEnabled(false);
        ToolItem tltmClear = new ToolItem(toolBar, 0);
        tltmClear.setText(GlobalMessageConstants.CLEAR);
        tltmClear.setImage(ImageConstants.IMG_16_CLEAR);
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsTestObjectBuilderDialog.this.clearVariables();
            }
        });
        this.variableTableViewer = new TableViewer(composite, 67586);
        ColumnViewerUtil.setTableActivation((TableViewer)this.variableTableViewer);
        this.variableTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tltmRemove.setEnabled(!WindowsTestObjectBuilderDialog.this.variableTableViewer.getSelection().isEmpty());
            }
        });
        Table table = this.variableTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        GridData variableTableLayoutData = new GridData(4, 4, true, true, 1, 1);
        variableTableLayoutData.minimumHeight = 100;
        table.setLayoutData((Object)variableTableLayoutData);
        TableViewerColumn tableViewerColumnParamType = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnParamType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.variableTableViewer, defaultVariableInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getKeyExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getKeyExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getKeyExpression());
            }
        });
        TableColumn tblclmnParamType = tableViewerColumnParamType.getColumn();
        tblclmnParamType.setWidth(100);
        tblclmnParamType.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_PARAM_TYPE);
        tableViewerColumnParamType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnName.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.variableTableViewer){

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return false;
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getKeyExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getKeyExpression());
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getKeyExpression());
            }
        });
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return "";
            }
        });
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(100);
        tblclmnName.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_PARAM);
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.variableTableViewer, defaultVariableInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getValueExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getValueExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getValueExpression());
            }
        });
        TableColumn tblclmnValueType = tableViewerColumnValueType.getColumn();
        tblclmnValueType.setWidth(100);
        tblclmnValueType.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_VALUE_TYPE);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.variableTableViewer, 0);
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.variableTableViewer){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getValueExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getValueExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getValueExpression());
            }
        });
        TableColumn tblclmnValue = tableViewerColumnValue.getColumn();
        tblclmnValue.setWidth(200);
        tblclmnValue.setText(ComposerTestcaseMessageConstants.OBJECT_VARIABLE_TABLE_COL_VALUE);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return "";
            }
        });
        this.variableTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.variableTableViewer.setInput(this.variableMaps != null ? this.variableMaps.getMapEntryExpressions() : Collections.emptyMap());
        return composite;
    }

    private void layoutExecutionInfo() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                WindowsTestObjectBuilderDialog.this.compositeVariablesDetails.setVisible(WindowsTestObjectBuilderDialog.this.isVariablesCompositeExpanded);
                ((GridData)WindowsTestObjectBuilderDialog.this.compositeVariablesDetails.getLayoutData()).exclude = !WindowsTestObjectBuilderDialog.this.isVariablesCompositeExpanded;
                WindowsTestObjectBuilderDialog.this.compositeVariables.layout(true, true);
                WindowsTestObjectBuilderDialog.this.compositeVariables.getParent().layout();
                WindowsTestObjectBuilderDialog.this.redrawBtnExpandExecutionInfo();
                this.showSelectedTestObject();
            }

            private void showSelectedTestObject() {
                ITreeSelection selection = WindowsTestObjectBuilderDialog.this.getTreeViewer().getStructuredSelection();
                if (selection != null) {
                    WindowsTestObjectBuilderDialog.this.getTreeViewer().getTree().showSelection();
                }
            }
        });
    }

    private void redrawBtnExpandExecutionInfo() {
        this.btnExpandVariablesComposite.getParent().setRedraw(false);
        if (this.isVariablesCompositeExpanded) {
            this.btnExpandVariablesComposite.setImage(ImageConstants.IMG_16_ARROW_DOWN);
        } else {
            this.btnExpandVariablesComposite.setImage(ImageConstants.IMG_16_ARROW);
        }
        this.btnExpandVariablesComposite.getParent().setRedraw(true);
    }

    private void clearVariables() {
        this.variableMaps.clearExpressions();
        this.variableTableViewer.refresh();
    }

    private void removeVariables() {
        StructuredSelection selection = (StructuredSelection)this.variableTableViewer.getSelection();
        Object[] selectionElements = selection.toArray();
        if (selectionElements.length == 0) {
            return;
        }
        Object[] objectArray = selectionElements;
        int n = selectionElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof MapEntryExpressionWrapper) {
                this.variableMaps.removeExpression((MapEntryExpressionWrapper)object);
            }
            ++n2;
        }
        this.variableTableViewer.refresh();
    }

    private void addVariable() {
        MapEntryExpressionWrapper newMapEntry = new MapEntryExpressionWrapper((ASTNodeWrapper)this.variableMaps);
        newMapEntry.setKeyExpression(new ConstantExpressionWrapper(this.generateNewPropertyName(), (ASTNodeWrapper)newMapEntry));
        newMapEntry.setValueExpression(new ConstantExpressionWrapper("", (ASTNodeWrapper)newMapEntry));
        this.variableMaps.addExpression(newMapEntry);
        this.variableTableViewer.refresh();
    }

    private String generateNewPropertyName() {
        String name = DEFAULT_VARIABLE_NAME;
        int index = 0;
        boolean isUnique = false;
        String newName = name;
        while (!isUnique) {
            isUnique = true;
            for (MapEntryExpressionWrapper mapEntry : this.variableMaps.getMapEntryExpressions()) {
                if (!(mapEntry.getKeyExpression() instanceof ConstantExpressionWrapper) || !newName.equals(((ConstantExpressionWrapper)mapEntry.getKeyExpression()).getValue())) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                return newName;
            }
            newName = String.valueOf(name) + "_" + index;
            ++index;
        }
        return newName;
    }

    private boolean isObjectExpressionFindTestObjectMethodCall() {
        return this.objectExpressionWrapper instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)this.objectExpressionWrapper).isFindWindowsObjectMethodCall();
    }

    private void createOtherTypesTab(Composite parent) {
        this.otherTypesInputTableComposite = new Composite(parent, 0);
        this.otherTypesInputTableComposite.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(this.otherTypesInputTableComposite, 67586);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.createTableColumns(parent);
        this.addSwitchTypeComboListener(parent);
    }

    private void addSwitchTypeComboListener(final Composite parent) {
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = WindowsTestObjectBuilderDialog.this.combo.getSelectionIndex();
                if (index < 0 || index >= TEST_OBJECT_TABS.length) {
                    return;
                }
                String tabName = TEST_OBJECT_TABS[index];
                ExpressionWrapper newExpression = null;
                if (tabName.equals(OBJECT_FINDER_TAB_NAME)) {
                    newExpression = (ExpressionWrapper)InputValueType.WindowsObject.getNewValue(WindowsTestObjectBuilderDialog.this.objectExpressionWrapper.getParent());
                    WindowsTestObjectBuilderDialog.this.stackLayout.topControl = WindowsTestObjectBuilderDialog.this.objectFinderComposite;
                } else {
                    newExpression = (ExpressionWrapper)defaultInputValueTypes[0].getNewValue(WindowsTestObjectBuilderDialog.this.objectExpressionWrapper.getParent());
                    WindowsTestObjectBuilderDialog.this.stackLayout.topControl = WindowsTestObjectBuilderDialog.this.otherTypesInputTableComposite;
                    WindowsTestObjectBuilderDialog.this.setSelectionResult(null);
                }
                newExpression.copyProperties(WindowsTestObjectBuilderDialog.this.objectExpressionWrapper);
                WindowsTestObjectBuilderDialog.this.objectExpressionWrapper = newExpression;
                WindowsTestObjectBuilderDialog.this.refresh();
                parent.layout();
            }
        });
    }

    private void createTableColumns(Composite parent) {
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, defaultInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                if (!(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= this.inputValueTypes.length) {
                    return;
                }
                ASTNodeWrapper newAstNode = this.getNewAstNode(value, WindowsTestObjectBuilderDialog.this.objectExpressionWrapper);
                if (newAstNode == null || !(newAstNode instanceof ExpressionWrapper)) {
                    return;
                }
                newAstNode.copyProperties(WindowsTestObjectBuilderDialog.this.objectExpressionWrapper);
                WindowsTestObjectBuilderDialog.this.objectExpressionWrapper = (ExpressionWrapper)newAstNode;
                WindowsTestObjectBuilderDialog.this.refresh();
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValue.getColumn().setText(GlobalMessageConstants.VALUE);
        tableViewerColumnValue.getColumn().setWidth(300);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider());
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer));
    }

    private static FolderTreeEntity createSelectedTreeEntityHierachy(FolderEntity folderEntity, FolderEntity rootFolder) {
        if (folderEntity == null || folderEntity.equals((Object)rootFolder)) {
            return null;
        }
        return new FolderTreeEntity(folderEntity, (ITreeEntity)WindowsTestObjectBuilderDialog.createSelectedTreeEntityHierachy(folderEntity.getParentFolder(), rootFolder));
    }

    public void refresh() {
        if (!this.haveOtherTypes) {
            return;
        }
        ArrayList<ExpressionWrapper> objectExpressionWrapperList = new ArrayList<ExpressionWrapper>();
        objectExpressionWrapperList.add(this.objectExpressionWrapper);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(objectExpressionWrapperList);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btnOK = this.createButton(parent, 102, IDialogConstants.OK_LABEL, true);
        btnOK.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WindowsTestObjectBuilderDialog.this.okPressed();
                WindowsTestObjectBuilderDialog.this._instance.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void convertSelectionToObjectMethodCall() {
        if (!(this.getFirstResult() instanceof WindowsElementTreeEntity)) {
            return;
        }
        WindowsElementTreeEntity webElementTreeEntity = (WindowsElementTreeEntity)this.getFirstResult();
        String objectPk = null;
        try {
            if (!(webElementTreeEntity.getObject() instanceof WindowsElementEntity)) {
                return;
            }
            objectPk = webElementTreeEntity.getObject().getIdForDisplay();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (objectPk == null) {
            return;
        }
        try {
            MethodCallExpressionWrapper newMethodCall = AstEntityInputUtil.createNewFindWindowsObjectMethodCall(objectPk, this.objectExpressionWrapper.getParent());
            newMethodCall.copyProperties(this.objectExpressionWrapper);
            if (this.variableMaps != null && this.variableMaps.getMapEntryExpressions().size() > 0) {
                newMethodCall.getArguments().addExpression(this.variableMaps);
            }
            this.objectExpressionWrapper = newMethodCall;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    @Override
    public ExpressionWrapper getReturnValue() {
        if (this.stackLayout.topControl == this.objectFinderComposite) {
            this.convertSelectionToObjectMethodCall();
        }
        return this.objectExpressionWrapper;
    }

    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_TEST_OBJ_INPUT;
    }

    public static class WindowsTreeEntityViewerFilter
    extends EntityViewerFilter {
        public WindowsTreeEntityViewerFilter(EntityProvider entityProvider) {
            super(entityProvider);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof WebElementTreeEntity) {
                return false;
            }
            return super.select(viewer, parentElement, element);
        }
    }
}

