/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.expr.Expression;

public class AnnotationNodeWrapper
extends ASTNodeWrapper {
    private ClassNodeWrapper classNode;
    private Map<String, ExpressionWrapper> members = new HashMap<String, ExpressionWrapper>();

    public AnnotationNodeWrapper(Class<?> type, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.classNode = new ClassNodeWrapper(type, (ASTNodeWrapper)this);
    }

    public AnnotationNodeWrapper(AnnotationNodeWrapper annotationNodeWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(annotationNodeWrapper, parentNodeWrapper);
        this.classNode = new ClassNodeWrapper(annotationNodeWrapper.getClassNode(), (ASTNodeWrapper)this);
        this.members.clear();
        for (Map.Entry<String, ExpressionWrapper> member : annotationNodeWrapper.getMembers().entrySet()) {
            this.members.put(member.getKey(), member.getValue().copy(this));
        }
    }

    public AnnotationNodeWrapper(AnnotationNode annotationNode, ASTNodeWrapper parentNodeWrapper) {
        super((ASTNode)annotationNode, parentNodeWrapper);
        this.classNode = ClassNodeWrapper.getClassWrapper(annotationNode.getClassNode(), this);
        if (annotationNode.getMembers() == null || annotationNode.getMembers().isEmpty()) {
            return;
        }
        for (Map.Entry member : annotationNode.getMembers().entrySet()) {
            this.members.put((String)member.getKey(), ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression((Expression)member.getValue(), this));
        }
    }

    public ClassNodeWrapper getClassNode() {
        return this.classNode;
    }

    public void setClassNode(ClassNodeWrapper classNode) {
        if (classNode == null) {
            return;
        }
        classNode.setParent(this);
        this.classNode = classNode;
    }

    public Map<String, ExpressionWrapper> getMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.classNode.getName());
        if (!this.hasMembers()) {
            return stringBuilder.toString();
        }
        stringBuilder.append("(");
        stringBuilder.append(StringUtils.join(Iterables.transform(this.members.entrySet(), (Function)new Function<Map.Entry<String, ExpressionWrapper>, String>(){

            public String apply(Map.Entry<String, ExpressionWrapper> member) {
                return String.valueOf(member.getKey()) + " = " + member.getValue();
            }
        }).iterator(), (String)","));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean hasMembers() {
        return this.members != null && !this.members.isEmpty();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> children = new ArrayList<ASTNodeWrapper>();
        children.add(this.classNode);
        if (!this.hasMembers()) {
            return children;
        }
        children.addAll(this.members.values());
        return children;
    }

    @Override
    public AnnotationNodeWrapper clone() {
        return new AnnotationNodeWrapper(this, this.getParent());
    }
}

