/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeWrapper;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ImportNodeCollection {
    private List<ImportNodeWrapper> importNodes = new ArrayList<ImportNodeWrapper>();
    private Map<String, Set<String>> importedAliasNamesForClassFullName = new HashMap<String, Set<String>>();
    private Map<String, String> importedClassNameForAlias = new HashMap<String, String>();
    private Map<String, ImportNodeWrapper> importedNodeForClassFullName = new HashMap<String, ImportNodeWrapper>();

    public List<ImportNodeWrapper> getImportNodes() {
        return this.importNodes;
    }

    public void setImportNodes(List<ImportNodeWrapper> importNodes) {
        this.importNodes = importNodes;
    }

    public boolean hasAlias(String qualifiedName) {
        return this.getBestMatchForAliasName(qualifiedName) != null;
    }

    public boolean isImported(String aliasName) {
        return this.importedClassNameForAlias.get(aliasName) != null;
    }

    public String getQualifierForAlias(String aliasName) {
        return this.importedClassNameForAlias.get(aliasName);
    }

    public String getBestMatchForAliasName(String qualifier) {
        Set<String> aliasNames = this.getAliasNames(qualifier);
        if (aliasNames.isEmpty()) {
            return null;
        }
        int size = aliasNames.size();
        return aliasNames.toArray(new String[size])[size - 1];
    }

    public void clear() {
        this.importNodes.clear();
        this.importedAliasNamesForClassFullName.clear();
        this.importedClassNameForAlias.clear();
        this.importedNodeForClassFullName.clear();
    }

    public void addImportNode(ImportNodeWrapper newImportWrapper) {
        if (this.importNodes.contains(newImportWrapper)) {
            return;
        }
        this.importNodes.add(newImportWrapper);
        ImportNodeEntry entry = this.analyze(newImportWrapper);
        if (entry == null) {
            return;
        }
        String qualifiedName = entry.getQualifiedName();
        Set<String> aliasNames = this.getAliasNames(qualifiedName);
        String newAliasName = entry.getAliasName();
        aliasNames.add(newAliasName);
        this.importedAliasNamesForClassFullName.put(qualifiedName, aliasNames);
        this.importedClassNameForAlias.put(newAliasName, qualifiedName);
        this.importedNodeForClassFullName.put(qualifiedName, newImportWrapper);
    }

    public Class<?> resolve(String qualifiedName) {
        ImportNodeWrapper wrapper = this.importedNodeForClassFullName.get(qualifiedName);
        if (wrapper == null) {
            return null;
        }
        Class<?> typeClass = wrapper.getType().getTypeClass();
        String fieldName = wrapper.getFieldName();
        if (ImportNodeStatistics.evaluate(wrapper) != ImportNodeStatistics.SIMPLE_STATIC_IMPORT && StringUtils.isEmpty((String)fieldName)) {
            return typeClass;
        }
        return AstKeywordsInputUtil.getFirstAccessibleMethodReturnType(typeClass, fieldName, true);
    }

    private Set<String> getAliasNames(String qualifiedName) {
        Set<String> aliasNames = this.importedAliasNamesForClassFullName.get(qualifiedName);
        if (aliasNames == null) {
            aliasNames = new LinkedHashSet<String>();
            this.importedAliasNamesForClassFullName.put(qualifiedName, aliasNames);
        }
        return aliasNames;
    }

    public ImportNodeEntry analyze(ImportNodeWrapper newImportWrapper) {
        if (newImportWrapper == null) {
            return null;
        }
        switch (ImportNodeStatistics.evaluate(newImportWrapper)) {
            case SIMPLE_IMPORT: {
                return new ImportNodeEntry(newImportWrapper.getClassName(), newImportWrapper.getKnownAlias());
            }
            case SIMPLE_STATIC_IMPORT: {
                return new ImportNodeEntry(String.valueOf(newImportWrapper.getClassName()) + "." + newImportWrapper.getFieldName(), newImportWrapper.getKnownAlias());
            }
        }
        return null;
    }

    private class ImportNodeEntry {
        private final String qualifiedName;
        private final String aliasName;

        public ImportNodeEntry(String qualifiedName, String aliasName) {
            this.qualifiedName = qualifiedName;
            this.aliasName = aliasName;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }
    }

    private static enum ImportNodeStatistics {
        SIMPLE_IMPORT,
        SIMPLE_STATIC_IMPORT,
        STAR_IMPORT,
        STATIC_STAR_IMPORT;


        private static ImportNodeStatistics evaluate(ImportNodeWrapper newImportWrapper) {
            if (newImportWrapper.isStatic() && newImportWrapper.isStar()) {
                return STATIC_STAR_IMPORT;
            }
            if (newImportWrapper.isStar()) {
                return STAR_IMPORT;
            }
            if (newImportWrapper.isStatic()) {
                return SIMPLE_STATIC_IMPORT;
            }
            return SIMPLE_IMPORT;
        }
    }
}

