/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTHasBlock;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ClosureExpressionWrapper
extends ExpressionWrapper
implements ASTHasBlock {
    private static final String UNKNOWN = "<unknown>";
    private ParameterWrapper[] parameters;
    private BlockStatementWrapper code;

    public ClosureExpressionWrapper(ParameterWrapper[] parameters, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.parameters = parameters;
        this.code = new BlockStatementWrapper(this);
        this.type = ClassNodeWrapper.getClassWrapper(ClassHelper.CLOSURE_TYPE, this);
    }

    public ClosureExpressionWrapper(ClosureExpression closureExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)closureExpression, parentNodeWrapper);
        if (closureExpression.getParameters() != null) {
            this.parameters = new ParameterWrapper[closureExpression.getParameters().length];
            int i = 0;
            while (i < closureExpression.getParameters().length) {
                this.parameters[i] = new ParameterWrapper(closureExpression.getParameters()[i], (ASTNodeWrapper)this);
                ++i;
            }
        }
        this.initCodeBlock(closureExpression);
    }

    private void initCodeBlock(ClosureExpression closureExpression) {
        Statement statementCode = closureExpression.getCode();
        if (statementCode instanceof BlockStatement) {
            this.code = new BlockStatementWrapper((BlockStatement)statementCode, (ASTNodeWrapper)this);
            return;
        }
        this.code = new BlockStatementWrapper(this);
        this.code.addStatement(ASTNodeWrapHelper.getStatementNodeWrapperFromStatement(statementCode, this));
    }

    public ClosureExpressionWrapper(ClosureExpressionWrapper closureExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(closureExpressionWrapper, parentNodeWrapper);
        this.parameters = new ParameterWrapper[closureExpressionWrapper.getParameters().length];
        int i = 0;
        while (i < closureExpressionWrapper.getParameters().length) {
            this.parameters[i] = new ParameterWrapper(closureExpressionWrapper.getParameters()[i], (ASTNodeWrapper)this);
            ++i;
        }
        this.code = new BlockStatementWrapper(closureExpressionWrapper.getBlock(), (ASTNodeWrapper)this);
    }

    @Override
    public String getText() {
        String paramText = ClosureExpressionWrapper.getParametersText(this.parameters);
        if (paramText.length() > 0) {
            return "{ " + paramText + " -> ... }";
        }
        return "{ -> ... }";
    }

    public ParameterWrapper[] getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        ParameterWrapper[] parameterWrapperArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterWrapper parameter = parameterWrapperArray[n2];
            astNodeWrappers.add(parameter);
            ++n2;
        }
        astNodeWrappers.add(this.code);
        return astNodeWrappers;
    }

    @Override
    public BlockStatementWrapper getBlock() {
        return this.code;
    }

    @Override
    public ClosureExpressionWrapper clone() {
        return new ClosureExpressionWrapper(this, this.getParent());
    }

    private static String getParameterText(ParameterWrapper node) {
        String type;
        if (node == null) {
            return UNKNOWN;
        }
        String name = node.getName() == null ? UNKNOWN : node.getName();
        String string = type = node.getType() == null || node.getType().getName() == null ? UNKNOWN : node.getType().getName();
        if (node.getInitialExpression() != null) {
            return String.valueOf(type) + " " + name + " = " + node.getInitialExpression().getText();
        }
        return String.valueOf(type) + " " + name;
    }

    private static String getParametersText(ParameterWrapper[] parameters) {
        if (parameters == null) {
            return "";
        }
        if (parameters.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int max = parameters.length;
        int x = 0;
        while (x < max) {
            result.append(ClosureExpressionWrapper.getParameterText(parameters[x]));
            if (x < max - 1) {
                result.append(", ");
            }
            ++x;
        }
        return result.toString();
    }

    public void setParameters(ParameterWrapper[] array) {
        this.parameters = array;
    }

    public void setBlock(BlockStatementWrapper blockStatementWrapper) {
        this.code = blockStatementWrapper;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof ClosureExpressionWrapper)) {
            return false;
        }
        ClosureExpressionWrapper closureExpressionWrapper = (ClosureExpressionWrapper)input;
        this.setParameters(closureExpressionWrapper.getParameters());
        this.setBlock(closureExpressionWrapper.getBlock());
        return true;
    }
}

