/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;

public class MapEntryExpressionWrapper
extends ExpressionWrapper {
    private ExpressionWrapper keyExpression;
    private ExpressionWrapper valueExpression;

    public MapEntryExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.keyExpression = new ConstantExpressionWrapper("", (ASTNodeWrapper)this);
        this.valueExpression = new ConstantExpressionWrapper("", (ASTNodeWrapper)this);
    }

    public MapEntryExpressionWrapper(ExpressionWrapper keyExpression, ExpressionWrapper valueExpression, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.setKeyExpression(keyExpression);
        this.setValueExpression(valueExpression);
    }

    public MapEntryExpressionWrapper(MapEntryExpression expression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)expression, parentNodeWrapper);
        this.keyExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression.getKeyExpression(), this);
        this.valueExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression.getValueExpression(), this);
    }

    public MapEntryExpressionWrapper(MapEntryExpressionWrapper mapEntryExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(mapEntryExpressionWrapper, parentNodeWrapper);
        this.copyMapEntryProperties(mapEntryExpressionWrapper);
    }

    private void copyMapEntryProperties(MapEntryExpressionWrapper mapEntryExpressionWrapper) {
        this.keyExpression = mapEntryExpressionWrapper.getKeyExpression().copy(this);
        this.valueExpression = mapEntryExpressionWrapper.getValueExpression().copy(this);
    }

    public ExpressionWrapper getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(ExpressionWrapper keyExpression) {
        if (keyExpression == null) {
            return;
        }
        keyExpression.setParent(this);
        this.keyExpression = keyExpression;
    }

    public ExpressionWrapper getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(ExpressionWrapper valueExpression) {
        if (valueExpression == null) {
            return;
        }
        valueExpression.setParent(this);
        this.valueExpression = valueExpression;
    }

    @Override
    public String getText() {
        return String.valueOf(this.keyExpression.getText()) + ":" + this.valueExpression.getText();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.keyExpression);
        astNodeWrappers.add(this.valueExpression);
        return astNodeWrappers;
    }

    @Override
    public MapEntryExpressionWrapper clone() {
        return new MapEntryExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof MapEntryExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyMapEntryProperties((MapEntryExpressionWrapper)input);
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (!(newChild instanceof ExpressionWrapper) || !(oldChild instanceof ExpressionWrapper)) {
            return false;
        }
        ExpressionWrapper originalExpression = (ExpressionWrapper)oldChild;
        ExpressionWrapper newExpression = (ExpressionWrapper)newChild;
        if (this.getKeyExpression() == originalExpression) {
            this.setKeyExpression(newExpression);
            return true;
        }
        if (this.getValueExpression() == originalExpression) {
            this.setValueExpression(newExpression);
            return true;
        }
        return false;
    }
}

