/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ImportNodeCollection;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.checkpoint.CheckpointFactory;
import com.kms.katalon.core.testcase.TestCaseFactory;
import com.kms.katalon.core.testdata.TestDataFactory;
import com.kms.katalon.core.testobject.ObjectRepository;
import com.kms.katalon.custom.keyword.KeywordClass;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.openqa.selenium.Keys;

public class MethodCallExpressionWrapper
extends ExpressionWrapper {
    public static final String TO_STRING_METHOD_NAME = "toString";
    public static final String THIS_VARIABLE = "this";
    public static final String CALL_TEST_CASE_METHOD_NAME = "callTestCase";
    public static final String FIND_TEST_CASE_METHOD_NAME = "findTestCase";
    public static final String FIND_TEST_DATA_METHOD_NAME = "findTestData";
    public static final String FIND_TEST_OBJECT_METHOD_NAME = "findTestObject";
    public static final String FIND_WINDOWS_OBJECT_METHOD_NAME = "findWindowsObject";
    public static final String FIND_CHECKPOINT_METHOD_NAME = "findCheckpoint";
    public static final String GET_VALUE_METHOD_NAME = "getValue";
    public static final String KEYS_CHORDS_METHOD_NAME = "chord";
    private ExpressionWrapper objectExpression;
    private ExpressionWrapper method;
    private ArgumentListExpressionWrapper arguments;
    private boolean spreadSafe = false;
    private boolean safe = false;

    public MethodCallExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        this(THIS_VARIABLE, TO_STRING_METHOD_NAME, parentNodeWrapper);
    }

    public MethodCallExpressionWrapper(String classSimpleName, String method, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.objectExpression = new VariableExpressionWrapper(classSimpleName, (ASTNodeWrapper)this);
        this.method = new ConstantExpressionWrapper(method, (ASTNodeWrapper)this);
        this.arguments = new ArgumentListExpressionWrapper((ASTNodeWrapper)this);
    }

    public MethodCallExpressionWrapper(Class<?> clazz, String method, ASTNodeWrapper parentNodeWrapper) {
        this(clazz != null ? clazz.getSimpleName() : THIS_VARIABLE, method, parentNodeWrapper);
    }

    public MethodCallExpressionWrapper(MethodCallExpression expression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)expression, parentNodeWrapper);
        this.objectExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression.getObjectExpression(), this);
        this.method = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(expression.getMethod(), this);
        this.arguments = expression.getArguments() instanceof ArgumentListExpression ? new ArgumentListExpressionWrapper((ArgumentListExpression)expression.getArguments(), (ASTNodeWrapper)this) : new ArgumentListExpressionWrapper((ASTNodeWrapper)this);
    }

    public MethodCallExpressionWrapper(MethodCallExpressionWrapper methodCallExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(methodCallExpressionWrapper, parentNodeWrapper);
        this.copyMethodCallProperties(methodCallExpressionWrapper);
    }

    private void copyMethodCallProperties(MethodCallExpressionWrapper methodCallExpressionWrapper) {
        this.objectExpression = methodCallExpressionWrapper.getObjectExpression().copy(this);
        this.method = methodCallExpressionWrapper.getMethod().copy(this);
        this.arguments = new ArgumentListExpressionWrapper(methodCallExpressionWrapper.getArguments(), (ASTNodeWrapper)this);
    }

    public ExpressionWrapper getObjectExpression() {
        return this.objectExpression;
    }

    public void setObjectExpression(ExpressionWrapper objectExpression) {
        if (objectExpression == null) {
            return;
        }
        objectExpression.setParent(this);
        this.objectExpression = objectExpression;
    }

    public String getObjectExpressionAsString() {
        if (!(this.objectExpression instanceof ConstantExpressionWrapper)) {
            return this.objectExpression.getText();
        }
        return ((ConstantExpressionWrapper)this.objectExpression).getValue().toString();
    }

    public boolean isObjectExpressionOfClass(Class<?> clazz) {
        String objectExpressionString = this.getObjectExpressionAsString();
        return StringUtils.equals((String)objectExpressionString, (String)clazz.getName()) || StringUtils.equals((String)objectExpressionString, (String)clazz.getSimpleName());
    }

    public boolean isObjectExpressionOfClass(String className) {
        return StringUtils.equals((String)this.getObjectExpressionAsString(), (String)className);
    }

    public String getMethodAsString() {
        if (!(this.method instanceof ConstantExpressionWrapper)) {
            return this.method.getText();
        }
        return ((ConstantExpressionWrapper)this.method).getValueAsString();
    }

    public ExpressionWrapper getMethod() {
        return this.method;
    }

    public boolean setMethod(ExpressionWrapper method) {
        if (method == null || method.isEqualsTo(this.method)) {
            return false;
        }
        method.copyProperties(this.method);
        method.setParent(this);
        this.method = method;
        return true;
    }

    public boolean setMethod(String method) {
        if (StringUtils.equals((String)method, (String)this.getMethodAsString())) {
            return false;
        }
        ConstantExpressionWrapper newConstant = new ConstantExpressionWrapper(method, (ASTNodeWrapper)this);
        newConstant.copyProperties(this.method);
        this.method = newConstant;
        return true;
    }

    public ArgumentListExpressionWrapper getArguments() {
        return this.arguments;
    }

    public boolean setArguments(ArgumentListExpressionWrapper arguments) {
        if (arguments == null || arguments.isEqualsTo(this.arguments)) {
            return false;
        }
        arguments.setParent(this);
        arguments.copyProperties(this.arguments);
        this.arguments = arguments;
        return true;
    }

    public boolean isSpreadSafe() {
        return this.spreadSafe;
    }

    public void setSpreadSafe(boolean spreadSafe) {
        this.spreadSafe = spreadSafe;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    @Override
    public String getText() {
        String text = "";
        text = this.objectExpression instanceof BinaryExpressionWrapper ? "(" + this.objectExpression.getText() + ")" : this.objectExpression.getText();
        return String.valueOf(THIS_VARIABLE.equals(text) ? "" : String.valueOf(text) + ".") + (this.method instanceof ConstantExpressionWrapper ? ((ConstantExpressionWrapper)this.method).getValue() : this.method.getText()) + this.arguments.getText();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.objectExpression);
        astNodeWrappers.add(this.method);
        astNodeWrappers.add(this.arguments);
        return astNodeWrappers;
    }

    @Override
    public MethodCallExpressionWrapper clone() {
        return new MethodCallExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof MethodCallExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyMethodCallProperties((MethodCallExpressionWrapper)input);
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (oldChild == this.getObjectExpression() && newChild instanceof ExpressionWrapper) {
            this.setObjectExpression((ExpressionWrapper)newChild);
            return true;
        }
        if (oldChild == this.getMethod() && newChild instanceof ExpressionWrapper) {
            this.setMethod((ExpressionWrapper)newChild);
            return true;
        }
        if (oldChild == this.getArguments() && newChild instanceof ArgumentListExpressionWrapper) {
            this.setArguments((ArgumentListExpressionWrapper)newChild);
            return true;
        }
        return super.replaceChild(oldChild, newChild);
    }

    public static MethodCallExpressionWrapper newLocalMethod(String method, ASTNodeWrapper parentNodeWrapper) {
        return new MethodCallExpressionWrapper(THIS_VARIABLE, method, parentNodeWrapper);
    }

    public boolean isKeyword(String className) {
        KeywordClass keywordClass = KeywordController.getInstance().getBuiltInKeywordClassByName(className);
        if (keywordClass == null) {
            return false;
        }
        return KeywordController.getInstance().getBuiltInKeywordByName(keywordClass, this.getMethodAsString()) != null;
    }

    public boolean isBuiltInKeywordMethodCall() {
        if (this.getObjectExpression() == null) {
            return false;
        }
        for (KeywordClass keywordClass : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            String classAliasName = keywordClass.getAliasName();
            if ((!this.isObjectExpressionOfClass(keywordClass.getType()) || !this.isKeyword(keywordClass.getSimpleName())) && (!this.importHasAliasName(classAliasName) || !this.isObjectExpressionOfClass(classAliasName) || !this.isKeyword(classAliasName))) continue;
            return true;
        }
        return false;
    }

    private boolean importHasAliasName(String aliasName) {
        ImportNodeCollection importNodeCollection = this.getImportNodeCollection();
        return importNodeCollection != null && importNodeCollection.isImported(aliasName);
    }

    private ImportNodeCollection getImportNodeCollection() {
        ScriptNodeWrapper scriptClass = this.getScriptClass();
        return scriptClass != null ? scriptClass.getImportNodeCollection() : null;
    }

    public boolean isMethodNameImportedAsStatic(String methodName) {
        ImportNodeCollection importNodeCollection = this.getImportNodeCollection();
        return importNodeCollection != null && this.isQualifiedNameImported(methodName) && StringUtils.equals((String)methodName, (String)importNodeCollection.getQualifierForAlias(this.getMethodAsString()));
    }

    private boolean isQualifiedNameImported(String qualifiedName) {
        return this.isObjectExpressionOfClass(THIS_VARIABLE) && this.getImportNodeCollection().hasAlias(qualifiedName);
    }

    public boolean isCustomKeywordMethodCall() {
        return this.getObjectExpression() != null && "CustomKeywords".equals(this.getObjectExpressionAsString());
    }

    public boolean isCallTestCaseMethodCall() {
        if (this.getObjectExpression() == null) {
            return false;
        }
        for (KeywordClass keywordClass : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            String classAliasName = keywordClass.getAliasName();
            if (!this.isObjectExpressionOfClass(keywordClass.getType()) && (!this.importHasAliasName(classAliasName) || !this.isObjectExpressionOfClass(classAliasName))) continue;
            return CALL_TEST_CASE_METHOD_NAME.equals(this.getMethodAsString()) && this.getArguments().getExpressions().size() > 1;
        }
        return false;
    }

    public boolean isFindTestCaseMethodCall() {
        return this.isFindTestArtifactMethodCall(TestCaseFactory.class, FIND_TEST_CASE_METHOD_NAME);
    }

    public boolean isFindTestDataMethodCall() {
        return this.isFindTestArtifactMethodCall(TestDataFactory.class, FIND_TEST_DATA_METHOD_NAME);
    }

    public boolean isFindTestObjectMethodCall() {
        return this.isFindTestArtifactMethodCall(ObjectRepository.class, FIND_TEST_OBJECT_METHOD_NAME);
    }

    public boolean isFindWindowsObjectMethodCall() {
        return this.isFindTestArtifactMethodCall(ObjectRepository.class, FIND_WINDOWS_OBJECT_METHOD_NAME);
    }

    public boolean isFindCheckpointMethodCall() {
        return this.isFindTestArtifactMethodCall(CheckpointFactory.class, FIND_CHECKPOINT_METHOD_NAME);
    }

    private boolean isFindTestArtifactMethodCall(Class<?> clazzToFind, String methodName) {
        String fullMethodName = String.valueOf(clazzToFind.getName()) + "." + methodName;
        return this.isObjectExpressionOfClass(clazzToFind) && this.getMethodAsString().equals(methodName) || this.isMethodNameImportedAsStatic(fullMethodName) && this.getArguments() != null && this.getArguments().getExpressions().size() >= 1;
    }

    public boolean isGetTestDataValueMethodCall() {
        return this.getObjectExpression() instanceof MethodCallExpressionWrapper && ((MethodCallExpressionWrapper)this.getObjectExpression()).isFindTestDataMethodCall() && GET_VALUE_METHOD_NAME.equals(this.getMethodAsString());
    }

    public boolean isKeysArgumentExpression() {
        return this.isObjectExpressionOfClass(Keys.class) && this.getMethodAsString().equals(KEYS_CHORDS_METHOD_NAME);
    }

    public boolean isStaticMethodCall(ClassLoader classLoader) {
        String objectAsString = this.objectExpression.getText();
        if (StringUtils.isEmpty((String)objectAsString)) {
            return false;
        }
        Class<?> callerClass = this.objectExpression.resolveType(classLoader);
        if (callerClass == null) {
            return false;
        }
        String fullCallerClassName = callerClass.getName();
        if (fullCallerClassName.equals(objectAsString) || callerClass.getSimpleName().equals(objectAsString)) {
            return true;
        }
        return fullCallerClassName.equals(this.getImportNodeCollection().getQualifierForAlias(objectAsString));
    }

    @Override
    public Class<?> resolveType(ClassLoader classLoader) {
        return this.resolveObjectType(classLoader, false);
    }

    private Class<?> resolveObjectType(ClassLoader classLoader, boolean parentResolved) {
        if (THIS_VARIABLE.equals(this.getObjectExpressionAsString())) {
            String methodAsString = this.getMethodAsString();
            ImportNodeCollection importNodeCollection = this.getImportNodeCollection();
            if (importNodeCollection == null || !this.importHasAliasName(methodAsString)) {
                return null;
            }
            return importNodeCollection.resolve(importNodeCollection.getQualifierForAlias(methodAsString));
        }
        if (this.objectExpression instanceof MethodCallExpressionWrapper) {
            return ((MethodCallExpressionWrapper)this.objectExpression).resolveObjectType(classLoader, true);
        }
        Class<?> objectExpressionResult = this.objectExpression.resolveType(classLoader);
        if (objectExpressionResult == null) {
            return null;
        }
        if (!parentResolved) {
            return objectExpressionResult;
        }
        return AstKeywordsInputUtil.getFirstAccessibleMethodReturnType(objectExpressionResult, this.getMethodAsString(), this.isStaticMethodCall(classLoader));
    }
}

