/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.RangeExpression;

public class RangeExpressionWrapper
extends ExpressionWrapper {
    private static final int DEFAULT_TO = 0;
    private static final int DEFAULT_FROM = 0;
    private ExpressionWrapper from;
    private ExpressionWrapper to;
    private boolean inclusive = true;

    public RangeExpressionWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.from = new ConstantExpressionWrapper(0, (ASTNodeWrapper)this);
        this.to = new ConstantExpressionWrapper(0, (ASTNodeWrapper)this);
    }

    public RangeExpressionWrapper(ExpressionWrapper from, ExpressionWrapper to, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.from = from;
        this.to = to;
    }

    public RangeExpressionWrapper(ExpressionWrapper from, ExpressionWrapper to, boolean inclusive, ASTNodeWrapper parentNodeWrapper) {
        this(from, to, parentNodeWrapper);
        this.inclusive = inclusive;
    }

    public RangeExpressionWrapper(RangeExpression rangeExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)rangeExpression, parentNodeWrapper);
        this.from = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(rangeExpression.getFrom(), this);
        this.to = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(rangeExpression.getTo(), this);
        this.inclusive = rangeExpression.isInclusive();
    }

    public RangeExpressionWrapper(RangeExpressionWrapper rangeExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(rangeExpressionWrapper, parentNodeWrapper);
        this.copyRangeProperties(rangeExpressionWrapper);
    }

    private void copyRangeProperties(RangeExpressionWrapper rangeExpressionWrapper) {
        this.from = rangeExpressionWrapper.getFrom().copy(this);
        this.to = rangeExpressionWrapper.getTo().copy(this);
        this.inclusive = rangeExpressionWrapper.isInclusive();
    }

    public ExpressionWrapper getFrom() {
        return this.from;
    }

    public void setFrom(ExpressionWrapper from) {
        if (from == null) {
            return;
        }
        from.setParent(this);
        this.from = from;
    }

    public ExpressionWrapper getTo() {
        return this.to;
    }

    public void setTo(ExpressionWrapper to) {
        if (to == null) {
            return;
        }
        to.setParent(this);
        this.to = to;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    @Override
    public String getText() {
        return "(" + this.from.getText() + (!this.isInclusive() ? "..<" : "..") + this.to.getText() + ")";
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.from);
        astNodeWrappers.add(this.to);
        return astNodeWrappers;
    }

    @Override
    public RangeExpressionWrapper clone() {
        return new RangeExpressionWrapper(this, this.getParent());
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this;
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (!(input instanceof RangeExpressionWrapper) || this.isEqualsTo(input)) {
            return false;
        }
        this.copyRangeProperties((RangeExpressionWrapper)input);
        return true;
    }

    @Override
    public boolean replaceChild(ASTNodeWrapper oldChild, ASTNodeWrapper newChild) {
        if (!(newChild instanceof ExpressionWrapper)) {
            return false;
        }
        if (oldChild == this.getFrom()) {
            this.setFrom((ExpressionWrapper)newChild);
            return true;
        }
        if (oldChild == this.getTo()) {
            this.setTo((ExpressionWrapper)newChild);
            return true;
        }
        return false;
    }
}

