/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshTestCaseHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() == null) {
                    return;
                }
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestCaseTreeEntity) {
                    try {
                        RefreshTestCaseHandler.this.execute((TestCaseTreeEntity)object);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private void execute(TestCaseTreeEntity testCaseTreeEntity) throws Exception {
        TestCaseEntity testCase = testCaseTreeEntity.getObject();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        ITreeEntity parentEntity = testCaseTreeEntity.getParent();
        if (testCase != null && TestCaseController.getInstance().getTestCase(testCase.getId()) != null) {
            IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)project);
            IFolder testCaseScriptFolder = groovyProject.getFolder(GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)testCase));
            testCaseScriptFolder.refreshLocal(2, null);
        } else {
            this.refreshParentTestCaseFolder(parentEntity, project);
        }
    }

    private void refreshParentTestCaseFolder(ITreeEntity parentTestCaseFolderTreeEntity, ProjectEntity project) throws Exception {
        if (parentTestCaseFolderTreeEntity != null && parentTestCaseFolderTreeEntity instanceof FolderTreeEntity) {
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentTestCaseFolderTreeEntity);
        } else {
            FolderEntity folder = FolderController.getInstance().getTestCaseRoot(project);
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)new FolderTreeEntity(folder, null));
        }
    }
}

