/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.dal.exception.NullAttributeException;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.binary.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestCaseHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object eventData = event.getProperty("org.eclipse.e4.data");
                if (eventData instanceof TestCaseTreeEntity var3_4) {
                    RenameTestCaseHandler.this.execute((TestCaseTreeEntity)testCaseTreeEntity);
                }
            }
        });
    }

    private void execute(final TestCaseTreeEntity testCaseTreeEntity) {
        try {
            final TestCaseEntity testCase = testCaseTreeEntity.getObject();
            if (Objects.isNull(testCase)) {
                throw new NullAttributeException("TestCaseEntity is null.");
            }
            List existingNames = FolderController.getInstance().getChildrenNames(testCase.getParentFolder());
            RenameWizard renameWizard = new RenameWizard((ITreeEntity)testCaseTreeEntity, existingNames);
            CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
            if (wizardDialog.open() == 0) {
                final String oldName = testCase.getName();
                final String pk = testCase.getId();
                final String newNameValue = renameWizard.getNewNameValue();
                if (!StringUtils.equals((CharSequence)newNameValue, (CharSequence)oldName)) {
                    new ProgressMonitorDialog(this.parentShell).run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                monitor.beginTask(ComposerTestcaseMessageConstants.MSG_RENAMING_TEST_CASE, -1);
                                GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)testCase);
                                testCase.setName(newNameValue);
                                TestCaseController.getInstance().updateTestCase(testCase);
                                RenameTestCaseHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testCaseTreeEntity.getParent());
                                RenameTestCaseHandler.this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)testCaseTreeEntity);
                                RenameTestCaseHandler.this.eventBroker.post("TESTCASE/UPDATED", (Object)new Object[]{pk, testCase});
                                UISynchronizeService.asyncExec(() -> {
                                    boolean bl = RenameTestCaseHandler.this.partService.saveAll(false);
                                });
                                return;
                            }
                            catch (Exception e) {
                                testCase.setName(oldName);
                                LoggerSingleton.logError((Throwable)e);
                                UISynchronizeService.syncExec(() -> MessageDialog.openError((Shell)RenameTestCaseHandler.this.parentShell, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_TEST_CASE));
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

