/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.integration;

import com.kms.katalon.composer.testcase.parts.integration.TestCaseIntegrationPlatformBuilder;
import com.kms.katalon.composer.testcase.parts.integration.TestCaseIntegrationViewBuilder;
import com.kms.katalon.controller.ProjectController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TestCaseIntegrationFactory {
    private static TestCaseIntegrationFactory _instance;
    private Map<String, TestCaseIntegrationViewBuilder> integrationViewMap = new HashMap<String, TestCaseIntegrationViewBuilder>();
    private TestCaseIntegrationPlatformBuilder platformBuilder;

    public Map<String, TestCaseIntegrationViewBuilder> getIntegrationViewMap() {
        return this.integrationViewMap;
    }

    private TestCaseIntegrationFactory() {
    }

    public static TestCaseIntegrationFactory getInstance() {
        if (_instance == null) {
            _instance = new TestCaseIntegrationFactory();
        }
        return _instance;
    }

    public void addNewIntegrationView(String productName, TestCaseIntegrationViewBuilder contributionView) {
        this.integrationViewMap.put(productName, contributionView);
    }

    public void setPlatformBuilder(TestCaseIntegrationPlatformBuilder platformBuilder) {
        this.platformBuilder = platformBuilder;
    }

    public List<TestCaseIntegrationViewBuilder> getSortedViewBuilders() {
        List<TestCaseIntegrationViewBuilder> sortedBuilders = new ArrayList<Map.Entry<String, TestCaseIntegrationViewBuilder>>(this.getIntegrationViewMap().entrySet()).stream().map(e -> (TestCaseIntegrationViewBuilder)e.getValue()).filter(e -> e.isEnabled(ProjectController.getInstance().getCurrentProject())).collect(Collectors.toList());
        if (this.platformBuilder != null) {
            sortedBuilders.addAll(this.platformBuilder.getBuilders());
        }
        sortedBuilders.sort((left, right) -> left.getName().toLowerCase().compareTo(right.getName().toLowerCase()));
        return sortedBuilders;
    }
}

