/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.model;

import com.google.gson.internal.Primitives;
import com.kms.katalon.composer.testcase.ast.editors.ClassExpressionTypeSelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.ast.editors.ClassNodeTypeSelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.ast.editors.PropertyTypeSelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.ast.editors.VariableTypeSelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.CastExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClassExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ThrowStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputValueEditorProvider;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.core.checkpoint.Checkpoint;
import com.kms.katalon.core.testcase.TestCase;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.WindowsTestObject;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.openqa.selenium.Keys;

public enum InputValueType implements InputValueEditorProvider
{
    String,
    Number,
    Boolean,
    Null,
    Variable,
    MethodCall,
    List,
    Map,
    Closure,
    ClosureList,
    Condition,
    Binary,
    Range,
    Property,
    GlobalVariable,
    TestDataValue,
    TestCase,
    TestObject,
    WindowsObject,
    TestData,
    Checkpoint,
    Class,
    This,
    Throwable,
    Keys,
    Key;

    private static final String THIS_VARIABLE = "this";

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isEditable(Object astObject) {
        return this != Null;
    }

    public CellEditor getCellEditorForValue(Composite parent, Object astObject, ITestCasePart testCasePart) {
        switch (this) {
            case Variable: {
                return AstValueUtil.getCellEditorForVariableExpression(parent, (VariableExpressionWrapper)astObject, testCasePart);
            }
        }
        return this.getCellEditorForValue(parent, astObject);
    }

    @Override
    public CellEditor getCellEditorForValue(Composite parent, Object astObject) {
        switch (this) {
            case Binary: {
                return AstValueUtil.getCellEditorForBinaryExpression(parent, (BinaryExpressionWrapper)astObject);
            }
            case Boolean: {
                return AstValueUtil.getCellEditorForBooleanConstantExpression(parent);
            }
            case Class: {
                return this.getCellEditorForClass(parent, astObject);
            }
            case Closure: {
                return AstValueUtil.getCellEditorForClosureExpression(parent, (ClosureExpressionWrapper)astObject);
            }
            case ClosureList: {
                return AstValueUtil.getCellEditorForClosureListExpression(parent, (ClosureListExpressionWrapper)astObject);
            }
            case Condition: {
                return AstValueUtil.getCellEditorForBooleanExpression(parent, (BooleanExpressionWrapper)astObject);
            }
            case GlobalVariable: {
                return AstValueUtil.getCellEditorForGlobalVariableExpression(parent, (PropertyExpressionWrapper)astObject);
            }
            case List: {
                if (astObject instanceof CastExpressionWrapper) {
                    return AstValueUtil.getCellEditorForCastToListExpression(parent, (CastExpressionWrapper)astObject);
                }
                return AstValueUtil.getCellEditorForListExpression(parent, (ListExpressionWrapper)astObject);
            }
            case Map: {
                return AstValueUtil.getCellEditorForMapExpression(parent, (MapExpressionWrapper)astObject);
            }
            case MethodCall: {
                return AstValueUtil.getCellEditorForMethodCallExpression(parent, (MethodCallExpressionWrapper)astObject);
            }
            case Number: {
                return AstValueUtil.getCellEditorForNumberConstantExpression(parent);
            }
            case Property: {
                return AstValueUtil.getCellEditorForPropertyExpression(parent, (PropertyExpressionWrapper)astObject);
            }
            case Range: {
                return AstValueUtil.getCellEditorForRangeExpression(parent, (RangeExpressionWrapper)astObject);
            }
            case String: {
                return AstValueUtil.getCellEditorForStringConstantExpression(parent);
            }
            case TestCase: {
                return AstValueUtil.getCellEditorForCallTestCase(parent, (MethodCallExpressionWrapper)astObject);
            }
            case TestData: {
                return AstValueUtil.getCellEditorForTestData(parent, (MethodCallExpressionWrapper)astObject);
            }
            case TestDataValue: {
                return AstValueUtil.getCellEditorForTestDataValue(parent, (MethodCallExpressionWrapper)astObject);
            }
            case TestObject: {
                return AstValueUtil.getCellEditorForTestObject(parent, (MethodCallExpressionWrapper)astObject);
            }
            case WindowsObject: {
                return AstValueUtil.getCellEditorForWindowsTestObject(parent, (MethodCallExpressionWrapper)astObject);
            }
            case Checkpoint: {
                return AstValueUtil.getCellEditorForFindCheckpoint(parent, (MethodCallExpressionWrapper)astObject);
            }
            case Throwable: {
                return AstValueUtil.getCellEditorForThrowable(parent, (ConstructorCallExpressionWrapper)astObject);
            }
            case Variable: {
                return AstValueUtil.getCellEditorForVariableExpression(parent, (VariableExpressionWrapper)astObject);
            }
            case Key: {
                return AstValueUtil.getCellEditorForKeyExpression(parent);
            }
            case Keys: {
                return AstValueUtil.getCellEditorForKeysExpression(parent, (MethodCallExpressionWrapper)astObject);
            }
        }
        return null;
    }

    private CellEditor getCellEditorForClass(Composite parent, Object astObject) {
        if (astObject instanceof ClassExpressionWrapper) {
            return new ClassExpressionTypeSelectionDialogCellEditor(parent, ((ClassExpressionWrapper)astObject).getText());
        }
        if (astObject instanceof VariableExpressionWrapper) {
            return new VariableTypeSelectionDialogCellEditor(parent, ((VariableExpressionWrapper)astObject).getText());
        }
        if (astObject instanceof PropertyExpressionWrapper) {
            return new PropertyTypeSelectionDialogCellEditor(parent, ((PropertyExpressionWrapper)astObject).getText());
        }
        if (astObject instanceof ClassNodeWrapper) {
            return new ClassNodeTypeSelectionDialogCellEditor(parent, ((ClassNodeWrapper)astObject).getName());
        }
        return null;
    }

    public Object getNewValue(ASTNodeWrapper parent) {
        switch (this) {
            case String: {
                return new ConstantExpressionWrapper("", parent);
            }
            case Number: {
                return new ConstantExpressionWrapper(0, parent);
            }
            case Boolean: {
                return new ConstantExpressionWrapper(true, parent);
            }
            case Null: {
                return new ConstantExpressionWrapper(parent);
            }
            case Binary: {
                return new BinaryExpressionWrapper(parent);
            }
            case Variable: {
                return new VariableExpressionWrapper(parent);
            }
            case MethodCall: {
                return new MethodCallExpressionWrapper(parent);
            }
            case Condition: {
                return new BooleanExpressionWrapper(parent);
            }
            case List: {
                return new ListExpressionWrapper(parent);
            }
            case Map: {
                return new MapExpressionWrapper(parent);
            }
            case ClosureList: {
                return new ClosureListExpressionWrapper(parent);
            }
            case Range: {
                return new RangeExpressionWrapper(parent);
            }
            case Property: {
                return new PropertyExpressionWrapper(parent);
            }
            case GlobalVariable: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport("internal", "GlobalVariable");
                }
                return new PropertyExpressionWrapper(GlobalVariable.name(), parent);
            }
            case TestObject: {
                return AstEntityInputUtil.createNewFindTestObjectMethodCall(parent);
            }
            case WindowsObject: {
                return AstEntityInputUtil.createNewFindWindowsObjectMethodCall(parent);
            }
            case Class: {
                return new ClassExpressionWrapper(String.class, parent);
            }
            case TestDataValue: {
                return AstEntityInputUtil.createNewGetTestDataValueExpression(null, 1, 1, parent);
            }
            case TestData: {
                return AstEntityInputUtil.createNewFindTestDataExpression(null, parent);
            }
            case TestCase: {
                return AstEntityInputUtil.createNewFindTestCaseMethodCall(null, parent);
            }
            case Checkpoint: {
                return AstEntityInputUtil.createNewFindCheckpointMethodCall(null, parent);
            }
            case This: {
                return new VariableExpressionWrapper(THIS_VARIABLE, parent);
            }
            case Throwable: {
                return new ConstructorCallExpressionWrapper(ThrowStatementWrapper.DEFAULT_THROW_TYPE, parent);
            }
            case Key: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport(Keys.class);
                }
                return new PropertyExpressionWrapper(Keys.class.getSimpleName(), "ENTER", parent);
            }
            case Keys: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport(Keys.class);
                }
                return new MethodCallExpressionWrapper(Keys.class, "chord", parent);
            }
            case Closure: {
                return new ClosureExpressionWrapper(new ParameterWrapper[0], parent);
            }
        }
        return new ConstantExpressionWrapper(parent);
    }

    @Override
    public Object getValueToEdit(Object astObject) {
        return astObject;
    }

    public Object changeValue(Object astObject, Object newValue) {
        return newValue;
    }

    @Override
    public String getValueToDisplay(Object astObject) {
        if (!(astObject instanceof ASTNodeWrapper)) {
            return "";
        }
        if (astObject instanceof MethodCallExpressionWrapper) {
            return this.getValueToDisplayForMethodCall(astObject);
        }
        return ((ASTNodeWrapper)astObject).getText();
    }

    private String getValueToDisplayForMethodCall(Object astObject) {
        MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)astObject;
        if (methodCall.isFindTestCaseMethodCall()) {
            return AstEntityInputUtil.getTextValueForTestCaseArgument(methodCall);
        }
        if (methodCall.isCallTestCaseMethodCall()) {
            return methodCall.getArguments().getExpression(0).getText();
        }
        if (methodCall.isFindTestObjectMethodCall()) {
            return AstEntityInputUtil.getTextValueForTestObjectArgument(methodCall);
        }
        if (methodCall.isFindWindowsObjectMethodCall()) {
            return AstEntityInputUtil.getTextValueForWindowsObjectArgument(methodCall);
        }
        if (methodCall.isFindTestDataMethodCall()) {
            return AstEntityInputUtil.getTextValueForTestDataArgument(methodCall);
        }
        if (methodCall.isGetTestDataValueMethodCall()) {
            return AstEntityInputUtil.getTextValueForTestDataValueArgument(methodCall);
        }
        if (methodCall.isFindCheckpointMethodCall()) {
            return AstEntityInputUtil.getTextValueForFindCheckpoint(methodCall);
        }
        return methodCall.getText();
    }

    @Override
    public Object newValue() {
        return this.getNewValue(null);
    }

    @Override
    public ASTNodeWrapper toASTNodeWrapper(Object rawValue) {
        return rawValue instanceof ASTNodeWrapper ? (ASTNodeWrapper)rawValue : null;
    }

    public boolean isAssignableTo(Class<?> paramType) {
        switch (this) {
            case String: 
            case TestDataValue: 
            case Keys: {
                return InputValueType.isClassAssignable(String.class, paramType);
            }
            case Number: {
                if (paramType.isPrimitive()) {
                    paramType = ClassUtils.primitiveToWrapper(paramType);
                }
                return InputValueType.isClassAssignable(Number.class, paramType) || InputValueType.isClassAssignable(paramType, Number.class);
            }
            case Boolean: 
            case Condition: {
                return InputValueType.isClassAssignable(Boolean.class, paramType);
            }
            case Null: {
                return !paramType.isPrimitive() && InputValueType.isClassAssignable(Boolean.class, paramType);
            }
            case Class: {
                return InputValueType.isClassAssignable(Type.class, paramType);
            }
            case List: {
                return InputValueType.isClassAssignable(List.class, paramType);
            }
            case Map: {
                return InputValueType.isClassAssignable(Map.class, paramType);
            }
            case TestCase: {
                return InputValueType.isClassAssignable(TestCase.class, paramType);
            }
            case TestData: {
                return InputValueType.isClassAssignable(TestData.class, paramType);
            }
            case TestObject: {
                return InputValueType.isClassAssignable(TestObject.class, paramType);
            }
            case WindowsObject: {
                return InputValueType.isClassAssignable(WindowsTestObject.class, paramType);
            }
            case Checkpoint: {
                return InputValueType.isClassAssignable(Checkpoint.class, paramType);
            }
            case Variable: 
            case MethodCall: 
            case Binary: 
            case Property: 
            case GlobalVariable: {
                return true;
            }
        }
        return false;
    }

    private static boolean isClassAssignable(Class<?> inputClass, Class<?> paramClass) {
        if (inputClass == null || paramClass == null) {
            return false;
        }
        if (paramClass.isPrimitive()) {
            paramClass = Primitives.wrap(paramClass);
        }
        return ClassUtils.isAssignable(inputClass, (Class)paramClass, (boolean)true);
    }
}

