/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForCompositePart;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.composer.testcase.actions.KatalonFormatAction;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseDataBindingPart;
import com.kms.katalon.composer.testcase.parts.TestCaseIntegrationPart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.testcase.parts.TestCasePropertiesPart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariableEditorPart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariablePart;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.testcase.providers.TestObjectScriptDropListener;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestCaseCompositePart
implements EventHandler,
SavableCompositePart,
IComposerPartEvent {
    public static final int CHILD_TEST_CASE_PARTS_NUM = 7;
    public static final int CHILD_TEST_CASE_EDITOR_PART_INDEX = 1;
    private static final int CHILD_TEST_CASE_MANUAL_PART_INDEX = 0;
    private static final int CHILD_TEST_CASE_VARIABLE_PART_INDEX = 2;
    private static final int CHILD_TEST_CASE_VARIABLE_EDITOR_PART_INDEX = 3;
    private static final int CHILD_TEST_CASE_DATA_BINDING_PART_INDEX = 4;
    private static final int CHILD_TEST_CASE_INTEGRATION_PART_INDEX = 5;
    private static final int CHILD_TEST_CASE_PROPERTIES_PART_INDEX = 6;
    public static final String SCRIPT_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_SCRIPT;
    public static final String MANUAL_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_MANUAL;
    public static final String VARIABLE_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_VARIABLE;
    public static final String VARIABLE_EDITOR_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_VARIABLE_EDITOR;
    public static final String INTEGRATION_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_INTEGRATION;
    public static final String PROPERTIES_TAB_TITLE = ComposerTestcaseMessageConstants.PA_TAB_PROPERTIES;
    @Inject
    private MDirtyable dirty;
    private IPropertyListener childPropertyListner;
    private MCompositePart compositePart;
    @Inject
    private EPartService partService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Named(value="activeShell")
    private Shell parentShell;
    private TestCasePart childTestCasePart;
    private TestCaseVariablePart childTestCaseVariablesPart;
    private TestCaseVariableEditorPart childTestCaseVariableEditorPart;
    private CompatibilityEditor childTestCaseEditorPart;
    private TestCaseIntegrationPart childTestCaseIntegrationPart;
    private TestCasePropertiesPart propertiesPart;
    private TestCaseDataBindingPart dataBindingPart;
    private GroovyEditor groovyEditor;
    private CTabFolder tabFolder;
    private MPartStack subPartStack;
    private HelpToolBarForCompositePart helpPart;
    private boolean editorLastDirty;
    private boolean isInitialized;
    private boolean isScriptChanged;
    private boolean variableEditorLastDirty = false;
    private TestCaseEntity testCase;
    private TestCaseEntity originalTestCase;
    private ScriptNodeWrapper scriptNode;
    private boolean parsingFailed;
    private boolean disposed;
    private boolean invalidScheme;
    private boolean variableTab = true;
    private int index = -1;
    private boolean isRecorderNewTestCase = false;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public MDirtyable getDirty() {
        return this.dirty;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @PostConstruct
    public void init(Composite parent, MCompositePart compositePart) {
        this.compositePart = compositePart;
        this.dirty.setDirty(false);
        this.isInitialized = false;
        this.isScriptChanged = false;
        this.changeOriginalTestCase((TestCaseEntity)compositePart.getObject());
        this.initListeners();
        this.createToolBar((MPart)compositePart);
        this.invalidScheme = false;
    }

    private void createToolBar(MPart part) {
        this.helpPart = new HelpToolBarForCompositePart(part, this.partService){

            protected String getDocumentationUrlForPartObject(Object partObject) {
                if (partObject instanceof TestCasePart) {
                    return DocumentationMessageConstants.TEST_CASE_MANUAL;
                }
                if (partObject instanceof TestCaseVariablePart) {
                    return DocumentationMessageConstants.TEST_CASE_VARIABLE;
                }
                if (partObject instanceof TestCaseVariableEditorPart) {
                    return DocumentationMessageConstants.TEST_CASE_VARIABLE_EDITOR;
                }
                if (partObject instanceof TestCaseDataBindingPart) {
                    return DocumentationMessageConstants.TEST_CASE_DATA_BINDING;
                }
                if (partObject instanceof CompatibilityEditor) {
                    return DocumentationMessageConstants.TEST_CASE_SCRIPT;
                }
                if (partObject instanceof TestCaseIntegrationPart) {
                    return ((TestCaseIntegrationPart)partObject).getDocumentationUrl();
                }
                if (partObject instanceof TestCasePropertiesPart) {
                    return DocumentationMessageConstants.TEST_CASE_PROPERTIES;
                }
                return null;
            }
        };
    }

    public void initDefaultSelectedPart() {
        String defaultTestCaseView = TestCasePreferenceDefaultValueInitializer.getTestCasePartStartView();
        if (StringUtils.equals((String)defaultTestCaseView, (String)MANUAL_TAB_TITLE)) {
            if (this.tabFolder.getSelectionIndex() != 0) {
                this.setSelectedPart(this.getChildManualPart());
            } else if (this.isScriptChanged) {
                this.setScriptContentToManual();
            }
        } else if (StringUtils.equals((String)defaultTestCaseView, (String)SCRIPT_TAB_TITLE)) {
            if (this.tabFolder.getSelectionIndex() != 1) {
                this.setSelectedPart(this.getChildCompatibilityPart());
            } else if (this.childTestCasePart.isManualScriptChanged()) {
                this.setChildEditorContents(this.scriptNode);
            }
        }
    }

    public void initComponent() {
        List compositePartChildren = this.compositePart.getChildren();
        if (compositePartChildren.size() == 1 && compositePartChildren.get(0) instanceof MPartStack) {
            this.subPartStack = (MPartStack)compositePartChildren.get(0);
            if (this.subPartStack.getChildren().size() == 7) {
                for (MStackElement stackElement : this.subPartStack.getChildren()) {
                    if (!(stackElement instanceof MPart)) continue;
                    Object partObject = ((MPart)stackElement).getObject();
                    if (partObject instanceof TestCasePart) {
                        this.childTestCasePart = (TestCasePart)partObject;
                        continue;
                    }
                    if (partObject instanceof CompatibilityEditor) {
                        this.initChildEditorPart((CompatibilityEditor)partObject);
                        continue;
                    }
                    if (partObject instanceof TestCaseVariablePart) {
                        this.childTestCaseVariablesPart = (TestCaseVariablePart)partObject;
                        continue;
                    }
                    if (partObject instanceof TestCaseVariableEditorPart) {
                        this.childTestCaseVariableEditorPart = (TestCaseVariableEditorPart)((Object)partObject);
                        continue;
                    }
                    if (partObject instanceof TestCaseDataBindingPart) {
                        this.dataBindingPart = (TestCaseDataBindingPart)partObject;
                    }
                    if (partObject instanceof TestCaseIntegrationPart) {
                        this.childTestCaseIntegrationPart = (TestCaseIntegrationPart)partObject;
                        continue;
                    }
                    if (!(partObject instanceof TestCasePropertiesPart)) continue;
                    this.propertiesPart = (TestCasePropertiesPart)((Object)partObject);
                }
            }
            if (this.subPartStack.getWidget() instanceof CTabFolder) {
                this.tabFolder = (CTabFolder)this.subPartStack.getWidget();
                this.tabFolder.setTabPosition(1024);
                this.tabFolder.setBorderVisible(false);
                this.tabFolder.setMaximizeVisible(false);
                this.tabFolder.setMinimizeVisible(false);
                if (this.tabFolder.getItemCount() == 7) {
                    CTabItem testCasePartTab = this.tabFolder.getItem(0);
                    testCasePartTab.setText(MANUAL_TAB_TITLE);
                    testCasePartTab.setImage(ImageConstants.IMG_16_MANUAL);
                    testCasePartTab.setShowClose(false);
                    CTabItem groovyEditorPartTab = this.tabFolder.getItem(1);
                    groovyEditorPartTab.setText(SCRIPT_TAB_TITLE);
                    groovyEditorPartTab.setImage(ImageConstants.IMG_16_SCRIPT);
                    groovyEditorPartTab.setShowClose(false);
                    CTabItem variablePartTab = this.tabFolder.getItem(2);
                    variablePartTab.setText(VARIABLE_TAB_TITLE);
                    variablePartTab.setImage(ImageConstants.IMG_16_VARIABLE);
                    variablePartTab.setShowClose(false);
                    CTabItem variableEditorPartTab = this.tabFolder.getItem(3);
                    variableEditorPartTab.setText(VARIABLE_EDITOR_TAB_TITLE);
                    variableEditorPartTab.setImage(ImageConstants.IMG_16_SCRIPT);
                    variableEditorPartTab.setShowClose(false);
                    CTabItem dataBindingPartTab = this.tabFolder.getItem(4);
                    dataBindingPartTab.setText(ComposerTestcaseMessageConstants.PA_TAB_DATA_BINDING);
                    dataBindingPartTab.setImage(ImageConstants.IMG_16_DATA_BINDING);
                    dataBindingPartTab.setShowClose(false);
                    CTabItem integrationPartTab = this.tabFolder.getItem(5);
                    integrationPartTab.setText(INTEGRATION_TAB_TITLE);
                    integrationPartTab.setImage(ImageConstants.IMG_16_INTEGRATION);
                    integrationPartTab.setShowClose(false);
                    CTabItem propertiesPartTab = this.tabFolder.getItem(6);
                    propertiesPartTab.setText(PROPERTIES_TAB_TITLE);
                    propertiesPartTab.setImage(ImageConstants.IMG_16_PROPERTIES);
                    propertiesPartTab.setShowClose(false);
                }
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (TestCaseCompositePart.this.tabFolder == null || TestCaseCompositePart.this.childTestCasePart == null) {
                            return;
                        }
                        TestCaseCompositePart.this.index = TestCaseCompositePart.this.tabFolder.getSelectionIndex();
                        if (TestCaseCompositePart.this.tabFolder.getSelectionIndex() == 0) {
                            if (OSUtil.isMacBigSurOrLater()) {
                                TestCaseCompositePart.this.childTestCasePart.getTestCaseTreeTable().getTree().redraw();
                            }
                            if (TestCaseCompositePart.this.isScriptChanged || TestCaseCompositePart.this.scriptNode == null || !TestCaseCompositePart.this.childTestCasePart.isScriptLoaded()) {
                                TestCaseCompositePart.this.setScriptContentToManual();
                            }
                            return;
                        }
                        if (TestCaseCompositePart.this.tabFolder.getSelectionIndex() == 1) {
                            Trackings.trackOpenObject((String)"testCaseScript");
                            if (TestCaseCompositePart.this.childTestCasePart.isManualScriptChanged()) {
                                TestCaseCompositePart.this.setChildEditorContents(TestCaseCompositePart.this.scriptNode);
                            }
                            return;
                        }
                        if (TestCaseCompositePart.this.tabFolder.getSelectionIndex() == 2) {
                            if (TestCaseCompositePart.this.dirty.isDirty() && TestCaseCompositePart.this.variableEditorLastDirty) {
                                TestCaseCompositePart.this.updateVariableManualView();
                            }
                            TestCaseCompositePart.this.variableEditorLastDirty = false;
                            Trackings.trackOpenObject((String)"testCaseVariable");
                            TestCaseCompositePart.this.variableTab = true;
                            return;
                        }
                        if (TestCaseCompositePart.this.tabFolder.getSelectionIndex() == 3) {
                            if (TestCaseCompositePart.this.dirty.isDirty() && !TestCaseCompositePart.this.variableEditorLastDirty) {
                                TestCaseCompositePart.this.updateVariableScriptView();
                            }
                            TestCaseCompositePart.this.variableEditorLastDirty = true;
                            TestCaseCompositePart.this.variableTab = false;
                            return;
                        }
                        if (TestCaseCompositePart.this.tabFolder.getSelectionIndex() == 4) {
                            Trackings.trackOpenObject((String)"testCaseDataBinding");
                        }
                        if (TestCaseCompositePart.this.tabFolder.getSelectionIndex() == 6) {
                            if (TestCaseCompositePart.this.isScriptChanged || TestCaseCompositePart.this.scriptNode == null) {
                                TestCaseCompositePart.this.setScriptContentToManual();
                            }
                            TestCaseCompositePart.this.propertiesPart.loadInput();
                            return;
                        }
                    }
                });
                this.tabFolder.layout();
            }
            this.childTestCaseVariablesPart.loadVariables();
            this.dataBindingPart.loadTestCaseTestData();
            this.dataBindingPart.loadVariableBinding();
            this.updateVariableScriptView();
            this.childTestCaseIntegrationPart.loadInput();
            this.initDefaultSelectedPart();
            if (this.tabFolder.getSelectionIndex() == 0) {
                this.setScriptContentToManual();
            } else if (this.scriptNode == null) {
                this.scriptNode = new ScriptNodeWrapper();
            } else {
                this.childTestCasePart.loadASTNodesToTreeTable(this.scriptNode);
            }
            this.propertiesPart.loadInput();
            this.isInitialized = true;
        }
    }

    private void updateVariableManualView() {
        try {
            this.childTestCaseVariablesPart.setVariablesFromScriptContent(this.childTestCaseVariableEditorPart.getScriptContent());
            this.setInvalidScheme(false);
        }
        catch (Exception exception) {
            this.setInvalidScheme(true);
        }
    }

    private void updateVariableScriptView() {
        try {
            this.childTestCaseVariableEditorPart.setScriptContentFrom(this.childTestCaseVariablesPart.getVariableEntityWrapper());
            this.setInvalidScheme(false);
        }
        catch (Exception exception) {
            this.setInvalidScheme(true);
        }
    }

    private void initChildEditorPart(CompatibilityEditor compatibilityEditor) {
        this.childTestCaseEditorPart = compatibilityEditor;
        this.groovyEditor = (GroovyEditor)this.childTestCaseEditorPart.getEditor();
        this.addFormatAction();
        GroovyEditorUtil.addImportActions((GroovyEditor)this.groovyEditor);
        this.groovyEditor.getViewer().getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                try {
                    if (!TestCaseCompositePart.this.childTestCasePart.isManualScriptChanged()) {
                        if (!((MStackElement)TestCaseCompositePart.this.subPartStack.getSelectedElement()).equals(TestCaseCompositePart.this.partService.getActivePart())) {
                            TestCaseCompositePart.this.setScriptContentToManual();
                        } else {
                            if (!TestCaseCompositePart.this.isScriptChanged) {
                                TestCaseCompositePart.this.isScriptChanged = true;
                            }
                            TestCaseCompositePart.this.childTestCaseEditorPart.getModel().setDirty(true);
                        }
                        GroovyEditorUtil.showProblems((GroovyEditor)TestCaseCompositePart.this.groovyEditor);
                    }
                    TestCaseCompositePart.this.updateDirty();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.addTestObjectDropListener();
    }

    private void addFormatAction() {
        if (this.groovyEditor.getAction(ComposerTestcaseMessageConstants.PA_ACTION_FORMAT) instanceof KatalonFormatAction) {
            return;
        }
        KatalonFormatAction formatAction = new KatalonFormatAction((IWorkbenchSite)this.groovyEditor.getSite(), FormatKind.FORMAT);
        formatAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.groovyEditor.setAction(ComposerTestcaseMessageConstants.PA_ACTION_FORMAT, (IAction)formatAction);
    }

    public void changeOriginalTestCase(TestCaseEntity testCase) {
        this.originalTestCase = testCase;
        this.cloneTestCase();
    }

    private void cloneTestCase() {
        this.testCase = new TestCaseEntity();
        TestCaseEntityUtil.copyTestCaseProperties(this.originalTestCase, this.testCase, false);
    }

    public boolean setScriptContentToManual() {
        block6: {
            block5: {
                try {
                    if (this.groovyEditor != null && this.childTestCasePart != null) break block5;
                    return false;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return false;
                }
            }
            this.parsingFailed = false;
            Shell activeShell = Display.getCurrent().getActiveShell();
            final String scriptContent = this.groovyEditor.getViewer().getDocument().get();
            new ProgressMonitorDialog(activeShell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(ComposerTestcaseMessageConstants.PARSING_SCRIPT_PROGRESS_NAME, -1);
                    try {
                        TestCaseCompositePart.this.scriptNode = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(scriptContent);
                    }
                    catch (GroovyParsingException groovyParsingException) {
                        TestCaseCompositePart.this.parsingFailed = true;
                    }
                    catch (Exception e) {
                        TestCaseCompositePart.this.parsingFailed = true;
                        LoggerSingleton.logError((Throwable)e);
                    }
                    monitor.done();
                }
            });
            if (!this.parsingFailed) break block6;
            MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_PLS_FIX_ERROR_IN_SCRIPT);
            this.subPartStack.setSelectedElement((MUIElement)this.childTestCaseEditorPart.getModel());
            this.isScriptChanged = true;
            GroovyEditorUtil.showProblems((GroovyEditor)this.groovyEditor);
            return false;
        }
        if (this.scriptNode == null) {
            this.scriptNode = new ScriptNodeWrapper();
        }
        this.childTestCasePart.loadASTNodesToTreeTable(this.scriptNode);
        this.isScriptChanged = false;
        return true;
    }

    public String getScriptContent() {
        try {
            return this.groovyEditor.getViewer().getDocument().get();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    public List<ASTNode> getAstNodesFromScript() throws Exception {
        if (this.groovyEditor != null) {
            return GroovyParser.parseGroovyScriptIntoAstNodes((String)this.groovyEditor.getViewer().getDocument().get());
        }
        return Collections.emptyList();
    }

    private boolean setChildEditorContents(ScriptNodeWrapper scriptNode) {
        while (this.groovyEditor.getViewer() == null) {
        }
        if (this.groovyEditor.getViewer() != null) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(scriptNode);
                this.groovyEditor.getViewer().getDocument().set(stringBuilder.toString());
                this.childTestCasePart.setManualScriptChanged(false);
                this.childTestCaseEditorPart.getModel().setDirty(true);
                this.updateDirty();
                return true;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return false;
    }

    private void initListeners() {
        this.eventBroker.subscribe("TESTCASE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EDITORS_CLOSED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
        this.childPropertyListner = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (source instanceof GroovyEditor && propId == 257) {
                    TestCaseCompositePart.this.editorLastDirty = TestCaseCompositePart.this.childTestCaseEditorPart.getModel().isDirty();
                }
            }
        };
    }

    public TestCasePart getChildTestCasePart() {
        return this.childTestCasePart;
    }

    public void loadTreeTableInput() {
        this.setScriptContentToManual();
    }

    public MPart getChildManualPart() {
        return this.childTestCasePart.getMPart();
    }

    public MPart getChildCompatibilityPart() {
        return this.childTestCaseEditorPart.getModel();
    }

    public GroovyEditor getChildGroovyEditor() {
        return (GroovyEditor)this.childTestCaseEditorPart.getEditor();
    }

    public MPart getChildVariablesPart() {
        return this.childTestCaseVariablesPart.getMPart();
    }

    public MPart getChildVariableEditorPart() {
        return this.childTestCaseVariableEditorPart.getMPart();
    }

    public MPart getChildDataBindingPart() {
        return this.dataBindingPart.getMPart();
    }

    public TestCaseDataBindingPart getDataBindingPart() {
        return this.dataBindingPart;
    }

    public MPart getChildIntegrationPart() {
        return this.childTestCaseIntegrationPart.getMPart();
    }

    public MPart getPropertiesPart() {
        return this.propertiesPart.getMPart();
    }

    public TestCaseEntity getTestCase() {
        return this.testCase;
    }

    public TestCaseEntity getOriginalTestCase() {
        return this.originalTestCase;
    }

    private void setInvalidScheme(boolean value) {
        this.invalidScheme = value;
    }

    public void save() throws Exception {
        if (!this.featureService.canUse(KSEFeature.CUSTOM_KEYWORD) && this.isUseCustomKeyword()) {
            if (!KSEFeatureAccessHandler.isDisplayed()) {
                KSEFeatureAccessHandler.setDisplayed((boolean)true);
                String dialogMessage = ComposerTestcaseMessageConstants.MSG_KSE_FEATURE_TEST_CASE_CONTAINS_CUSTOM_KEYWORD;
                KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CUSTOM_KEYWORD, (String)"", (String)dialogMessage);
            }
            return;
        }
        if (this.variableTab) {
            this.updateVariableScriptView();
        } else {
            this.updateVariableManualView();
        }
        if (this.childTestCasePart.isManualScriptChanged()) {
            this.setChildEditorContents(this.scriptNode);
        }
        this.saveTestScript();
        this.saveTestCase();
        this.updateDirty();
        if (!this.isRecorderNewTestCase) {
            Trackings.trackEditObject((String)"testCase", (String)"");
        }
        Trackings.trackSaveObject((String)"testCase");
    }

    public void recorderSave(boolean isNewTestCase) throws Exception {
        this.setRecorderNewTestCase(isNewTestCase);
        this.save();
        this.setRecorderNewTestCase(false);
        KSEFeatureAccessHandler.setDisplayed((boolean)false);
    }

    public void addVariables(VariableEntity[] variables) {
        this.childTestCaseVariablesPart.addVariable(variables);
    }

    public void deleteVariables(List<VariableEntity> variables) {
        this.childTestCaseVariablesPart.deleteVariables(variables);
    }

    public VariableEntity[] getVariables() {
        return this.childTestCaseVariablesPart.getVariables();
    }

    public List<VariableEntity> getVariablesList() {
        return this.childTestCaseVariablesPart.getVariablesList();
    }

    private boolean validateInput() {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(this.testCase.getName(), 2);
        if (status.isOK()) {
            return this.childTestCaseVariablesPart.validateVariables();
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)status.getMessage());
        return false;
    }

    public boolean saveTestCase() throws Exception {
        if (this.validateInput()) {
            List<TestCaseTestDataLink> testDataLinks = this.dataBindingPart.getTestCaseTestDataLinks();
            this.testCase.getTestDataLinks().clear();
            this.testCase.setTestDataLinks(testDataLinks);
            List<VariableLink> variableLinks = this.dataBindingPart.getVariableLinks();
            this.testCase.getVariableLinks().clear();
            this.testCase.setVariableLinks(variableLinks);
            List variableList = this.testCase.getVariables();
            variableList.clear();
            variableList.addAll(this.childTestCaseVariablesPart.getVariablesList());
            this.propertiesPart.preSave();
            this.childTestCaseIntegrationPart.getEditingIntegrated().entrySet().forEach(entry -> this.testCase.updateIntegratedEntity((IntegratedEntity)entry.getValue()));
            String oldPk = this.originalTestCase.getId();
            String oldIdForDisplay = this.originalTestCase.getIdForDisplay();
            TestCaseEntity temp = new TestCaseEntity();
            TestCaseEntityUtil.copyTestCaseProperties(this.originalTestCase, temp, false);
            TestCaseEntityUtil.copyTestCaseProperties(this.testCase, this.originalTestCase, false);
            try {
                boolean nameChanged;
                boolean bl = nameChanged = !this.originalTestCase.getName().equals(temp.getName());
                if (nameChanged) {
                    GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)temp);
                    this.originalTestCase.setScriptContents(temp.getScriptContents());
                    temp.setScriptContents(this.originalTestCase.getScriptContents());
                }
                TestCaseController.getInstance().updateTestCase(this.originalTestCase);
                if (nameChanged) {
                    this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, this.originalTestCase.getIdForDisplay()});
                }
                TestCaseTreeEntity testCaseTreeEntity = TreeEntityUtil.getTestCaseTreeEntity((TestCaseEntity)this.originalTestCase, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testCaseTreeEntity);
                this.eventBroker.post("TESTCASE/UPDATED", (Object)new Object[]{oldPk, this.originalTestCase});
                EventUtil.send((String)"PROPERTIES/ENTITY", null);
                EventUtil.send((String)"PROPERTIES/ENTITY", (Object)this.originalTestCase);
                this.originalTestCase.setScriptContents(new byte[0]);
                temp.setScriptContents(new byte[0]);
                this.childTestCaseIntegrationPart.onSaveSuccess(this.originalTestCase);
                return true;
            }
            catch (Exception e) {
                TestCaseEntityUtil.copyTestCaseProperties(temp, this.originalTestCase);
                this.originalTestCase.setScriptContents(temp.getScriptContents());
                LoggerSingleton.logError((Throwable)e);
                this.childTestCaseIntegrationPart.onSaveFailure(e);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.WARN, (String)e.getMessage());
            }
        }
        return false;
    }

    public boolean saveTestScript() {
        try {
            this.groovyEditor.doSave(null);
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.parentShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
            return false;
        }
    }

    public void setDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
    }

    public void updateDirty() {
        this.updateDirty(this.isAnyChildDirty());
    }

    private void updateDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
        this.childTestCasePart.getMPart().setDirty(false);
        this.childTestCaseVariablesPart.getMPart().setDirty(false);
        this.childTestCaseVariableEditorPart.getMPart().setDirty(false);
        this.dataBindingPart.getMPart().setDirty(false);
        this.childTestCaseEditorPart.getModel().setDirty(false);
        this.childTestCaseIntegrationPart.getMPart().setDirty(false);
        this.getPropertiesPart().setDirty(false);
        if (isDirty) {
            this.updateTabTitles();
        }
    }

    private void updateTabTitles() {
        if (this.tabFolder.isDisposed()) {
            return;
        }
        this.tabFolder.getItem(0).setText(MANUAL_TAB_TITLE);
        this.tabFolder.getItem(1).setText(SCRIPT_TAB_TITLE);
        this.tabFolder.getItem(2).setText(VARIABLE_TAB_TITLE);
        this.tabFolder.getItem(3).setText(VARIABLE_EDITOR_TAB_TITLE);
        this.tabFolder.getItem(4).setText(ComposerTestcaseMessageConstants.PA_TAB_DATA_BINDING);
        this.tabFolder.getItem(5).setText(INTEGRATION_TAB_TITLE);
        this.tabFolder.getItem(6).setText(PROPERTIES_TAB_TITLE);
    }

    private boolean isAnyChildDirty() {
        return this.childTestCasePart.getMPart().isDirty() || this.childTestCaseEditorPart.getModel().isDirty() || this.childTestCaseVariablesPart.getMPart().isDirty() || this.childTestCaseVariableEditorPart.getMPart().isDirty() || this.dataBindingPart.getMPart().isDirty() || this.childTestCaseIntegrationPart.getMPart().isDirty() || this.propertiesPart.isDirty();
    }

    @Persist
    public void onSave() {
        try {
            this.save();
            KSEFeatureAccessHandler.setDisplayed((boolean)false);
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_PART);
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public IPropertyListener getChildPropertyListner() {
        return this.childPropertyListner;
    }

    public void handleEvent(Event event) {
        block11: {
            if (event.getTopic().equals("TESTCASE/UPDATED")) {
                try {
                    String elementId;
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object == null || !(object instanceof Object[]) || !(elementId = EntityPartUtil.getTestCaseCompositePartId((String)((String)((Object[])object)[0]))).equalsIgnoreCase(this.compositePart.getElementId())) break block11;
                    TestCaseEntity testCase = (TestCaseEntity)((Object[])object)[1];
                    this.changeOriginalTestCase(testCase);
                    this.updatePart(testCase);
                    if (this.index != -1) {
                        this.tabFolder.setSelection(this.index);
                        break block11;
                    }
                    this.initDefaultSelectedPart();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            } else if (event.getTopic().equals("EXPLORER/REFRESH_SELECTED_ITEM")) {
                try {
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (object instanceof TestCaseTreeEntity) {
                        this.handleTestCaseRefreshed(((TestCaseTreeEntity)object).getObject());
                    } else if (object instanceof FolderTreeEntity) {
                        this.handleFolderRefreshed(((FolderTreeEntity)object).getObject());
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
    }

    private void handleTestCaseRefreshed(TestCaseEntity testCase) throws Exception {
        TestCaseEntity currentTestCase = this.getTestCase();
        if (testCase == null || !testCase.getId().equals(currentTestCase.getId())) {
            return;
        }
        if (this.isTestCaseDisposed(testCase)) {
            this.dispose();
            return;
        }
        this.refresh(testCase);
    }

    private void refresh(TestCaseEntity testCase) throws Exception {
        if (this.dirty.isDirty()) {
            return;
        }
        this.changeOriginalTestCase(testCase);
        TestCaseTreeTableInput treeTableInput = this.childTestCasePart.getTreeTableInput();
        if (treeTableInput != null) {
            treeTableInput.reloadTestCaseVariables(this.childTestCasePart.getVariables());
        }
        this.updatePart(testCase);
        this.childTestCaseIntegrationPart.loadInput();
        this.propertiesPart.loadInput();
        this.updateDirty(false);
        this.clearChildsUndoRedoHistory();
    }

    private void clearChildsUndoRedoHistory() {
        this.childTestCasePart.clearHistory();
        this.childTestCaseVariablesPart.clearHistory();
        this.propertiesPart.clearHistory();
    }

    private boolean isTestCaseDisposed(TestCaseEntity testCase) throws Exception {
        return TestCaseController.getInstance().getTestCase(testCase.getId()) == null;
    }

    private void handleFolderRefreshed(FolderEntity folder) throws Exception {
        TestCaseEntity currentTestCase = this.getTestCase();
        if (folder != null && FolderController.getInstance().isFolderAncestorOfEntity(folder, (IEntity)currentTestCase) && this.isTestCaseDisposed(currentTestCase)) {
            this.dispose();
        }
    }

    private void dispose() {
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.compositePart);
        this.eventBroker.unsubscribe((EventHandler)this);
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @PreDestroy
    public void preDestroy() {
        try {
            if (this.groovyEditor != null && this.getChildCompatibilityPart() != null) {
                GroovyEditorUtil.clearEditorProblems((GroovyEditor)this.groovyEditor);
            }
            this.helpPart.dispose();
            this.dispose();
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void updatePart(TestCaseEntity testCase) throws Exception {
        String newCompositePartId = EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId());
        this.changeOriginalTestCase(testCase);
        if (!newCompositePartId.equals(this.compositePart.getElementId())) {
            this.compositePart.setLabel(testCase.getName());
            this.compositePart.setElementId(newCompositePartId);
            if (this.compositePart.getChildren().size() == 1 && this.compositePart.getChildren().get(0) instanceof MPartStack) {
                MPartStack partStack = (MPartStack)this.compositePart.getChildren().get(0);
                partStack.setElementId(String.valueOf(newCompositePartId) + ".partStack");
                this.childTestCasePart.getMPart().setElementId(String.valueOf(newCompositePartId) + ".partStack.testCasePart");
                this.childTestCaseVariablesPart.getMPart().setElementId(String.valueOf(newCompositePartId) + ".partStack.variables");
                this.getPropertiesPart().setElementId(String.valueOf(newCompositePartId) + ".partStack.properties");
                this.childTestCaseVariableEditorPart.getMPart().setElementId(String.valueOf(newCompositePartId) + ".partStack.variableEditor");
                this.partService.hidePart(this.getChildCompatibilityPart(), true);
                String testCaseEditorId = String.valueOf(newCompositePartId) + ".partStack.editor";
                MPart editorPart = GroovyEditorUtil.createTestCaseEditorPart((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)testCase).getPath()), (MPartStack)partStack, (String)testCaseEditorId, (EPartService)this.partService, (int)1);
                this.partService.activate(editorPart);
                this.initComponent();
                this.childTestCaseEditorPart.getEditor().addPropertyListener(this.getChildPropertyListner());
                this.updateDirty();
            }
        }
        boolean isAnyChildDirty = this.isAnyChildDirty();
        this.childTestCaseVariablesPart.loadVariables();
        this.childTestCaseVariableEditorPart.setScriptContentFrom(this.childTestCaseVariablesPart.getVariableEntityWrapper());
        if (this.childTestCasePart.getTreeTableInput() == null) {
            this.setScriptContentToManual();
        }
        this.childTestCasePart.getTreeTableInput().reloadTestCaseVariables(this.childTestCasePart.getVariables());
        this.childTestCaseIntegrationPart.reloadInput();
        this.dataBindingPart.loadTestCaseTestData();
        this.dataBindingPart.loadVariableBinding();
        this.updateDirty();
        this.setDirty(isAnyChildDirty);
    }

    public MPart getSelectedPart() {
        return (MPart)this.subPartStack.getSelectedElement();
    }

    public void setSelectedPart(MPart partToSelect) {
        if (this.subPartStack.getChildren().contains(partToSelect)) {
            this.subPartStack.setSelectedElement((MUIElement)partToSelect);
            if (partToSelect == this.getChildManualPart() && (this.isScriptChanged || this.scriptNode == null)) {
                this.setScriptContentToManual();
            } else if (partToSelect == this.getChildCompatibilityPart() && this.childTestCasePart.isManualScriptChanged()) {
                this.setChildEditorContents(this.scriptNode);
            }
        }
    }

    public void refreshScript() {
        if (!this.isInitialized) {
            return;
        }
        if (this.subPartStack.getSelectedElement() == this.getChildCompatibilityPart()) {
            this.setChildEditorContents(this.scriptNode);
        }
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> childrenParts = new ArrayList<MPart>();
        childrenParts.add(this.getChildManualPart());
        childrenParts.add(this.getChildCompatibilityPart());
        childrenParts.add(this.getChildVariablesPart());
        childrenParts.add(this.getChildVariableEditorPart());
        childrenParts.add(this.getChildDataBindingPart());
        childrenParts.add(this.getChildIntegrationPart());
        childrenParts.add(this.getPropertiesPart());
        return childrenParts;
    }

    public boolean isTestCaseEmpty() {
        return GroovyWrapperParser.parseGroovyScriptAndGetFirstStatement(this.groovyEditor.getViewer().getDocument().get()) == null;
    }

    public void validateScriptErrors() throws Exception {
        try {
            GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(this.groovyEditor.getViewer().getDocument().get());
        }
        catch (Exception e) {
            GroovyEditorUtil.showProblems((GroovyEditor)this.groovyEditor);
            throw e;
        }
    }

    private void addTestObjectDropListener() {
        Control control = (Control)this.groovyEditor.getAdapter(Control.class);
        if (!(control instanceof StyledText)) {
            return;
        }
        DropTarget dropTarget = null;
        Object existingDropTarget = control.getData("DropTarget");
        dropTarget = existingDropTarget != null ? (DropTarget)existingDropTarget : new DropTarget(control, 1);
        Transfer[] transfers = dropTarget.getTransfer();
        List treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        if (transfers.length != 0) {
            treeEntityTransfers.addAll(Arrays.asList(transfers));
        }
        dropTarget.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dropTarget.addDropListener((DropTargetListener)new TestObjectScriptDropListener(this.groovyEditor.getViewer().getTextWidget()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean isUseCustomKeyword() throws Exception {
        ScriptNodeWrapper newScript = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper(this.groovyEditor.getViewer().getDocument().get());
        for (StatementWrapper statement : newScript.getBlock().getStatements()) {
            void variable;
            VariableExpressionWrapper variableExpressionWrapper;
            void method;
            MethodCallExpressionWrapper methodCallExpressionWrapper;
            void expression;
            ExpressionStatementWrapper expressionStatementWrapper;
            StatementWrapper statementWrapper = statement;
            if (!(statementWrapper instanceof ExpressionStatementWrapper) || (expressionStatementWrapper = (ExpressionStatementWrapper)statementWrapper) != (ExpressionStatementWrapper)statementWrapper || !(( instanceOfPatternExpressionValue = expression.getExpression()) instanceof MethodCallExpressionWrapper) || (methodCallExpressionWrapper = (MethodCallExpressionWrapper) instanceOfPatternExpressionValue) != (MethodCallExpressionWrapper) instanceOfPatternExpressionValue || !(( instanceOfPatternExpressionValue = method.getObjectExpression()) instanceof VariableExpressionWrapper) || (variableExpressionWrapper = (VariableExpressionWrapper) instanceOfPatternExpressionValue) != (VariableExpressionWrapper) instanceOfPatternExpressionValue || !"CustomKeywords".equals(variable.getVariable())) continue;
            return true;
        }
        return false;
    }

    public MCompositePart getCompositePart() {
        return this.compositePart;
    }

    public String getEntityId() {
        return this.getTestCase().getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.originalTestCase == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.startsWith((String)part.getElementId(), (String)EntityPartUtil.getTestCaseCompositePartId((String)this.originalTestCase.getId()))) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.originalTestCase);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof TestCaseEntity)) {
            return;
        }
        TestCaseEntity updatedEntity = (TestCaseEntity)eventData;
        if (!StringUtils.equals((String)updatedEntity.getIdForDisplay(), (String)this.getEntityId())) {
            return;
        }
        String newTag = updatedEntity.getTag();
        String newDescription = updatedEntity.getDescription();
        String newComment = updatedEntity.getComment();
        this.testCase.setTag(newTag);
        this.testCase.setDescription(newDescription);
        this.testCase.setComment(newComment);
        this.propertiesPart.loadInput();
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
    }

    public void setInvalidSchemeDetected(boolean b) {
        this.invalidScheme = b;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public boolean isDirty() {
        return this.compositePart.isDirty();
    }

    public void changeScriptNode(ScriptNodeWrapper scriptNode) {
        this.scriptNode = scriptNode;
    }

    public void openAddedTestData(DataFileEntity dataFileEntity) {
        this.eventBroker.post("TESTDATA/OPEN", (Object)dataFileEntity);
    }

    public void setVariablesAndDataBindingTab() {
        this.tabFolder.setSelection(4);
    }

    public void refreshTestCaseAfterTestDataChanged(String oldTestDataId, String newTestDataId) {
        this.dataBindingPart.refreshTestCaseAfterTestDataChanged(oldTestDataId, newTestDataId);
    }

    public void setRecorderNewTestCase(boolean isRecorderNewTestCase) {
        this.isRecorderNewTestCase = isRecorderNewTestCase;
    }
}

