/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.util.CssUtil;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.dialogs.ManageTestCaseTagDialog;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.util.EntityTagUtil;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TestCasePropertiesPart
extends CPart {
    @Inject
    private EPartService partService;
    private MPart mPart;
    private TestCaseCompositePart parentPart;
    private Composite parentComposite;
    private Text txtId;
    private Text txtName;
    private Text txtCreatedDate;
    private Text txtModifiedDate;
    private Text txtTag;
    private Text txtDescription;
    private Text txtComment;
    private Button btnManageTags;
    private boolean isInputLoaded;

    @PostConstruct
    public void postConstruct(Composite parentComposite, MPart mPart) {
        MCompositePart compositePart;
        Object compositePartObject;
        this.parentComposite = parentComposite;
        this.mPart = mPart;
        MElementContainer parent = mPart.getParent().getParent();
        if (parent instanceof MGenericTile && (MGenericTile)parent instanceof MCompositePart && (compositePartObject = (compositePart = (MCompositePart)((MGenericTile)parent)).getObject()) instanceof TestCaseCompositePart) {
            this.parentPart = (TestCaseCompositePart)compositePartObject;
        }
        this.initialize(mPart, this.partService);
        this.createComponents();
        this.registerListeners();
    }

    private void createComponents() {
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        this.parentComposite.setLayout((Layout)parentLayout);
        this.parentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite container = new ScrolledComposite(this.parentComposite, 768);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setMinSize(600, 400);
        container.setExpandHorizontal(true);
        container.setExpandVertical(true);
        CssUtil.applyCssClassName((Widget)container, (String)Composite.class.getSimpleName());
        container.setBackgroundMode(1);
        Composite mainComposite = new Composite((Composite)container, 0);
        GridLayout mainCompositeLayout = new GridLayout(2, true);
        mainCompositeLayout.marginWidth = 0;
        mainCompositeLayout.marginHeight = 0;
        mainComposite.setLayout((Layout)mainCompositeLayout);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setContent((Control)mainComposite);
        Composite left = new Composite(mainComposite, 0);
        left.setLayout((Layout)new GridLayout(2, false));
        left.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLabel(GlobalMessageConstants.ID, left, 0x1000000);
        this.txtId = new Text(left, 2056);
        this.txtId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel(GlobalMessageConstants.CREATED_DATE, left, 0x1000000);
        this.txtCreatedDate = new Text(left, 2056);
        this.txtCreatedDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel(GlobalMessageConstants.TAG, left, 0x1000000);
        this.txtTag = new Text(left, 2048);
        this.txtTag.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite tagComposite = new Composite(left, 0);
        tagComposite.setLayout((Layout)new GridLayout());
        tagComposite.setLayoutData((Object)new GridData(131072, 4, true, false, 2, 1));
        this.btnManageTags = new Button(tagComposite, 0);
        this.btnManageTags.setText(ComposerTestcaseMessageConstants.TestCasePropertiesPart_BTN_MANAGE_TAGS);
        this.createLabel(GlobalMessageConstants.DESCRIPTION, left, 128);
        this.txtDescription = new Text(left, 2624);
        GridData gdDesc = new GridData(4, 4, true, true);
        gdDesc.minimumHeight = 100;
        this.txtDescription.setLayoutData((Object)gdDesc);
        Composite right = new Composite(mainComposite, 0);
        right.setLayout((Layout)new GridLayout(2, false));
        right.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLabel(GlobalMessageConstants.NAME, right, 0x1000000);
        this.txtName = new Text(right, 2056);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel(GlobalMessageConstants.MODIFIED_DATE, right, 0x1000000);
        this.txtModifiedDate = new Text(right, 2056);
        this.txtModifiedDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblEmpty = new Label(right, 0);
        GridData gdEmptyLabel = new GridData(4, 4, false, false, 2, 1);
        gdEmptyLabel.heightHint = 21;
        lblEmpty.setLayoutData((Object)gdEmptyLabel);
        this.createLabel(GlobalMessageConstants.COMMENT, right, 128);
        this.txtComment = new Text(right, 2632);
        GridData gdComment = new GridData(4, 4, true, true);
        gdComment.minimumHeight = 100;
        this.txtComment.setLayoutData((Object)gdComment);
    }

    private Label createLabel(String labelText, Composite parent, int verticalAlign) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        GridData gdLabel = new GridData(16384, verticalAlign, false, false);
        gdLabel.widthHint = 80;
        label.setLayoutData((Object)gdLabel);
        return label;
    }

    private void registerListeners() {
        this.txtTag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = TestCasePropertiesPart.this.txtTag.getText();
                TestCasePropertiesPart.this.parentPart.getTestCase().setTag(text);
                TestCasePropertiesPart.this.setDirty(true);
            }
        });
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = TestCasePropertiesPart.this.txtDescription.getText();
                TestCasePropertiesPart.this.parentPart.getTestCase().setDescription(text);
                TestCasePropertiesPart.this.setDirty(true);
            }
        });
        this.btnManageTags.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set<String> newTags;
                String newTagValues;
                Set testCaseTags = EntityTagUtil.parse((String)TestCasePropertiesPart.this.txtTag.getText());
                ManageTestCaseTagDialog dialog = new ManageTestCaseTagDialog(Display.getCurrent().getActiveShell(), testCaseTags);
                if (dialog.open() == 1001 && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(newTagValues = EntityTagUtil.joinTags(newTags = dialog.getAppendedTags())))) {
                    String updatedTagValues = EntityTagUtil.appendTags((String)TestCasePropertiesPart.this.txtTag.getText(), newTags);
                    TestCasePropertiesPart.this.txtTag.setText(updatedTagValues);
                }
            }
        });
    }

    public void loadInput() {
        this.isInputLoaded = false;
        TestCaseEntity originalTestCase = this.parentPart.getOriginalTestCase();
        TestCaseEntity testCase = this.parentPart.getTestCase();
        this.populateTxtFieldValue(this.txtId, originalTestCase.getIdForDisplay());
        this.populateTxtFieldValue(this.txtName, originalTestCase.getName());
        this.populateTxtFieldValue(this.txtCreatedDate, originalTestCase.getDateCreated());
        this.populateTxtFieldValue(this.txtModifiedDate, originalTestCase.getDateModified());
        this.populateTxtFieldValue(this.txtTag, testCase.getTag());
        this.populateTxtFieldValue(this.txtDescription, testCase.getDescription());
        this.populateTxtFieldValue(this.txtComment, testCase.getComment());
        this.isInputLoaded = true;
    }

    private void populateTxtFieldValue(Text txtField, Object value) {
        if (txtField == null) {
            return;
        }
        txtField.setText(ObjectUtils.toString((Object)value));
    }

    private String getComments() {
        if (this.parentPart.getChildTestCasePart() != null) {
            return StringUtils.join(this.parentPart.getChildTestCasePart().getCommentSteps(), (String)"\n");
        }
        return "";
    }

    public MPart getMPart() {
        return this.mPart;
    }

    public boolean isDirty() {
        return this.mPart.isDirty();
    }

    public void setDirty(boolean isDirty) {
        if (!this.isInputLoaded) {
            return;
        }
        this.mPart.setDirty(isDirty);
        this.parentPart.updateDirty();
    }

    public void preSave() {
        this.parentPart.getTestCase().setComment(this.txtComment.getText());
    }

    @PreDestroy
    public void preDestroy() {
        super.dispose();
    }
}

