/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.parts;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.testcase.ast.variable.operations.ChangeVariableMaskedOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.ClearVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.DeleteVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.DownVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.NewVariableOperation;
import com.kms.katalon.composer.testcase.ast.variable.operations.UpVariableOperation;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.IVariablePart;
import com.kms.katalon.composer.testcase.parts.TableActionOperator;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariableViewEvent;
import com.kms.katalon.composer.testcase.providers.VariableTableDropTarget;
import com.kms.katalon.composer.testcase.support.VariableDefaultValueEditingSupport;
import com.kms.katalon.composer.testcase.support.VariableDefaultValueTypeEditingSupport;
import com.kms.katalon.composer.testcase.support.VariableDescriptionEditingSupport;
import com.kms.katalon.composer.testcase.support.VariableNameEditingSupport;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.LocalVariableController;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.entity.variable.VariableEntityWrapper;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.constant.GroovyConstants;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TestCaseVariableView
implements TableActionOperator,
EventManager<TestCaseVariableViewEvent> {
    private static final String DEFAULT_VARIABLE_NAME = "variable";
    private static final InputValueType[] defaultInputValueTypes = new InputValueType[]{InputValueType.String, InputValueType.Number, InputValueType.Boolean, InputValueType.Null, InputValueType.GlobalVariable, InputValueType.TestDataValue, InputValueType.TestObject, InputValueType.TestData, InputValueType.Property, InputValueType.List, InputValueType.Map};
    private CTableViewer tableViewer;
    private VariableEntityWrapper variableEntityWrapper = new VariableEntityWrapper();
    private IVariablePart variablePart;
    private InputValueType[] inputValueTypes = defaultInputValueTypes;
    private ITestCasePart testCasePart;
    private Map<TestCaseVariableViewEvent, Set<EventListener<TestCaseVariableViewEvent>>> eventListeners = new HashMap<TestCaseVariableViewEvent, Set<EventListener<TestCaseVariableViewEvent>>>();

    public TestCaseVariableView(IVariablePart variablePart) {
        this.variablePart = variablePart;
        this.variableEntityWrapper.setVariables(new ArrayList());
    }

    public void setInputValueTypes(InputValueType[] inputValueTypes) {
        this.inputValueTypes = inputValueTypes;
    }

    public InputValueType[] getInputValueTypes() {
        return this.inputValueTypes;
    }

    public void setTestCasePart(ITestCasePart testCasePart) {
        this.testCasePart = testCasePart;
    }

    public ITestCasePart getTestCasePart() {
        return this.testCasePart;
    }

    public Composite createComponents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite compositeToolbar = new Composite(container, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddVariable = new ToolItem(toolBar, 0);
        tltmAddVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariableView.this.addVariable();
            }
        });
        tltmAddVariable.setText(GlobalMessageConstants.ADD);
        tltmAddVariable.setImage(ImageConstants.IMG_16_ADD);
        final ToolItem tltmRemove = new ToolItem(toolBar, 0);
        tltmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariableView.this.removeVariables();
            }
        });
        tltmRemove.setText(GlobalMessageConstants.DELETE);
        tltmRemove.setImage(ImageConstants.IMG_16_REMOVE);
        tltmRemove.setEnabled(false);
        ToolItem tltmClear = new ToolItem(toolBar, 0);
        tltmClear.setText(GlobalMessageConstants.CLEAR);
        tltmClear.setImage(ImageConstants.IMG_16_CLEAR);
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariableView.this.clearVariables();
            }
        });
        ToolItem tltmUp = new ToolItem(toolBar, 0);
        tltmUp.setText(ComposerTestcaseMessageConstants.PA_BTN_TIP_MOVE_UP);
        tltmUp.setImage(ImageConstants.IMG_16_MOVE_UP);
        tltmUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariableView.this.upVariable();
            }
        });
        ToolItem tltmDown = new ToolItem(toolBar, 0);
        tltmDown.setText(ComposerTestcaseMessageConstants.PA_BTN_TIP_MOVE_DOWN);
        tltmDown.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        tltmDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseVariableView.this.downVariable();
            }
        });
        Composite compositeTable = new Composite(container, 0);
        compositeTable.setLayout((Layout)new FillLayout(256));
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        compositeTable.setLayoutData((Object)gridData);
        this.tableViewer = new CTableViewer(compositeTable, 67586);
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tltmRemove.setEnabled(!TestCaseVariableView.this.tableViewer.getSelection().isEmpty());
            }
        });
        this.tableViewer.addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection selection = (StructuredSelection)TestCaseVariableView.this.tableViewer.getSelection();
                VariableEntity variable = (VariableEntity)selection.getFirstElement();
                event.data = String.valueOf(TestCaseVariableView.this.variableEntityWrapper.getVariables().indexOf(variable));
            }
        });
        this.tableViewer.addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new VariableTableDropTarget(this));
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnNo = tableViewerColumnNo.getColumn();
        tblclmnNo.setWidth(70);
        tblclmnNo.setText(GlobalMessageConstants.NO_);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof VariableEntity) {
                    return Integer.toString(TestCaseVariableView.this.variableEntityWrapper.getVariables().indexOf(element) + 1);
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnName.setEditingSupport((EditingSupport)new VariableNameEditingSupport((ColumnViewer)this.tableViewer, this));
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof VariableEntity) {
                    return ((VariableEntity)element).getName();
                }
                return "";
            }
        });
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(100);
        tblclmnName.setText(GlobalMessageConstants.NAME);
        TableViewerColumn tableViewerColumnDefaultValueType = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnDefaultValueType.setEditingSupport((EditingSupport)new VariableDefaultValueTypeEditingSupport((ColumnViewer)this.tableViewer, this, this.inputValueTypes));
        TableColumn tblclmnDefaultValueType = tableViewerColumnDefaultValueType.getColumn();
        tblclmnDefaultValueType.setWidth(100);
        tblclmnDefaultValueType.setText(ComposerTestcaseMessageConstants.PA_COL_DEFAULT_VALUE_TYPE);
        tableViewerColumnDefaultValueType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExpressionWrapper expression;
                block5: {
                    if (!(element instanceof VariableEntity)) {
                        return "";
                    }
                    expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(((VariableEntity)element).getDefaultValue());
                    if (expression != null) break block5;
                    return null;
                }
                try {
                    InputValueType valueType = AstValueUtil.getTypeValue(expression);
                    if (valueType != null) {
                        return TreeEntityUtil.getReadableKeywordName((String)valueType.getName());
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnDefaultValue = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnDefaultValue.setEditingSupport((EditingSupport)new VariableDefaultValueEditingSupport((ColumnViewer)this.tableViewer, this, this.getTestCasePart()));
        TableColumn tblclmnDefaultValue = tableViewerColumnDefaultValue.getColumn();
        tblclmnDefaultValue.setWidth(150);
        tblclmnDefaultValue.setText(ComposerTestcaseMessageConstants.PA_COL_DEFAULT_VALUE);
        tableViewerColumnDefaultValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof VariableEntity) || ((VariableEntity)element).getDefaultValue() == null) {
                    return "";
                }
                ExpressionWrapper expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(((VariableEntity)element).getDefaultValue());
                if (expression == null) {
                    return "";
                }
                return expression.getText();
            }
        });
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnDescription.setEditingSupport((EditingSupport)new VariableDescriptionEditingSupport((ColumnViewer)this.tableViewer, this));
        tableViewerColumnDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof VariableEntity) {
                    return ((VariableEntity)element).getDescription();
                }
                return "";
            }
        });
        TableColumn tblColumnDescription = tableViewerColumnDescription.getColumn();
        tblColumnDescription.setWidth(120);
        tblColumnDescription.setText(GlobalMessageConstants.DESCRIPTION);
        TableViewerColumn tableViewerColumnLogged = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        tableViewerColumnLogged.setLabelProvider((CellLabelProvider)new TypeCheckStyleCellTableLabelProvider<VariableEntity>(5){

            protected Class<VariableEntity> getElementType() {
                return VariableEntity.class;
            }

            protected Image getImage(VariableEntity element) {
                return element.isMasked() ? ImageConstants.IMG_16_CHECKBOX_CHECKED : ImageConstants.IMG_16_CHECKBOX_UNCHECKED;
            }

            protected String getText(VariableEntity element) {
                return "";
            }
        });
        tableViewerColumnLogged.setEditingSupport((EditingSupport)new TypeCheckedEditingSupport<VariableEntity>((ColumnViewer)this.tableViewer){

            protected Class<VariableEntity> getElementType() {
                return VariableEntity.class;
            }

            protected CellEditor getCellEditorByElement(VariableEntity element) {
                return new CheckboxCellEditor(this.getComposite());
            }

            protected boolean canEditElement(VariableEntity element) {
                return element != null;
            }

            protected Object getElementValue(VariableEntity element) {
                return element.isMasked();
            }

            protected void setElementValue(VariableEntity element, Object value) {
                if (!(value instanceof Boolean)) {
                    return;
                }
                boolean newMasked = (Boolean)value;
                if (element.isMasked() == newMasked) {
                    return;
                }
                TestCaseVariableView.this.executeOperation((IUndoableOperation)new ChangeVariableMaskedOperation(TestCaseVariableView.this, element, newMasked));
            }
        });
        TableColumn tblColumnLogged = tableViewerColumnLogged.getColumn();
        tblColumnLogged.setWidth(50);
        tblColumnLogged.setText(ComposerTestcaseMessageConstants.PA_COL_MASKED);
        tblColumnLogged.setToolTipText(ComposerTestcaseMessageConstants.PA_COL_MASKED_TOOLTIP);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.loadVariables(Collections.emptyList());
        return container;
    }

    private void addVariable() {
        VariableEntity newVariable = new VariableEntity();
        newVariable.setName(this.generateNewPropertyName());
        newVariable.setDefaultValue("''");
        this.executeOperation((IUndoableOperation)new NewVariableOperation(this, newVariable));
        this.invoke((Object)TestCaseVariableViewEvent.ADD_VARIABLE, null);
    }

    private String generateNewPropertyName() {
        String name = DEFAULT_VARIABLE_NAME;
        int index = 0;
        boolean isUnique = false;
        String newName = name;
        while (!isUnique) {
            isUnique = true;
            for (VariableEntity variable : this.variableEntityWrapper.getVariables()) {
                if (!variable.getName().equals(newName)) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                return newName;
            }
            newName = String.valueOf(name) + "_" + index;
            ++index;
        }
        return newName;
    }

    public void addVariable(VariableEntity[] variablesArray) {
        boolean isAdded = false;
        VariableEntity[] variableEntityArray = variablesArray;
        int n = variablesArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableEntity addedVariable = variableEntityArray[n2];
            boolean exists = false;
            for (VariableEntity currentVariable : this.variableEntityWrapper.getVariables()) {
                if (!currentVariable.getName().equals(addedVariable.getName())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.variableEntityWrapper.getVariables().add(addedVariable);
                isAdded = true;
            }
            ++n2;
        }
        if (isAdded) {
            this.tableViewer.refresh();
            this.setDirty(true);
        }
    }

    public void deleteVariables(List<VariableEntity> variableList) {
        if (this.variableEntityWrapper.getVariables().removeAll(variableList)) {
            this.tableViewer.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                this.tableViewer.getTable().redraw();
            }
            this.setDirty(true);
        }
    }

    private void removeVariables() {
        this.executeOperation((IUndoableOperation)new DeleteVariableOperation(this));
    }

    private void clearVariables() {
        this.executeOperation((IUndoableOperation)new ClearVariableOperation(this));
    }

    private void upVariable() {
        this.executeOperation((IUndoableOperation)new UpVariableOperation(this));
    }

    private void downVariable() {
        this.executeOperation((IUndoableOperation)new DownVariableOperation(this));
    }

    public void loadVariables(List<VariableEntity> newVariables) {
        this.variableEntityWrapper.getVariables().clear();
        this.variableEntityWrapper.getVariables().addAll(newVariables);
        this.tableViewer.setInput((Object)this.variableEntityWrapper.getVariables());
        this.tableViewer.refresh();
    }

    public VariableEntity[] getVariables() {
        if (this.variableEntityWrapper.getVariables() == null) {
            return new VariableEntity[0];
        }
        return this.variableEntityWrapper.getVariables().toArray(new VariableEntity[this.variableEntityWrapper.getVariables().size()]);
    }

    @Override
    public List<VariableEntity> getVariablesList() {
        return this.variableEntityWrapper.getVariables();
    }

    @Override
    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public boolean validateVariables() {
        StringBuilder errorCollector = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        for (VariableEntity variable : this.variableEntityWrapper.getVariables()) {
            int index = this.variableEntityWrapper.getVariables().indexOf(variable) + 1;
            String variableName = variable.getName();
            String variableDefaultValue = variable.getDefaultValue();
            if (variableDefaultValue == null || variableDefaultValue.isEmpty()) {
                variableDefaultValue = null;
            }
            if (variableName == null || variableName.isEmpty()) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_VAR_AT_INDEX_CANNOT_BE_NULL_OR_EMPTY, Integer.toString(index)));
            }
            if (!GroovyConstants.isValidVariableName((String)variableName)) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_INVALID_VAR, variableName));
            }
            if (names.contains(variableName)) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_DUPLICATE_VAR, variableName));
            } else {
                names.add(variableName);
            }
            try {
                SyntaxUtil.checkVariableSyntax((String)variableName, (String)variableDefaultValue);
            }
            catch (IllegalArgumentException e) {
                errorCollector.append(MessageFormat.format(ComposerTestcaseMessageConstants.PA_ERROR_MSG_INVALID_DEFAULT_VAR_VAL_AT_INDEX, index, e.getMessage()));
            }
        }
        String errorString = errorCollector.toString();
        if (errorString.isEmpty()) {
            return true;
        }
        MultiStatusErrorDialog.showErrorDialog((Throwable)new IllegalArgumentException(errorString), (String)ComposerTestcaseMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_TEST_CASE, (String)ComposerTestcaseMessageConstants.PA_ERROR_REASON_INVALID_TEST_CASE);
        return false;
    }

    @Override
    public IStatus executeOperation(IUndoableOperation operation) {
        try {
            return operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @Override
    public void setDirty(boolean dirty) {
        this.variablePart.setDirty(dirty);
    }

    public Iterable<EventListener<TestCaseVariableViewEvent>> getListeners(TestCaseVariableViewEvent event) {
        return this.eventListeners.get((Object)event);
    }

    public void addListener(EventListener<TestCaseVariableViewEvent> listener, Iterable<TestCaseVariableViewEvent> events) {
        events.forEach(e -> {
            Set<EventListener<TestCaseVariableViewEvent>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<TestCaseVariableViewEvent>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((TestCaseVariableViewEvent)((Object)e), listenerOnEvent);
        });
    }

    public TestCaseVariableView() {
    }

    public VariableEntityWrapper getVariableEntityWrapper() {
        return this.variableEntityWrapper;
    }

    public void setVariablesFromScriptContent(String scriptContent) throws Exception {
        VariableEntityWrapper newVariableEntityWrapper = this.getVariableEntityWrapperFromScriptContent(scriptContent);
        if (newVariableEntityWrapper != null) {
            this.variableEntityWrapper.setVariables(newVariableEntityWrapper.getVariables());
        }
        this.tableViewer.setInput((Object)this.variableEntityWrapper.getVariables());
        this.tableViewer.refresh();
    }

    public VariableEntityWrapper getVariableEntityWrapperFromScriptContent(String scriptContent) throws Exception {
        VariableEntityWrapper newVariableEntityWrapper = null;
        if (scriptContent != null && scriptContent != "") {
            newVariableEntityWrapper = LocalVariableController.getInstance().toVariableEntityWrapper(scriptContent);
            return newVariableEntityWrapper;
        }
        return newVariableEntityWrapper;
    }

    @Override
    public TestCaseCompositePart getParent() {
        return null;
    }
}

