/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.preferences;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.preferences.ManualPreferenceValueInitializer;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import com.kms.katalon.custom.keyword.KeywordMethod;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TestCasePreferencePage
extends PreferencePageWithHelp {
    private Button btnDefaultVariableIsConstant;
    private Button btnDefaultVariableIsVariable;
    private Button btnGenerateDefaultValue;
    private Button btnGenerateVariable;
    private Button btnExportVariable;
    private Button btnDefaultViewManual;
    private Button btnDefaultViewScript;
    private Group grpTestCaseDefaultView;
    private Group grpDefaultKeyword;
    private ListViewer listViewerKwType;
    private ListViewer listViewerKwName;
    private Combo comboKeywordType;
    private IKeywordContributor[] contributors;
    private Composite fieldEditorParent;
    private Map<String, String> defaultKeywords;
    private Text txtMaximumLineWidth;
    private Button btnAllowLineWrapping;
    private Composite cpsWrappingLineWidth;

    public TestCasePreferencePage() {
        this.setTitle(GlobalMessageConstants.TEST_CASE);
        List keywordContributorList = KeywordContributorCollection.getKeywordContributors();
        this.contributors = keywordContributorList.toArray(new IKeywordContributor[keywordContributorList.size()]);
    }

    protected Control createContents(Composite parent) {
        this.fieldEditorParent = new Composite(parent, 0);
        this.fieldEditorParent.setLayout((Layout)new GridLayout(1, false));
        Group grpDefaultVariableType = new Group(this.fieldEditorParent, 0);
        grpDefaultVariableType.setText(ComposerTestcaseMessageConstants.PREF_GRP_DEFAULT_VAR_TYPE);
        GridData gdGrpDefaultVariableType = new GridData(4, 0x1000000, true, false, 1, 1);
        gdGrpDefaultVariableType.exclude = true;
        grpDefaultVariableType.setLayoutData((Object)gdGrpDefaultVariableType);
        grpDefaultVariableType.setLayout((Layout)new GridLayout(1, false));
        this.btnDefaultVariableIsConstant = new Button((Composite)grpDefaultVariableType, 16);
        this.btnDefaultVariableIsConstant.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDefaultVariableIsConstant.setText(InputValueType.String.name());
        this.btnDefaultVariableIsVariable = new Button((Composite)grpDefaultVariableType, 16);
        this.btnDefaultVariableIsVariable.setText(InputValueType.Variable.name());
        Group grpTestCaseCalling = new Group(this.fieldEditorParent, 0);
        grpTestCaseCalling.setText(ComposerTestcaseMessageConstants.PREF_GRP_TEST_CASE_CALLING);
        grpTestCaseCalling.setLayout((Layout)new GridLayout(1, false));
        grpTestCaseCalling.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnGenerateDefaultValue = new Button((Composite)grpTestCaseCalling, 16);
        this.btnGenerateDefaultValue.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnGenerateDefaultValue.setText(ComposerTestcaseMessageConstants.PREF_BTN_GEN_VAR_WITH_DEFAULT_VAL);
        Composite compositeGenerateVariable = new Composite((Composite)grpTestCaseCalling, 0);
        compositeGenerateVariable.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glCompositeGenerateVariable = new GridLayout(1, false);
        glCompositeGenerateVariable.marginWidth = 0;
        compositeGenerateVariable.setLayout((Layout)glCompositeGenerateVariable);
        this.btnGenerateVariable = new Button(compositeGenerateVariable, 16);
        this.btnGenerateVariable.setText(ComposerTestcaseMessageConstants.PREF_BTN_GEN_VAR_WITH_THE_SAME_NAME);
        this.btnExportVariable = new Button(compositeGenerateVariable, 32);
        GridData gd_btnExportVariable = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnExportVariable.horizontalIndent = 20;
        this.btnExportVariable.setLayoutData((Object)gd_btnExportVariable);
        this.btnExportVariable.setText(ComposerTestcaseMessageConstants.PREF_BTN_EXPOSE_VARS_AUTO);
        this.createTestCaseDefaultViewGroup();
        Composite compositeDefaultFailureHandling = new Composite(this.fieldEditorParent, 0);
        compositeDefaultFailureHandling.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        compositeDefaultFailureHandling.setLayout((Layout)new GridLayout(2, false));
        Composite compositeDefaultKeywordType = new Composite(this.fieldEditorParent, 0);
        compositeDefaultKeywordType.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        compositeDefaultKeywordType.setLayout((Layout)new GridLayout(2, false));
        Label lblDefaultKeywordType = new Label(compositeDefaultKeywordType, 0);
        lblDefaultKeywordType.setText(ComposerTestcaseMessageConstants.PREF_LBL_DEFAULT_KEYWORD_TYPE);
        this.comboKeywordType = new Combo(compositeDefaultKeywordType, 8);
        this.comboKeywordType.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.grpDefaultKeyword = new Group(this.fieldEditorParent, 0);
        this.grpDefaultKeyword.setText(ComposerTestcaseMessageConstants.PREF_GRP_DEFAULT_KEYWORD);
        GridData gd_grpDefaultKeyword = new GridData(4, 4, true, true, 1, 1);
        gd_grpDefaultKeyword.heightHint = 300;
        this.grpDefaultKeyword.setLayoutData((Object)gd_grpDefaultKeyword);
        this.grpDefaultKeyword.setLayout((Layout)new GridLayout(1, false));
        SashForm sashFormDefaultKeyword = new SashForm((Composite)this.grpDefaultKeyword, 0);
        sashFormDefaultKeyword.setSashWidth(5);
        sashFormDefaultKeyword.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        sashFormDefaultKeyword.setLocation(0, 0);
        Composite compositeKwType = new Composite((Composite)sashFormDefaultKeyword, 2048);
        GridLayout glCompositeKwType = new GridLayout(1, false);
        glCompositeKwType.verticalSpacing = 0;
        glCompositeKwType.marginHeight = 0;
        glCompositeKwType.marginWidth = 0;
        compositeKwType.setLayout((Layout)glCompositeKwType);
        Composite compositeKwTypeLabel = new Composite(compositeKwType, 0);
        compositeKwTypeLabel.setLayout((Layout)new GridLayout(1, false));
        compositeKwTypeLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblKeywordType = new Label(compositeKwTypeLabel, 0);
        lblKeywordType.setAlignment(0x1000000);
        lblKeywordType.setText(ComposerTestcaseMessageConstants.PREF_LBL_KEYWORK_TYPE);
        Label lblNewLabel_1 = new Label(compositeKwType, 258);
        lblNewLabel_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite compositeKwTypeListView = new Composite(compositeKwType, 0);
        GridLayout glCompositeKwTypeListView = new GridLayout(1, false);
        glCompositeKwTypeListView.marginWidth = 0;
        glCompositeKwTypeListView.marginHeight = 0;
        compositeKwTypeListView.setLayout((Layout)glCompositeKwTypeListView);
        compositeKwTypeListView.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewerKwType = new ListViewer(compositeKwTypeListView, 512);
        org.eclipse.swt.widgets.List listKeywordType = this.listViewerKwType.getList();
        listKeywordType.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewerKwType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewerKwType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IKeywordContributor && element != null) {
                    IKeywordContributor contributor = (IKeywordContributor)element;
                    return contributor.getLabelName();
                }
                return "";
            }
        });
        Composite compositeKwName = new Composite((Composite)sashFormDefaultKeyword, 2048);
        GridLayout gl_compositeKwName = new GridLayout(1, false);
        gl_compositeKwName.verticalSpacing = 0;
        gl_compositeKwName.marginHeight = 0;
        gl_compositeKwName.marginWidth = 0;
        compositeKwName.setLayout((Layout)gl_compositeKwName);
        Composite compositeKwNameLabel = new Composite(compositeKwName, 0);
        compositeKwNameLabel.setLayout((Layout)new GridLayout(1, false));
        compositeKwNameLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblNewLabel = new Label(compositeKwNameLabel, 0);
        lblNewLabel.setText(ComposerTestcaseMessageConstants.PREF_LBL_KEYWORK_NAME);
        Label lblSeparator = new Label(compositeKwName, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite compositeKwNameListView = new Composite(compositeKwName, 0);
        GridLayout glCompositeKwNameListView = new GridLayout(1, false);
        glCompositeKwNameListView.marginWidth = 0;
        glCompositeKwNameListView.marginHeight = 0;
        compositeKwNameListView.setLayout((Layout)glCompositeKwNameListView);
        compositeKwNameListView.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewerKwName = new ListViewer(compositeKwNameListView, 512);
        org.eclipse.swt.widgets.List listKeywordName = this.listViewerKwName.getList();
        listKeywordName.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewerKwName.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewerKwName.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof KeywordMethod && element != null) {
                    KeywordMethod method = (KeywordMethod)element;
                    return TreeEntityUtil.getReadableKeywordName((String)method.getName());
                }
                return "";
            }
        });
        sashFormDefaultKeyword.setWeights(new int[]{1, 1});
        this.initializeValue(false);
        this.registerControlModifyListeners();
        Group grpLineWrappingSettings = new Group(this.fieldEditorParent, 0);
        grpLineWrappingSettings.setText(ComposerTestcaseMessageConstants.PREF_MANUAL_GRP_LINE_WRAPPING);
        grpLineWrappingSettings.setLayout((Layout)new GridLayout(1, false));
        grpLineWrappingSettings.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnAllowLineWrapping = new Button((Composite)grpLineWrappingSettings, 32);
        this.btnAllowLineWrapping.setText(ComposerTestcaseMessageConstants.PREF_MANUAL_BTN_ENABLE_LINE_WRAPPING);
        this.cpsWrappingLineWidth = new Composite((Composite)grpLineWrappingSettings, 0);
        GridData gdCpsWrappingLineWidth = new GridData(4, 4, true, false, 1, 1);
        gdCpsWrappingLineWidth.horizontalIndent = 10;
        this.cpsWrappingLineWidth.setLayoutData((Object)gdCpsWrappingLineWidth);
        GridLayout glCpsWrappingLineWidth = new GridLayout(2, false);
        glCpsWrappingLineWidth.marginHeight = 0;
        glCpsWrappingLineWidth.marginWidth = 0;
        this.cpsWrappingLineWidth.setLayout((Layout)glCpsWrappingLineWidth);
        Label lblNewLabel1 = new Label(this.cpsWrappingLineWidth, 0);
        lblNewLabel1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNewLabel1.setText(ComposerTestcaseMessageConstants.PREF_MANUAL_LBL_LINE_WIDTH);
        this.txtMaximumLineWidth = new Text(this.cpsWrappingLineWidth, 2048);
        GridData gdTxtMaximumLineWidth = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdTxtMaximumLineWidth.widthHint = 50;
        this.txtMaximumLineWidth.setLayoutData((Object)gdTxtMaximumLineWidth);
        this.updateInput();
        this.registerControlModifyListenersforManual();
        return this.fieldEditorParent;
    }

    private void checkButtonAndNotifyToListener(Button btn, boolean selected) {
        btn.setSelection(selected);
        btn.notifyListeners(13, new Event());
    }

    private void updateInput() {
        this.checkButtonAndNotifyToListener(this.btnAllowLineWrapping, ManualPreferenceValueInitializer.isLineWrappingEnabled());
        this.txtMaximumLineWidth.setText(Integer.toString(ManualPreferenceValueInitializer.getMaximumLineWidth()));
    }

    private void createTestCaseDefaultViewGroup() {
        this.grpTestCaseDefaultView = new Group(this.fieldEditorParent, 0);
        this.grpTestCaseDefaultView.setText(ComposerTestcaseMessageConstants.PREF_GRP_TEST_CASE_DEFAULT_VIEW);
        GridData gd_grpTestCaseDefaultView = new GridData(4, 4, true, true, 1, 1);
        this.grpTestCaseDefaultView.setLayoutData((Object)gd_grpTestCaseDefaultView);
        this.grpTestCaseDefaultView.setLayout((Layout)new GridLayout(1, false));
        this.btnDefaultViewManual = new Button((Composite)this.grpTestCaseDefaultView, 16);
        this.btnDefaultViewManual.setText(ComposerTestcaseMessageConstants.PREF_BTN_DEFAULT_VIEW_MANUAL);
        this.btnDefaultViewScript = new Button((Composite)this.grpTestCaseDefaultView, 16);
        this.btnDefaultViewScript.setText(ComposerTestcaseMessageConstants.PREF_BTN_DEFAULT_VIEW_SCRIPT);
    }

    private void registerControlModifyListeners() {
        this.btnGenerateDefaultValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TestCasePreferencePage.this.btnGenerateDefaultValue.getSelection()) {
                    TestCasePreferencePage.this.btnExportVariable.setEnabled(false);
                    TestCasePreferencePage.this.btnGenerateVariable.setSelection(false);
                }
            }
        });
        this.btnGenerateVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TestCasePreferencePage.this.btnGenerateVariable.getSelection()) {
                    TestCasePreferencePage.this.btnExportVariable.setEnabled(true);
                    TestCasePreferencePage.this.btnGenerateDefaultValue.setSelection(false);
                }
            }
        });
        this.listViewerKwType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    TestCasePreferencePage.this.updateListViewKwName();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        this.listViewerKwName.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IKeywordContributor contributor = (IKeywordContributor)((IStructuredSelection)TestCasePreferencePage.this.listViewerKwType.getSelection()).getFirstElement();
                KeywordMethod method = (KeywordMethod)((IStructuredSelection)event.getSelection()).getFirstElement();
                TestCasePreferencePage.this.defaultKeywords.put(contributor.getKeywordClass().getName(), method.getName());
            }
        });
        this.registerControlModifyListenersForTestCaseStartView();
    }

    private void enableWrappingLineComposite(boolean enabled) {
        ControlUtils.recursiveSetEnabled((Control)this.cpsWrappingLineWidth, (boolean)enabled);
    }

    private void registerControlModifyListenersforManual() {
        this.btnAllowLineWrapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCasePreferencePage.this.enableWrappingLineComposite(TestCasePreferencePage.this.btnAllowLineWrapping.getSelection());
            }
        });
        this.txtMaximumLineWidth.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldS = TestCasePreferencePage.this.txtMaximumLineWidth.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                if (StringUtils.isEmpty((String)newS)) {
                    return;
                }
                e.doit = this.isPositive(newS);
            }

            private boolean isPositive(String s) {
                try {
                    return Integer.parseInt(s) >= 1;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
        this.txtMaximumLineWidth.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String lineWidth = TestCasePreferencePage.this.txtMaximumLineWidth.getText();
                if (StringUtils.isEmpty((String)lineWidth)) {
                    TestCasePreferencePage.this.txtMaximumLineWidth.setText(Integer.toString(ManualPreferenceValueInitializer.getMaximumLineWidth()));
                }
            }
        });
    }

    private void registerControlModifyListenersForTestCaseStartView() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCasePreferencePage.this.btnDefaultViewManual.setSelection(e.widget == TestCasePreferencePage.this.btnDefaultViewManual);
                TestCasePreferencePage.this.btnDefaultViewScript.setSelection(e.widget == TestCasePreferencePage.this.btnDefaultViewScript);
            }
        };
        this.btnDefaultViewManual.addSelectionListener((SelectionListener)selectionListener);
        this.btnDefaultViewScript.addSelectionListener((SelectionListener)selectionListener);
    }

    private void initializeValue(boolean isDefault) {
        try {
            this.initTestCaseCallingValue(isDefault);
            this.initDefaultKeywordType(isDefault);
            this.initDefaultKeywordValue(isDefault);
            this.initDefaultTestCaseView(isDefault);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void initDefaultTestCaseView(boolean isDefault) {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String defaultTestCaseView = isDefault ? preferenceStore.getDefaultString("default.startView") : preferenceStore.getString("default.startView");
        this.btnDefaultViewManual.setSelection(StringUtils.equals((String)defaultTestCaseView, (String)TestCaseCompositePart.MANUAL_TAB_TITLE));
        this.btnDefaultViewScript.setSelection(StringUtils.equals((String)defaultTestCaseView, (String)TestCaseCompositePart.SCRIPT_TAB_TITLE));
    }

    private void initDefaultKeywordType(boolean isDefault) {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String defaultKeywordTypeString = preferenceStore.getString("default.keywordType");
        if (isDefault) {
            defaultKeywordTypeString = preferenceStore.getDefaultString("default.keywordType");
        }
        int selectedIndex = 0;
        String[] keywordTypeStringArray = new String[this.contributors.length];
        int i = 0;
        while (i < this.contributors.length) {
            if (this.contributors[i].getKeywordClass().getName().equalsIgnoreCase(defaultKeywordTypeString)) {
                selectedIndex = i;
            }
            keywordTypeStringArray[i] = this.contributors[i].getLabelName();
            ++i;
        }
        this.comboKeywordType.setItems(keywordTypeStringArray);
        this.comboKeywordType.setText(keywordTypeStringArray[selectedIndex]);
    }

    private void initDefaultKeywordValue(boolean isDefault) throws Exception {
        if (this.contributors.length <= 0) {
            return;
        }
        this.listViewerKwType.setInput((Object)this.contributors);
        this.defaultKeywords = TestCasePreferenceDefaultValueInitializer.getDefaultKeywords();
        this.listViewerKwType.getList().deselectAll();
        if (this.listViewerKwType.getSelection() == null || this.listViewerKwType.getSelection().isEmpty()) {
            this.listViewerKwType.getList().select(0);
        }
        this.updateListViewKwName();
    }

    private void updateListViewKwName() throws Exception {
        IKeywordContributor contributor = (IKeywordContributor)((IStructuredSelection)this.listViewerKwType.getSelection()).getFirstElement();
        List methods = KeywordController.getInstance().getBuiltInKeywords(contributor.getKeywordClass().getSimpleName(), true);
        this.listViewerKwName.setInput((Object)methods);
        this.listViewerKwName.getList().deselectAll();
        String keywordName = this.defaultKeywords.get(contributor.getKeywordClass().getName());
        if (!StringUtils.isBlank((String)keywordName)) {
            for (KeywordMethod method : methods) {
                if (!method.getName().equals(keywordName)) continue;
                this.listViewerKwName.getList().select(methods.indexOf(method));
                this.listViewerKwName.getList().showSelection();
                break;
            }
        }
        if (this.listViewerKwName.getSelection() == null || this.listViewerKwName.getSelection().isEmpty()) {
            this.listViewerKwName.getList().select(0);
        }
    }

    private void initTestCaseCallingValue(boolean isDefault) {
        this.resetAllRadioButtonStates();
        String defaultVariableType = this.getPreferenceStore().getString("default.variableType");
        if (isDefault) {
            defaultVariableType = this.getPreferenceStore().getDefaultString("default.variableType");
        }
        InputValueType valueType = InputValueType.valueOf(defaultVariableType);
        switch (valueType) {
            case Variable: {
                this.btnDefaultVariableIsVariable.setSelection(true);
                break;
            }
            default: {
                this.btnDefaultVariableIsConstant.setSelection(true);
            }
        }
        boolean generateDefaultValue = this.getPreferenceStore().getBoolean("auto.generateDefaultVariableType");
        if (isDefault) {
            generateDefaultValue = this.getPreferenceStore().getDefaultBoolean("auto.generateDefaultVariableType");
        }
        if (generateDefaultValue) {
            this.btnGenerateDefaultValue.setSelection(true);
            this.btnExportVariable.setEnabled(false);
        } else {
            this.btnGenerateVariable.setSelection(true);
            this.btnExportVariable.setEnabled(true);
        }
        boolean exportVariables = this.getPreferenceStore().getBoolean("auto.exportVariable");
        if (isDefault) {
            exportVariables = this.getPreferenceStore().getDefaultBoolean("auto.exportVariable");
        }
        if (exportVariables) {
            this.btnExportVariable.setSelection(true);
        }
    }

    private void resetAllRadioButtonStates() {
        this.btnDefaultVariableIsConstant.setSelection(false);
        this.btnDefaultVariableIsVariable.setSelection(false);
        this.btnGenerateDefaultValue.setSelection(false);
        this.btnGenerateVariable.setSelection(false);
        this.btnExportVariable.setSelection(false);
        this.btnExportVariable.setEnabled(true);
    }

    protected void performDefaults() {
        if (this.fieldEditorParent == null) {
            return;
        }
        this.resetAllRadioButtonStates();
        this.initializeValue(true);
        if (this.isNotAbleToUpdate()) {
            return;
        }
        ManualPreferenceValueInitializer.defaultStore();
        this.updateInput();
    }

    private boolean isNotAbleToUpdate() {
        return this.fieldEditorParent == null || this.fieldEditorParent.isDisposed();
    }

    protected void performApply() {
        if (this.fieldEditorParent == null) {
            return;
        }
        if (this.btnDefaultVariableIsConstant.getSelection()) {
            this.getPreferenceStore().setValue("default.variableType", InputValueType.String.name());
        }
        if (this.btnDefaultVariableIsVariable.getSelection()) {
            this.getPreferenceStore().setValue("default.variableType", InputValueType.Variable.name());
        }
        this.getPreferenceStore().setValue("auto.generateDefaultVariableType", this.btnGenerateDefaultValue.getSelection());
        this.getPreferenceStore().setValue("auto.exportVariable", this.btnExportVariable.getSelection());
        String selectedKeywordType = this.comboKeywordType.getText();
        int i = 0;
        while (i < this.contributors.length) {
            if (this.contributors[i].getLabelName().equalsIgnoreCase(selectedKeywordType)) {
                this.getPreferenceStore().setValue("default.keywordType", this.contributors[i].getKeywordClass().getName());
                break;
            }
            ++i;
        }
        TestCasePreferenceDefaultValueInitializer.storeDefaultKeywords(this.defaultKeywords);
        this.applyValueForTestCaseStartView();
    }

    private void applyValueForTestCaseStartView() {
        String defaultTestCaseViewValue = null;
        if (this.btnDefaultViewManual.getSelection()) {
            defaultTestCaseViewValue = ComposerTestcaseMessageConstants.PA_TAB_MANUAL;
        } else if (this.btnDefaultViewScript.getSelection()) {
            defaultTestCaseViewValue = ComposerTestcaseMessageConstants.PA_TAB_SCRIPT;
        }
        if (defaultTestCaseViewValue == null) {
            return;
        }
        this.getPreferenceStore().setValue("default.startView", defaultTestCaseViewValue);
    }

    public boolean performOk() {
        block4: {
            try {
                boolean result = super.performOk();
                if (result && this.isValid()) {
                    this.performApply();
                }
                if (!this.isNotAbleToUpdate()) break block4;
                return true;
            }
            catch (IOException e) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerTestcaseMessageConstants.PREF_MANUAL_MSG_UNABLE_TO_UPDATE, (String)e.getMessage());
                LoggerSingleton.logError((Throwable)e);
                return false;
            }
        }
        ManualPreferenceValueInitializer.enableLineWrapping(this.btnAllowLineWrapping.getSelection());
        ManualPreferenceValueInitializer.setMaximumLineWidth(Integer.valueOf(this.txtMaximumLineWidth.getText()));
        ManualPreferenceValueInitializer.updateStore();
        return true;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.PREFERENCE_TEST_CASE;
    }
}

