/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.util;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.CastExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClassExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.DeclarationExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.Keys;

public class AstInputValueTypeProvider {
    private static HashMap<String, InputValueTypeProvider<? extends ASTNodeWrapper>> inputClasses;
    private static final InputValueTypeProvider<ClassNodeWrapper> classNodeValueTypeProvider;
    private static final InputValueTypeProvider<ConstantExpressionWrapper> constantValueTypeProvider;
    private static final InputValueTypeProvider<VariableExpressionWrapper> variableValueTypeProvider;
    private static final InputValueTypeProvider<BinaryExpressionWrapper> binaryValueTypeProvider;
    private static final InputValueTypeProvider<MethodCallExpressionWrapper> methodValueTypeProvider;
    private static final InputValueTypeProvider<BooleanExpressionWrapper> booleanValueTypeProvider;
    private static final InputValueTypeProvider<ClosureExpressionWrapper> closureValueTypeProvider;
    private static final InputValueTypeProvider<ClosureListExpressionWrapper> closureListValueTypeProvider;
    private static final InputValueTypeProvider<ListExpressionWrapper> listExpressionWrapper;
    private static final InputValueTypeProvider<MapExpressionWrapper> mapValueTypeProvider;
    private static final InputValueTypeProvider<RangeExpressionWrapper> rangeValueTypeProvider;
    private static final InputValueTypeProvider<PropertyExpressionWrapper> propertyValueTypeProvider;
    private static final InputValueTypeProvider<ClassExpressionWrapper> classValueTypeProvider;
    private static final InputValueTypeProvider<ConstructorCallExpressionWrapper> constructorCallValueTypeProvider;
    private static final InputValueTypeProvider<CastExpressionWrapper> castExpressionValueTypeProvider;

    static {
        classNodeValueTypeProvider = new InputValueTypeProvider<ClassNodeWrapper>(){

            @Override
            public InputValueType getInputValueType(ClassNodeWrapper classNode) {
                return InputValueType.Class;
            }
        };
        constantValueTypeProvider = new InputValueTypeProvider<ConstantExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(ConstantExpressionWrapper constantExpression) {
                if (constantExpression.isFalseExpression() || constantExpression.isTrueExpression()) {
                    return InputValueType.Boolean;
                }
                if (constantExpression.isNumberExpression()) {
                    return InputValueType.Number;
                }
                if (constantExpression.isNullExpression()) {
                    return InputValueType.Null;
                }
                return InputValueType.String;
            }
        };
        variableValueTypeProvider = new InputValueTypeProvider<VariableExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(VariableExpressionWrapper variableExpression) {
                if (variableExpression.getText().equals("this")) {
                    return InputValueType.This;
                }
                Class<?> type = AstKeywordsInputUtil.loadType(variableExpression.getText(), variableExpression.getScriptClass());
                if (type != null) {
                    return InputValueType.Class;
                }
                return InputValueType.Variable;
            }
        };
        binaryValueTypeProvider = new InputValueTypeProvider<BinaryExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(BinaryExpressionWrapper variableExpression) {
                return InputValueType.Binary;
            }
        };
        methodValueTypeProvider = new InputValueTypeProvider<MethodCallExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(MethodCallExpressionWrapper methodCallExpression) {
                if (methodCallExpression.isFindTestCaseMethodCall()) {
                    return InputValueType.TestCase;
                }
                if (methodCallExpression.isFindTestObjectMethodCall()) {
                    return InputValueType.TestObject;
                }
                if (methodCallExpression.isFindWindowsObjectMethodCall()) {
                    return InputValueType.WindowsObject;
                }
                if (methodCallExpression.isFindTestDataMethodCall()) {
                    return InputValueType.TestData;
                }
                if (methodCallExpression.isGetTestDataValueMethodCall()) {
                    return InputValueType.TestDataValue;
                }
                if (methodCallExpression.isKeysArgumentExpression()) {
                    return InputValueType.Keys;
                }
                return InputValueType.MethodCall;
            }
        };
        booleanValueTypeProvider = new InputValueTypeProvider<BooleanExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(BooleanExpressionWrapper booleanExpression) {
                return InputValueType.Condition;
            }
        };
        closureValueTypeProvider = new InputValueTypeProvider<ClosureExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(ClosureExpressionWrapper closureExpression) {
                return InputValueType.Closure;
            }
        };
        closureListValueTypeProvider = new InputValueTypeProvider<ClosureListExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(ClosureListExpressionWrapper closureListExpression) {
                return InputValueType.ClosureList;
            }
        };
        listExpressionWrapper = new InputValueTypeProvider<ListExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(ListExpressionWrapper listExpression) {
                return InputValueType.List;
            }
        };
        mapValueTypeProvider = new InputValueTypeProvider<MapExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(MapExpressionWrapper mapExpression) {
                return InputValueType.Map;
            }
        };
        rangeValueTypeProvider = new InputValueTypeProvider<RangeExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(RangeExpressionWrapper rangeExpression) {
                return InputValueType.Range;
            }
        };
        propertyValueTypeProvider = new InputValueTypeProvider<PropertyExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(PropertyExpressionWrapper propertyExpression) {
                if (StringUtils.equals((String)propertyExpression.getObjectExpressionAsString(), (String)InputValueType.GlobalVariable.name())) {
                    return InputValueType.GlobalVariable;
                }
                if (propertyExpression.isObjectExpressionOfClass(Keys.class)) {
                    return InputValueType.Key;
                }
                Class<?> type = AstKeywordsInputUtil.loadType(propertyExpression.getText(), propertyExpression.getScriptClass());
                if (type != null) {
                    return InputValueType.Class;
                }
                return InputValueType.Property;
            }
        };
        classValueTypeProvider = new InputValueTypeProvider<ClassExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(ClassExpressionWrapper classExpression) {
                return InputValueType.Class;
            }
        };
        constructorCallValueTypeProvider = new InputValueTypeProvider<ConstructorCallExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(ConstructorCallExpressionWrapper constructorCallExpression) {
                Class<?> throwableClass = AstKeywordsInputUtil.loadType(constructorCallExpression.getType().getName(), constructorCallExpression.getScriptClass());
                if (Throwable.class.isAssignableFrom(throwableClass)) {
                    return InputValueType.Throwable;
                }
                return InputValueType.Null;
            }
        };
        castExpressionValueTypeProvider = new InputValueTypeProvider<CastExpressionWrapper>(){

            @Override
            public InputValueType getInputValueType(CastExpressionWrapper castExpression) {
                if (castExpression.getExpression() instanceof ListExpressionWrapper) {
                    return InputValueType.List;
                }
                return InputValueType.Null;
            }
        };
        inputClasses = new HashMap();
        inputClasses.put(ClassNodeWrapper.class.getSimpleName(), classNodeValueTypeProvider);
        inputClasses.put(ConstantExpressionWrapper.class.getSimpleName(), constantValueTypeProvider);
        inputClasses.put(VariableExpressionWrapper.class.getSimpleName(), variableValueTypeProvider);
        inputClasses.put(BinaryExpressionWrapper.class.getSimpleName(), binaryValueTypeProvider);
        inputClasses.put(MethodCallExpressionWrapper.class.getSimpleName(), methodValueTypeProvider);
        inputClasses.put(BooleanExpressionWrapper.class.getSimpleName(), booleanValueTypeProvider);
        inputClasses.put(ClosureExpressionWrapper.class.getSimpleName(), closureValueTypeProvider);
        inputClasses.put(ClosureListExpressionWrapper.class.getSimpleName(), closureListValueTypeProvider);
        inputClasses.put(ListExpressionWrapper.class.getSimpleName(), listExpressionWrapper);
        inputClasses.put(MapExpressionWrapper.class.getSimpleName(), mapValueTypeProvider);
        inputClasses.put(RangeExpressionWrapper.class.getSimpleName(), rangeValueTypeProvider);
        inputClasses.put(PropertyExpressionWrapper.class.getSimpleName(), propertyValueTypeProvider);
        inputClasses.put(ClassExpressionWrapper.class.getSimpleName(), classValueTypeProvider);
        inputClasses.put(ConstructorCallExpressionWrapper.class.getSimpleName(), constructorCallValueTypeProvider);
        inputClasses.put(DeclarationExpressionWrapper.class.getSimpleName(), binaryValueTypeProvider);
        inputClasses.put(CastExpressionWrapper.class.getSimpleName(), castExpressionValueTypeProvider);
    }

    public static <T extends ASTNodeWrapper> InputValueType getInputValueTypeForASTNode(T astNode) {
        InputValueTypeProvider<? extends ASTNodeWrapper> provider = inputClasses.get(astNode.getClass().getSimpleName());
        if (provider != null) {
            return provider.getInputValueType(astNode);
        }
        return null;
    }

    static interface InputValueTypeProvider<T extends ASTNodeWrapper> {
        public InputValueType getInputValueType(T var1);
    }
}

