/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.util;

import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.TreeTableMenuItemConstants;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.keyword.internal.IKeywordContributor;
import com.kms.katalon.core.keyword.internal.KeywordContributorCollection;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.session.RemoteMobileExecutionSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TestCaseMenuUtil {
    private static final int DEFAULT_MAX_EXISTING_SESSION_TITLE = 20;

    public static MenuItem addActionSubMenu(Menu menu, TreeTableMenuItemConstants.AddAction addAction, String MenuText, SelectionListener selectionListener) {
        MenuItem actionMenuItem = new MenuItem(menu, 64);
        actionMenuItem.setText(MenuText);
        Menu actionMenu = new Menu(menu);
        actionMenuItem.setMenu(actionMenu);
        TestCaseMenuUtil.fillActionMenu(addAction, selectionListener, actionMenu);
        return actionMenuItem;
    }

    public static void fillActionMenu(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu, int[] excludes) {
        TestCaseMenuUtil.fillActionMenu(addAction, selectionListener, actionMenu);
        if (excludes != null) {
            HashSet<Integer> excludeIds = new HashSet<Integer>(Arrays.asList(ArrayUtils.toObject((int[])excludes)));
            MenuItem[] menuItemArray = actionMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                if (excludeIds.contains(item.getID())) {
                    item.dispose();
                }
                ++n2;
            }
        }
    }

    public static void fillActionMenu(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu) {
        TestCaseMenuUtil.addBuiltInKeywordMenuItems(addAction, selectionListener, actionMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_CUSTOM_KEYWORD, 32, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_CALL_TEST_CASE, 70, 8);
        new MenuItem(actionMenu, 2);
        MenuItem decisionMakingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_DECISION_MAKING_STATEMENT, 20, 64);
        Menu decisionMakingStatementWrappersMenu = new Menu(actionMenu);
        decisionMakingStatementWrappersMenuItem.setMenu(decisionMakingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_IF_STATEMENT, 1, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_ELSE_STATEMENT, 2, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_ELSE_IF_STATEMENT, 3, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_SWITCH_STATEMENT, 12, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_CASE_STATEMENT, 13, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, decisionMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_DEFAULT_STATEMENT, 14, 8);
        MenuItem loopingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_LOOPING_STATEMENT, 21, 64);
        Menu loopingMakingStatementWrappersMenu = new Menu(actionMenu);
        loopingStatementWrappersMenuItem.setMenu(loopingMakingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, loopingMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_FOR_STATEMENT, 5, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, loopingMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_WHILE_STATEMENT, 4, 8);
        MenuItem branchingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_BRANCHING_STATEMENT, 22, 64);
        Menu branchingMakingStatementWrappersMenu = new Menu(actionMenu);
        branchingStatementWrappersMenuItem.setMenu(branchingMakingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, branchingMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_BREAK_STATEMENT, 9, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, branchingMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_CONTINUE_STATEMENT, 10, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, branchingMakingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_RETURN_STATEMENT, 11, 8);
        MenuItem exceptionHandlingStatementWrappersMenuItem = TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_EXCEPTION_HANDLING_STATEMENT, 23, 64);
        new MenuItem(actionMenu, 2);
        Menu exceptionHandlingStatementWrappersMenu = new Menu(actionMenu);
        exceptionHandlingStatementWrappersMenuItem.setMenu(exceptionHandlingStatementWrappersMenu);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_TRY_STATEMENT, 15, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_CATCH_STATEMENT, 16, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_FINALLY_STATEMENT, 17, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, exceptionHandlingStatementWrappersMenu, ComposerTestcaseMessageConstants.TREE_THROW_STATEMENT, 18, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.TREE_BINARY_STATEMENT, 6, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.TREE_ASSERT_STATEMENT, 7, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.TREE_METHOD_CALL_STATEMENT, 8, 8);
        new MenuItem(actionMenu, 2);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_METHOD, 72, 8);
    }

    public static MenuItem generateExecuteFromTestStepMenuItem(Menu menu, SelectionListener selectionListener, int menuIndex) {
        return TestCaseMenuUtil.generateExecuteFromTestStepMenuItem(menu, selectionListener, menuIndex, LaunchMode.RUN);
    }

    public static List<MenuItem> generateExecuteFromTestStepMenuItems(Menu menu, SelectionListener selectionListener) {
        ArrayList<MenuItem> executeFromTestStepMenuItems = new ArrayList<MenuItem>();
        MenuItem runFromTestStepMenuItem = TestCaseMenuUtil.generateExecuteFromTestStepMenuItem(menu, selectionListener, -1, LaunchMode.RUN);
        executeFromTestStepMenuItems.add(runFromTestStepMenuItem);
        MenuItem debugFromTestStepMenuItem = TestCaseMenuUtil.generateExecuteFromTestStepMenuItem(menu, selectionListener, -1, LaunchMode.DEBUG);
        executeFromTestStepMenuItems.add(debugFromTestStepMenuItem);
        return executeFromTestStepMenuItems;
    }

    private static String appearTextDependOnLaunchMode(LaunchMode launchMode) {
        if (launchMode == LaunchMode.DEBUG) {
            return ComposerTestcaseMessageConstants.ADAP_MENU_CONTEXT_DEBUG_FROM_TEST_STEP;
        }
        return ComposerTestcaseMessageConstants.ADAP_MENU_CONTEXT_RUN_FROM_TEST_STEP;
    }

    public static MenuItem generateExecuteFromTestStepMenuItem(Menu menu, SelectionListener selectionListener, int menuIndex, LaunchMode launchMode) {
        List allAvailableExecutionSessions = ExecutionSessionSocketServer.getInstance().getAllAvailableExecutionSessions();
        boolean isExecutionSessionsEmpty = allAvailableExecutionSessions.isEmpty();
        MenuItem executeFromTestStepMenuItem = menuIndex >= 0 ? new MenuItem(menu, isExecutionSessionsEmpty ? 8 : 64, menuIndex) : new MenuItem(menu, isExecutionSessionsEmpty ? 8 : 64);
        String executeFromTestStepMenuItemText = TestCaseMenuUtil.appearTextDependOnLaunchMode(launchMode);
        executeFromTestStepMenuItem.setText(executeFromTestStepMenuItemText);
        executeFromTestStepMenuItem.addSelectionListener(selectionListener);
        if (isExecutionSessionsEmpty) {
            executeFromTestStepMenuItem.setEnabled(false);
            return executeFromTestStepMenuItem;
        }
        HashMap<String, Integer> labelMap = new HashMap<String, Integer>();
        Menu executeSessionMenu = new Menu(executeFromTestStepMenuItem);
        executeSessionMenu.setData((Object)launchMode);
        for (ExecutionSession executionSession : allAvailableExecutionSessions) {
            MenuItem executionSessionMenuItem = new MenuItem(executeSessionMenu, 8);
            String menuLabel = TestCaseMenuUtil.getLabelForExecutionSession(executionSession);
            if (labelMap.containsKey(menuLabel)) {
                Integer numberOfInstances = (Integer)labelMap.get(menuLabel) + 1;
                labelMap.put(menuLabel, numberOfInstances);
                menuLabel = String.valueOf(menuLabel) + " (" + numberOfInstances + ")";
            } else {
                labelMap.put(menuLabel, 1);
            }
            executionSessionMenuItem.setText(menuLabel);
            executionSessionMenuItem.addSelectionListener(selectionListener);
            executionSessionMenuItem.setID(50);
            executionSessionMenuItem.setData((Object)executionSession);
            executionSessionMenuItem.setImage(TestCaseMenuUtil.getImageForDriverType(executionSession));
        }
        executeFromTestStepMenuItem.setMenu(executeSessionMenu);
        return executeFromTestStepMenuItem;
    }

    private static String getLabelForExecutionSession(ExecutionSession executionSession) {
        String executionTitle = executionSession.getTitle();
        if (executionTitle.isEmpty()) {
            executionTitle = ComposerTestcaseMessageConstants.LBL_EXECUTION_EXISTING_SESSION_BLANK_TITLE;
        }
        return StringUtils.abbreviate((String)executionTitle, (int)20);
    }

    private static Image getImageForDriverType(ExecutionSession executionSession) {
        String driverTypeName = executionSession.getDriverTypeName();
        if (WebUIDriverType.KOBITON_WEB_DRIVER.toString().equals(driverTypeName) || executionSession instanceof RemoteMobileExecutionSession && ((RemoteMobileExecutionSession)executionSession).getRemoteType().equals(WebUIDriverType.KOBITON_WEB_DRIVER.getName())) {
            return ImageManager.getImage((String)"kobiton_16.png");
        }
        if (WebUIDriverType.ANDROID_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/android_16.png");
        }
        if (WebUIDriverType.CHROME_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/chrome_16.png");
        }
        if (WebUIDriverType.EDGE_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/edge_16.png");
        }
        if (WebUIDriverType.FIREFOX_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/firefox_16.png");
        }
        if (WebUIDriverType.HEADLESS_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/chrome_headless_16.png");
        }
        if (WebUIDriverType.IE_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/ie_16.png");
        }
        if (WebUIDriverType.IOS_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/apple_16.png");
        }
        if (WebUIDriverType.SAFARI_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/safari_16.png");
        }
        if (WebUIDriverType.FIREFOX_HEADLESS_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/firefox_headless_16.png");
        }
        if (WebUIDriverType.EDGE_CHROMIUM_DRIVER.toString().equals(driverTypeName)) {
            return ImageManager.getImage((String)"execution/edge_chromium_16.png");
        }
        return null;
    }

    public static void fillActionMenuAddTestSuite(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu) {
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_ADD_TO_AN_EXISTING_TEST_SUITE, 80, 8);
        TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, ComposerTestcaseMessageConstants.CONS_MENU_CONTEXT_ADD_TO_A_NEW_TEST_SUITE, 81, 8);
    }

    private static MenuItem addNewMenuItem(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu, String text, int id, int type) {
        MenuItem newMenuItem = new MenuItem(actionMenu, type);
        newMenuItem.setText(text);
        newMenuItem.addSelectionListener(selectionListener);
        newMenuItem.setID(id);
        newMenuItem.setData("ACTION", (Object)addAction);
        return newMenuItem;
    }

    private static void addBuiltInKeywordMenuItems(TreeTableMenuItemConstants.AddAction addAction, SelectionListener selectionListener, Menu actionMenu) {
        TreeTableMenuItemConstants.generateBuiltInKeywordMenuItemIDs(KeywordController.getInstance().getBuiltInKeywordClasses());
        for (IKeywordContributor contributor : KeywordContributorCollection.getKeywordContributors()) {
            int menuItemID = TreeTableMenuItemConstants.getMenuItemID(contributor.getAliasName());
            if (menuItemID < 0) continue;
            TestCaseMenuUtil.addNewMenuItem(addAction, selectionListener, actionMenu, contributor.getLabelName(), menuItemID, 8);
        }
    }
}

