/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.helper.AndroidSystemBarProperties;
import com.kms.katalon.core.mobile.helper.OSBarProperties;
import com.kms.katalon.core.mobile.helper.ViewportRect;
import com.kms.katalon.core.util.internal.JsonUtil;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import java.text.MessageFormat;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public final class AndroidHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(AndroidHelper.class);

    private AndroidHelper() {
    }

    public static int getStatusBarHeight(AppiumDriver<? extends WebElement> driver) {
        int statusBar = 0;
        try {
            statusBar = AndroidHelper.getStatusBarByProperty(driver);
        }
        catch (WebDriverException webDriverException) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "getSystemBar"));
        }
        if (statusBar == 0) {
            try {
                return AndroidHelper.getStatusBarHeightByCommand(driver);
            }
            catch (WebDriverException webDriverException) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "viewportRect"));
            }
        }
        return statusBar;
    }

    private static int getStatusBarByProperty(AppiumDriver<? extends WebElement> driver) throws WebDriverException {
        Map bars = ((AndroidDriver)driver).getSystemBars();
        AndroidSystemBarProperties barsProps = (AndroidSystemBarProperties)JsonUtil.fromJson((String)JsonUtil.toJson((Object)bars), AndroidSystemBarProperties.class);
        OSBarProperties statusBar = barsProps.getStatusBar();
        if (statusBar != null && statusBar.getWidth() > 0 && statusBar.getHeight() > 0) {
            return statusBar.getHeight();
        }
        return 0;
    }

    private static int getStatusBarHeightByCommand(AppiumDriver<? extends WebElement> driver) {
        Object res = driver.executeScript("mobile:viewportRect", new Object[0]);
        ViewportRect vp = (ViewportRect)JsonUtil.fromJson((String)res.toString(), ViewportRect.class);
        return vp.top == 0 ? 0 : vp.top;
    }
}

