/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.common.MobileXPathBuilder;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.AppiumDriverSession;
import com.kms.katalon.core.mobile.driver.AppiumSessionCollector;
import com.kms.katalon.core.mobile.helper.AndroidHelper;
import com.kms.katalon.core.mobile.helper.IOSHelper;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.ConsoleCommandBuilder;
import com.kms.katalon.core.util.internal.ProcessUtil;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.PointOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class MobileCommonHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(MobileCommonHelper.class);
    private static final String ATTRIBUTE_NAME_FOR_ANDROID_RESOURCE_ID = "resourceId";
    private static final String ATTRIBUTE_NAME_FOR_ANDROID_CONTENT_DESC = "name";
    public static final String PROPERTY_NAME_DEVICE_PIXEL_RATIO = "devicePixelRatio";
    public static final String PROPERTY_NAME_OS_STATUS_BAR_HEIGHT = "osStatusBarHeight";
    public static final String PROPERTY_NAME_STATUS_BAR_HEIGHT = "statusBarHeight";
    public static final String PROPERTY_NAME_SCALE_FACTOR = "scaleFactor";
    public static final String PROPERTY_NAME_IOS_BUNDLEID = "iosBundleId";
    public static Map<String, String> deviceModels = new HashMap<String, String>();
    public static Map<String, String> airPlaneButtonCoords;

    static {
        deviceModels.put("iPhone3,1", "iPhone 4");
        deviceModels.put("iPhone3,3", "iPhone 4");
        deviceModels.put("iPhone4,1", "iPhone 4S");
        deviceModels.put("iPhone5,1", "iPhone 5");
        deviceModels.put("iPhone5,2", "iPhone 5");
        deviceModels.put("iPhone5,3", "iPhone 5c");
        deviceModels.put("iPhone5,4", "iPhone 5c");
        deviceModels.put("iPhone6,1", "iPhone 5s");
        deviceModels.put("iPhone6,2", "iPhone 5s");
        deviceModels.put("iPhone7,1", "iPhone 6 Plus");
        deviceModels.put("iPhone7,2", "iPhone 6");
        deviceModels.put("iPad1,1", "iPad");
        deviceModels.put("iPad2,1", "iPad 2");
        deviceModels.put("iPad2,2", "iPad 2");
        deviceModels.put("iPad2,3", "iPad 2");
        deviceModels.put("iPad2,4", "iPad 2");
        deviceModels.put("iPad2,5", "iPad mini");
        deviceModels.put("iPad2,6", "iPad mini");
        deviceModels.put("iPad2,7", "iPad mini");
        deviceModels.put("iPad3,1", "iPad 3");
        deviceModels.put("iPad3,2", "iPad 3");
        deviceModels.put("iPad3,3", "iPad 3");
        deviceModels.put("iPad3,4", "iPad 4");
        deviceModels.put("iPad3,5", "iPad 4");
        deviceModels.put("iPad3,6", "iPad 4");
        deviceModels.put("iPad4,1", "iPad Air");
        deviceModels.put("iPad4,2", "iPad Air");
        deviceModels.put("iPad4,3", "iPad Air");
        deviceModels.put("iPad4,4", "iPad mini 2");
        deviceModels.put("iPad4,5", "iPad mini 2");
        deviceModels.put("iPad4,6", "iPad mini 2");
        deviceModels.put("iPad4,7", "iPad mini 3");
        deviceModels.put("iPad4,8", "iPad mini 3");
        deviceModels.put("iPad4,9", "iPad mini 3");
        deviceModels.put("iPad5,3", "iPad Air 2");
        deviceModels.put("iPad5,4", "iPad Air 2");
        airPlaneButtonCoords = new HashMap<String, String>();
        airPlaneButtonCoords.put("iPhone 5s", "40;195");
        airPlaneButtonCoords.put("iPhone 5", "40;195");
        airPlaneButtonCoords.put("iPad 2", "260;905");
        airPlaneButtonCoords.put("iPad 3", "260;905");
        airPlaneButtonCoords.put("iPad 4", "260;905");
        airPlaneButtonCoords.put("iPad Air", "260;905");
        airPlaneButtonCoords.put("iPad Air 2", "260;905");
        airPlaneButtonCoords.put("iPhone 6", "50;290");
        airPlaneButtonCoords.put("iPhone 6 Plus", "59;359");
        airPlaneButtonCoords.put("iPad mini", "265;905");
        airPlaneButtonCoords.put("iPad mini 2", "265;905");
        airPlaneButtonCoords.put("iPad mini 3", "265;905");
    }

    public static void swipe(AppiumDriver driver, int startX, int startY, int endX, int endY) {
        TouchAction swipe = new TouchAction((PerformsTouchActions)driver).press(PointOption.point((int)startX, (int)startY)).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(500L))).moveTo(PointOption.point((int)endX, (int)endY)).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(500L))).release();
        swipe.perform();
    }

    public static String getAttributeLocatorValue(TestObject testObject) {
        if (testObject == null || testObject.getProperties().isEmpty()) {
            return null;
        }
        MobileXPathBuilder xpathBuilder = new MobileXPathBuilder(testObject.getActiveProperties());
        return xpathBuilder.build();
    }

    public static String getAttributeValue(WebElement element, String attributeName) {
        switch (attributeName.toString()) {
            case "height": {
                return String.valueOf(element.getSize().height);
            }
            case "width": {
                return String.valueOf(element.getSize().width);
            }
            case "x": {
                return String.valueOf(element.getLocation().x);
            }
            case "y": {
                return String.valueOf(element.getLocation().y);
            }
            case "resource-id": {
                if (MobileDriverFactory.getDriver() instanceof AndroidDriver) {
                    return element.getAttribute(ATTRIBUTE_NAME_FOR_ANDROID_RESOURCE_ID);
                }
            }
            case "content-desc": {
                if (!(MobileDriverFactory.getDriver() instanceof AndroidDriver)) break;
                return element.getAttribute(ATTRIBUTE_NAME_FOR_ANDROID_CONTENT_DESC);
            }
        }
        try {
            return element.getAttribute(attributeName);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public static void checkXAndY(Number x, Number y) {
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_X);
        if (x == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FAILED_PARAM_X_CANNOT_BE_NULL, "x"));
        }
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_Y);
        if (y == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FAILED_PARAM_X_CANNOT_BE_NULL, "y"));
        }
    }

    public static void setCommonAppiumSessionProperties(AppiumDriver<? extends WebElement> driver) {
        AppiumDriverSession session = AppiumSessionCollector.getSession(driver);
        session.getProperties().put(PROPERTY_NAME_STATUS_BAR_HEIGHT, MobileCommonHelper.getStatusBarHeight(driver));
        session.getProperties().put(PROPERTY_NAME_SCALE_FACTOR, Float.valueOf(MobileCommonHelper.getScaleFactor(driver)));
    }

    public static int getStatusBarHeight(AppiumDriver<? extends WebElement> driver) {
        int statusBar = 0;
        if (driver instanceof AndroidDriver) {
            statusBar = AndroidHelper.getStatusBarHeight(driver);
        }
        if (driver instanceof IOSDriver) {
            statusBar = IOSHelper.getStatusBarHeight(driver);
        }
        return statusBar;
    }

    public static float getScaleFactor(AppiumDriver<? extends WebElement> driver) {
        float scaleFactor = 1.0f;
        if (driver instanceof IOSDriver) {
            scaleFactor = IOSHelper.getScaleFactor(driver);
        }
        return scaleFactor;
    }

    public static WebElement findElementByIosClassChain(IOSDriver iosDriver, String type, String name, String label) {
        IOSDriver driver = iosDriver;
        String locator = "**/%s[`name == '%s' OR label = '%s'`]";
        return driver.findElementByIosClassChain(String.format(locator, type, name, label));
    }

    public static WebElement findElementByIosClassChain(IOSDriver iosDriver, String type, String name) {
        IOSDriver driver = iosDriver;
        String locator = "**/%s[`name == '%s'`]";
        return driver.findElementByIosClassChain(String.format(locator, type, name));
    }

    public static int getMajorVersion(String version) {
        return Integer.parseInt(version.split("\\.")[0]);
    }

    public static boolean isIPhoneXOrLater(String deviceModel) {
        if (!deviceModel.contains("iPhone")) {
            return false;
        }
        String[] versionNumbers = deviceModel.replace("iPhone", "").split(",");
        int majorVersion = Integer.parseInt(versionNumbers[0]);
        int minorVersion = Integer.parseInt(versionNumbers[1]);
        return majorVersion >= 11 || majorVersion == 10 && (minorVersion == 3 || minorVersion == 6);
    }

    public static boolean isIPad(String deviceModel) {
        return deviceModel.contains("iPad");
    }

    public static long getAndroidPackageSize(String deviceId, String appId, String adbFolder) {
        try {
            String command = MessageFormat.format("adb -s {0} shell \"stat -c %s $(pm path {1} | grep base.apk | cut -d : -f 2)\"", deviceId, appId);
            List packageSize = ConsoleCommandBuilder.create((String)command).path(adbFolder).execSync();
            return Long.valueOf((String)packageSize.get(0));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static String getBundleId(String packagePath, String aaptFolder) {
        return MobileCommonHelper.grepBundleInfo(packagePath, aaptFolder, "package: name='(.*?)'");
    }

    public static String getBundleVersion(String packagePath, String aaptFolder) {
        return MobileCommonHelper.grepBundleInfo(packagePath, aaptFolder, "versionName='(.*?)'");
    }

    public static String grepBundleInfo(String packagePath, String aaptFolder, String infoPattern) {
        try {
            String command = MessageFormat.format("aapt dump badging \"{0}\"", packagePath);
            List infoLines = ConsoleCommandBuilder.create((String)command).path(aaptFolder).execSync();
            Pattern idPattern = Pattern.compile(infoPattern);
            for (String lineI : infoLines) {
                Matcher idMatcher = idPattern.matcher(lineI);
                if (!idMatcher.find()) continue;
                return idMatcher.group(1);
            }
            return null;
        }
        catch (IOException | InterruptedException exception) {
            return null;
        }
    }

    public static String getInstalledAppVersion(String deviceId, String appId, String adbFolder) {
        return MobileCommonHelper.grepInstalledAppInfo(deviceId, appId, adbFolder, "versionName=(.*?)(\\s|$)");
    }

    public static String grepInstalledAppInfo(String deviceId, String appId, String adbFolder, String infoPattern) {
        try {
            String command = MessageFormat.format("adb -s {0} shell dumpsys package \"{1}\"", deviceId, appId);
            List infoLines = ConsoleCommandBuilder.create((String)command).path(adbFolder).execSync();
            Pattern idPattern = Pattern.compile(infoPattern);
            for (String lineI : infoLines) {
                Matcher idMatcher = idPattern.matcher(lineI);
                if (!idMatcher.find()) continue;
                return idMatcher.group(1);
            }
            return null;
        }
        catch (IOException | InterruptedException exception) {
            return null;
        }
    }

    public static boolean isSameSize(String packagePath, String deviceId, String appId, String adbFolder) {
        long installedPackageSize = MobileCommonHelper.getAndroidPackageSize(deviceId, appId, adbFolder);
        try {
            return Files.size(new File(packagePath).toPath()) == installedPackageSize;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isSameVersion(String packagePath, String deviceId, String appId, String adbFolder, String aaptFolder) {
        String bundleVersion = MobileCommonHelper.getBundleVersion(packagePath, aaptFolder);
        String installedAppVersion = MobileCommonHelper.getInstalledAppVersion(deviceId, appId, adbFolder);
        return StringUtils.equals((CharSequence)bundleVersion, (CharSequence)installedAppVersion);
    }

    public static boolean isSameApp(String packagePath, String deviceId, String appId, String adbFolder, String aaptFolder) {
        return MobileCommonHelper.isSameVersion(packagePath, deviceId, appId, adbFolder, aaptFolder) && MobileCommonHelper.isSameSize(packagePath, deviceId, appId, adbFolder);
    }

    public static boolean inAndroidAppInstalled(String deviceId, String appId, String adbFolder) throws IOException, InterruptedException {
        List result = ConsoleCommandBuilder.create((String)MessageFormat.format("adb -s \"{0}\" shell pm path \"{1}\"", deviceId, appId)).path(adbFolder).execSync();
        return ProcessUtil.includes((List)result, (String)appId);
    }

    public static void uninstallAndroidApp(String deviceId, String appId, String adbFolder) throws IOException, InterruptedException {
        ConsoleCommandBuilder.create((String)MessageFormat.format("adb -s \"{0}\" uninstall \"{1}\"", deviceId, appId)).path(adbFolder).execSync();
    }
}

