/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.helper.screenshot.ScreenCaptor;
import com.kms.katalon.core.helper.screenshot.ScreenCaptureException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.AppiumDriverSession;
import com.kms.katalon.core.mobile.driver.AppiumSessionCollector;
import com.kms.katalon.core.mobile.exception.MobileException;
import com.kms.katalon.core.mobile.helper.MobileElementCommonHelper;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.testobject.TestObject;
import io.appium.java_client.AppiumDriver;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class MobileScreenCaptor
extends ScreenCaptor {
    private static final KeywordLogger _logger = KeywordLogger.getInstance(MobileScreenCaptor.class);
    private static final Color DEFAULT_HIDDEN_COLOR = Color.RED;

    protected void take(File newFile) throws ScreenCaptureException {
        AppiumDriver<?> driver = this.getAnyAppiumDriver();
        String context = driver.getContext();
        try {
            try {
                this.internalSwitchToNativeContext(driver);
                File tempFile = (File)driver.getScreenshotAs(OutputType.FILE);
                FileUtils.copyFile((File)tempFile, (File)newFile);
                FileUtils.forceDelete((File)tempFile);
            }
            catch (WebDriverException e) {
                throw new ScreenCaptureException((Exception)((Object)e));
            }
            catch (StepFailedException e) {
                throw new ScreenCaptureException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new ScreenCaptureException((Exception)e);
            }
        }
        finally {
            driver.context(context);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected AppiumDriver<?> getAnyAppiumDriver() {
        block5: {
            driver = null;
            try {
                driver = MobileDriverFactory.getDriver();
                break block5;
            }
            catch (StepFailedException v0) {
                var5_2 = RunConfiguration.getStoredDrivers();
                var4_3 = var5_2.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                driverObject = var5_2[var3_4];
                if (driverObject instanceof AppiumDriver) {
                    driver = (AppiumDriver)driverObject;
                }
                ++var3_4;
                continue;
            }
        }
        if (driver == null) {
            throw new StepFailedException(StringConstants.KW_MSG_UNABLE_FIND_DRIVER);
        }
        return driver;
    }

    protected boolean internalSwitchToNativeContext(AppiumDriver<?> driver) {
        return this.internalSwitchToContext(driver, "NATIVE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean internalSwitchToContext(AppiumDriver<?> driver, String contextName) {
        try {
            String context;
            Iterator iterator = driver.getContextHandles().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(context = (String)iterator.next()).contains(contextName));
            driver.context(context);
            return true;
        }
        catch (WebDriverException webDriverException) {}
        return false;
    }

    public static String takeScreenshot(AppiumDriver<? extends WebElement> driver, String fileName) {
        File tempFile = (File)driver.getScreenshotAs(OutputType.FILE);
        if (!tempFile.exists()) {
            throw new StepFailedException(StringConstants.KW_MSG_UNABLE_TO_TAKE_SCREENSHOT);
        }
        try {
            FileUtils.copyFile((File)tempFile, (File)new File(fileName));
            FileUtils.forceDelete((File)tempFile);
        }
        catch (Exception e) {
            _logger.logWarning(e.getMessage(), null, (Throwable)e);
            return null;
        }
        return fileName;
    }

    public static BufferedImage takeViewportScreenshot(AppiumDriver<? extends WebElement> driver, List<TestObject> ignoredElements, Color hidingColor) throws MobileException {
        AppiumDriverSession session = AppiumSessionCollector.getSession(driver);
        int statusBarHeight = (Integer)session.getProperties().get("statusBarHeight");
        float scaleFactor = ((Float)session.getProperties().get("scaleFactor")).floatValue();
        Color paintColor = hidingColor != null ? hidingColor : DEFAULT_HIDDEN_COLOR;
        BufferedImage screenshot = MobileScreenCaptor.takeScreenshot(driver);
        screenshot = MobileScreenCaptor.removeStatusBar(screenshot, statusBarHeight);
        screenshot = MobileScreenCaptor.hideElements(screenshot, driver, ignoredElements, paintColor, scaleFactor, statusBarHeight);
        return screenshot;
    }

    protected static BufferedImage takeScreenshot(AppiumDriver<? extends WebElement> driver) throws MobileException {
        try {
            byte[] rawImage = (byte[])driver.getScreenshotAs(OutputType.BYTES);
            return ImageIO.read(new ByteArrayInputStream(rawImage));
        }
        catch (Exception e) {
            throw new MobileException(StringConstants.KW_MSG_UNABLE_TO_TAKE_SCREENSHOT, e);
        }
    }

    public static BufferedImage hideElements(BufferedImage screenshot, AppiumDriver<? extends WebElement> driver, List<TestObject> ignoredElements, Color hideColor, float scaleFactor, int statusBarHeight) {
        Objects.requireNonNull(driver);
        Objects.requireNonNull(screenshot);
        if (ignoredElements == null || ignoredElements.isEmpty()) {
            _logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_SCREENSHOT_HIDDEN_OBJECTS_COUNT, "0"));
            return screenshot;
        }
        Graphics2D g = screenshot.createGraphics();
        if (hideColor == null) {
            hideColor = DEFAULT_HIDDEN_COLOR;
        }
        g.setColor(hideColor);
        int counter = 0;
        for (TestObject to : ignoredElements) {
            try {
                WebElement element = MobileElementCommonHelper.findElementWithCheck(to, 0);
                Rectangle boundedRect = MobileScreenCaptor.getBoundedRect(element, scaleFactor, statusBarHeight);
                g.fillRect(boundedRect.x, boundedRect.y, boundedRect.width, boundedRect.height);
                ++counter;
            }
            catch (Exception exception) {
                _logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_SCREENSHOT_FAILED_HIDE_OBJECT, to.getObjectId()));
            }
        }
        _logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_SCREENSHOT_HIDDEN_OBJECTS_COUNT, String.valueOf(counter)));
        return screenshot;
    }

    public static Rectangle getBoundedRect(WebElement element, float scaleFactor, int statusBarHeight) {
        Objects.requireNonNull(element);
        Rectangle rect = element.getRect();
        int targetRectWidth = (int)((float)rect.width * scaleFactor);
        int tartgetRectHeight = (int)((float)rect.height * scaleFactor);
        int targetRectX = (int)((float)rect.x * scaleFactor);
        int targetRectY = (int)((float)rect.y * scaleFactor) - statusBarHeight;
        return new Rectangle(targetRectX, targetRectY, tartgetRectHeight, targetRectWidth);
    }

    public static BufferedImage removeStatusBar(BufferedImage screenshot, int statusBarHeight) {
        if (statusBarHeight <= 0) {
            _logger.logWarning(StringConstants.KW_LOG_SCREENSHOT_STATUSBAR_EXIST);
            return screenshot;
        }
        int noStatusBarHeight = screenshot.getHeight() - statusBarHeight;
        return screenshot.getSubimage(0, statusBarHeight + 1, screenshot.getWidth(), noStatusBarHeight - 1);
    }

    public static BufferedImage takeElementScreenshot(AppiumDriver<? extends WebElement> driver, TestObject to, List<TestObject> ignoredElements, Color hidingColor) throws Exception {
        AppiumDriverSession session = AppiumSessionCollector.getSession(driver);
        int statusBarHeight = (Integer)session.getProperties().get("statusBarHeight");
        float scaleFactor = ((Float)session.getProperties().get("scaleFactor")).floatValue();
        BufferedImage screenshot = MobileScreenCaptor.takeViewportScreenshot(driver, ignoredElements, hidingColor);
        WebElement element = MobileElementCommonHelper.findElementWithCheck(to, 0);
        Rectangle rect = MobileScreenCaptor.getBoundedRect(element, scaleFactor, statusBarHeight);
        return screenshot.getSubimage(rect.x, rect.y, rect.width, rect.height);
    }

    public static BufferedImage takeAreaScreenshot(AppiumDriver<? extends WebElement> driver, Rectangle rect, List<TestObject> ignoredElements, Color hidingColor) throws MobileException {
        try {
            BufferedImage screenshot = MobileScreenCaptor.takeViewportScreenshot(driver, ignoredElements, hidingColor);
            return screenshot.getSubimage(rect.x, rect.y, rect.width, rect.height);
        }
        catch (Exception e) {
            throw new MobileException(StringConstants.KW_MSG_UNABLE_TO_TAKE_SCREENSHOT, e);
        }
    }
}

