/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import v2.io.swagger.deserializer.ApiDeclarationDeserializer;
import v2.io.swagger.deserializer.ResourceListingDeserializer;
import v2.io.swagger.io.Authentication;
import v2.io.swagger.io.NoAuthentication;
import v2.io.swagger.models.apideclaration.ApiDeclaration;
import v2.io.swagger.models.resourcelisting.ResourceListing;
import v2.io.swagger.parser.SwaggerException;
import v2.io.swagger.reader.SwaggerReader;
import v2.io.swagger.reader.SwaggerReaderConfiguration;
import v2.io.swagger.reader.SwaggerReaderFactory;
import v2.io.swagger.report.Message;
import v2.io.swagger.report.MessageBuilder;
import v2.io.swagger.report.Severity;
import v2.io.swagger.transform.migrate.ApiDeclarationMigrator;
import v2.io.swagger.transform.migrate.ResourceListingMigrator;
import v2.io.swagger.validate.ApiDeclarationJsonValidator;
import v2.io.swagger.validate.ResourceListingJsonValidator;

public class SwaggerLegacyParser {
    public ResourceListing read(String url) {
        return this.read(url, new NoAuthentication());
    }

    public ResourceListing read(String url, Authentication authentication) {
        MessageBuilder messageBuilder = new MessageBuilder();
        SwaggerReader swaggerReader = new SwaggerReaderFactory(new SwaggerReaderConfiguration()).newReader();
        JsonNode jsonNode = swaggerReader.read(url, authentication, messageBuilder);
        this.validateMessageReport(messageBuilder);
        ResourceListingMigrator resourceListingMigrator = new ResourceListingMigrator();
        jsonNode = resourceListingMigrator.migrate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ResourceListingJsonValidator resourceListingJsonValidator = new ResourceListingJsonValidator();
        resourceListingJsonValidator.validate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ResourceListingDeserializer resourceListingDeserializer = new ResourceListingDeserializer();
        ResourceListing resourceListing = (ResourceListing)resourceListingDeserializer.deserialize(jsonNode, messageBuilder);
        this.validateMessageReport(messageBuilder);
        return resourceListing;
    }

    public ApiDeclaration read(String url, String resourcePath) {
        return this.read(url, resourcePath, new NoAuthentication());
    }

    public ApiDeclaration read(String url, String resourcePath, Authentication authentication) {
        MessageBuilder messageBuilder = new MessageBuilder();
        SwaggerReader swaggerReader = new SwaggerReaderFactory(new SwaggerReaderConfiguration()).newReader();
        JsonNode jsonNode = null;
        try {
            String resourceListingURL = this.getResourceListingURL(url, resourcePath);
            jsonNode = swaggerReader.read(resourceListingURL, authentication, messageBuilder);
        }
        catch (URISyntaxException e) {
            messageBuilder.append(new Message("", e.getMessage(), Severity.ERROR));
        }
        this.validateMessageReport(messageBuilder);
        ApiDeclarationMigrator apiDeclarationMigrator = new ApiDeclarationMigrator();
        jsonNode = apiDeclarationMigrator.migrate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ApiDeclarationJsonValidator apiDeclarationJsonValidator = new ApiDeclarationJsonValidator();
        apiDeclarationJsonValidator.validate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ApiDeclarationDeserializer apiDeclarationDeserializer = new ApiDeclarationDeserializer();
        ApiDeclaration apiDeclaration = (ApiDeclaration)apiDeclarationDeserializer.deserialize(jsonNode, messageBuilder);
        this.validateMessageReport(messageBuilder);
        return apiDeclaration;
    }

    private String getResourceListingURL(String url, String resourcePath) throws URISyntaxException {
        URI uri = new URI(resourcePath);
        String resourceListingUrl = uri.isAbsolute() ? resourcePath : url + resourcePath;
        return resourceListingUrl;
    }

    private void validateMessageReport(MessageBuilder messageBuilder) {
        System.out.println((Object)messageBuilder.getHighestSeverity());
        if (messageBuilder.getHighestSeverity() == Severity.ERROR) {
            throw new SwaggerException(messageBuilder.toString());
        }
    }
}

