/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.parser.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import v2.io.swagger.models.ArrayModel;
import v2.io.swagger.models.ComposedModel;
import v2.io.swagger.models.HttpMethod;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.ModelImpl;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.RefModel;
import v2.io.swagger.models.RefPath;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.parameters.BodyParameter;
import v2.io.swagger.models.parameters.Parameter;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.RefProperty;
import v2.io.swagger.parser.ResolverCache;
import v2.io.swagger.parser.SwaggerResolver;
import v2.io.swagger.parser.processors.OperationProcessor;
import v2.io.swagger.parser.processors.ParameterProcessor;

public class PathsProcessor {
    private final Swagger swagger;
    private final ResolverCache cache;
    private final SwaggerResolver.Settings settings;
    private final ParameterProcessor parameterProcessor;
    private final OperationProcessor operationProcessor;

    public PathsProcessor(ResolverCache cache, Swagger swagger) {
        this(cache, swagger, new SwaggerResolver.Settings());
    }

    public PathsProcessor(ResolverCache cache, Swagger swagger, SwaggerResolver.Settings settings) {
        this.swagger = swagger;
        this.cache = cache;
        this.settings = settings;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.operationProcessor = new OperationProcessor(cache, swagger);
    }

    public void processPaths() {
        Map<String, Path> pathMap = this.swagger.getPaths();
        if (pathMap == null) {
            return;
        }
        for (String pathStr : pathMap.keySet()) {
            Path path = pathMap.get(pathStr);
            if (this.settings.addParametersToEachOperation()) {
                List<Operation> operations;
                List<Parameter> parameters = path.getParameters();
                if (parameters != null && (operations = path.getOperations()) != null) {
                    for (Operation operation : operations) {
                        ArrayList<Parameter> parametersToAdd = new ArrayList<Parameter>();
                        List<Parameter> existingParameters = operation.getParameters();
                        for (Parameter parameterToAdd : parameters) {
                            boolean matched = false;
                            for (Parameter existingParameter : existingParameters) {
                                if (parameterToAdd.getIn() == null || !parameterToAdd.getIn().equals(existingParameter.getIn()) || !parameterToAdd.getName().equals(existingParameter.getName())) continue;
                                matched = true;
                            }
                            if (matched) continue;
                            parametersToAdd.add(parameterToAdd);
                        }
                        if (parametersToAdd.size() <= 0) continue;
                        operation.getParameters().addAll(0, parametersToAdd);
                    }
                }
                path.setParameters(null);
            }
            if (path instanceof RefPath) {
                RefPath refPath = (RefPath)path;
                Path resolvedPath = this.cache.loadRef(refPath.get$ref(), refPath.getRefFormat(), Path.class);
                String pathRef = refPath.get$ref().split("#")[0];
                this.updateLocalRefs(resolvedPath, pathRef);
                if (resolvedPath != null) {
                    this.swagger.path(pathStr, resolvedPath);
                    path = resolvedPath;
                }
            }
            List<Parameter> processedPathParameters = this.parameterProcessor.processParameters(path.getParameters());
            path.setParameters(processedPathParameters);
            Map<HttpMethod, Operation> operationMap = path.getOperationMap();
            for (HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = operationMap.get((Object)httpMethod);
                this.operationProcessor.processOperation(operation);
            }
        }
    }

    protected void updateLocalRefs(Path path, String pathRef) {
        if (path.getParameters() != null) {
            List<Parameter> params = path.getParameters();
            for (Parameter param : params) {
                this.updateLocalRefs(param, pathRef);
            }
        }
        List<Operation> ops = path.getOperations();
        for (Operation op : ops) {
            if (op.getParameters() != null) {
                for (Parameter param : op.getParameters()) {
                    this.updateLocalRefs(param, pathRef);
                }
            }
            if (op.getResponses() == null) continue;
            for (Response response : op.getResponses().values()) {
                this.updateLocalRefs(response, pathRef);
            }
        }
    }

    protected void updateLocalRefs(Response response, String pathRef) {
        if (response.getSchema() != null) {
            this.updateLocalRefs(response.getSchema(), pathRef);
        }
    }

    protected void updateLocalRefs(Parameter param, String pathRef) {
        BodyParameter bp;
        if (param instanceof BodyParameter && (bp = (BodyParameter)param).getSchema() != null) {
            this.updateLocalRefs(bp.getSchema(), pathRef);
        }
    }

    protected void updateLocalRefs(Model model, String pathRef) {
        ArrayModel am;
        if (model instanceof RefModel) {
            RefModel refModel = (RefModel)model;
            if (this.isLocalRef(refModel.get$ref())) {
                refModel.set$ref(this.computeLocalRef(refModel.get$ref(), pathRef));
            }
        } else if (model instanceof ModelImpl) {
            ModelImpl impl = (ModelImpl)model;
            if (impl.getProperties() != null) {
                for (Property property : impl.getProperties().values()) {
                    this.updateLocalRefs(property, pathRef);
                }
            }
        } else if (model instanceof ComposedModel) {
            ComposedModel cm = (ComposedModel)model;
            for (Model innerModel : cm.getAllOf()) {
                this.updateLocalRefs(innerModel, pathRef);
            }
        } else if (model instanceof ArrayModel && (am = (ArrayModel)model).getItems() != null) {
            this.updateLocalRefs(am.getItems(), pathRef);
        }
    }

    protected void updateLocalRefs(Property property, String pathRef) {
        RefProperty ref;
        if (property instanceof RefProperty && this.isLocalRef((ref = (RefProperty)property).get$ref())) {
            ref.set$ref(this.computeLocalRef(ref.get$ref(), pathRef));
        }
    }

    protected boolean isLocalRef(String ref) {
        return ref.startsWith("#");
    }

    protected String computeLocalRef(String ref, String prefix) {
        return prefix + ref;
    }
}

