/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.transform.migrate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import v2.io.swagger.transform.migrate.SwaggerMigrator;
import v2.io.swagger.transform.util.SwaggerMigrationException;
import v2.io.swagger.transform.util.SwaggerMigrators;

public final class V11TypeMigrator
implements SwaggerMigrator {
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final TypeReference<Map<String, JsonPatch>> TYPE_REF = new TypeReference<Map<String, JsonPatch>>(){};
    private static final JsonPatch DEFAULT_PATCH;
    private final Map<String, JsonPatch> patches;
    private final JsonPatch fileTypePatch;

    public V11TypeMigrator() {
        try {
            JsonNode node = JsonLoader.fromResource((String)"/patches/v1.1/dataType.json");
            this.patches = (Map)MAPPER.readValue(node.traverse(), TYPE_REF);
            node = JsonLoader.fromResource((String)"/patches/other/fileTypePatch.json");
            this.fileTypePatch = (JsonPatch)MAPPER.readValue(node.traverse(), JsonPatch.class);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load the necessary file", e);
        }
    }

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        Objects.requireNonNull(input);
        JsonNode node = input.path("dataType");
        if (node.isMissingNode()) {
            return this.postMigrate(input);
        }
        if (!node.isTextual()) {
            throw new SwaggerMigrationException("dataType is not a text field");
        }
        String dataType = node.textValue();
        JsonPatch patch = (JsonPatch)Optional.fromNullable((Object)this.patches.get(dataType)).or((Object)DEFAULT_PATCH);
        JsonNode migrated = SwaggerMigrators.fromPatch(patch).migrate(input);
        return this.postMigrate(migrated);
    }

    private JsonNode postMigrate(JsonNode input) throws SwaggerMigrationException {
        JsonNode typeNode = input.path("type");
        if (!typeNode.isTextual()) {
            return input;
        }
        if (!"File".equals(typeNode.textValue())) {
            return input;
        }
        try {
            return this.fileTypePatch.apply(input);
        }
        catch (JsonPatchException e) {
            throw new SwaggerMigrationException(e);
        }
    }

    static {
        String op = "[{\"op\":\"move\",\"from\":\"/dataType\",\"path\":\"/$ref\"}]";
        try {
            DEFAULT_PATCH = (JsonPatch)MAPPER.readValue("[{\"op\":\"move\",\"from\":\"/dataType\",\"path\":\"/$ref\"}]", JsonPatch.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

