/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import v2.io.swagger.annotations.ApiImplicitParam;
import v2.io.swagger.annotations.ApiParam;
import v2.io.swagger.annotations.Example;
import v2.io.swagger.annotations.ExampleProperty;
import v2.io.swagger.converter.ModelConverters;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.parameters.AbstractSerializableParameter;
import v2.io.swagger.models.parameters.BodyParameter;
import v2.io.swagger.models.parameters.Parameter;
import v2.io.swagger.models.properties.AbstractNumericProperty;
import v2.io.swagger.models.properties.FileProperty;
import v2.io.swagger.models.properties.LongProperty;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.PropertyBuilder;
import v2.io.swagger.models.properties.StringProperty;
import v2.io.swagger.util.AllowableValues;
import v2.io.swagger.util.AllowableValuesUtils;

public class ParameterProcessor {
    static Logger LOGGER = LoggerFactory.getLogger(ParameterProcessor.class);

    public static Parameter applyAnnotations(Swagger swagger, Parameter parameter, Type type, List<Annotation> annotations) {
        AnnotationsHelper helper = new AnnotationsHelper(annotations, type);
        if (helper.isContext()) {
            return null;
        }
        ParamWrapper<?> param = helper.getApiParam();
        if (param.isHidden()) {
            return null;
        }
        String defaultValue = helper.getDefaultValue();
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter p = (AbstractSerializableParameter)parameter;
            if (param.isRequired()) {
                p.setRequired(true);
            }
            if (param.getReadOnly()) {
                p.readOnly(param.getReadOnly());
            }
            if (param.getAllowEmptyValue()) {
                p.allowEmptyValue(param.getAllowEmptyValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getName())) {
                p.setName(param.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getDescription())) {
                p.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getExample())) {
                p.setExample(param.getExample());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getAccess())) {
                p.setAccess(param.getAccess());
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{param.getCollectionFormat()})) {
                p.setCollectionFormat(param.getCollectionFormat());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getDataType())) {
                if ("java.io.File".equalsIgnoreCase(param.getDataType())) {
                    p.setProperty(new FileProperty());
                } else if ("long".equalsIgnoreCase(param.getDataType())) {
                    p.setProperty(new LongProperty());
                } else {
                    p.setType(param.getDataType());
                }
            }
            if (helper.getMin() != null) {
                p.setMinimum(helper.getMin());
                if (helper.isMinExclusive()) {
                    p.setExclusiveMinimum(true);
                }
            }
            if (helper.getMax() != null) {
                p.setMaximum(helper.getMax());
                if (helper.isMaxExclusive()) {
                    p.setExclusiveMaximum(true);
                }
            }
            if (helper.getMinItems() != null) {
                p.setMinItems(helper.getMinItems());
            }
            if (helper.getMaxItems() != null) {
                p.setMaxItems(helper.getMaxItems());
            }
            if (helper.getMinLength() != null) {
                p.setMinLength(helper.getMinLength());
            }
            if (helper.getMaxLength() != null) {
                p.setMaxLength(helper.getMaxLength());
            }
            if (helper.getPattern() != null) {
                p.setPattern(helper.getPattern());
            }
            if (helper.isRequired() != null) {
                p.setRequired(true);
            }
            if (helper.getType() != null) {
                p.setType(helper.getType());
            }
            if (helper.getFormat() != null) {
                p.setFormat(helper.getFormat());
            }
            AllowableValues allowableValues = AllowableValuesUtils.create(param.getAllowableValues());
            if (p.getItems() != null || param.isAllowMultiple()) {
                EnumMap<PropertyBuilder.PropertyId, Object> args;
                if (p.getItems() == null) {
                    args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                    args.put(PropertyBuilder.PropertyId.DEFAULT, p.getDefaultValue());
                    p.setDefaultValue(null);
                    args.put(PropertyBuilder.PropertyId.ENUM, p.getEnum());
                    p.setEnum(null);
                    args.put(PropertyBuilder.PropertyId.MINIMUM, p.getMinimum());
                    p.setMinimum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)p.isExclusiveMinimum());
                    p.setExclusiveMinimum(null);
                    args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)p.getMaximum());
                    p.setMaximum(null);
                    args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)p.isExclusiveMaximum());
                    args.put(PropertyBuilder.PropertyId.MIN_LENGTH, (Object)p.getMinLength());
                    p.setMinLength(null);
                    args.put(PropertyBuilder.PropertyId.MAX_LENGTH, (Object)p.getMaxLength());
                    p.setMaxLength(null);
                    args.put(PropertyBuilder.PropertyId.PATTERN, (Object)p.getPattern());
                    p.setPattern(null);
                    args.put(PropertyBuilder.PropertyId.EXAMPLE, p.getExample());
                    p.setExclusiveMaximum(null);
                    Property items = PropertyBuilder.build(p.getType(), p.getFormat(), args);
                    ((AbstractSerializableParameter)((AbstractSerializableParameter)p.type("array")).format(null)).items(items);
                }
                args = new EnumMap(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                if (helper.getMin() != null) {
                    args.put(PropertyBuilder.PropertyId.MINIMUM, helper.getMin());
                    if (helper.isMinExclusive()) {
                        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, Boolean.valueOf(true));
                    }
                }
                if (helper.getMax() != null) {
                    args.put(PropertyBuilder.PropertyId.MAXIMUM, helper.getMax());
                    if (helper.isMaxExclusive()) {
                        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, Boolean.valueOf(true));
                    }
                }
                if (helper.getMinLength() != null) {
                    args.put(PropertyBuilder.PropertyId.MIN_LENGTH, helper.getMinLength());
                }
                if (helper.getMaxLength() != null) {
                    args.put(PropertyBuilder.PropertyId.MAX_LENGTH, helper.getMaxLength());
                }
                if (helper.getPattern() != null) {
                    args.put(PropertyBuilder.PropertyId.PATTERN, helper.getPattern());
                }
                if (allowableValues != null) {
                    args.putAll(allowableValues.asPropertyArguments());
                }
                PropertyBuilder.merge(p.getItems(), args);
            } else {
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    p.setDefaultValue(defaultValue);
                }
                if (allowableValues != null) {
                    ParameterProcessor.processAllowedValues(allowableValues, p);
                }
            }
        } else {
            Property property;
            BodyParameter bp = new BodyParameter();
            if (helper.getApiParam() != null) {
                String value;
                String mediaType;
                Example example;
                ParamWrapper<ApiParam> apiParam;
                ParamWrapper<?> pw = helper.getApiParam();
                if (pw instanceof ApiParamWrapper) {
                    apiParam = (ApiParamWrapper)pw;
                    example = ((ApiParamWrapper)apiParam).getExamples();
                    if (example != null && example.value() != null) {
                        for (ExampleProperty ex : example.value()) {
                            mediaType = ex.mediaType();
                            value = ex.value();
                            if (mediaType.isEmpty() || value.isEmpty()) continue;
                            bp.example(mediaType.trim(), value.trim());
                        }
                    }
                } else if (pw instanceof ApiImplicitParamWrapper && (example = ((ApiImplicitParamWrapper)(apiParam = (ApiImplicitParamWrapper)pw)).getExamples()) != null && example.value() != null) {
                    for (ExampleProperty ex : example.value()) {
                        mediaType = ex.mediaType();
                        value = ex.value();
                        if (mediaType.isEmpty() || value.isEmpty()) continue;
                        bp.example(mediaType.trim(), value.trim());
                    }
                }
            }
            bp.setRequired(param.isRequired());
            bp.setName(StringUtils.isNotEmpty((CharSequence)param.getName()) ? param.getName() : "body");
            if (StringUtils.isNotEmpty((CharSequence)param.getDescription())) {
                bp.setDescription(param.getDescription());
            }
            if (StringUtils.isNotEmpty((CharSequence)param.getAccess())) {
                bp.setAccess(param.getAccess());
            }
            if ((property = ModelConverters.getInstance().readAsProperty(type)) != null) {
                EnumMap<PropertyBuilder.PropertyId, Object> args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    args.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                }
                bp.setSchema(PropertyBuilder.toModel(PropertyBuilder.merge(property, args)));
                for (Map.Entry<String, Model> entry : ModelConverters.getInstance().readAll(type).entrySet()) {
                    swagger.addDefinition(entry.getKey(), entry.getValue());
                }
            }
            parameter = bp;
        }
        return parameter;
    }

    private static void processAllowedValues(AllowableValues allowableValues, AbstractSerializableParameter<?> p) {
        if (allowableValues == null) {
            return;
        }
        Map<PropertyBuilder.PropertyId, Object> args = allowableValues.asPropertyArguments();
        if (args.containsKey((Object)PropertyBuilder.PropertyId.ENUM)) {
            p.setEnum((List)args.get((Object)PropertyBuilder.PropertyId.ENUM));
        } else {
            if (args.containsKey((Object)PropertyBuilder.PropertyId.MINIMUM)) {
                p.setMinimum((BigDecimal)args.get((Object)PropertyBuilder.PropertyId.MINIMUM));
            }
            if (args.containsKey((Object)PropertyBuilder.PropertyId.MAXIMUM)) {
                p.setMaximum((BigDecimal)args.get((Object)PropertyBuilder.PropertyId.MAXIMUM));
            }
            if (args.containsKey((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM)) {
                p.setExclusiveMinimum((Boolean)args.get((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM) != false ? Boolean.valueOf(true) : null);
            }
            if (args.containsKey((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM)) {
                p.setExclusiveMaximum((Boolean)args.get((Object)PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM) != false ? Boolean.valueOf(true) : null);
            }
        }
    }

    private static void processJsr303Annotations(AnnotationsHelper helper, AbstractSerializableParameter<?> p) {
        if (helper == null) {
            return;
        }
        if (helper.getMin() != null) {
            p.setMinimum(helper.getMin());
        }
        if (helper.getMax() != null) {
            p.setMaximum(helper.getMax());
        }
    }

    private static final class ApiImplicitParamWrapper
    implements ParamWrapper<ApiImplicitParam> {
        private final ApiImplicitParam apiParam;

        private ApiImplicitParamWrapper(ApiImplicitParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return this.apiParam.dataType();
        }

        @Override
        public String getParamType() {
            return this.apiParam.paramType();
        }

        @Override
        public ApiImplicitParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }

        @Override
        public String getType() {
            return this.apiParam.type();
        }

        @Override
        public String getFormat() {
            return this.apiParam.format();
        }

        @Override
        public boolean getReadOnly() {
            return this.apiParam.readOnly();
        }

        @Override
        public boolean getAllowEmptyValue() {
            return this.apiParam.allowEmptyValue();
        }

        @Override
        public String getCollectionFormat() {
            return this.apiParam.collectionFormat();
        }
    }

    private static final class ApiParamWrapper
    implements ParamWrapper<ApiParam> {
        private final ApiParam apiParam;

        private ApiParamWrapper(ApiParam apiParam) {
            this.apiParam = apiParam;
        }

        @Override
        public String getName() {
            return this.apiParam.name();
        }

        @Override
        public String getDescription() {
            return this.apiParam.value();
        }

        @Override
        public String getDefaultValue() {
            return this.apiParam.defaultValue();
        }

        @Override
        public String getAllowableValues() {
            return this.apiParam.allowableValues();
        }

        @Override
        public boolean isRequired() {
            return this.apiParam.required();
        }

        @Override
        public String getAccess() {
            return this.apiParam.access();
        }

        @Override
        public boolean isAllowMultiple() {
            return this.apiParam.allowMultiple();
        }

        @Override
        public String getDataType() {
            return null;
        }

        @Override
        public String getParamType() {
            return null;
        }

        @Override
        public ApiParam getAnnotation() {
            return this.apiParam;
        }

        @Override
        public boolean isHidden() {
            return this.apiParam.hidden();
        }

        @Override
        public String getExample() {
            return this.apiParam.example();
        }

        public Example getExamples() {
            return this.apiParam.examples();
        }

        @Override
        public String getType() {
            return this.apiParam.type();
        }

        @Override
        public String getFormat() {
            return this.apiParam.format();
        }

        @Override
        public boolean getReadOnly() {
            return this.apiParam.readOnly();
        }

        @Override
        public boolean getAllowEmptyValue() {
            return this.apiParam.allowEmptyValue();
        }

        @Override
        public String getCollectionFormat() {
            return this.apiParam.collectionFormat();
        }
    }

    private static class AnnotationsHelper {
        private static final ApiParam DEFAULT_API_PARAM = AnnotationsHelper.getDefaultApiParam(null);
        private boolean context;
        private ParamWrapper<?> apiParam = new ApiParamWrapper(DEFAULT_API_PARAM);
        private String type;
        private String format;
        private String defaultValue;
        private Integer minItems;
        private Integer maxItems;
        private Boolean required;
        private BigDecimal min;
        private boolean minExclusive = false;
        private BigDecimal max;
        private boolean maxExclusive = false;
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private Boolean allowEmptyValue;
        private String collectionFormat;

        public AnnotationsHelper(List<Annotation> annotations, Type _type) {
            String rsDefault = null;
            Size size = null;
            for (Annotation item : annotations) {
                if ("javax.ws.rs.core.Context".equals(item.annotationType().getName())) {
                    this.context = true;
                    continue;
                }
                if (item instanceof ApiParam) {
                    this.apiParam = new ApiParamWrapper((ApiParam)item);
                    continue;
                }
                if (item instanceof ApiImplicitParam) {
                    this.apiParam = new ApiImplicitParamWrapper((ApiImplicitParam)item);
                    continue;
                }
                if ("javax.ws.rs.DefaultValue".equals(item.annotationType().getName())) {
                    try {
                        rsDefault = (String)item.annotationType().getMethod("value", new Class[0]).invoke((Object)item, new Object[0]);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Invocation of value method failed", (Throwable)ex);
                    }
                    continue;
                }
                if (item instanceof Size) {
                    size = (Size)item;
                    continue;
                }
                if (item instanceof NotNull) {
                    this.required = true;
                    continue;
                }
                if (item instanceof Min) {
                    this.min = new BigDecimal(((Min)item).value());
                    continue;
                }
                if (item instanceof Max) {
                    this.max = new BigDecimal(((Max)item).value());
                    continue;
                }
                if (item instanceof DecimalMin) {
                    DecimalMin decimalMinAnnotation = (DecimalMin)item;
                    this.min = new BigDecimal(decimalMinAnnotation.value());
                    this.minExclusive = !decimalMinAnnotation.inclusive();
                    continue;
                }
                if (item instanceof DecimalMax) {
                    DecimalMax decimalMaxAnnotation = (DecimalMax)item;
                    this.max = new BigDecimal(decimalMaxAnnotation.value());
                    this.maxExclusive = !decimalMaxAnnotation.inclusive();
                    continue;
                }
                if (!(item instanceof Pattern)) continue;
                this.pattern = ((Pattern)item).regexp();
            }
            if (size != null) {
                boolean defaultToArray;
                Property property = ModelConverters.getInstance().readAsProperty(_type);
                boolean bl = defaultToArray = this.apiParam != null && this.apiParam.isAllowMultiple();
                if (!defaultToArray && property instanceof AbstractNumericProperty) {
                    this.min = new BigDecimal(size.min());
                    this.max = new BigDecimal(size.max());
                } else if (!defaultToArray && property instanceof StringProperty) {
                    this.minLength = size.min();
                    this.maxLength = size.max();
                } else {
                    this.minItems = size.min();
                    this.maxItems = size.max();
                }
            }
            this.defaultValue = StringUtils.isNotEmpty((CharSequence)this.apiParam.getDefaultValue()) ? this.apiParam.getDefaultValue() : rsDefault;
            this.type = StringUtils.isNotEmpty((CharSequence)this.apiParam.getType()) ? this.apiParam.getType() : null;
            this.format = StringUtils.isNotEmpty((CharSequence)this.apiParam.getFormat()) ? this.apiParam.getFormat() : null;
            this.allowEmptyValue = this.apiParam.isAllowMultiple() ? Boolean.valueOf(true) : null;
            this.collectionFormat = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.apiParam.getCollectionFormat()}) ? this.apiParam.getCollectionFormat() : null;
        }

        private boolean isAssignableToNumber(Class<?> clazz) {
            return Number.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz);
        }

        private static ApiParam getDefaultApiParam(@ApiParam String annotationHolder) {
            for (Method method : AnnotationsHelper.class.getDeclaredMethods()) {
                if (!"getDefaultApiParam".equals(method.getName())) continue;
                return (ApiParam)method.getParameterAnnotations()[0][0];
            }
            throw new IllegalStateException("Failed to locate default @ApiParam");
        }

        public boolean isContext() {
            return this.context;
        }

        public ParamWrapper<?> getApiParam() {
            return this.apiParam;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getMinItems() {
            return this.minItems;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public Boolean isRequired() {
            return this.required;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public boolean isMaxExclusive() {
            return this.maxExclusive;
        }

        public BigDecimal getMin() {
            return this.min;
        }

        public String getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isMinExclusive() {
            return this.minExclusive;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Boolean getAllowEmptyValue() {
            return this.allowEmptyValue;
        }

        public String getCollectionFormat() {
            return this.collectionFormat;
        }
    }

    public static interface ParamWrapper<T extends Annotation> {
        public String getName();

        public String getDescription();

        public String getDefaultValue();

        public String getAllowableValues();

        public boolean isRequired();

        public String getAccess();

        public boolean isAllowMultiple();

        public String getDataType();

        public String getParamType();

        public T getAnnotation();

        public boolean isHidden();

        public String getExample();

        public String getType();

        public String getFormat();

        public boolean getReadOnly();

        public boolean getAllowEmptyValue();

        public String getCollectionFormat();
    }
}

