/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.artifact.handler;

import com.katalon.platform.api.controller.FolderController;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.model.ProjectEntity;
import com.katalon.platform.api.ui.TestExplorerActionService;
import com.katalon.platform.api.ui.UISynchronizeService;
import com.kms.katalon.composer.artifact.constant.StringConstants;
import com.kms.katalon.composer.artifact.core.FileCompressionException;
import com.kms.katalon.composer.artifact.core.TestArtifactScriptRefactor;
import com.kms.katalon.composer.artifact.core.util.EntityUtil;
import com.kms.katalon.composer.artifact.core.util.FileUtil;
import com.kms.katalon.composer.artifact.core.util.KeywordUtil;
import com.kms.katalon.composer.artifact.core.util.PlatformUtil;
import com.kms.katalon.composer.artifact.core.util.ProfileUtil;
import com.kms.katalon.composer.artifact.core.util.TestCaseUtil;
import com.kms.katalon.composer.artifact.core.util.ZipUtil;
import com.kms.katalon.composer.artifact.dialog.ImportTestArtifactDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportTestArtifactHandler {
    private static final long DIALOG_CLOSED_DELAY_MILLIS = 500L;
    private Shell activeShell;

    public ImportTestArtifactHandler(Shell shell) {
        this.activeShell = shell;
    }

    public void execute() {
        Trackings.trackOpenImportTestArtifactsDialog();
        ImportTestArtifactDialog dialog = new ImportTestArtifactDialog(this.activeShell);
        if (dialog.open() == 0) {
            ImportTestArtifactDialog.ImportTestArtifactDialogResult result = dialog.getResult();
            String importFileLocation = result.getImportFileLocation();
            String testCaseImportLocation = result.getTestCaseImportLocation();
            String testObjectImportLocation = result.getTestObjectImportLocation();
            try {
                this.importTestArtifacts(importFileLocation, testCaseImportLocation, testObjectImportLocation);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_UNABLE_TO_IMPORT_TEST_ARTIFACTS);
                LoggerSingleton.logError((Throwable)e, (String)StringConstants.MSG_UNABLE_TO_IMPORT_TEST_ARTIFACTS);
            }
        }
    }

    private void importTestArtifacts(String importFileLocation, final String testCaseImportLocation, final String testObjectImportLocation) throws IOException, FileCompressionException {
        final File importFile = new File(importFileLocation);
        if (!importFile.exists()) {
            MessageDialog.openError((Shell)this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_INVALID_IMPORT_FILE);
            return;
        }
        if (!testCaseImportLocation.startsWith("Test Cases")) {
            MessageDialog.openError((Shell)this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_INVALID_TEST_CASE_IMPORT_LOCATION);
            return;
        }
        if (!testObjectImportLocation.startsWith("Object Repository")) {
            MessageDialog.openError((Shell)this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_INVALID_TEST_OBJECT_IMPORT_LOCATION);
            return;
        }
        final Job importArtifactsJob = new Job(StringConstants.MSG_IMPORTING_TEST_ARTIFACTS){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    File sourceFolder;
                    File tempFolder = Files.createTempDirectory(StringConstants.IMPORT_EXPORT_IMPORT_TEMP_FOLDER, new FileAttribute[0]).toFile();
                    ZipUtil.extractAll(importFile, tempFolder);
                    if (!FileUtil.isEmptyFolder(tempFolder) && (sourceFolder = tempFolder.listFiles()[0]).isDirectory()) {
                        TestArtifactScriptRefactor refactor;
                        List<File> scriptFiles;
                        File testCaseImportFolder = null;
                        File testScriptImportFolder = null;
                        File testObjectImportFolder = null;
                        testCaseImportFolder = ImportTestArtifactHandler.this.importTestCases(sourceFolder, testCaseImportLocation);
                        if (testCaseImportFolder != null) {
                            testScriptImportFolder = ImportTestArtifactHandler.this.importTestScripts(sourceFolder, testCaseImportFolder);
                        }
                        testObjectImportFolder = ImportTestArtifactHandler.this.importTestObjects(sourceFolder, testObjectImportLocation);
                        ImportTestArtifactHandler.this.importProfiles(sourceFolder);
                        List<File> importedKeywordFiles = ImportTestArtifactHandler.this.importKeywords(sourceFolder);
                        if (testObjectImportFolder != null && testScriptImportFolder != null) {
                            Map<String, String> testObjectIdLookup = ImportTestArtifactHandler.this.collectTestObjectIds(testObjectImportFolder);
                            scriptFiles = FileUtil.listFilesWithExtension(testScriptImportFolder, "groovy");
                            refactor = TestArtifactScriptRefactor.createForTestObjectEntity(testObjectIdLookup);
                            refactor.updateReferences(scriptFiles);
                            if (importedKeywordFiles != null) {
                                refactor.updateReferences(importedKeywordFiles);
                            }
                        }
                        if (testCaseImportFolder != null && testScriptImportFolder != null) {
                            Map<String, String> testCaseIdLookup = ImportTestArtifactHandler.this.collectTestCaseIds(testCaseImportFolder);
                            scriptFiles = FileUtil.listFilesWithExtension(testScriptImportFolder, "groovy");
                            refactor = TestArtifactScriptRefactor.createForTestCaseEntity(testCaseIdLookup);
                            refactor.updateReferences(scriptFiles);
                            if (importedKeywordFiles != null) {
                                refactor.updateReferences(importedKeywordFiles);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e, (String)e.getMessage());
                    return new Status(4, "com.katalon.plugin.katashare", StringConstants.MSG_ERROR_IMPORTING_TEST_ARTIFACTS, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        importArtifactsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!importArtifactsJob.getResult().isOK()) {
                    LoggerSingleton.logError((String)"Failed to import test artifacts!");
                    MessageDialog.openError((Shell)ImportTestArtifactHandler.this.activeShell, (String)StringConstants.ERROR, (String)StringConstants.MSG_FAILED_TO_IMPORT_TEST_ARTIFACTS);
                }
                Executors.newSingleThreadExecutor().submit(() -> {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    PlatformUtil.getUIService(UISynchronizeService.class).syncExec(() -> MessageDialog.openInformation((Shell)ImportTestArtifactHandler.this.activeShell, (String)StringConstants.INFO, (String)StringConstants.MSG_TEST_ARTIFACTS_IMPORTED_SUCCESSFULLY));
                });
            }
        });
        importArtifactsJob.setUser(true);
        importArtifactsJob.schedule();
    }

    private File importTestCases(File sourceFolder, String testCaseImportLocation) throws IOException {
        File sharedTestCaseFolder = new File(sourceFolder, StringConstants.IMPORT_EXPORT_TEST_CASES_FOLDER);
        if (!FileUtil.isEmptyFolder(sharedTestCaseFolder)) {
            ProjectEntity project = PlatformUtil.getCurrentProject();
            String importFolderRelativePath = StringUtils.replace((String)testCaseImportLocation, (String)EntityUtil.getEntityIdSeparator(), (String)File.separator);
            File importFolder = new File(project.getFolderLocation(), importFolderRelativePath);
            FileUtils.copyDirectory((File)sharedTestCaseFolder, (File)importFolder);
            return importFolder;
        }
        return null;
    }

    private File importTestScripts(File sourceFolder, File testCaseImportFolder) throws IOException, ResourceException {
        File sharedTestScriptFolder = new File(sourceFolder, StringConstants.IMPORT_EXPORT_TEST_SCRIPTS_FOLDER);
        if (!FileUtil.isEmptyFolder(sharedTestScriptFolder)) {
            ProjectEntity project = PlatformUtil.getCurrentProject();
            String importFolderRelativePath = testCaseImportFolder.getAbsolutePath().substring(TestCaseUtil.getTestCaseRootFolder(project).length());
            String importFolderLocation = String.valueOf(TestCaseUtil.getTestScriptRootFolder(project)) + importFolderRelativePath;
            Files.createDirectories(Paths.get(importFolderLocation, new String[0]), new FileAttribute[0]);
            File importFolder = new File(importFolderLocation);
            FileUtils.copyDirectory((File)sharedTestScriptFolder, (File)importFolder);
            String importFolderId = "Test Cases" + EntityUtil.getEntityIdSeparator() + StringUtils.replace((String)importFolderRelativePath, (String)File.separator, (String)EntityUtil.getEntityIdSeparator());
            com.katalon.platform.api.model.FolderEntity importFolderEntity = PlatformUtil.getPlatformController(FolderController.class).getFolder(project, importFolderId);
            TestExplorerActionService explorerActionService = PlatformUtil.getUIService(TestExplorerActionService.class);
            explorerActionService.refreshFolder(project, importFolderEntity);
            return importFolder;
        }
        return null;
    }

    private File importTestObjects(File sourceFolder, String testObjectImportLocation) throws IOException, ResourceException {
        File sharedTestObjectFolder = new File(sourceFolder, StringConstants.IMPORT_EXPORT_TEST_OBJECTS_FOLDER);
        if (!FileUtil.isEmptyFolder(sharedTestObjectFolder)) {
            ProjectEntity project = PlatformUtil.getCurrentProject();
            String importFolderRelativePath = StringUtils.replace((String)testObjectImportLocation, (String)EntityUtil.getEntityIdSeparator(), (String)File.separator);
            File importFolder = new File(project.getFolderLocation(), importFolderRelativePath);
            FileUtils.copyDirectory((File)sharedTestObjectFolder, (File)importFolder);
            com.katalon.platform.api.model.FolderEntity importFolderEntity = PlatformUtil.getPlatformController(FolderController.class).getFolder(project, testObjectImportLocation);
            TestExplorerActionService explorerActionService = PlatformUtil.getUIService(TestExplorerActionService.class);
            explorerActionService.refreshFolder(project, importFolderEntity);
            return importFolder;
        }
        return null;
    }

    private void importProfiles(File sourceFolder) throws IOException, ResourceException {
        File sharedProfileFolder = new File(sourceFolder, StringConstants.IMPORT_EXPORT_PROFILES_FOLDER);
        if (!FileUtil.isEmptyFolder(sharedProfileFolder)) {
            ProjectEntity project = PlatformUtil.getCurrentProject();
            File profileRootFolder = new File(ProfileUtil.getProfileRootFolder(project));
            FileUtils.copyDirectory((File)sharedProfileFolder, (File)profileRootFolder);
            com.katalon.platform.api.model.FolderEntity importFolderEntity = PlatformUtil.getPlatformController(FolderController.class).getFolder(project, "Profiles");
            TestExplorerActionService explorerActionService = PlatformUtil.getUIService(TestExplorerActionService.class);
            explorerActionService.refreshFolder(project, importFolderEntity);
        }
    }

    private List<File> importKeywords(File sourceFolder) throws Exception {
        File sharedKeywordFolder = new File(sourceFolder, StringConstants.IMPORT_EXPORT_KEYWORDS_FOLDER);
        if (!FileUtil.isEmptyFolder(sharedKeywordFolder)) {
            ProjectEntity project = PlatformUtil.getCurrentProject();
            File keywordRootFolder = new File(KeywordUtil.getKeywordRootFolder(project));
            FileUtils.copyDirectory((File)sharedKeywordFolder, (File)keywordRootFolder);
            FolderEntity keywordRootFolderEntity = com.kms.katalon.controller.FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject());
            GroovyRefreshUtil.refreshFolder((String)keywordRootFolderEntity.getRelativePath(), (com.kms.katalon.entity.project.ProjectEntity)keywordRootFolderEntity.getProject(), (IProgressMonitor)new NullProgressMonitor());
            com.katalon.platform.api.model.FolderEntity importFolderEntity = PlatformUtil.getPlatformController(FolderController.class).getFolder(project, "Keywords");
            TestExplorerActionService explorerActionService = PlatformUtil.getUIService(TestExplorerActionService.class);
            explorerActionService.refreshFolder(project, importFolderEntity);
            List<File> keywordFiles = FileUtil.listFilesWithExtension(sharedKeywordFolder, "groovy");
            List<File> copiedKeywordFiles = keywordFiles.stream().map(keywordFile -> {
                String keywordFilePath = keywordFile.getAbsolutePath();
                String keywordFileRelativePath = keywordFilePath.substring((String.valueOf(sharedKeywordFolder.getAbsolutePath()) + File.separator).length());
                File copiedKeywordFile = new File(keywordRootFolder, keywordFileRelativePath);
                return copiedKeywordFile;
            }).collect(Collectors.toList());
            return copiedKeywordFiles;
        }
        return null;
    }

    private Map<String, String> collectTestObjectIds(File testObjectImportFolder) throws IOException {
        ProjectEntity project = PlatformUtil.getCurrentProject();
        HashMap<String, String> testObjectIdLookup = new HashMap<String, String>();
        Files.walk(Paths.get(testObjectImportFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && FilenameUtils.getExtension((String)p.toFile().getAbsolutePath()).equals("rs")).forEach(p -> {
            String path = p.toFile().getAbsolutePath();
            String pathWithoutExtension = FilenameUtils.removeExtension((String)path);
            String newRelativeId = pathWithoutExtension.substring((String.valueOf(project.getFolderLocation()) + File.separator).length());
            newRelativeId = StringUtils.replace((String)newRelativeId, (String)File.separator, (String)EntityUtil.getEntityIdSeparator());
            String oldRelativeId = "Object Repository" + File.separator + pathWithoutExtension.substring((String.valueOf(testObjectImportFolder.getAbsolutePath()) + File.separator).length());
            oldRelativeId = StringUtils.replace((String)oldRelativeId, (String)File.separator, (String)EntityUtil.getEntityIdSeparator());
            testObjectIdLookup.put(oldRelativeId, newRelativeId);
        });
        return testObjectIdLookup;
    }

    private Map<String, String> collectTestCaseIds(File testCaseImportFolder) throws IOException {
        ProjectEntity project = PlatformUtil.getCurrentProject();
        HashMap<String, String> testCaseIdLookup = new HashMap<String, String>();
        Files.walk(Paths.get(testCaseImportFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && FilenameUtils.getExtension((String)p.toFile().getAbsolutePath()).equals("tc")).forEach(p -> {
            String path = p.toFile().getAbsolutePath();
            String pathWithoutExtension = FilenameUtils.removeExtension((String)path);
            String newRelativeId = pathWithoutExtension.substring((String.valueOf(project.getFolderLocation()) + File.separator).length());
            newRelativeId = StringUtils.replace((String)newRelativeId, (String)File.separator, (String)EntityUtil.getEntityIdSeparator());
            String oldRelativeId = "Test Cases" + File.separator + pathWithoutExtension.substring((String.valueOf(testCaseImportFolder.getAbsolutePath()) + File.separator).length());
            oldRelativeId = StringUtils.replace((String)oldRelativeId, (String)File.separator, (String)EntityUtil.getEntityIdSeparator());
            testCaseIdLookup.put(oldRelativeId, newRelativeId);
        });
        return testCaseIdLookup;
    }

    static /* synthetic */ Shell access$0(ImportTestArtifactHandler importTestArtifactHandler) {
        return importTestArtifactHandler.activeShell;
    }
}

