/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.service;

import com.kms.katalon.activation.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.activation.plugin.models.KStoreClientException;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.Plugin;
import com.kms.katalon.activation.plugin.models.ResolutionException;
import com.kms.katalon.activation.plugin.models.ResolutionItem;
import com.kms.katalon.activation.plugin.models.TrialExpiredException;
import com.kms.katalon.activation.plugin.service.KStoreRestClient;
import com.kms.katalon.activation.plugin.util.PluginHelper;
import com.kms.katalon.activation.plugin.util.PluginSettings;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.entity.util.ZipManager;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LocalRepository {
    private static LocalRepository instance;

    private LocalRepository() {
    }

    public static LocalRepository getInstance() {
        if (instance == null) {
            instance = new LocalRepository();
        }
        return instance;
    }

    public List<ResolutionItem> resolveExpiredTrialPlugins(List<KStorePlugin> expiredTrialPlugins, IProgressMonitor progressMonitor) {
        ArrayList<ResolutionItem> resolutionItems = new ArrayList<ResolutionItem>();
        for (KStorePlugin plugin : expiredTrialPlugins) {
            ResolutionItem resolutionItem = new ResolutionItem();
            Plugin resolvedPlugin = new Plugin();
            resolvedPlugin.setName(plugin.getProduct().getName());
            resolvedPlugin.setVersion(plugin.getLatestCompatibleVersion().getNumber());
            resolvedPlugin.setOnline(true);
            resolvedPlugin.setOnlinePlugin(plugin);
            resolvedPlugin.setCustomKeywordPlugin(PluginHelper.isCustomKeywordPlugin(plugin));
            plugin.setExpired(true);
            resolutionItem.setPlugin(resolvedPlugin);
            resolutionItem.setException(new TrialExpiredException());
            resolutionItems.add(resolutionItem);
        }
        return resolutionItems;
    }

    public List<ResolutionItem> resolvePlugins(List<KStorePlugin> plugins, KStoreCredentials credentials, IProgressMonitor progressMonitor) throws ResolutionException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        monitor.beginTask("", 100);
        ArrayList<ResolutionItem> resolutionItems = new ArrayList<ResolutionItem>();
        HashMap<Long, Exception> errors = new HashMap<Long, Exception>();
        List<KStorePlugin> downloads = this.collectDownloads(plugins);
        this.prepareInstallFolder();
        try {
            this.prepareDownloadFolder();
        }
        catch (IOException e) {
            throw new ResolutionException("Fail to init download folder", e);
        }
        SubMonitor downloadMonitor = monitor.split(50, 0);
        downloadMonitor.beginTask("Downloading plugins...", 100);
        int work = 0;
        for (KStorePlugin plugin : downloads) {
            try {
                this.downloadPlugin(plugin, credentials);
            }
            catch (Exception e) {
                errors.put(plugin.getId(), e);
            }
            int progress = Math.round((float)(++work) * 100.0f / (float)downloads.size());
            downloadMonitor.worked(progress);
        }
        downloadMonitor.done();
        SubMonitor extractMonitor = monitor.split(50, 0);
        extractMonitor.beginTask("Extracting plugins...", 100);
        work = 0;
        for (KStorePlugin plugin : downloads) {
            if (!errors.containsKey(plugin.getId())) {
                File downloadFileInfo = this.getPluginDownloadFileInfo(plugin);
                try {
                    this.extractPlugin(plugin, downloadFileInfo);
                }
                catch (Exception e) {
                    errors.put(plugin.getId(), e);
                }
            }
            int progress = Math.round((float)(++work) * 100.0f / (float)downloads.size());
            extractMonitor.worked(progress);
        }
        extractMonitor.done();
        for (KStorePlugin plugin : plugins) {
            ResolutionItem resolutionItem = new ResolutionItem();
            Plugin resolvedPlugin = new Plugin();
            resolvedPlugin.setName(plugin.getProduct().getName());
            resolvedPlugin.setVersion(plugin.getLatestCompatibleVersion().getNumber());
            resolvedPlugin.setOnline(true);
            resolvedPlugin.setOnlinePlugin(plugin);
            resolvedPlugin.setCustomKeywordPlugin(PluginHelper.isCustomKeywordPlugin(plugin));
            resolutionItem.setPlugin(resolvedPlugin);
            if (!errors.containsKey(plugin.getId())) {
                resolvedPlugin.setFile(this.findBinaryJar(plugin));
            } else {
                resolutionItem.setException((Exception)errors.get(plugin.getId()));
            }
            resolutionItems.add(resolutionItem);
        }
        return resolutionItems;
    }

    private List<KStorePlugin> collectDownloads(List<KStorePlugin> plugins) {
        return plugins.stream().filter(p -> !this.isLocallyInstalled((KStorePlugin)p)).collect(Collectors.toList());
    }

    private boolean isLocallyInstalled(KStorePlugin plugin) {
        File pluginJarFile = this.findBinaryJar(plugin);
        return pluginJarFile != null;
    }

    private File findBinaryJar(KStorePlugin plugin) {
        File pluginInstallFolder = this.getPluginInstallFolder(plugin);
        if (!pluginInstallFolder.exists()) {
            return null;
        }
        File jar = Arrays.stream(pluginInstallFolder.listFiles()).filter(f -> {
            String name = f.getName().toLowerCase();
            return name.endsWith(".jar") && !name.endsWith("-javadoc.jar") && !name.endsWith("-sources.jar");
        }).findAny().orElse(null);
        return jar;
    }

    private void downloadPlugin(KStorePlugin plugin, KStoreCredentials credentials) throws IOException, KStoreClientException {
        File downloadFile = this.getPluginDownloadFileInfo(plugin);
        downloadFile.createNewFile();
        KStoreRestClient restClient = new KStoreRestClient(credentials);
        restClient.downloadPlugin(plugin, downloadFile);
        this.trackDownloadPlugin(plugin, credentials);
    }

    private void extractPlugin(KStorePlugin plugin, File downloadFile) throws Exception {
        File pluginInstallFolder = this.getPluginInstallFolder(plugin);
        pluginInstallFolder.mkdirs();
        ZipManager.unzip((File)downloadFile, (String)pluginInstallFolder.getAbsolutePath());
    }

    private File getPluginDownloadFileInfo(KStorePlugin plugin) {
        String name = PluginHelper.idAndVersionKey(plugin);
        return new File(this.getRepoDownloadFolder(), String.valueOf(name) + ".zip");
    }

    private File getPluginInstallFolder(KStorePlugin plugin) {
        String pluginVersion = plugin.getLatestCompatibleVersion().getNumber();
        return new File(this.getRepoInstallFolder(), String.valueOf(plugin.getId()) + File.separator + pluginVersion);
    }

    private void prepareInstallFolder() {
        File installFolder = this.getRepoInstallFolder();
        installFolder.mkdirs();
    }

    private void prepareDownloadFolder() throws IOException {
        File downloadFolder = this.getRepoDownloadFolder();
        downloadFolder.mkdirs();
        FileUtils.cleanDirectory((File)downloadFolder);
    }

    private File getRepoInstallFolder() {
        return new File(PluginSettings.getPluginRepoDir(), "install");
    }

    private File getRepoDownloadFolder() {
        return new File(PluginSettings.getPluginRepoDir(), "download");
    }

    private void trackDownloadPlugin(KStorePlugin plugin, KStoreCredentials credentials) {
        String apiKey = credentials instanceof KStoreApiKeyCredentials ? ((KStoreApiKeyCredentials)credentials).getApiKey() : "";
        Trackings.trackDownloadPlugin((String)apiKey, (long)plugin.getProduct().getId(), (String)plugin.getProduct().getName(), (String)plugin.getLatestCompatibleVersion().getNumber(), (RunningMode)ApplicationRunningMode.get());
    }
}

