/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.service;

import com.kms.katalon.activation.plugin.MiscBundleActivator;
import com.kms.katalon.activation.plugin.constant.ActivationMessageConstants;
import com.kms.katalon.activation.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.activation.plugin.models.KStoreClientExceptionWithInfo;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.KStoreProduct;
import com.kms.katalon.activation.plugin.models.OfflinePlugin;
import com.kms.katalon.activation.plugin.models.Plugin;
import com.kms.katalon.activation.plugin.models.ReloadItem;
import com.kms.katalon.activation.plugin.models.ReloadPluginsException;
import com.kms.katalon.activation.plugin.models.ResolutionItem;
import com.kms.katalon.activation.plugin.plugin.applitool.InstallApplitoolsPluginHandler;
import com.kms.katalon.activation.plugin.plugin.basicreport.InstallBasicReportPluginHandler;
import com.kms.katalon.activation.plugin.service.KStoreRestClient;
import com.kms.katalon.activation.plugin.service.LogService;
import com.kms.katalon.activation.plugin.service.PluginResolver;
import com.kms.katalon.activation.plugin.util.KStoreCredentialsHelper;
import com.kms.katalon.activation.plugin.util.PlatformHelper;
import com.kms.katalon.activation.plugin.util.PluginFactory;
import com.kms.katalon.activation.plugin.util.PluginHelper;
import com.kms.katalon.activation.plugin.util.PluginSettings;
import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.custom.factory.CustomKeywordPluginFactory;
import com.kms.katalon.custom.keyword.CustomKeywordPlugin;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.PluginOptions;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.license.models.LicenseType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;

public class PluginService {
    private static final String EXCEPTION_UNAUTHORIZED_SINGAL = "Unauthorized";
    private static PluginService instance;
    private IEventBroker eventBroker;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    private PluginService() {
        this.eventBroker = MiscBundleActivator.getInstance().getEventBroker();
    }

    public static PluginService getInstance() {
        if (instance == null) {
            instance = new PluginService();
        }
        return instance;
    }

    public List<ReloadItem> reloadPlugins(KStoreCredentials credentials, IProgressMonitor monitor, boolean isEnterpriseLicense) throws ReloadPluginsException, InterruptedException {
        CustomKeywordPluginFactory.getInstance().clearPluginInStore();
        try {
            List<OfflinePlugin> offlinePlugins;
            List<Object> onlinePlugins;
            ArrayList<ReloadItem> results = new ArrayList<ReloadItem>();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            subMonitor.beginTask("", 100);
            SubMonitor getOnlinePluginsMonitor = subMonitor.split(10, 0);
            if (this.shouldReloadPluginsOnline() && KStoreCredentialsHelper.isValidCredential(credentials)) {
                getOnlinePluginsMonitor.beginTask("Fetching latest plugins info from Katalon Store...", 100);
                try {
                    onlinePlugins = this.getOnlinePlugins(credentials);
                    getOnlinePluginsMonitor.done();
                }
                catch (KStoreClientExceptionWithInfo e) {
                    LogUtil.printAndLogError((Throwable)e);
                    onlinePlugins = Collections.emptyList();
                }
            } else {
                onlinePlugins = Collections.emptyList();
            }
            getOnlinePluginsMonitor.done();
            SubMonitor getOfflinePluginsMonitor = subMonitor.split(10, 0);
            if (this.shouldReloadPluginsOffline()) {
                getOfflinePluginsMonitor.beginTask("Getting offline plugins info...", 100);
                offlinePlugins = this.getOfflinePlugins((IProgressMonitor)getOfflinePluginsMonitor);
                getOfflinePluginsMonitor.done();
            } else {
                offlinePlugins = Collections.emptyList();
            }
            getOfflinePluginsMonitor.done();
            SubMonitor uninstallMonitor = subMonitor.split(10, 0);
            uninstallMonitor.beginTask("Uninstalling plugins...", 100);
            List<Plugin> installedPlugins = PluginFactory.getInstance().getPlugins();
            int totalUninstallWork = installedPlugins.size();
            int uninstallWork = 0;
            for (Plugin plugin : installedPlugins) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                PlatformHelper.uninstallPlugin(plugin);
                this.markWork(++uninstallWork, totalUninstallWork, uninstallMonitor);
            }
            uninstallMonitor.done();
            SubMonitor resolveOnlinePluginMonitor = subMonitor.split(30, 0);
            resolveOnlinePluginMonitor.beginTask("Resolving online plugins...", 100);
            ArrayList<KStorePlugin> allowedOnlinePlugins = new ArrayList<KStorePlugin>();
            ArrayList<KStorePlugin> expiredTrialPlugins = new ArrayList<KStorePlugin>();
            onlinePlugins.stream().forEach(onlinePlugin -> {
                if (onlinePlugin.isFree() || onlinePlugin.isTrial() && !onlinePlugin.isExpired() || isEnterpriseLicense) {
                    onlinePlugin.setExpired(false);
                    onlinePlugin.setTrial(onlinePlugin.isTrial() && !isEnterpriseLicense);
                    onlinePlugin.setPaid(onlinePlugin.isPaid() || !onlinePlugin.isFree() && isEnterpriseLicense);
                    allowedOnlinePlugins.add((KStorePlugin)onlinePlugin);
                } else {
                    expiredTrialPlugins.add((KStorePlugin)onlinePlugin);
                }
            });
            List<ResolutionItem> onlinePluginResolutionItems = PluginResolver.getInstance().resolveOnlinePlugins(allowedOnlinePlugins, credentials, (IProgressMonitor)resolveOnlinePluginMonitor);
            List<ResolutionItem> expiredTrialPluginResolutionItems = PluginResolver.getInstance().resolveExpiredTrialPlugins(expiredTrialPlugins, (IProgressMonitor)resolveOnlinePluginMonitor);
            resolveOnlinePluginMonitor.done();
            SubMonitor resolveOfflinePluginMonitor = subMonitor.split(10, 0);
            resolveOfflinePluginMonitor.beginTask("Resolving offline plugins...", 100);
            List<ResolutionItem> offlinePluginResolutionItems = PluginResolver.getInstance().resolveOfflinePlugins(offlinePlugins, (IProgressMonitor)resolveOfflinePluginMonitor);
            resolveOfflinePluginMonitor.done();
            ArrayList<ResolutionItem> resolutionItems = new ArrayList<ResolutionItem>();
            resolutionItems.addAll(onlinePluginResolutionItems);
            resolutionItems.addAll(offlinePluginResolutionItems);
            resolutionItems.addAll(expiredTrialPluginResolutionItems);
            SubMonitor installPluginMonitor = subMonitor.split(20, 0);
            installPluginMonitor.beginTask("Installing plugins...", 100);
            int totalInstallWork = onlinePlugins.size();
            int installWork = 0;
            CustomKeywordPluginFactory.getInstance().clearPluginInStore();
            PluginFactory.getInstance().clear();
            for (ResolutionItem resolutionItem : resolutionItems) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                Plugin plugin = resolutionItem.getPlugin();
                ReloadItem reloadItem = new ReloadItem();
                reloadItem.setPlugin(plugin);
                results.add(reloadItem);
                if (resolutionItem.getException() != null) {
                    reloadItem.setException(resolutionItem.getException());
                    continue;
                }
                if (plugin.isOnline()) {
                    KStorePlugin onlinePlugin2 = plugin.getOnlinePlugin();
                    if (onlinePlugin2.isExpired() && !isEnterpriseLicense) {
                        LogService.getInstance().logInfo(String.format("Expired plugin: %d.", onlinePlugin2.getId()));
                        continue;
                    }
                    if (onlinePlugin2.getLatestCompatibleVersion() == null) {
                        LogService.getInstance().logInfo(String.format("Plugin with latest compatible version: %d.", onlinePlugin2.getId()));
                        continue;
                    }
                }
                LogService.getInstance().logInfo(String.format("Plugin name: %s. Is online: %b. Plugin location: %s.", plugin.getName(), plugin.isOnline(), plugin.getFile().getAbsolutePath()));
                try {
                    if (plugin.isCustomKeywordPlugin()) {
                        CustomKeywordPlugin customKeywordPlugin = new CustomKeywordPlugin();
                        customKeywordPlugin.setId(plugin.getFile().getAbsolutePath());
                        File pluginFile = plugin.getFile();
                        customKeywordPlugin.setPluginFile(pluginFile);
                        CustomKeywordPluginFactory.getInstance().addPluginFile(pluginFile, customKeywordPlugin);
                    } else {
                        PlatformHelper.installPlugin(plugin);
                    }
                    reloadItem.markPluginInstalled(true);
                    PluginFactory.getInstance().addPlugin(plugin);
                }
                catch (Exception e) {
                    LogService.getInstance().logError(e);
                    File pluginRepoDir = PluginSettings.getPluginRepoDir();
                    if (pluginRepoDir.exists()) {
                        pluginRepoDir.delete();
                    }
                    reloadItem.setException(e);
                }
                this.markWork(++installWork, totalInstallWork, installPluginMonitor);
            }
            installPluginMonitor.done();
            this.installBasicReportPlugin();
            SubMonitor refreshClasspathMonitor = subMonitor.split(10, 0);
            refreshClasspathMonitor.beginTask("Refreshing classpath...", 100);
            this.refreshProjectClasspath(refreshClasspathMonitor);
            refreshClasspathMonitor.done();
            this.trackInstallPlugins(PluginFactory.getInstance().getPlugins(), credentials, ApplicationRunningMode.get());
            monitor.done();
            return results;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)ActivationMessageConstants.KStore_ERROR_INVALID_CREDENTAILS)) {
                throw new ReloadPluginsException(ActivationMessageConstants.KStore_ERROR_INVALID_CREDENTAILS, e);
            }
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)EXCEPTION_UNAUTHORIZED_SINGAL)) {
                throw new ReloadPluginsException("Error occurs during executing reload plugins due to invalid API Key", e);
            }
            if (e instanceof KStoreClientExceptionWithInfo) {
                KStoreClientExceptionWithInfo castedE = (KStoreClientExceptionWithInfo)e;
                throw new ReloadPluginsException("Unexpected error occurs during executing reload plugins under account: " + castedE.getInfoMessage(), e);
            }
            throw new ReloadPluginsException("Unexpected error occurs during executing reload plugins", e);
        }
    }

    private void installApplitoolsPlugin() throws IOException {
        new InstallApplitoolsPluginHandler().doinstallApplitoolsPlugin();
    }

    private void installBasicReportPlugin() {
        new InstallBasicReportPluginHandler().doInstallBasicReportPlugin();
    }

    public boolean shouldReloadPluginsOnline() throws IOException {
        PluginOptions reloadOption = PluginSettings.getReloadPluginOption();
        return reloadOption == PluginOptions.ONLINE || reloadOption == PluginOptions.ONLINE_AND_OFFLINE;
    }

    public boolean shouldReloadPluginsOnlineOnly() throws IOException {
        PluginOptions reloadOption = PluginSettings.getReloadPluginOption();
        return reloadOption == PluginOptions.ONLINE;
    }

    public boolean shouldReloadPluginsOffline() throws IOException {
        PluginOptions reloadOption = PluginSettings.getReloadPluginOption();
        return reloadOption == PluginOptions.OFFLINE || reloadOption == PluginOptions.ONLINE_AND_OFFLINE;
    }

    private List<KStorePlugin> getOnlinePlugins(KStoreCredentials credentials) throws KStoreClientExceptionWithInfo {
        KStoreRestClient restClient = new KStoreRestClient(credentials);
        String appVersion = ApplicationInfo.officialReleaseVersion();
        KatalonPackage katalonPackage = KatalonApplication.getKatalonPackage();
        LicenseType licenseType = ActivationInfoCollector.getLicenseType();
        if (licenseType == null && ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            licenseType = LicenseType.ENTERPRISE;
        }
        List<KStorePlugin> latestPlugins = restClient.getLatestPlugins(appVersion, katalonPackage, licenseType);
        List<KStorePlugin> deprelicatedPlugin = this.getDeprecatedPlugin(latestPlugins);
        latestPlugins.removeAll(deprelicatedPlugin);
        latestPlugins.stream().forEach(p -> this.logPluginInfo((KStorePlugin)p));
        return latestPlugins;
    }

    private List<OfflinePlugin> getOfflinePlugins(IProgressMonitor progressMonitor) {
        boolean canUsePrivatePlugins = FeatureServiceConsumer.getServiceInstance().canUse("private_plugin");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        monitor.beginTask("", 100);
        List<OfflinePlugin> offlinePlugins = new ArrayList<OfflinePlugin>();
        int customKeywordPluginCount = 0;
        int idePluginCount = 0;
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null) {
            File[] files;
            int n;
            File[] files2;
            File pluginsFolder = new File(project.getFolderLocation(), "Plugins");
            if (pluginsFolder.exists() && (files2 = pluginsFolder.listFiles()) != null) {
                File[] fileArray = files2;
                n = files2.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile() && FilenameUtils.getExtension((String)file.getAbsolutePath()).equals("jar")) {
                        OfflinePlugin plugin = new OfflinePlugin();
                        plugin.setName(FilenameUtils.getName((String)file.getAbsolutePath()));
                        plugin.setFile(file);
                        plugin.setCustomKeywordPlugin(true);
                        offlinePlugins.add(plugin);
                        ++customKeywordPluginCount;
                    }
                    ++n2;
                }
            }
            monitor.worked(50);
            File platformPluginsFolder = new File(pluginsFolder, "platform");
            if (platformPluginsFolder.exists() && (files = platformPluginsFolder.listFiles()) != null) {
                File[] fileArray = files;
                int n3 = files.length;
                n = 0;
                while (n < n3) {
                    File file = fileArray[n];
                    if (file.isFile() && FilenameUtils.getExtension((String)file.getAbsolutePath()).equals("jar")) {
                        OfflinePlugin plugin = new OfflinePlugin();
                        plugin.setName(FilenameUtils.getName((String)file.getAbsolutePath()));
                        plugin.setFile(file);
                        plugin.setCustomKeywordPlugin(false);
                        offlinePlugins.add(plugin);
                        ++idePluginCount;
                    }
                    ++n;
                }
            }
            monitor.worked(50);
        }
        List<OfflinePlugin> deprelicatedPlugin = this.getDeprecatedOfflinePlugin(offlinePlugins);
        offlinePlugins.removeAll(deprelicatedPlugin);
        int applitoolsPluginIdx = this.getApplitoolsPluginIndex(offlinePlugins);
        if (applitoolsPluginIdx >= 0 && !this.canUserUseApplitoolsPlugin()) {
            offlinePlugins.remove(applitoolsPluginIdx);
        }
        if (canUsePrivatePlugins) {
            if (offlinePlugins.size() > 0) {
                Trackings.trackUsePrivatePlugins((int)customKeywordPluginCount, (int)idePluginCount);
            }
            return offlinePlugins;
        }
        if (offlinePlugins.size() > 0 && ((OfflinePlugin)offlinePlugins.get(0)).isCustomKeywordPlugin()) {
            OfflinePlugin plugin = offlinePlugins.get(0);
            offlinePlugins = new ArrayList();
            offlinePlugins.add(plugin);
        } else {
            offlinePlugins = Collections.emptyList();
        }
        return offlinePlugins;
    }

    private int getApplitoolsPluginIndex(List<OfflinePlugin> offlinePlugins) {
        int numOfflinePlugins = offlinePlugins.size();
        int i = 0;
        while (i < numOfflinePlugins) {
            if (this.isApplitoolsPlugin(offlinePlugins.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean canUserUseApplitoolsPlugin() {
        return FeatureServiceConsumer.getServiceInstance().canUse(KSEFeature.APPLITOOLS_PLUGIN);
    }

    private boolean isApplitoolsPlugin(OfflinePlugin offlinePlugin) {
        StringBuilder builder = this.parseCustomKeywordPluginManifest(offlinePlugin);
        if (builder == null) {
            return false;
        }
        return builder.toString().contains("com.kms.katalon.keyword.Applitools-Keywords");
    }

    private StringBuilder parseCustomKeywordPluginManifest(OfflinePlugin offlinePlugin) {
        String line = null;
        BufferedReader reader = null;
        StringBuilder builder = null;
        try {
            InputStream stream = new URLClassLoader(new URL[]{offlinePlugin.getFile().toURL()}).getResourceAsStream("katalon-plugin.json");
            if (stream != null) {
                reader = new BufferedReader(new InputStreamReader(stream));
                builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
            }
            return builder;
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    private void logPluginInfo(KStorePlugin plugin) {
        try {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("id", plugin.getId());
            infoMap.put("productId", plugin.getProduct().getId());
            infoMap.put("name", plugin.getProduct().getName());
            if (LicenseUtil.isNonPaidLicense()) {
                infoMap.put("expired", plugin.isExpired());
            }
            if (ApplicationRunningMode.get() == RunningMode.GUI) {
                LogUtil.logInfo((String)("Plugin info: " + JsonUtil.toJson(infoMap)));
            } else {
                LogUtil.printOutputLine((String)("Plugin info: " + JsonUtil.toJson(infoMap)));
            }
        }
        catch (Exception exception) {}
    }

    public void logPluginProductInfo(KStoreProduct plugin) {
        try {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("id", plugin.getId());
            infoMap.put("productId", plugin.getId());
            infoMap.put("name", plugin.getName());
            if (ApplicationRunningMode.get() == RunningMode.GUI) {
                LogUtil.logInfo((String)("Plugin info: " + JsonUtil.toJson(infoMap)));
            } else {
                LogUtil.printOutputLine((String)("Plugin info: " + JsonUtil.toJson(infoMap)));
            }
        }
        catch (Exception exception) {}
    }

    public List<KStorePlugin> getDeprecatedPlugin(List<KStorePlugin> plugins) {
        ArrayList<KStorePlugin> deprecatedPlugin = new ArrayList<KStorePlugin>();
        for (KStorePlugin plugin : plugins) {
            if (!PluginHelper.isDeprecatedPlugin(plugin.getProduct().getName())) continue;
            deprecatedPlugin.add(plugin);
        }
        return deprecatedPlugin;
    }

    public List<KStorePlugin> getDeprecatedOnlinePlugin(List<KStorePlugin> plugins) {
        ArrayList<KStorePlugin> deprecatedPlugin = new ArrayList<KStorePlugin>();
        for (KStorePlugin plugin : plugins) {
            if (!PluginHelper.isDeprecatedPlugin(plugin.getProduct().getName())) continue;
            deprecatedPlugin.add(plugin);
        }
        return deprecatedPlugin;
    }

    public List<OfflinePlugin> getDeprecatedOfflinePlugin(List<OfflinePlugin> plugins) {
        ArrayList<OfflinePlugin> deprecatedPlugin = new ArrayList<OfflinePlugin>();
        for (OfflinePlugin plugin : plugins) {
            if (!PluginHelper.isDeprecatedPlugin(plugin.getName())) continue;
            deprecatedPlugin.add(plugin);
        }
        return deprecatedPlugin;
    }

    private void refreshProjectClasspath(SubMonitor monitor) throws Exception {
        ProjectController projectController = ProjectController.getInstance();
        ProjectEntity currentProject = projectController.getCurrentProject();
        if (currentProject != null) {
            boolean allowSourceAttachment = this.featureService.canUse(KSEFeature.SOURCE_CODE_FOR_DEBUGGING);
            GroovyUtil.initGroovyProjectClassPath((ProjectEntity)currentProject, (List)projectController.getCustomKeywordPlugins(currentProject), (boolean)false, (boolean)allowSourceAttachment, (IProgressMonitor)monitor);
            projectController.updateProjectClassLoader(currentProject);
            if (ApplicationRunningMode.get() == RunningMode.GUI) {
                KeywordController.getInstance().parseAllCustomKeywords(currentProject, null);
                this.eventBroker.post("KEYWORD_BROWSER/REFRESH", null);
            } else if (ApplicationRunningMode.get() == RunningMode.CONSOLE) {
                KeywordController.getInstance().parsePluginCustomKeywords(currentProject, null);
            }
        }
    }

    private void markWork(int work, int totalWork, SubMonitor monitor) {
        int subwork = Math.round((float)work * 100.0f / (float)totalWork);
        monitor.worked(subwork);
    }

    private void trackInstallPlugins(List<Plugin> plugins, KStoreCredentials credentials, RunningMode runningMode) {
        List installedPluginIds = plugins.stream().filter(p -> p.isOnline()).map(p -> p.getOnlinePlugin().getProduct().getId()).collect(Collectors.toList());
        if (credentials instanceof KStoreApiKeyCredentials) {
            Trackings.trackInstallPlugins(installedPluginIds, (String)((KStoreApiKeyCredentials)credentials).getApiKey(), (RunningMode)runningMode);
        } else {
            Trackings.trackInstallPlugins(installedPluginIds, (String)"", (RunningMode)runningMode);
        }
    }
}

