/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.IImportExportController;
import com.kms.katalon.controller.constants.StringConstants;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.util.ImportDuplicateEntityResult;
import org.eclipse.e4.core.services.log.Logger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractImportController
extends EntityController
implements IImportExportController,
EventHandler {
    protected static final String IMPORT_PROJECT_ERROR_MESSAGE = StringConstants.CTRL_ERROR_MSG_CANNOT_IMPORT_PROJ;
    protected static final String IMPORTING_PROJECT_DISPLAY_TEXT = StringConstants.CTRL_TXT_IMPORTING_PROJ;
    protected String guid;
    protected ProjectEntity project;
    protected String directory;
    protected Logger logger;

    public AbstractImportController(String guid, ProjectEntity project, String directory, Logger logger) {
        this.guid = guid;
        this.project = project;
        this.directory = directory;
        this.logger = logger;
    }

    @Override
    public String getDisplayText() {
        return IMPORTING_PROJECT_DISPLAY_TEXT;
    }

    @Override
    public String getErrorMessage() {
        return IMPORT_PROJECT_ERROR_MESSAGE;
    }

    @Override
    public void cancel() throws Exception {
        AbstractImportController.getDataProviderSetting().getImportDataProvider().cancelImport(this.guid);
    }

    @Override
    public int getProgress() throws Exception {
        return AbstractImportController.getDataProviderSetting().getImportDataProvider().getImportProgress(this.guid);
    }

    public void handleEvent(Event event) {
        Object object;
        if (event.getTopic().equalsIgnoreCase("IMPORT/DUPLICATE_ENTITY_RESULT") && (object = event.getProperty("org.eclipse.e4.data")) != null && object instanceof ImportDuplicateEntityResult) {
            try {
                AbstractImportController.getDataProviderSetting().getImportDataProvider().setImportDuplicateEntityResult((ImportDuplicateEntityResult)object, this.guid);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
    }
}

