/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.CheckpointSourceController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.constants.StringConstants;
import com.kms.katalon.core.testdata.CSVData;
import com.kms.katalon.core.testdata.reader.CSVSeparator;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.checkpoint.CsvCheckpointSourceInfo;
import org.apache.commons.lang.ArrayUtils;

public class CsvCheckpointSourceController
implements CheckpointSourceController<CsvCheckpointSourceInfo> {
    private static CsvCheckpointSourceController instance;

    public static CsvCheckpointSourceController getInstance() {
        if (instance == null) {
            instance = new CsvCheckpointSourceController();
        }
        return instance;
    }

    public CSVData getSourceData(CsvCheckpointSourceInfo sourceInfo) throws Exception {
        String separator = sourceInfo.getSheetNameOrSeparator();
        if (!ArrayUtils.contains((Object[])CSVSeparator.stringValues(), (Object)separator)) {
            throw new IllegalArgumentException(StringConstants.CTRL_EXC_INVALID_CSV_SEPARATOR);
        }
        String csvFileLocation = sourceInfo.getSourceUrl();
        if (sourceInfo.isUsingRelativePath()) {
            csvFileLocation = PathUtil.relativeToAbsolutePath((String)csvFileLocation, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        }
        return new CSVData(csvFileLocation, sourceInfo.isUsingFirstRowAsHeader(), CSVSeparator.fromValue((String)separator));
    }
}

