/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.constants.StringConstants;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.SaveWebElementInfoEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ObjectRepositoryController
extends EntityController {
    private static EntityController _instance;

    private ObjectRepositoryController() {
    }

    public static ObjectRepositoryController getInstance() {
        if (_instance == null) {
            _instance = new ObjectRepositoryController();
        }
        return (ObjectRepositoryController)_instance;
    }

    public WebElementEntity newTestObject(FolderEntity parentFolder, String testObjectName) throws ControllerException {
        try {
            return this.saveNewTestObject(this.newTestObjectWithoutSave(parentFolder, testObjectName));
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public MobileElementEntity newMobileElement(MobileElementEntity mobileElement) throws ControllerException {
        try {
            return (MobileElementEntity)ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().saveNewTestObject((WebElementEntity)mobileElement);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public WebServiceRequestEntity newWSTestObject(FolderEntity parentFolder, String wsTestObjectName) throws ControllerException {
        try {
            return (WebServiceRequestEntity)this.saveNewTestObject((WebElementEntity)this.newWSTestObjectWithoutSave(parentFolder, wsTestObjectName));
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public WebElementEntity newTestObjectWithoutSave(FolderEntity parentFolder, String testObjectName) throws Exception {
        if (parentFolder == null) {
            return null;
        }
        if (StringUtils.isBlank((String)testObjectName)) {
            testObjectName = StringConstants.CTRL_NEW_TEST_OBJECT;
        }
        WebElementEntity newWebElement = new WebElementEntity();
        newWebElement.setElementGuidId(Util.generateGuid());
        newWebElement.setName(this.getAvailableWebElementName(parentFolder, testObjectName));
        newWebElement.setParentFolder(parentFolder);
        newWebElement.setProject(parentFolder.getProject());
        return newWebElement;
    }

    public DraftWebServiceRequestEntity newDraftWebServiceEntity(ProjectEntity project) {
        DraftWebServiceRequestEntity newWebElement = new DraftWebServiceRequestEntity();
        newWebElement.setProject(project);
        newWebElement.setKatalonVersion(System.getProperty("application.version"));
        return newWebElement;
    }

    public WebServiceRequestEntity newWSTestObjectWithoutSave(FolderEntity parentFolder, String wsTestObjectName) throws Exception {
        if (parentFolder == null) {
            return null;
        }
        if (StringUtils.isBlank((String)wsTestObjectName)) {
            wsTestObjectName = StringConstants.CTRL_NEW_WS_REQUEST;
        }
        WebServiceRequestEntity newWS = new WebServiceRequestEntity();
        newWS.setElementGuidId(Util.generateGuid());
        newWS.setName(this.getAvailableWebElementName(parentFolder, wsTestObjectName));
        newWS.setParentFolder(parentFolder);
        newWS.setProject(parentFolder.getProject());
        newWS.setKatalonVersion(System.getProperty("application.version"));
        return newWS;
    }

    public WebElementEntity saveNewTestObject(WebElementEntity newTestObject) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().saveNewTestObject(newTestObject);
    }

    public WebElementEntity getWebElement(String elementPk) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getWebElement(elementPk);
    }

    public WebElementEntity getWebElementByDisplayPk(String elementDisplayPk) throws ControllerException {
        try {
            return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getWebElement(String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + elementDisplayPk + WebElementEntity.getWebElementFileExtension());
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public WebElementEntity getWebElementByScriptName(String scriptName, ProjectEntity projectEntity) throws ControllerException {
        try {
            return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getWebElementByScriptName(scriptName, projectEntity);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public void importWebElement(List<SaveWebElementInfoEntity> entities) throws Exception {
        ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().importWebElement(entities);
    }

    public FolderEntity importWebElementFolder(FolderEntity folder, FolderEntity parentFolder) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().importWebElementFolder(folder, parentFolder);
    }

    public WebElementEntity importWebElement(WebElementEntity webElement, FolderEntity parentFolder) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().importWebElement(webElement, parentFolder);
    }

    public WebElementEntity copyWebElement(WebElementEntity webElement, FolderEntity targetFolder) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().copyWebElement(webElement, targetFolder);
    }

    public WebElementEntity moveWebElement(WebElementEntity webElement, FolderEntity targetFolder) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().moveWebElement(webElement, targetFolder);
    }

    public void deleteWebElement(WebElementEntity webElement) throws Exception {
        ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().deleteWebElement(webElement);
    }

    public WebElementEntity updateTestObject(WebElementEntity webElement) throws ControllerException {
        try {
            return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().updateTestObject(webElement);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public List<String> getSibblingWebElementNames(WebElementEntity webElement) throws Exception {
        List sibblingWebElements = ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getChildWebElementsOfFolder(webElement.getParentFolder());
        ArrayList<String> sibblingName = new ArrayList<String>();
        for (WebElementEntity sibblingWebElement : sibblingWebElements) {
            if (ObjectRepositoryController.getDataProviderSetting().getEntityPk((Entity)sibblingWebElement).equals(ObjectRepositoryController.getDataProviderSetting().getEntityPk((Entity)webElement))) continue;
            sibblingName.add(sibblingWebElement.getName());
        }
        return sibblingName;
    }

    public String getAvailableWebElementName(FolderEntity parentFolder, String name) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getAvailableWebElementName(parentFolder, name);
    }

    public List<WebElementEntity> getTestObjectReferences(WebElementEntity webElement, ProjectEntity projectEntity) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getWebElementPropertyByRefElement(webElement.getIdForDisplay(), projectEntity, true);
    }

    public WebElementPropertyEntity getRefElementProperty(WebElementEntity webElement) {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getRefElementProperty(webElement);
    }

    public void reloadTestObject(WebElementEntity testObject, Entity entity) throws Exception {
        testObject = this.getWebElement(entity.getId());
        entity = testObject;
    }

    public List<WebElementEntity> getAllDescendantWebElements(FolderEntity folder) throws Exception {
        if (folder.getFolderType() != FolderEntity.FolderType.WEBELEMENT) {
            return Collections.emptyList();
        }
        ArrayList<WebElementEntity> childWebElements = new ArrayList<WebElementEntity>();
        for (FileEntity child : FolderController.getInstance().getChildren(folder)) {
            if (child instanceof WebElementEntity) {
                childWebElements.add((WebElementEntity)child);
                continue;
            }
            if (!(child instanceof FolderEntity)) continue;
            childWebElements.addAll(this.getAllDescendantWebElements((FolderEntity)child));
        }
        return childWebElements;
    }

    public void updateDraftTestObject(WebServiceRequestEntity originalWsObject) {
    }

    public Map<String, File> getObjectRepositoryLookup() {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getObjectRepositoryLookup();
    }

    public List<Object> getAllChildren(FolderEntity folder) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getAllChildren(folder);
    }

    public List<WebElementEntity> getChildrenOfWebElement(FolderEntity folder) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getChildWebElementsOfFolder(folder);
    }

    public List<Object> getAllDirectChildren(FolderEntity folder) throws Exception {
        return ObjectRepositoryController.getDataProviderSetting().getWebElementDataProvider().getAllDirectChildren(folder);
    }
}

