/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.custom.factory.CustomKeywordPluginFactory;
import com.kms.katalon.custom.improvement.factory.CustomKeywordClassFactory;
import com.kms.katalon.custom.improvement.parser.ParseKeywordException;
import com.kms.katalon.custom.improvement.parser.ProjectCustomKeywordsParser;
import com.kms.katalon.custom.parser.CustomKeywordParser;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@Creatable
public class ProjectController
extends EntityController {
    private static final short DEFAULT_PAGELOAD_TIMEOUT = 30;
    private static EntityController _instance;
    private static final String RECENT_PROJECT_FILE_LOCATION;
    public static final int NUMBER_OF_RECENT_PROJECTS = 6;
    private boolean isOpenning = false;

    static {
        RECENT_PROJECT_FILE_LOCATION = String.valueOf(Platform.getLocation().toString()) + File.separator + "recent_projects";
    }

    private ProjectController() {
    }

    public static ProjectController getInstance() {
        if (_instance == null) {
            _instance = new ProjectController();
        }
        return (ProjectController)_instance;
    }

    public ProjectEntity addNewProject(String name, String description, String projectLocation) throws Exception {
        return this.addNewProject(name, description, projectLocation, false, false);
    }

    public ProjectEntity addNewProject(String name, String description, String projectLocation, boolean generateGitIgnoreFile, boolean generateGradleFile) throws Exception {
        ProjectEntity newProject = ProjectController.getDataProviderSetting().getProjectDataProvider().addNewProject(name, description, (short)30, projectLocation);
        if (generateGitIgnoreFile) {
            this.initGitignoreFile(newProject);
        }
        if (generateGradleFile) {
            this.initGradleFile(newProject);
        }
        this.setOpenning(false);
        return newProject;
    }

    public ProjectEntity addNewTestOpsProjectWithoutNewFolder(String name, String description, String projectLocation) throws Exception {
        ProjectEntity newProject = ProjectController.getDataProviderSetting().getProjectDataProvider().addNewTestOpsProjectWithoutNewFolder(name, description, (short)30, projectLocation);
        this.initGitignoreFile(newProject);
        this.initGradleFile(newProject);
        this.setOpenning(false);
        return newProject;
    }

    public ProjectEntity openProjectForUI(String projectPk, boolean allowSourceAttachment, IProgressMonitor monitor) throws Exception {
        try {
            ProjectEntity project;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if ((project = ProjectController.getDataProviderSetting().getProjectDataProvider().openProjectWithoutClasspath(projectPk)) != null) {
                monitor.beginTask("Initialzing project's working space...", 10);
                ProjectController.cleanWorkspace();
                if (project.getUUID() == null) {
                    project.setUUID(Util.generateGuid());
                    this.updateProject(project);
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                DataProviderState.getInstance().setCurrentProject(project);
                System.setProperty("project.properties", String.valueOf(project.isTimeStampInProperties()));
                try {
                    ProjectController.addJdtSettings(project);
                    ProjectController.addResourceSettings(project);
                    GroovyUtil.initGroovyProject((ProjectEntity)project, ProjectController.getInstance().getCustomKeywordPlugins(project), (boolean)allowSourceAttachment, (IProgressMonitor)progress.newChild(40, 1));
                    this.updateProjectClassLoader(project);
                }
                catch (JavaModelException javaModelException) {
                    monitor.beginTask("Trying cleaning up Groovy project...", 10);
                    this.cleanupGroovyProject(project);
                    GroovyUtil.initGroovyProject((ProjectEntity)project, ProjectController.getInstance().getCustomKeywordPlugins(project), (boolean)allowSourceAttachment, (IProgressMonitor)progress.newChild(40, 1));
                }
                GlobalVariableController.getInstance().generateGlobalVariableLibFile(project, (IProgressMonitor)progress.newChild(50, 1));
                System.setProperty("project.location", project.getFolderLocation());
            }
            ProjectEntity projectEntity = project;
            return projectEntity;
        }
        finally {
            this.setOpenning(false);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void closeAndCleanupProject(ProjectEntity project) throws Exception {
        try {
            this.closeProject(project.getId(), (IProgressMonitor)new NullProgressMonitor());
            this.cleanupGroovyProject(project);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    private void cleanupGroovyProject(ProjectEntity project) {
        File eclipseSettingsFolder;
        File libsFolder;
        File projectFile;
        File binFolder;
        File classpathFile = new File(project.getFolderLocation(), ".classpath");
        if (classpathFile.exists()) {
            FileUtils.deleteQuietly((File)classpathFile);
        }
        if ((binFolder = new File(project.getFolderLocation(), "bin")).exists()) {
            FileUtils.deleteQuietly((File)binFolder);
        }
        if ((projectFile = new File(project.getFolderLocation(), ".project")).exists()) {
            FileUtils.deleteQuietly((File)projectFile);
        }
        if ((libsFolder = new File(project.getFolderLocation(), "Libs")).exists()) {
            FileUtils.deleteQuietly((File)libsFolder);
        }
        if ((eclipseSettingsFolder = new File(project.getFolderLocation(), ".settings")).exists()) {
            FileUtils.deleteQuietly((File)eclipseSettingsFolder);
        }
    }

    public void cleanProjectUISettings(ProjectEntity projectEntity) throws CoreException {
        CustomKeywordClassFactory.getInstance().reset();
        GroovyUtil.emptyProjectClasspath((ProjectEntity)projectEntity);
    }

    public ProjectEntity openProject(String projectPk, boolean isEnterpriseAccount) throws Exception {
        ProjectEntity project;
        LogUtil.printOutputLine((String)"Cleaning up workspace");
        ProjectController.cleanWorkspace();
        LogUtil.printOutputLine((String)("Opening project file: " + projectPk));
        File projectFile = new File(projectPk);
        String projectFolderLocation = projectFile.getParent();
        String userDirLocation = System.getProperty("user.dir");
        if (userDirLocation.equals(projectFolderLocation)) {
            LogUtil.printErrorLine((String)"Warning! Please run Katalon execution command outside of the project folder.");
        }
        if ((project = ProjectController.getDataProviderSetting().getProjectDataProvider().openProjectWithoutClasspath(projectPk)) != null) {
            DataProviderState.getInstance().setCurrentProject(project);
            ProjectController.addJdtSettings(project);
            ProjectController.addResourceSettings(project);
            System.setProperty("project.properties", String.valueOf(project.isTimeStampInProperties()));
            GroovyUtil.initGroovyProject((ProjectEntity)project, ProjectController.getInstance().getCustomKeywordPlugins(project), (boolean)isEnterpriseAccount, null);
            LogUtil.printOutputLine((String)"Generating global variables...");
            GlobalVariableController.getInstance().generateGlobalVariableLibFile(project, null);
            LogUtil.printOutputLine((String)MessageFormat.format("Project ''{0}'' opened", project.getName()));
            System.setProperty("project.location", project.getFolderLocation());
        }
        this.setOpenning(false);
        return project;
    }

    public static void cleanWorkspace() {
        File externalFolder = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), ".metadata/.plugins/org.eclipse.core.resources/.projects/.org.eclipse.jdt.core.external.folders");
        if (!externalFolder.exists()) {
            externalFolder.mkdirs();
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.delete(false, true, null);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    private static void addJdtSettings(ProjectEntity project) {
        File jdtSettingFile = new File(project.getFolderLocation(), ".settings/org.eclipse.jdt.core.prefs");
        if (jdtSettingFile.exists()) {
            return;
        }
        String fileContent = ProjectController.getFileContent("resources/template/project_jdt_setting.tpl");
        try {
            FileUtils.write((File)jdtSettingFile, (CharSequence)fileContent, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private static void addResourceSettings(ProjectEntity project) {
        File resourceSettingFile = new File(project.getFolderLocation(), ".settings/org.eclipse.core.resources.prefs");
        if (resourceSettingFile.exists()) {
            return;
        }
        String fileContent = ProjectController.getFileContent("resources/template/project_jdt_resource_setting.tpl");
        try {
            FileUtils.write((File)resourceSettingFile, (CharSequence)fileContent, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private static String getFileContent(String filePath) {
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(ProjectController.class), (IPath)new Path(filePath), null);
        try {
            return StringUtils.join((Collection)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
    }

    public void closeProject(String projectPk, IProgressMonitor monitor) throws Exception {
        ProjectEntity project = ProjectController.getDataProviderSetting().getProjectDataProvider().openProjectWithoutClasspath(projectPk);
        if (project != null) {
            IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)project);
            try {
                groovyProject.clearHistory(monitor);
                groovyProject.close(monitor);
            }
            catch (CoreException e) {
                LogUtil.logError((Throwable)e);
            }
            GroovyUtil.removeProjectClassLoaderFromLookup((ProjectEntity)project);
        }
        DataProviderState.getInstance().setCurrentProject(null);
    }

    public ProjectEntity updateProject(String name, String description, String projectPk, boolean checkProp, ProjectType projectType) throws Exception {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().updateProject(name, description, projectPk, (short)0, checkProp, projectType);
    }

    public void updateProject(ProjectEntity projectEntity) throws Exception {
        ProjectController.getDataProviderSetting().getProjectDataProvider().updateProject(projectEntity);
    }

    public List<ProjectEntity> validateRecentProjectLocations(List<String> recentProjectLocations) {
        if (recentProjectLocations != null) {
            ArrayList<ProjectEntity> recentProjects = new ArrayList<ProjectEntity>();
            for (String projectLocation : recentProjectLocations) {
                try {
                    ProjectEntity project = ProjectController.getDataProviderSetting().getProjectDataProvider().getProject(projectLocation);
                    if (project == null) continue;
                    recentProjects.add(project);
                }
                catch (DALException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
            return recentProjects;
        }
        return new ArrayList<ProjectEntity>();
    }

    @Deprecated
    private List<ProjectEntity> validateRecentProjects(List<ProjectEntity> recentProjects) {
        if (recentProjects != null) {
            ArrayList<ProjectEntity> resultList = new ArrayList<ProjectEntity>();
            for (ProjectEntity recentProject : recentProjects) {
                if (recentProject == null) continue;
                File projectFolder = new File(recentProject.getFolderLocation());
                File projectFile = new File(recentProject.getLocation());
                if (!projectFolder.exists() || !projectFolder.isDirectory() || !projectFile.exists() || !projectFile.isFile()) continue;
                try {
                    ProjectEntity project = ProjectController.getDataProviderSetting().getProjectDataProvider().getProject(projectFile.getAbsolutePath());
                    if (!project.getName().equals(recentProject.getName())) continue;
                    resultList.add(recentProject);
                }
                catch (DALException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
            return resultList;
        }
        return new ArrayList<ProjectEntity>();
    }

    @Deprecated
    public List<ProjectEntity> getRecentProjects() {
        File recentProjectFile = new File(RECENT_PROJECT_FILE_LOCATION);
        if (recentProjectFile.isFile() && recentProjectFile.exists()) {
            ObjectInputStream inputStream = null;
            List projects = null;
            try {
                try {
                    inputStream = new ObjectInputStream(new FileInputStream(RECENT_PROJECT_FILE_LOCATION));
                    projects = (List)inputStream.readObject();
                }
                catch (Throwable throwable) {
                    ArrayList<ProjectEntity> arrayList = new ArrayList<ProjectEntity>();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return arrayList;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return this.validateRecentProjects(projects);
        }
        return new ArrayList<ProjectEntity>();
    }

    public ProjectEntity getCurrentProject() {
        return DataProviderState.getInstance().getCurrentProject();
    }

    public boolean validateNewProjectName(String projectParentFolderName, String projectName) throws Exception {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().isDuplicationProjectName(projectName, projectParentFolderName) == false;
    }

    public String getTempDir() {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().getSystemTempFolder();
    }

    public String getWebServiceTempDir() {
        return String.valueOf(this.getTempDir()) + File.separator + "Web Services";
    }

    public String getNonremovableTempDir() {
        return new File(ProjectController.getDataProviderSetting().getProjectDataProvider().getSystemTempFolder(), "non-removable").getAbsolutePath();
    }

    public String getInternalSettingDir() {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().getInternalSettingFolder();
    }

    public File getProjectFile(String folderLocation) {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().getProjectFile(folderLocation);
    }

    public String getRelativePath(String path) {
        if (this.getCurrentProject() == null) {
            return path;
        }
        String projectDir = this.getCurrentProject().getFolderLocation();
        File file = new File(path);
        if (file.isAbsolute() && file.getAbsolutePath().startsWith(projectDir)) {
            return PathUtil.absoluteToRelativePath((String)path, (String)projectDir);
        }
        return path;
    }

    public File getFile(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        if (this.getCurrentProject() != null) {
            String projectPath = this.getCurrentProject().getFolderLocation();
            return new File(projectPath, path);
        }
        return null;
    }

    public ProjectEntity newProjectEntity(String name, String description, String location, boolean legacy) throws DALException {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().newProjectEntity(name, description, location, legacy);
    }

    public ProjectEntity updateProjectInfo(File projectFile, ProjectEntity newInfo) throws DALException {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().updateProjectEntity(projectFile, newInfo);
    }

    public ProjectEntity getProject(String projectFileLocation) throws ControllerException {
        try {
            return ProjectController.getDataProviderSetting().getProjectDataProvider().getProject(projectFileLocation);
        }
        catch (DALException e) {
            throw new ControllerException(e);
        }
    }

    public List<File> getCustomKeywordPlugins(ProjectEntity project) throws ControllerException {
        return CustomKeywordPluginFactory.getInstance().getAllPluginFiles();
    }

    public URLClassLoader getProjectClassLoader(ProjectEntity project) throws MalformedURLException, CoreException {
        return GroovyUtil.getProjectClassLoader((ProjectEntity)project);
    }

    public void updateProjectClassLoader(ProjectEntity projectEntity) throws MalformedURLException, CoreException {
        GroovyUtil.updateProjectClassLoader((ProjectEntity)projectEntity);
    }

    public boolean isOpenning() {
        return this.isOpenning;
    }

    public void setOpenning(boolean isOpenning) {
        this.isOpenning = isOpenning;
    }

    public void initGitignoreFile(ProjectEntity project) throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(ProjectController.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("/resources/gitignore/gitignore_template"), null);
        File templateFile = FileUtils.toFile((URL)FileLocator.toFileURL((URL)url));
        File gitignoreFile = new File(project.getFolderLocation(), ".gitignore");
        if (!gitignoreFile.exists()) {
            gitignoreFile.createNewFile();
            FileUtils.copyFile((File)templateFile, (File)gitignoreFile);
        }
    }

    public void initGradleFile(ProjectEntity project) throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(ProjectController.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("/resources/gradle/gradle_template"), null);
        File templateFile = FileUtils.toFile((URL)FileLocator.toFileURL((URL)url));
        File gradleFile = new File(project.getFolderLocation(), "build.gradle");
        if (!gradleFile.exists()) {
            gradleFile.createNewFile();
            FileUtils.copyFile((File)templateFile, (File)gradleFile);
        }
    }

    public boolean hasCustomKeywords() {
        ProjectEntity currentProject = this.getCurrentProject();
        try {
            return new ProjectCustomKeywordsParser(currentProject).hasCustomKeywords();
        }
        catch (ParseKeywordException parseKeywordException) {
            return false;
        }
    }

    public boolean hasPluginKeywords() {
        return CustomKeywordParser.getInstance().hasPluginKeywords();
    }
}

