/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.fernflower.FernFlowerDecompiler;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.DecompileUtil;
import org.sf.feeling.decompiler.util.DecompilerOutputUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.SortMemberUtil;
import org.sf.feeling.decompiler.util.SourceMapperUtil;
import org.sf.feeling.decompiler.util.UIUtil;

public abstract class BaseDecompilerSourceMapper
extends DecompilerSourceMapper {
    protected IDecompiler origionalDecompiler;
    private IDecompiler usedDecompiler;
    private String classLocation;
    private static Map<String, String> options = new HashMap<String, String>();

    static {
        CompilerOptions option = new CompilerOptions();
        options = option.getMap();
        options.put("org.eclipse.jdt.core.compiler.compliance", DecompilerOutputUtil.getMaxDecompileLevel());
        options.put("org.eclipse.jdt.core.compiler.source", DecompilerOutputUtil.getMaxDecompileLevel());
    }

    public BaseDecompilerSourceMapper(IPath sourcePath, String rootPath) {
        this(sourcePath, rootPath, options);
    }

    public BaseDecompilerSourceMapper(IPath sourcePath, String rootPath, Map options) {
        super(sourcePath, rootPath, options);
    }

    public char[] findSource(IType type, IBinaryType info) {
        SourceMapper rootSourceMapper;
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean always = prefs.getBoolean("org.sf.feeling.decompiler.alwaysuse");
        LinkedList exceptions = new LinkedList();
        IPackageFragment pkgFrag = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkgFrag.getParent();
        JavaDecompilerPlugin.getDefault().syncLibrarySource(root);
        char[] attachedSource = null;
        if (UIUtil.requestFromJavadocHover() && !this.fromInput(type) && always) {
            this.sourceRanges.remove(type);
            attachedSource = ((SourceMapper)originalSourceMapper.get(root)).findSource(type, info);
            return attachedSource;
        }
        if (originalSourceMapper.containsKey(root) && (attachedSource = ((SourceMapper)originalSourceMapper.get(root)).findSource(type, info)) != null && !always) {
            this.updateSourceRanges(type, attachedSource);
            this.isAttachedSource = true;
            this.mapSourceSwitch(type, attachedSource, true);
            SourceMapperUtil.mapSource(((PackageFragmentRoot)root).getSourceMapper(), type, attachedSource, info);
            return attachedSource;
        }
        if (info == null) {
            if (always) {
                return null;
            }
            return attachedSource;
        }
        try {
            if (root instanceof PackageFragmentRoot) {
                PackageFragmentRoot pfr = (PackageFragmentRoot)root;
                SourceMapper sourceMapper = pfr.getSourceMapper();
                if (!originalSourceMapper.containsKey(root)) {
                    ReflectionUtils.setFieldValue((Object)this, "options", ReflectionUtils.getFieldValue(sourceMapper, "options"));
                    originalSourceMapper.put(root, sourceMapper);
                }
                if (sourceMapper != null && !always && !(sourceMapper instanceof DecompilerSourceMapper) && (attachedSource = sourceMapper.findSource(type, info)) != null) {
                    this.updateSourceRanges(type, attachedSource);
                    this.isAttachedSource = true;
                    this.mapSourceSwitch(type, attachedSource, true);
                    SourceMapperUtil.mapSource(((PackageFragmentRoot)root).getSourceMapper(), type, attachedSource, info);
                    return attachedSource;
                }
                if (sourceMapper != this) {
                    pfr.setSourceMapper((SourceMapper)this);
                }
            }
        }
        catch (JavaModelException e) {
            JavaDecompilerPlugin.logError(e, "Could not set source mapper.");
        }
        this.isAttachedSource = false;
        if (JavaDecompilerPlugin.getDefault().isAutoAttachSource()) {
            JavaDecompilerPlugin.getDefault().attachSource(root, false);
        }
        String className = new String(info.getName());
        String fullName = new String(info.getFileName());
        className = fullName.substring(fullName.lastIndexOf(className));
        int index = className.lastIndexOf(47);
        className = className.substring(index + 1);
        this.classLocation = "";
        this.usedDecompiler = this.decompile(null, type, exceptions, root, className);
        if (!(this.usedDecompiler != null && this.usedDecompiler.getSource() != null && this.usedDecompiler.getSource().length() != 0 || this.usedDecompiler != null && "FernFlower".equals(this.usedDecompiler.getDecompilerType()))) {
            this.usedDecompiler = this.decompile(new FernFlowerDecompiler(), type, exceptions, root, className);
            if (this.usedDecompiler == null || this.usedDecompiler.getSource() == null || this.usedDecompiler.getSource().length() == 0) {
                return null;
            }
        }
        String code = this.usedDecompiler.getSource();
        boolean showReport = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayMetadata");
        if (!showReport) {
            code = this.usedDecompiler.removeComment(code);
        }
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        if (showLineNumber && align || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            if (showReport) {
                code = this.usedDecompiler.removeComment(code);
            }
            DecompilerOutputUtil decompilerOutputUtil = new DecompilerOutputUtil(this.usedDecompiler.getDecompilerType(), code);
            code = decompilerOutputUtil.realign();
        }
        StringBuffer source = new StringBuffer();
        if (!UIUtil.isDebugPerspective() && !JavaDecompilerPlugin.getDefault().isDebugMode()) {
            boolean useSorter = prefs.getBoolean("org.sf.feeling.decompiler.use_eclipse_sorter");
            if (useSorter) {
                className = new String(info.getName());
                fullName = new String(info.getFileName());
                if (fullName.lastIndexOf(className) != -1) {
                    className = fullName.substring(fullName.lastIndexOf(className));
                }
                code = SortMemberUtil.sortMember(type.getPackageFragment().getElementName(), className, code);
            }
            source.append(this.formatSource(code));
            if (showReport) {
                this.printDecompileReport(source, this.classLocation, exceptions, this.usedDecompiler.getDecompilationTime());
            }
        } else {
            source.append(code);
        }
        char[] sourceAsCharArray = source.toString().toCharArray();
        if (originalSourceMapper.containsKey(root) && (rootSourceMapper = (SourceMapper)originalSourceMapper.get(root)).findSource(type, info) == null) {
            SourceMapperUtil.mapSource(rootSourceMapper, type, sourceAsCharArray, info);
        }
        this.updateSourceRanges(type, sourceAsCharArray);
        return sourceAsCharArray;
    }

    private void updateSourceRanges(IType type, char[] attachedSource) {
        if (type.getParent() instanceof ClassFile) {
            try {
                DecompileUtil.updateSourceRanges((IClassFile)((ClassFile)type.getParent()), new String(attachedSource));
            }
            catch (JavaModelException e) {
                Logger.debug(e);
            }
        }
    }

    private boolean fromInput(IType type) {
        JavaDecompilerClassFileEditor editor = UIUtil.getActiveEditor();
        if (editor != null && editor.getEditorInput() instanceof IClassFileEditorInput) {
            IClassFile input = ((IClassFileEditorInput)editor.getEditorInput()).getClassFile();
            IType inputType = (IType)ReflectionUtils.invokeMethod((Object)input, "getOuterMostEnclosingType", new Class[0], new Object[0]);
            return type.equals(inputType);
        }
        return false;
    }

    private IDecompiler decompile(IDecompiler decompiler, IType type, Collection exceptions, IPackageFragmentRoot root, String className) {
        Boolean displayNumber;
        IDecompiler result;
        block15: {
            result = decompiler;
            String pkg = type.getPackageFragment().getElementName().replace('.', '/');
            displayNumber = null;
            if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
                displayNumber = JavaDecompilerPlugin.getDefault().isDisplayLineNumber();
                JavaDecompilerPlugin.getDefault().displayLineNumber(Boolean.TRUE);
            }
            try {
                if (root.isArchive()) {
                    String archivePath = this.getArchivePath(root);
                    this.classLocation = String.valueOf(this.classLocation) + archivePath;
                    if (result == null) {
                        try {
                            result = ClassUtil.checkAvailableDecompiler(this.origionalDecompiler, new ByteArrayInputStream(type.getClassFile().getBytes()));
                        }
                        catch (JavaModelException e) {
                            result = this.origionalDecompiler;
                        }
                    }
                    result.decompileFromArchive(archivePath, pkg, className);
                    break block15;
                }
                String rootLocation = null;
                try {
                    if (root.getUnderlyingResource() != null) {
                        rootLocation = root.getUnderlyingResource().getLocation().toOSString();
                        this.classLocation = String.valueOf(this.classLocation) + rootLocation + "/" + pkg + "/" + className;
                    } else if (root instanceof ExternalPackageFragmentRoot) {
                        rootLocation = ((ExternalPackageFragmentRoot)root).getPath().toOSString();
                        this.classLocation = String.valueOf(this.classLocation) + rootLocation + "/" + pkg + "/" + className;
                    } else {
                        rootLocation = root.getPath().toOSString();
                        this.classLocation = String.valueOf(this.classLocation) + rootLocation + "/" + pkg + "/" + className;
                    }
                    if (result == null) {
                        result = ClassUtil.checkAvailableDecompiler(this.origionalDecompiler, new File(this.classLocation));
                    }
                    result.decompile(rootLocation, pkg, className);
                }
                catch (JavaModelException e) {
                    exceptions.add(e);
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (displayNumber != null) {
            JavaDecompilerPlugin.getDefault().displayLineNumber(displayNumber);
        }
        return result;
    }

    @Override
    public String decompile(String decompilerType, File file) {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        Boolean displayNumber = null;
        if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            displayNumber = JavaDecompilerPlugin.getDefault().isDisplayLineNumber();
            JavaDecompilerPlugin.getDefault().displayLineNumber(Boolean.TRUE);
        }
        IDecompiler currentDecompiler = ClassUtil.checkAvailableDecompiler(this.origionalDecompiler, file);
        currentDecompiler.decompile(file.getParentFile().getAbsolutePath(), "", file.getName());
        if (displayNumber != null) {
            JavaDecompilerPlugin.getDefault().displayLineNumber(displayNumber);
        }
        if (currentDecompiler.getSource() == null || currentDecompiler.getSource().length() == 0) {
            return null;
        }
        String code = currentDecompiler.getSource();
        boolean showReport = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayMetadata");
        if (!showReport) {
            code = currentDecompiler.removeComment(code);
        }
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        if (showLineNumber && align || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            if (showReport) {
                code = currentDecompiler.removeComment(code);
            }
            DecompilerOutputUtil decompilerOutputUtil = new DecompilerOutputUtil(currentDecompiler.getDecompilerType(), code);
            code = decompilerOutputUtil.realign();
        }
        StringBuffer source = new StringBuffer();
        if (!UIUtil.isDebugPerspective() && !JavaDecompilerPlugin.getDefault().isDebugMode()) {
            source.append(this.formatSource(code));
            if (showReport) {
                LinkedList exceptions = new LinkedList();
                exceptions.addAll(currentDecompiler.getExceptions());
                this.printDecompileReport(source, file.getAbsolutePath(), exceptions, currentDecompiler.getDecompilationTime());
            }
        } else {
            source.append(code);
        }
        return source.toString();
    }

    protected abstract void printDecompileReport(StringBuffer var1, String var2, Collection var3, long var4);
}

