/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search2.internal.ui.text.AnnotationManagers;
import org.eclipse.search2.internal.ui.text.EditorAnnotationManager;
import org.eclipse.search2.internal.ui.text.WindowAnnotationManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.FindNextAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.GotoLineAction;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IncrementalFindAction;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.actions.DecompileActionGroup;
import org.sf.feeling.decompiler.editor.ByteCodeSourceViewer;
import org.sf.feeling.decompiler.editor.ClassFileSourceMap;
import org.sf.feeling.decompiler.editor.DecompilerClassEditorInput;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.editor.DisassemblerSourceViewer;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.editor.JavaDecompilerBufferManager;
import org.sf.feeling.decompiler.editor.SourceMapperFactory;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.DecompileUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.UIUtil;

public class JavaDecompilerClassFileEditor
extends ClassFileEditor {
    public static final String ID = "org.sf.feeling.decompiler.ClassFileEditor";
    private IBuffer classBuffer;
    private PaintListener paintListener;
    private MouseAdapter mouseAdapter;
    private int currentSourceMode = -1;
    private boolean selectionChange = false;
    private ISourceReference selectedElement = null;
    private String decompilerType = null;
    private DisassemblerSourceViewer fDisassemblerSourceViewer;
    private ByteCodeSourceViewer fByteCodeSourceViewer;

    public ISourceReference getSelectedElement() {
        return this.selectedElement;
    }

    public ISelectionProvider getSelectionProvider() {
        if (UIUtil.requestFromCopyOperation()) {
            if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && this.fDisassemblerSourceViewer != null) {
                return this.fDisassemblerSourceViewer.getSelectionProvider();
            }
            if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && this.fByteCodeSourceViewer != null) {
                return this.fByteCodeSourceViewer.getSelectionProvider();
            }
        }
        return super.getSelectionProvider();
    }

    private boolean doOpenBuffer(IEditorInput input, boolean force) throws JavaModelException {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        String decompilerType = prefs.getString("org.sf.feeling.decompiler.type");
        return this.doOpenBuffer(input, decompilerType, force);
    }

    private boolean doOpenBuffer(IEditorInput input, String type, boolean force) throws JavaModelException {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean reuseBuf = prefs.getBoolean("org.sf.feeling.decompiler.reusebuff");
        boolean always = prefs.getBoolean("org.sf.feeling.decompiler.alwaysuse");
        return this.doOpenBuffer(input, type, force, reuseBuf, always);
    }

    private boolean doOpenBuffer(IEditorInput input, String type, boolean force, boolean reuseBuf, boolean always) throws JavaModelException {
        if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            reuseBuf = false;
        }
        if (input instanceof IClassFileEditorInput) {
            boolean opened = false;
            IClassFile cf = ((IClassFileEditorInput)input).getClassFile();
            this.decompilerType = type;
            String origSrc = cf.getSource();
            if (origSrc == null || origSrc != null && always || origSrc != null && !always && !reuseBuf || JavaDecompilerClassFileEditor.debugOptionChange(origSrc) || force) {
                char[] src;
                DecompilerSourceMapper sourceMapper = SourceMapperFactory.getSourceMapper(this.decompilerType);
                char[] cArray = src = sourceMapper == null ? null : sourceMapper.findSource(cf.getType());
                if (src == null) {
                    if ("FernFlower".equals(this.decompilerType)) {
                        src = SourceMapperFactory.getSourceMapper("FernFlower").findSource(cf.getType());
                    } else {
                        IDecompilerDescriptor decompilerDescriptor = JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(this.decompilerType);
                        if (decompilerDescriptor != null) {
                            src = decompilerDescriptor.getDecompilerSourceMapper().findSource(cf.getType());
                        }
                    }
                }
                if (src == null) {
                    return false;
                }
                char[] markedSrc = src;
                this.classBuffer = BufferManager.createBuffer((IOpenable)cf);
                this.classBuffer.setContents(markedSrc);
                this.getBufferManager().addBuffer(this.classBuffer);
                sourceMapper.mapSourceSwitch(cf.getType(), markedSrc, true);
                ClassFileSourceMap.updateSource(this.getBufferManager(), (ClassFile)cf, markedSrc);
                opened = true;
            }
            return opened;
        }
        return false;
    }

    public void clearSelection() {
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null && !this.getSourceViewer().getTextWidget().isDisposed()) {
            this.getSourceViewer().getTextWidget().setSelectionRange(0, 0);
        }
    }

    public boolean isDirty() {
        return false;
    }

    protected void selectionChanged() {
        this.selectionChange = true;
        super.selectionChanged();
        this.selectionChange = false;
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        super.setSelection(reference, moveCursor);
        this.selectedElement = reference;
        if (this.fByteCodeSourceViewer != null) {
            this.fByteCodeSourceViewer.setSelectionElement(reference);
        }
        if (this.fDisassemblerSourceViewer != null) {
            this.fDisassemblerSourceViewer.setSelectionElement(reference);
        }
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        super.setHighlightRange(offset, length, moveCursor);
        if (this.selectionChange) {
            return;
        }
        IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)this.getEditorInput();
        final IClassFile file = classFileEditorInput.getClassFile();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DecompileUtil.updateBuffer(file, file.getBuffer().getContents());
                }
                catch (JavaModelException e) {
                    Logger.debug(e);
                }
            }
        });
        final StyledText widget = this.getSourceViewer().getTextWidget();
        widget.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int selection;
                if (!widget.isDisposed() && widget.getVerticalBar() != null && (selection = widget.getVerticalBar().getSelection()) > 0 && selection < widget.getBounds().height / 2 && widget.getLocationAtOffset((int)widget.getSelection().x).y + selection + widget.getLineHeight() * 2 < widget.getBounds().height) {
                    ReflectionUtils.invokeMethod((Object)widget, "scrollVertical", new Class[]{Integer.TYPE, Boolean.TYPE}, new Object[]{-selection, true});
                }
            }
        });
    }

    public static boolean debugOptionChange(String source) {
        return JavaDecompilerClassFileEditor.isDebug(source) ^ ClassUtil.isDebug();
    }

    public static boolean isDebug(String source) {
        if (source == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("/\\*\\s*\\d+\\s*\\*/");
        Matcher matcher = pattern.matcher(source);
        return matcher.find() || source.indexOf("// Warning: No line numbers available in class file") != -1;
    }

    public IBuffer getClassBuffer() {
        return this.classBuffer;
    }

    public void doSetInput(boolean force) {
        IEditorInput input = this.getEditorInput();
        try {
            if (this.doOpenBuffer(input, force)) {
                super.doSetInput(input);
            }
        }
        catch (Exception e) {
            JavaDecompilerPlugin.logError(e, "");
        }
        this.handleMarkLink();
    }

    public void doSetInput(String type, boolean force) {
        IEditorInput input = this.getEditorInput();
        try {
            if (this.doOpenBuffer(input, type, force)) {
                super.doSetInput(input);
            }
        }
        catch (Exception e) {
            JavaDecompilerPlugin.logError(e, "");
        }
        this.handleMarkLink();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            String filePath = UIUtil.getPathLocation(((IFileEditorInput)input).getStorage().getFullPath());
            if (filePath == null || !new File(filePath).exists()) {
                super.doSetInput(input);
            } else {
                this.doSetInput((IEditorInput)new DecompilerClassEditorInput(EFS.getLocalFileSystem().getStore((IPath)new Path(filePath))));
            }
        } else {
            block22: {
                if (input instanceof FileStoreEditorInput) {
                    FileStoreEditorInput storeInput = (FileStoreEditorInput)input;
                    IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
                    String decompilerType = prefs.getString("org.sf.feeling.decompiler.type");
                    String source = DecompileUtil.decompiler(storeInput, decompilerType);
                    if (source != null) {
                        String packageName = DecompileUtil.getPackageName(source);
                        String classFullName = packageName == null ? storeInput.getName() : String.valueOf(packageName) + "." + storeInput.getName().replaceAll("(?i)\\.class", "");
                        File file = new File(System.getProperty("java.io.tmpdir"), storeInput.getName().replaceAll("(?i)\\.class", String.valueOf(System.currentTimeMillis()) + ".java"));
                        FileUtil.writeToFile(file, source, ResourcesPlugin.getEncoding());
                        file.deleteOnExit();
                        DecompilerClassEditorInput editorInput = new DecompilerClassEditorInput(EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath())));
                        editorInput.setToolTipText(classFullName);
                        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.eclipse.jdt.ui.CompilationUnitEditor");
                        try {
                            ReflectionUtils.invokeMethod((Object)editor, "setPartName", new Class[]{String.class}, (Object[])new String[]{this.getPartTitle(storeInput.getName())});
                            ReflectionUtils.invokeMethod((Object)editor, "setTitleImage", new Class[]{Image.class}, new Object[]{JavaDecompilerPlugin.getImageDescriptor("icons/decompiler.png").createImage()});
                            ReflectionUtils.setFieldValue(editor, "fIsEditingDerivedFileAllowed", false);
                        }
                        catch (Exception e) {
                            JavaDecompilerPlugin.logError(e, "");
                        }
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            JavaDecompilerClassFileEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)JavaDecompilerClassFileEditor.this, false);
                        }
                    });
                    throw new CoreException((IStatus)new Status(8, "org.sf.feeling.decompiler", 1, "", null));
                }
                if (input instanceof InternalClassFileEditorInput) {
                    InternalClassFileEditorInput classInput = (InternalClassFileEditorInput)input;
                    if (classInput.getClassFile().getParent() instanceof PackageFragment) {
                        this.doOpenBuffer(input, false);
                    } else {
                        IPath relativePath = classInput.getClassFile().getParent().getPath();
                        String location = UIUtil.getPathLocation(relativePath);
                        if (!FileUtil.isZipFile(location) && !FileUtil.isZipFile(relativePath.toOSString())) {
                            String filePath = UIUtil.getPathLocation(classInput.getClassFile().getPath());
                            if (filePath != null) {
                                DecompilerClassEditorInput editorInput = new DecompilerClassEditorInput(EFS.getLocalFileSystem().getStore((IPath)new Path(filePath)));
                                this.doSetInput((IEditorInput)editorInput);
                            } else {
                                this.doSetInput((IEditorInput)new DecompilerClassEditorInput(EFS.getLocalFileSystem().getStore(classInput.getClassFile().getPath())));
                            }
                            return;
                        }
                    }
                }
                try {
                    this.doOpenBuffer(input, false);
                }
                catch (JavaModelException e) {
                    IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
                    IClassFile file = classFileEditorInput.getClassFile();
                    if (file.getSourceRange() != null || file.getBytes() == null || !ClassUtil.isClassFile(file.getBytes())) break block22;
                    File classFile = new File(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd"), file.getElementName());
                    try {
                        FileOutputStream fos = new FileOutputStream(classFile);
                        fos.write(file.getBytes());
                        fos.close();
                        this.doSetInput((IEditorInput)new DecompilerClassEditorInput(EFS.getLocalFileSystem().getStore((IPath)new Path(classFile.getAbsolutePath()))));
                        classFile.delete();
                        return;
                    }
                    catch (IOException e1) {
                        JavaDecompilerPlugin.logError(e, "");
                    }
                    finally {
                        if (classFile != null && classFile.exists()) {
                            classFile.delete();
                        }
                    }
                }
            }
            super.doSetInput(input);
        }
        this.handleMarkLink();
    }

    protected void setPartName(String partName) {
        super.setPartName(this.getPartTitle(partName));
    }

    private String getPartTitle(String title) {
        if (this.decompilerType == null || title == null) {
            return title;
        }
        if (title.endsWith("]")) {
            return title;
        }
        return String.valueOf(title) + " [" + this.decompilerType + "]";
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.showSource();
    }

    private void handleMarkLink() {
        final int index = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get().indexOf("://");
        if (index != -1) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JavaDecompilerClassFileEditor.this.updateMatchAnnonation();
                    JavaDecompilerClassFileEditor.this.handleMarkLink(index);
                }
            });
        }
    }

    protected JavaDecompilerBufferManager getBufferManager() {
        BufferManager defManager = BufferManager.getDefaultBufferManager();
        JavaDecompilerBufferManager manager = defManager instanceof JavaDecompilerBufferManager ? (JavaDecompilerBufferManager)defManager : new JavaDecompilerBufferManager(defManager);
        return manager;
    }

    public void notifyPropertiesChange() {
        ReflectionUtils.invokeMethod((Object)this.getViewer(), "fireSelectionChanged", new Class[]{SelectionChangedEvent.class}, new Object[]{new SelectionChangedEvent((ISelectionProvider)this.getViewer(), (ISelection)new StructuredSelection())});
    }

    private void handleMarkLink(int index) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        final StyledText text = sourceViewer.getTextWidget();
        if (text.isDisposed()) {
            return;
        }
        IHyperlinkDetector[] descriptors = this.getSourceViewerConfiguration().getHyperlinkDetectors(sourceViewer);
        int i = 0;
        while (i < descriptors.length) {
            final IHyperlink[] links = descriptors[i].detectHyperlinks((ITextViewer)sourceViewer, (IRegion)new Region(index, 0), true);
            if (links != null && links.length > 0 && links[0] instanceof URLHyperlink) {
                IHyperlinkPresenter fHyperlinkPresenter = (IHyperlinkPresenter)ReflectionUtils.getFieldValue(sourceViewer, "fHyperlinkPresenter");
                final HyperlinkManager fHyperlinkManager = (HyperlinkManager)ReflectionUtils.getFieldValue(sourceViewer, "fHyperlinkManager");
                if (fHyperlinkPresenter != null && fHyperlinkManager != null) {
                    fHyperlinkPresenter.showHyperlinks(links);
                    final boolean[] flags = new boolean[1];
                    if (!text.isDisposed() && this.paintListener != null) {
                        text.removePaintListener(this.paintListener);
                    }
                    this.paintListener = new PaintListener(){

                        private Boolean isActive(HyperlinkManager fHyperlinkManager2) {
                            return (Boolean)ReflectionUtils.getFieldValue(fHyperlinkManager2, "fActive");
                        }

                        private void addPaintListener(final StyledText text2) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!text2.isDisposed() && JavaDecompilerClassFileEditor.this.paintListener != null) {
                                        text2.removePaintListener(JavaDecompilerClassFileEditor.this.paintListener);
                                        text2.addPaintListener(JavaDecompilerClassFileEditor.this.paintListener);
                                    }
                                }
                            });
                        }

                        public void paintControl(PaintEvent e) {
                            if (flags[0]) {
                                return;
                            }
                            flags[0] = true;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    boolean fActive = this.isActive(fHyperlinkManager);
                                    if (!fActive && !text.isDisposed()) {
                                        text.removePaintListener(JavaDecompilerClassFileEditor.this.paintListener);
                                        JavaDecompilerClassFileEditor.this.updateMatchAnnonation();
                                        this.addPaintListener(text);
                                    }
                                    flags[0] = false;
                                }
                            });
                        }
                    };
                    text.addPaintListener(this.paintListener);
                    if (this.mouseAdapter != null) {
                        text.removeMouseListener((MouseListener)this.mouseAdapter);
                    }
                    this.mouseAdapter = new MouseAdapter(){

                        public void mouseUp(MouseEvent e) {
                            int offset = JavaDecompilerClassFileEditor.this.getCaretModelOffset(text);
                            if (offset == -1) {
                                return;
                            }
                            int j = 0;
                            while (j < links.length) {
                                int linkOffset = links[j].getHyperlinkRegion().getOffset();
                                int linkLength = links[j].getHyperlinkRegion().getLength();
                                if (offset >= linkOffset && offset < linkOffset + linkLength) {
                                    if (links[j] instanceof URLHyperlink) {
                                        String url = ((URLHyperlink)links[j]).getURLString();
                                        UIUtil.openBrowser(url);
                                    }
                                    return;
                                }
                                ++j;
                            }
                        }
                    };
                    text.addMouseListener((MouseListener)this.mouseAdapter);
                }
            }
            ++i;
        }
    }

    private int getCaretModelOffset(StyledText text) {
        int offset;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            offset = extension.widgetOffset2ModelOffset(text.getCaretOffset());
        } else {
            int visibleRegionOffset = sourceViewer.getVisibleRegion().getOffset();
            offset = visibleRegionOffset + text.getCaretOffset();
        }
        return offset;
    }

    private void updateMatchAnnonation() {
        WindowAnnotationManager mgr = (WindowAnnotationManager)ReflectionUtils.invokeMethod(AnnotationManagers.class, "getWindowAnnotationManager", new Class[]{IWorkbenchWindow.class}, new Object[]{PlatformUI.getWorkbench().getActiveWorkbenchWindow()});
        if (mgr == null) {
            return;
        }
        Map fAnnotationManagers = (Map)ReflectionUtils.getFieldValue(mgr, "fAnnotationManagers");
        if (fAnnotationManagers == null) {
            return;
        }
        EditorAnnotationManager amgr = (EditorAnnotationManager)fAnnotationManagers.get((Object)this);
        if (amgr == null) {
            return;
        }
        ReflectionUtils.invokeMethod((Object)amgr, "removeAllAnnotations", new Class[0], new Object[0]);
    }

    public String[] collectContextMenuPreferencePages() {
        String[] inheritedPages = super.collectContextMenuPreferencePages();
        int length = 1;
        String[] result = new String[inheritedPages.length + length];
        if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
            result[0] = "org.sf.feeling.decompiler.Main";
        } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2) {
            result[0] = "org.sf.feeling.decompiler.Disassembler";
        } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1) {
            result[0] = "org.eclipse.ui.preferencePages.ColorsAndFonts";
        }
        System.arraycopy(inheritedPages, 0, result, length, inheritedPages.length);
        return result;
    }

    protected void createActions() {
        super.createActions();
        this.setAction(ITextEditorActionConstants.COPY, null);
        String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.ui.texteditor.ConstructedEditorMessages";
        ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedEditorMessages");
        Action copyAction = new Action(fgBundleForConstructedKeys.getString("Editor.Copy.label")){

            public void run() {
                if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                    ((SourceViewer)JavaDecompilerClassFileEditor.this.getSourceViewer()).getTextWidget().copy();
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer != null && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getTextWidget() != null) {
                    JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getTextWidget().copy();
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer != null && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getTextWidget() != null) {
                    JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getTextWidget().copy();
                }
            }
        };
        copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(ITextEditorActionConstants.COPY, (IAction)copyAction);
        this.setAction(ITextEditorActionConstants.SELECT_ALL, null);
        Action selectAllAction = new Action(fgBundleForConstructedKeys.getString("Editor.SelectAll.label")){

            public void run() {
                if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                    ((SourceViewer)JavaDecompilerClassFileEditor.this.getSourceViewer()).getTextWidget().selectAll();
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer != null && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getTextWidget() != null) {
                    JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getTextWidget().selectAll();
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer != null && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getTextWidget() != null) {
                    JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getTextWidget().selectAll();
                }
            }
        };
        selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(ITextEditorActionConstants.SELECT_ALL, (IAction)copyAction);
        this.setAction(ITextEditorActionConstants.FIND, null);
        FindReplaceAction findAction = new FindReplaceAction(fgBundleForConstructedKeys, "Editor.FindReplace.", (IWorkbenchPart)this){

            public void run() {
                if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.getAdapter(IFindReplaceTarget.class));
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer != null) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getAdapter(IFindReplaceTarget.class));
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer != null) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getAdapter(IFindReplaceTarget.class));
                }
                super.run();
            }
        };
        findAction.setHelpContextId(IAbstractTextEditorHelpContextIds.FIND_ACTION);
        findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setAction(ITextEditorActionConstants.FIND, (IAction)findAction);
        this.setAction("FindNext", null);
        FindNextAction findNextAction = new FindNextAction(fgBundleForConstructedKeys, "Editor.FindNext.", (IWorkbenchPart)this, true){

            public void run() {
                if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.getAdapter(IFindReplaceTarget.class));
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer != null) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getAdapter(IFindReplaceTarget.class));
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer != null) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getAdapter(IFindReplaceTarget.class));
                }
                super.run();
            }
        };
        findNextAction.setHelpContextId("org.eclipse.ui.FindNext_action_context");
        findNextAction.setActionDefinitionId("org.eclipse.ui.edit.findNext");
        this.setAction("FindNext", (IAction)findNextAction);
        this.setAction("FindPrevious", null);
        FindNextAction findPreviousAction = new FindNextAction(fgBundleForConstructedKeys, "Editor.FindPrevious.", (IWorkbenchPart)this, false){

            public void run() {
                if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.getAdapter(IFindReplaceTarget.class));
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer != null) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getAdapter(IFindReplaceTarget.class));
                } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer != null) {
                    ReflectionUtils.setFieldValue((Object)this, "fTarget", (IFindReplaceTarget)JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getAdapter(IFindReplaceTarget.class));
                }
                super.run();
            }
        };
        findPreviousAction.setHelpContextId("org.eclipse.ui.FindPrevious_action_context");
        findPreviousAction.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
        this.setAction("FindPrevious", (IAction)findPreviousAction);
        this.setAction("FindIncremental", null);
        IncrementalFindAction incrementalFindAction = new IncrementalFindAction(fgBundleForConstructedKeys, "Editor.FindIncremental.", (IWorkbenchPart)this, true){

            public void run() {
                try {
                    Class<?> clazz = Class.forName("org.eclipse.ui.texteditor.IncrementalFindTarget");
                    if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                        ReflectionUtils.setFieldValue((Object)this, "fTarget", JavaDecompilerClassFileEditor.this.getAdapter(clazz));
                    } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer != null) {
                        ReflectionUtils.setFieldValue((Object)this, "fTarget", JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getAdapter(clazz));
                    } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer != null) {
                        ReflectionUtils.setFieldValue((Object)this, "fTarget", JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getAdapter(clazz));
                    }
                }
                catch (ClassNotFoundException e) {
                    Logger.debug(e);
                }
                super.run();
            }
        };
        incrementalFindAction.setHelpContextId("org.eclipse.ui.FindIncremental_action_context");
        incrementalFindAction.setActionDefinitionId("org.eclipse.ui.edit.findIncremental");
        this.setAction("FindIncremental", (IAction)incrementalFindAction);
        this.setAction("FindIncrementalReverse", null);
        IncrementalFindAction incrementalFindReverseAction = new IncrementalFindAction(fgBundleForConstructedKeys, "Editor.FindIncrementalReverse.", (IWorkbenchPart)this, false){

            public void run() {
                try {
                    Class<?> clazz = Class.forName("org.eclipse.ui.texteditor.IncrementalFindTarget");
                    if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                        ReflectionUtils.setFieldValue((Object)this, "fTarget", JavaDecompilerClassFileEditor.this.getAdapter(clazz));
                    } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer != null) {
                        ReflectionUtils.setFieldValue((Object)this, "fTarget", JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer.getAdapter(clazz));
                    } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer != null) {
                        ReflectionUtils.setFieldValue((Object)this, "fTarget", JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer.getAdapter(clazz));
                    }
                }
                catch (ClassNotFoundException e) {
                    Logger.debug(e);
                }
                super.run();
            }
        };
        incrementalFindReverseAction.setHelpContextId("org.eclipse.ui.FindIncrementalReverse_action_context");
        incrementalFindReverseAction.setActionDefinitionId("org.eclipse.ui.edit.findIncrementalReverse");
        this.setAction("FindIncrementalReverse", (IAction)incrementalFindAction);
        this.setAction("GotoLine", null);
        GotoLineAction gotoAction = new GotoLineAction(fgBundleForConstructedKeys, "Editor.GotoLine.", (ITextEditor)this){

            protected ITextEditor getTextEditor() {
                if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2) {
                    return JavaDecompilerClassFileEditor.this.fDisassemblerSourceViewer;
                }
                if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1) {
                    return JavaDecompilerClassFileEditor.this.fByteCodeSourceViewer;
                }
                return JavaDecompilerClassFileEditor.this;
            }
        };
        gotoAction.setHelpContextId("org.eclipse.ui.GotoLine_action_context");
        gotoAction.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        this.setAction("GotoLine", (IAction)gotoAction);
        ReflectionUtils.setFieldValue((Object)this, "fSourceCopyAction", copyAction);
        ReflectionUtils.setFieldValue((Object)this, "fSelectAllAction", selectAllAction);
        DecompileActionGroup group = new DecompileActionGroup(this, "group.save", true);
        CompositeActionGroup fContextMenuGroup = (CompositeActionGroup)ReflectionUtils.getFieldValue((Object)this, "fContextMenuGroup");
        fContextMenuGroup.addGroup((ActionGroup)group);
    }

    public void showSource() {
        if (this.getEditorInput() instanceof IClassFileEditorInput) {
            this.showSource((IClassFileEditorInput)this.getEditorInput());
        }
    }

    protected void showSource(IClassFileEditorInput classFileEditorInput) {
        if (this.currentSourceMode == JavaDecompilerPlugin.getDefault().getSourceMode()) {
            return;
        }
        try {
            StackLayout fStackLayout = (StackLayout)ReflectionUtils.getFieldValue((Object)this, "fStackLayout");
            Composite fParent = (Composite)ReflectionUtils.getFieldValue((Object)this, "fParent");
            Composite fViewerComposite = (Composite)ReflectionUtils.getFieldValue((Object)this, "fViewerComposite");
            if (JavaDecompilerPlugin.getDefault().getSourceMode() == 0) {
                if (fStackLayout != null && fViewerComposite != null && fParent != null) {
                    fStackLayout.topControl = fViewerComposite;
                    fParent.layout();
                }
            } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2) {
                if (fStackLayout != null && fParent != null) {
                    if (this.fDisassemblerSourceViewer == null) {
                        this.fDisassemblerSourceViewer = new DisassemblerSourceViewer(this);
                        this.fDisassemblerSourceViewer.createControl(fParent);
                    }
                    this.fDisassemblerSourceViewer.getTextWidget().setSelection(0, 0);
                    this.fDisassemblerSourceViewer.setSelectionElement(this.selectedElement);
                    fStackLayout.topControl = this.fDisassemblerSourceViewer.getControl();
                    fParent.layout();
                }
            } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && fStackLayout != null && fParent != null) {
                if (this.fByteCodeSourceViewer == null) {
                    this.fByteCodeSourceViewer = new ByteCodeSourceViewer(this);
                    this.fByteCodeSourceViewer.createControl(fParent);
                }
                this.fByteCodeSourceViewer.getTextWidget().setSelection(0, 0);
                this.fByteCodeSourceViewer.setSelectionElement(this.selectedElement);
                fStackLayout.topControl = this.fByteCodeSourceViewer.getControl();
                fParent.layout();
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        this.currentSourceMode = JavaDecompilerPlugin.getDefault().getSourceMode();
    }

    protected String getCursorPosition() {
        if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2) {
            if (this.fDisassemblerSourceViewer != null && this.fDisassemblerSourceViewer.getTextWidget() != null) {
                int line = this.fDisassemblerSourceViewer.getTextWidget().getLineAtOffset(this.fDisassemblerSourceViewer.getTextWidget().getCaretOffset());
                int column = this.fDisassemblerSourceViewer.getTextWidget().getCaretOffset() - this.fDisassemblerSourceViewer.getTextWidget().getOffsetAtLine(line);
                return String.valueOf(line + 1) + " : " + (column + 1);
            }
        } else if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && this.fByteCodeSourceViewer != null && this.fByteCodeSourceViewer.getTextWidget().getSelection() != null) {
            int line = this.fByteCodeSourceViewer.getTextWidget().getLineAtOffset(this.fByteCodeSourceViewer.getTextWidget().getCaretOffset());
            int column = this.fByteCodeSourceViewer.getTextWidget().getCaretOffset() - this.fByteCodeSourceViewer.getTextWidget().getOffsetAtLine(line);
            return String.valueOf(line + 1) + " : " + (column + 1);
        }
        return super.getCursorPosition();
    }
}

