/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassExtractor {
    public static void extract(String archivePath, String packege, String className, boolean inner, String to) throws IOException {
        ZipFile archive = new ZipFile(archivePath);
        List entries = JarClassExtractor.findRelevant(archive, packege, className, inner);
        InputStream in = null;
        OutputStream out = null;
        byte[] buffer = new byte[2048];
        int i = 0;
        while (i < entries.size()) {
            ZipEntry entry = (ZipEntry)entries.get(i);
            String outFile = entry.getName();
            int lastSep = outFile.lastIndexOf(47);
            if (lastSep != -1) {
                outFile = outFile.substring(lastSep);
            }
            try {
                int amountRead;
                in = archive.getInputStream(entry);
                if (in == null) {
                    throw new IOException("Zip file entry <" + entry.getName() + "> not found");
                }
                out = new FileOutputStream(String.valueOf(to) + File.separator + outFile);
                while ((amountRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, amountRead);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            ++i;
        }
    }

    private static List findRelevant(ZipFile archive, String packege, String className, boolean inner) {
        String entryName = packege.length() == 0 ? className : String.valueOf(packege) + "/" + className;
        String innerPrefix = String.valueOf(entryName.substring(0, entryName.length() - 6)) + "$";
        Enumeration<? extends ZipEntry> entries = archive.entries();
        ArrayList<ZipEntry> relevant = new ArrayList<ZipEntry>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.equals(entryName) && (!name.startsWith(innerPrefix) || !inner)) continue;
            relevant.add(entry);
        }
        return relevant;
    }
}

