/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.execution.handler;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.XCBuildConfiguration;
import ca.mestevens.ios.xcode.parser.models.XCConfigurationList;
import ca.mestevens.ios.xcode.parser.models.XCodeProject;
import com.kms.katalon.composer.components.constants.ComposerComponentsMessageConstants;
import com.kms.katalon.composer.components.dialogs.InstallationInstructionDialog;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.installer.InstallationCommandStep;
import com.kms.katalon.composer.components.impl.installer.InstallationManager;
import com.kms.katalon.composer.components.impl.installer.InstallationStep;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.mobile.constants.ComposerMobileMessageConstants;
import com.kms.katalon.composer.mobile.constants.StringConstants;
import com.kms.katalon.composer.mobile.dialog.IosDeviceSelectionDialog;
import com.kms.katalon.composer.mobile.dialog.IosProvisioningProfileAndIdentitySelectionDialog;
import com.kms.katalon.composer.mobile.entity.AppiumInfo;
import com.kms.katalon.composer.mobile.execution.handler.IosInstallDependenciesHandler;
import com.kms.katalon.composer.mobile.util.MobileUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.identity.IosIdentityInfo;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IosInstallWebDriverAgent {
    private static final String WEB_DRIVER_AGENT_RUNNER_TARGET_NAME = "WebDriverAgentRunner";
    private static final String INSTALL_WEB_DRIVER_AGENT_LOG_NAME = "InstallWebDriverAgent";
    private static final int BUTTON_ID = 1;
    private static final String WEBDRIVERAGENT_PROJECT_RELATIVE_PATH = "/WebDriverAgent.xcodeproj";
    private static final String CODE_SIGN_STYLE_KEY = "CODE_SIGN_STYLE";
    private static final String DEVELOPMENT_TEAM_KEY = "DEVELOPMENT_TEAM";
    private static final String DEVELOPMENT_TEAM_SDK_KEY = "\"DEVELOPMENT_TEAM[sdk=iphoneos*]\"";
    private static final String RPOVISIONING_PROFILE_SPECIFIER_KEY = "RPOVISIONING_PROFILE_SPECIFIER";
    private static final String RPOVISIONING_PROFILE_SPECIFIER_SDK_KEY = "\"PROVISIONING_PROFILE_SPECIFIER[sdk=iphoneos*]\"";
    private static final String EMPTY_VALUE = "\"\"";
    private AppiumInfo appiumInfo;
    private String realDeviceId;
    private String provisioningProfile;

    @CanExecute
    public boolean canExecute() {
        return SystemUtils.IS_OS_MAC;
    }

    @Execute
    public void execute(Shell shell) {
        this.installWebDriverAgent(shell);
    }

    private boolean isAppiumVersionCompatibleWithXCodeVersion(Shell shell) {
        boolean isCompatible = true;
        try {
            int xcodeVersion = AppiumDriverManager.getXCodeVersion();
            boolean bl = isCompatible = xcodeVersion >= 14 && this.isSupportedXcuitestVersion();
            if (!isCompatible) {
                String errorMsg = MessageFormat.format(ComposerMobileMessageConstants.MSG_APPIUM_V1_DOES_NOT_COMPATIBLE_WITH_XCUITEST, this.appiumInfo.getVersion(), xcodeVersion);
                MessageDialogWithLink.openWarning((Shell)shell, (String)GlobalMessageConstants.WARN, (String)errorMsg);
            }
        }
        catch (ExecutionException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((String)StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT_FAILED, (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
        return isCompatible;
    }

    private boolean isSupportedXcuitestVersion() {
        String xcuitestVer = MobileUtil.getXcuitestVersion(this.appiumInfo.getAppiumHomeDir());
        return ModuleDescriptor.Version.parse(xcuitestVer).compareTo(ModuleDescriptor.Version.parse("4.32.24")) != -1;
    }

    private boolean setupXCodeProjectFile(final String teamId, final Shell shell) throws InvocationTargetException, InterruptedException {
        if (this.appiumInfo.getVersion().startsWith("1") && !this.isAppiumVersionCompatibleWithXCodeVersion(shell)) {
            return false;
        }
        final boolean[] prepareSucceeded = new boolean[]{true};
        new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Preparing...", 5);
                monitor.worked(1);
                try {
                    String projectFileLocation = String.valueOf(IosInstallWebDriverAgent.this.appiumInfo.getWebDriverAgentFolder()) + IosInstallWebDriverAgent.WEBDRIVERAGENT_PROJECT_RELATIVE_PATH + "/project.pbxproj";
                    String configBuildStr = "Build configuration list for PBXNativeTarget \"WebDriverAgentRunner\"";
                    XCodeProject project = new XCodeProject(projectFileLocation);
                    monitor.worked(2);
                    List list = project.configurationLists;
                    XCConfigurationList config = null;
                    for (XCConfigurationList xconfig : list) {
                        if (!xconfig.getReference().getComment().equals(configBuildStr)) continue;
                        config = xconfig;
                    }
                    monitor.worked(3);
                    List identiferList = config.getBuildConfigurations();
                    for (XCBuildConfiguration xBuildConfig : project.buildConfigurations) {
                        if (!xBuildConfig.getReference().equals(identiferList.get(0)) && !xBuildConfig.getReference().equals(identiferList.get(1))) continue;
                        xBuildConfig.setBuildSetting(IosInstallWebDriverAgent.CODE_SIGN_STYLE_KEY, "Manual");
                        xBuildConfig.setBuildSetting(IosInstallWebDriverAgent.DEVELOPMENT_TEAM_KEY, IosInstallWebDriverAgent.EMPTY_VALUE);
                        xBuildConfig.setBuildSetting(IosInstallWebDriverAgent.DEVELOPMENT_TEAM_SDK_KEY, teamId);
                        xBuildConfig.setBuildSetting(IosInstallWebDriverAgent.RPOVISIONING_PROFILE_SPECIFIER_KEY, IosInstallWebDriverAgent.EMPTY_VALUE);
                        xBuildConfig.setBuildSetting(IosInstallWebDriverAgent.RPOVISIONING_PROFILE_SPECIFIER_SDK_KEY, String.format("\"%s\"", IosInstallWebDriverAgent.this.provisioningProfile));
                    }
                    monitor.worked(4);
                    FileUtils.write((File)new File(projectFileLocation), (CharSequence)project.toString());
                    monitor.worked(5);
                }
                catch (InvalidObjectFormatException | IOException e) {
                    prepareSucceeded[0] = false;
                    LoggerSingleton.logError((Throwable)e);
                    if (e.getCause() != null) {
                        if (StringUtils.startsWith((String)e.getCause().toString(), (String)"java.nio.file.AccessDeniedException")) {
                            Display.getDefault().syncExec(new Runnable((Exception)e, shell){
                                private final /* synthetic */ Exception val$e;
                                private final /* synthetic */ Shell val$shell;
                                {
                                    this.val$e = exception;
                                    this.val$shell = shell;
                                }

                                @Override
                                public void run() {
                                    MultiStatusErrorDialog.showErrorDialog((String)StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT_FAILED, (String)ComposerMobileMessageConstants.MSG_CANNOT_MODIFY_WEBDRIVERAGENT_PBXPROJ_FILE, (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)this.val$e), (Shell)this.val$shell);
                                }
                            });
                        } else if (StringUtils.startsWith((String)e.getCause().toString(), (String)"java.nio.file.NoSuchFileException")) {
                            Display.getDefault().syncExec(new Runnable((Exception)e, shell){
                                private final /* synthetic */ Exception val$e;
                                private final /* synthetic */ Shell val$shell;
                                {
                                    this.val$e = exception;
                                    this.val$shell = shell;
                                }

                                @Override
                                public void run() {
                                    MultiStatusErrorDialog.showErrorDialog((String)StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT_FAILED, (String)ComposerMobileMessageConstants.MSG_CANNOT_FIND_WEBDRIVERAGENT_PBXPROJ_FILE, (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)this.val$e), (Shell)this.val$shell);
                                }
                            });
                        }
                    }
                    Display.getDefault().syncExec(new Runnable((Exception)e, shell){
                        private final /* synthetic */ Exception val$e;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.val$e = exception;
                            this.val$shell = shell;
                        }

                        @Override
                        public void run() {
                            MultiStatusErrorDialog.showErrorDialog((String)StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT_FAILED, (String)this.val$e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)this.val$e), (Shell)this.val$shell);
                        }
                    });
                }
            }
        });
        return prepareSucceeded[0];
    }

    private void installWebDriverAgent(Shell shell) {
        InstallationManager installationManager;
        IosDependenciesTrackingObj trackingObj;
        block16: {
            IosProvisioningProfileAndIdentitySelectionDialog dialog;
            block15: {
                block14: {
                    block13: {
                        trackingObj = new IosDependenciesTrackingObj();
                        installationManager = this.setupInstallationManager(shell);
                        if (this.verifyXCodeInstalled(shell)) break block13;
                        trackingObj.setCurrentStep(installationManager.getCurrentStep().getTitle());
                        if (installationManager.hasError()) {
                            trackingObj.setResult(false);
                        }
                        Executors.newFixedThreadPool(1).submit(() -> Trackings.trackInstallWebdriverAgent((boolean)trackingObj.getResult(), (String)trackingObj.getCurrentStep()));
                        return;
                    }
                    if (this.verifyAppiumInstalled(shell)) break block14;
                    trackingObj.setCurrentStep(installationManager.getCurrentStep().getTitle());
                    if (installationManager.hasError()) {
                        trackingObj.setResult(false);
                    }
                    Executors.newFixedThreadPool(1).submit(() -> Trackings.trackInstallWebdriverAgent((boolean)trackingObj.getResult(), (String)trackingObj.getCurrentStep()));
                    return;
                }
                dialog = this.setUpRealDevice(shell);
                if (dialog != null) break block15;
                trackingObj.setCurrentStep(installationManager.getCurrentStep().getTitle());
                if (installationManager.hasError()) {
                    trackingObj.setResult(false);
                }
                Executors.newFixedThreadPool(1).submit(() -> Trackings.trackInstallWebdriverAgent((boolean)trackingObj.getResult(), (String)trackingObj.getCurrentStep()));
                return;
            }
            try {
                try {
                    IosIdentityInfo identity = dialog.getIdentity();
                    this.provisioningProfile = dialog.getProvisioningProfileName();
                    this.appiumInfo = MobileUtil.getAppiumInfoToInstallWebDriverAgent();
                    boolean prepareSucceeded = this.setupXCodeProjectFile(identity.teamId(), shell);
                    if (!prepareSucceeded) break block16;
                    this.appendStep(installationManager, StringConstants.MSG_IOS_BUILD_WEB_DRIVER_AGENT_RUNNER, this.generateBuildCommand(WEB_DRIVER_AGENT_RUNNER_TARGET_NAME));
                    installationManager.startInstallation();
                }
                catch (Exception error) {
                    LoggerSingleton.logError((Throwable)error);
                    MultiStatusErrorDialog.showErrorDialog((String)StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT_FAILED, (String)error.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)error));
                    trackingObj.setResult(false);
                    trackingObj.setCurrentStep(installationManager.getCurrentStep().getTitle());
                    if (installationManager.hasError()) {
                        trackingObj.setResult(false);
                    }
                    Executors.newFixedThreadPool(1).submit(() -> Trackings.trackInstallWebdriverAgent((boolean)trackingObj.getResult(), (String)trackingObj.getCurrentStep()));
                }
            }
            catch (Throwable throwable) {
                trackingObj.setCurrentStep(installationManager.getCurrentStep().getTitle());
                if (installationManager.hasError()) {
                    trackingObj.setResult(false);
                }
                Executors.newFixedThreadPool(1).submit(() -> Trackings.trackInstallWebdriverAgent((boolean)trackingObj.getResult(), (String)trackingObj.getCurrentStep()));
                throw throwable;
            }
        }
        trackingObj.setCurrentStep(installationManager.getCurrentStep().getTitle());
        if (installationManager.hasError()) {
            trackingObj.setResult(false);
        }
        Executors.newFixedThreadPool(1).submit(() -> Trackings.trackInstallWebdriverAgent((boolean)trackingObj.getResult(), (String)trackingObj.getCurrentStep()));
    }

    private InstallationManager setupInstallationManager(Shell shell) {
        InstallationManager installationManager = new InstallationManager(shell, StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT, ComposerComponentsMessageConstants.WEBDRIVERAGENT_TROUBLESHOOT_LINK);
        installationManager.getInstallationDialog().setDialogTitle(StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT_TITLE);
        installationManager.getInstallationDialog().setSuccessfulMessage(StringConstants.MSG_IOS_INSTALL_WEB_DRIVER_AGENT_SUCCESSFULLY);
        return installationManager;
    }

    private void appendStep(InstallationManager installationManager, String title, String command) throws IOException, InterruptedException {
        File installationLog = this.getLogFile(INSTALL_WEB_DRIVER_AGENT_LOG_NAME);
        File installationErrorLog = this.getLogFile("InstallWebDriverAgentError");
        InstallationCommandStep installationStep = new InstallationCommandStep(title, installationLog, installationErrorLog, command, this.appiumInfo.getWebDriverAgentFolder());
        installationManager.appendStep((InstallationStep)installationStep);
    }

    private String generateBuildCommand(String target) {
        String projectLocation = String.valueOf(this.appiumInfo.getWebDriverAgentFolder()) + WEBDRIVERAGENT_PROJECT_RELATIVE_PATH;
        String buildCmd = "xcodebuild build-for-testing -project %s -scheme WebDriverAgentRunner -destination \"platform=iOS,id=%s\"";
        return String.format(buildCmd, projectLocation, this.realDeviceId);
    }

    private File getLogFile(String name) {
        try {
            return File.createTempFile(name, ".log");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean verifyXCodeInstalled(Shell shell) throws IOException, InterruptedException {
        if (!MobileUtil.isXcodeInstalled()) {
            this.guideToInstallXcode(shell);
            return false;
        }
        return true;
    }

    private void guideToInstallXcode(Shell shell) {
        InstallationInstructionDialog dialog = new InstallationInstructionDialog(shell, ComposerMobileMessageConstants.DIA_TITLE_INSTALLATION_INSTRUCTIONS, null, ComposerMobileMessageConstants.MSG_MISSING_XCODE_WEBDRIVERAGENT_INSTRUCTION, 4, new String[]{GlobalStringConstants.DIA_TROUBLESHOOT, GlobalStringConstants.DIA_OK}, 1, ComposerComponentsMessageConstants.WEBDRIVERAGENT_TROUBLESHOOT_LINK);
        dialog.open();
    }

    private boolean verifyAppiumInstalled(Shell shell) {
        String appiumString = MobileExecutionUtil.findAppiumDir();
        if (StringUtils.isBlank((String)appiumString)) {
            this.guideToInstallDependencies(shell);
            return false;
        }
        return true;
    }

    private void guideToInstallDependencies(Shell shell) {
        InstallationInstructionDialog dialog = new InstallationInstructionDialog(shell, ComposerMobileMessageConstants.DIA_TITLE_INSTALLATION_INSTRUCTIONS, null, ComposerMobileMessageConstants.MSG_MISSING_DEPENDENCIES_WEBDRIVERAGENT_INSTRUCTION, 4, new String[]{GlobalStringConstants.DIA_TROUBLESHOOT, ComposerMobileMessageConstants.MSG_IOS_INSTALL_DEPENDENCIES_TITLE}, 1, ComposerComponentsMessageConstants.WEBDRIVERAGENT_TROUBLESHOOT_LINK);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            new IosInstallDependenciesHandler().execute(shell);
        }
    }

    private IosProvisioningProfileAndIdentitySelectionDialog setUpRealDevice(Shell shell) {
        IosProvisioningProfileAndIdentitySelectionDialog dialog = null;
        boolean goBack = true;
        do {
            block6: {
                MobileDeviceInfo mobileDeviceInfo;
                if ((mobileDeviceInfo = this.selectRealDevice(shell)) == null) {
                    return null;
                }
                this.realDeviceId = mobileDeviceInfo.getDeviceId();
                dialog = this.getProvisioningProfileAndIdentityDialog(shell, this.realDeviceId);
                if (dialog != null) break block6;
                return null;
            }
            try {
                if (dialog.open() == 14) continue;
                if (dialog.getReturnCode() == 1) {
                    dialog = null;
                }
                goBack = false;
            }
            catch (IOException | InterruptedException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } while (goBack);
        return dialog;
    }

    private MobileDeviceInfo selectRealDevice(Shell shell) {
        IosDeviceSelectionDialog dialog = new IosDeviceSelectionDialog(shell, ComposerMobileMessageConstants.MSG_IOS_DEVICE_SELECTION_DIALOG_LABEL, true);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        return dialog.getDevice();
    }

    private IosProvisioningProfileAndIdentitySelectionDialog getProvisioningProfileAndIdentityDialog(Shell shell, String deviceId) throws IOException, InterruptedException {
        IosProvisioningProfileAndIdentitySelectionDialog identitySelectionDialog = new IosProvisioningProfileAndIdentitySelectionDialog(shell, deviceId);
        return identitySelectionDialog;
    }

    private class IosDependenciesTrackingObj {
        private boolean result = true;
        private String currentStep;

        private IosDependenciesTrackingObj() {
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public void setCurrentStep(String currentStep) {
            this.currentStep = currentStep;
        }

        public String getCurrentStep() {
            return this.currentStep;
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

