/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.handler;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.mobile.constants.ImageConstants;
import com.kms.katalon.composer.mobile.part.MobileTestObjectPart;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenMobileTestObjectHandler {
    private static final String MOBILE_TEST_OBJECT_PART_URI = "bundleclass://com.kms.katalon.composer.mobile/" + MobileTestObjectPart.class.getName();
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;
    private static OpenMobileTestObjectHandler instance;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        instance = this;
        eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object.getClass() == MobileElementEntity.class) {
                    OpenMobileTestObjectHandler.this.execute((MobileElementEntity)object);
                }
            }
        });
    }

    @Inject
    @Optional
    private void getNotifications(@UIEventTopic(value="MOBILE_TESTOBJECT/OPEN") WebElementEntity entity) {
        if (entity instanceof MobileElementEntity) {
            this.execute((MobileElementEntity)entity);
        }
    }

    public void execute(MobileElementEntity testObject) {
        if (testObject != null) {
            String partId = EntityPartUtil.getMobileTestObjectPartId((String)testObject.getId());
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
            boolean alreadyOpened = true;
            if (mPart == null) {
                mPart = (MPart)this.modelService.createModelElement(MPart.class);
                mPart.setElementId(partId);
                mPart.setLabel(testObject.getName());
                mPart.setContributionURI(MOBILE_TEST_OBJECT_PART_URI);
                mPart.setCloseable(true);
                mPart.setIconURI(ImageConstants.IMG_URL_16_MOBILE);
                mPart.setTooltip(testObject.getIdForDisplay());
                mPart.getTags().add("removeOnHide");
                stack.getChildren().add(mPart);
                alreadyOpened = false;
            }
            if (mPart.getObject() == null) {
                mPart.setObject((Object)testObject);
            }
            this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
            this.partService.bringToTop(mPart);
            stack.setSelectedElement((MUIElement)mPart);
            if (!alreadyOpened) {
                Trackings.trackOpenObject((String)"mobileTestObject");
            }
        }
    }

    public static OpenMobileTestObjectHandler getInstance() {
        return instance;
    }
}

