/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.part;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.handler.ObjectPropertyHandler;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPart;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.dialog.EditMobileElementPropertyDialog;
import com.kms.katalon.composer.mobile.dialog.NewMobileElementPropertyDialog;
import com.kms.katalon.composer.mobile.part.MobileTestObjectPropertiesTable;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MobileTestObjectPart
implements IComposerPart {
    private MobileElementEntity entity;
    private StyledText txtLocator;
    private MobileTestObjectPropertiesTable tableViewerObjectProperties;
    private Combo cbbLocatorStrategy;
    private MPart mpart;
    private Composite mainComposite;
    private static String[] strategies = MobileElementEntity.LocatorStrategy.getStrategies();
    private List<WebElementPropertyEntity> properties;
    private MobileElementEntity editingEntity;
    @Inject
    IEventBroker eventBroker;
    private EventServiceAdapter eventHandler = new EventServiceAdapter(){

        public void handleEvent(Event event) {
            Object[] objects = this.getObjects(event);
            if (objects == null || objects.length != 2) {
                return;
            }
            try {
                String oldWindowsObjectId = (String)objects[0];
                String newWindowsObjectId = (String)objects[1];
                if (MobileTestObjectPart.this.editingEntity.getIdForDisplay().equals(oldWindowsObjectId)) {
                    MobileTestObjectPart.this.entity = (MobileElementEntity)ObjectRepositoryController.getInstance().getWebElementByDisplayPk(newWindowsObjectId);
                    MobileTestObjectPart.this.editingEntity = (MobileElementEntity)MobileTestObjectPart.this.entity.clone();
                    MobileTestObjectPart.this.editingEntity.setName(MobileTestObjectPart.this.entity.getName());
                    MobileTestObjectPart.this.mpart.setLabel(MobileTestObjectPart.this.editingEntity.getName());
                }
            }
            catch (ControllerException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    };

    @PostConstruct
    public void onCreatePart(MPart mpart, Composite parent) {
        this.mpart = mpart;
        this.entity = (MobileElementEntity)mpart.getObject();
        this.createControls(parent);
        this.setInput();
        this.addListeners();
    }

    @PreDestroy
    public void onDestroyPart() {
        this.eventBroker.unsubscribe((EventHandler)this.eventHandler);
    }

    private void addListeners() {
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this.eventHandler);
        this.eventBroker.subscribe("EXPLORER/CUT_PASTED_SELECTED_ITEM", (EventHandler)this.eventHandler);
        this.txtLocator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        this.cbbLocatorStrategy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MobileElementEntity.LocatorStrategy value = MobileElementEntity.LocatorStrategy.valueOfStrategy((String)MobileTestObjectPart.this.cbbLocatorStrategy.getText());
                MobileTestObjectPart.this.updateUIByLocatorStrategy(value);
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
    }

    private void setInput() {
        this.editingEntity = (MobileElementEntity)this.entity.clone();
        this.mpart.setLabel(this.editingEntity.getName());
        MobileElementEntity.LocatorStrategy selectedLocator = this.editingEntity.getLocatorStrategy();
        int selectedIndex = Arrays.asList(strategies).indexOf(selectedLocator.getLocatorStrategy());
        this.cbbLocatorStrategy.select(selectedIndex);
        this.updateUIByLocatorStrategy(selectedLocator);
        this.txtLocator.setText(StringUtils.defaultString((String)this.editingEntity.getLocator()));
        this.properties = new ArrayList<WebElementPropertyEntity>(this.editingEntity.getWebElementProperties());
        this.tableViewerObjectProperties.setInput(this.properties);
    }

    private Shell getShell() {
        return this.mainComposite.getShell();
    }

    private void createControls(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setBackground(ColorUtil.getPartBackgroundColor());
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        Composite locatorComposite = new Composite(this.mainComposite, 0);
        locatorComposite.setLayout((Layout)new GridLayout(1, false));
        locatorComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblLocatorTitle = new Label(locatorComposite, 0);
        lblLocatorTitle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblLocatorTitle.setText("Locator");
        ControlUtils.setFontToBeBold((Control)lblLocatorTitle);
        Composite locatorDetailsComposite = new Composite(locatorComposite, 0);
        locatorDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glLocatorDetails = new GridLayout(2, false);
        glLocatorDetails.marginWidth = 0;
        glLocatorDetails.marginHeight = 0;
        locatorDetailsComposite.setLayout((Layout)glLocatorDetails);
        Label lblLocatorStrategy = new Label(locatorDetailsComposite, 0);
        lblLocatorStrategy.setText("Locator Strategy");
        lblLocatorStrategy.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.cbbLocatorStrategy = new Combo(locatorDetailsComposite, 8);
        this.cbbLocatorStrategy.setItems(strategies);
        Label lblLocator = new Label(locatorDetailsComposite, 0);
        lblLocator.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblLocator.setText("Locator");
        this.txtLocator = new StyledText(locatorDetailsComposite, 2624);
        GridData gdTxtEditor = new GridData(4, 4, true, false);
        gdTxtEditor.heightHint = 100;
        this.txtLocator.setLayoutData((Object)gdTxtEditor);
        Composite tableComposite = new Composite(this.mainComposite, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        GridLayout glTableComposite = new GridLayout();
        glTableComposite.marginTop = 15;
        tableComposite.setLayout((Layout)glTableComposite);
        Label lblObjectPropertiesTitle = new Label(tableComposite, 0);
        lblObjectPropertiesTitle.setText("Object Properties");
        ControlUtils.setFontToBeBold((Control)lblObjectPropertiesTitle);
        ToolBar tbProperties = new ToolBar(tableComposite, 0x820000);
        tbProperties.setForeground(ColorUtil.getToolBarForegroundColor());
        tbProperties.setLayoutData((Object)new GridData(4, 128, true, false));
        ToolItem tltmAdd = new ToolItem(tbProperties, 8);
        tltmAdd.setText("Add");
        tltmAdd.setImage(ImageManager.getImage((String)"add_16.png"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMobileElementPropertyDialog windowsElementDialog = new NewMobileElementPropertyDialog(MobileTestObjectPart.this.getShell());
                if (windowsElementDialog.open() == 0) {
                    MobileTestObjectPart.this.properties.add(windowsElementDialog.getNewProperty());
                    MobileTestObjectPart.this.tableViewerObjectProperties.setInput(MobileTestObjectPart.this.properties);
                    MobileTestObjectPart.this.tableViewerObjectProperties.refresh();
                    if (OSUtil.isMacBigSurOrLater()) {
                        MobileTestObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                    }
                    MobileTestObjectPart.this.mpart.setDirty(true);
                }
            }
        });
        ToolItem tltmEdit = new ToolItem(tbProperties, 8);
        tltmEdit.setText("Edit");
        tltmEdit.setImage(ImageManager.getImage((String)"edit_16.png"));
        tltmEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = MobileTestObjectPart.this.tableViewerObjectProperties.getStructuredSelection();
                if (structuredSelection.isEmpty()) {
                    return;
                }
                WebElementPropertyEntity editingProperty = (WebElementPropertyEntity)structuredSelection.getFirstElement();
                EditMobileElementPropertyDialog windowsElementDialog = new EditMobileElementPropertyDialog(MobileTestObjectPart.this.getShell(), editingProperty);
                if (windowsElementDialog.open() == 0) {
                    MobileTestObjectPart.this.tableViewerObjectProperties.refresh(editingProperty);
                    MobileTestObjectPart.this.mpart.setDirty(true);
                }
            }
        });
        ToolItem tltmDelete = new ToolItem(tbProperties, 8);
        tltmDelete.setText("Delete");
        tltmDelete.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List objects = MobileTestObjectPart.this.tableViewerObjectProperties.getStructuredSelection().toList();
                if (objects == null || objects.isEmpty()) {
                    return;
                }
                MobileTestObjectPart.this.properties.removeAll(objects);
                MobileTestObjectPart.this.tableViewerObjectProperties.refresh(true);
                if (OSUtil.isMacBigSurOrLater()) {
                    MobileTestObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        ToolItem tltmClear = new ToolItem(tbProperties, 8);
        tltmClear.setText("Clear");
        tltmClear.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MobileTestObjectPart.this.properties.isEmpty()) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)MobileTestObjectPart.this.getShell(), (String)GlobalStringConstants.CONFIRMATION, (String)"Do you want to clear all these properties?")) {
                    return;
                }
                MobileTestObjectPart.this.properties.clear();
                MobileTestObjectPart.this.tableViewerObjectProperties.setInput(MobileTestObjectPart.this.properties);
                MobileTestObjectPart.this.tableViewerObjectProperties.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    MobileTestObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        this.tableViewerObjectProperties = new MobileTestObjectPropertiesTable(tableComposite);
        this.tableViewerObjectProperties.addListener(new MobileTestObjectPropertiesTable.TestObjectPropertiesTableListener(){

            @Override
            public void onSelectProperties() {
                MobileTestObjectPart.this.txtLocator.setText(MobileTestObjectPart.this.getLocatorValue());
            }
        });
    }

    private void updateUIByLocatorStrategy(MobileElementEntity.LocatorStrategy selectedStrategy) {
        switch (selectedStrategy) {
            case ATTRIBUTES: {
                this.txtLocator.setEditable(false);
                this.txtLocator.setBackground(Display.getCurrent().getSystemColor(15));
                break;
            }
            default: {
                this.txtLocator.setEditable(true);
                this.txtLocator.setBackground(Display.getCurrent().getSystemColor(1));
            }
        }
        this.tableViewerObjectProperties.updateUIByLocatorStrategy(selectedStrategy);
        this.txtLocator.getParent().layout();
    }

    private TestObject buildTestObject(List<WebElementPropertyEntity> properties) {
        TestObject testObject = new TestObject();
        properties.forEach(prop -> testObject.addProperty(prop.getName(), ConditionType.fromValue((String)prop.getMatchCondition()), prop.getValue(), prop.getIsSelected().booleanValue()));
        return testObject;
    }

    private String getLocatorValue() {
        TestObject testObject = this.buildTestObject(this.properties);
        String locatorValue = MobileCommonHelper.getAttributeLocatorValue((TestObject)testObject);
        return locatorValue;
    }

    @Persist
    public void onSave() {
        MobileElementEntity.LocatorStrategy selectedLocator = MobileElementEntity.LocatorStrategy.valueOfStrategy((String)this.cbbLocatorStrategy.getText());
        this.editingEntity.setLocatorStrategy(selectedLocator);
        this.editingEntity.setLocator(this.txtLocator.getText());
        this.editingEntity.setWebElementProperties(this.properties);
        try {
            ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)this.editingEntity);
            this.entity = this.editingEntity;
            this.editingEntity = (MobileElementEntity)this.editingEntity.clone();
            List list = (List)this.tableViewerObjectProperties.getInput();
            if (!ObjectPropertyHandler.verifyObjectProperties((Object)this.editingEntity, (List)list)) {
                return;
            }
            WebElementTreeEntity treeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)this.entity, (ProjectEntity)this.entity.getProject());
            ExplorerPart.getInstance().refreshTreeEntity((Object)treeEntity.getParent());
            this.mpart.setDirty(false);
            Trackings.trackEditObject((String)"testObject", (String)"MOBILE");
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Error", (String)"Unable to save mobile test object");
        }
    }

    public String getEntityId() {
        return this.entity.getIdForDisplay();
    }
}

