/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickassist.proposals;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.eclipse.quickassist.GroovyQuickAssistProposal2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToSingleLineStringProposal
extends GroovyQuickAssistProposal2 {
    private Expression string;

    @Override
    public String getDisplayString() {
        return "Convert to single-line string";
    }

    @Override
    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }

    @Override
    public int getRelevance() {
        String nodeText;
        ASTNode node;
        if (this.string == null && ((node = this.context.getCoveredNode()) instanceof GStringExpression || node instanceof ConstantExpression && ((ConstantExpression)node).getValue() instanceof String) && node.getEnd() > node.getStart() && this.isMultiLineString(nodeText = this.context.getNodeText(node))) {
            this.string = (Expression)node;
        }
        return this.string != null ? 10 : 0;
    }

    @Override
    protected TextChange getTextChange(IProgressMonitor monitor) {
        char[] contents = this.context.getCompilationUnit().getContents();
        int startQuote = this.string.getStart();
        int endQuote = this.string.getEnd() - 3;
        if (startQuote < 0 || startQuote + 3 >= contents.length || endQuote < 0 || endQuote + 3 > contents.length) {
            return null;
        }
        boolean isSingle = contents[startQuote] == '\'';
        String replaceQuote = String.valueOf(contents[startQuote]);
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild((TextEdit)new ReplaceEdit(startQuote, 3, replaceQuote));
        edit.addChild((TextEdit)new ReplaceEdit(endQuote, 3, replaceQuote));
        int i = startQuote + 3;
        while (i < endQuote - 3) {
            char toEscape = contents[i];
            String escaped = null;
            switch (toEscape) {
                case '\t': {
                    escaped = "\\t";
                    break;
                }
                case '\b': {
                    escaped = "\\b";
                    break;
                }
                case '\n': {
                    escaped = "\\n";
                    break;
                }
                case '\r': {
                    escaped = "\\r";
                    break;
                }
                case '\f': {
                    escaped = "\\f";
                    break;
                }
                case '\'': {
                    if (!isSingle) break;
                    escaped = "\\'";
                    break;
                }
                case '\"': {
                    if (isSingle) break;
                    escaped = "\\\"";
                    break;
                }
                case '\\': {
                    escaped = "\\\\";
                }
            }
            if (escaped != null) {
                edit.addChild((TextEdit)new ReplaceEdit(i, 1, escaped));
            }
            ++i;
        }
        return this.toTextChange((TextEdit)edit);
    }

    private boolean isMultiLineString(String nodeText) {
        return nodeText.startsWith("'''") && nodeText.endsWith("'''") || nodeText.startsWith("\"\"\"") && nodeText.endsWith("\"\"\"");
    }
}

