/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class GroovyQuickFixPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.codehaus.groovy.eclipse.quickfix";
    public static final String GROOVY_CONTEXT_TYPE = "groovy";
    private static GroovyQuickFixPlugin plugin;
    private TemplateStore templateStore;
    private ContextTypeRegistry contextTypeRegistry;

    public static GroovyQuickFixPlugin getDefault() {
        return plugin;
    }

    public static void logWarning(String message, Throwable exception) {
        GroovyQuickFixPlugin.log(GroovyQuickFixPlugin.createWarningStatus(message, exception));
    }

    public static void log(String message, Throwable exception) {
        IStatus status = GroovyQuickFixPlugin.createErrorStatus(message, exception);
        GroovyQuickFixPlugin.log(status);
    }

    public static void log(Throwable exception) {
        GroovyQuickFixPlugin.log(GroovyQuickFixPlugin.createErrorStatus("Internal Error", exception));
    }

    public static void log(IStatus status) {
        GroovyQuickFixPlugin.getDefault().getLog().log(status);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static IStatus createWarningStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(2, PLUGIN_ID, 0, message, exception);
    }

    public GroovyQuickFixPlugin() {
        plugin = this;
    }

    public void savePreferences() {
        try {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).flush();
        }
        catch (BackingStoreException e) {
            GroovyQuickFixPlugin.log(e);
        }
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), GROOVY_CONTEXT_TYPE);
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                GroovyQuickFixPlugin.log(e);
            }
        }
        return this.templateStore;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.contextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType(GROOVY_CONTEXT_TYPE);
            this.contextTypeRegistry = registry;
        }
        return this.contextTypeRegistry;
    }

    public static boolean isGroovyProject(ICompilationUnit unit) {
        return Optional.ofNullable(unit).map(IJavaElement::getResource).map(IResource::getProject).filter(project -> project.isAccessible() && GroovyNature.hasGroovyNature((IProject)project)).isPresent();
    }

    public static boolean isGroovyProject(IInvocationContext context) {
        return Optional.ofNullable(context).map(IInvocationContext::getCompilationUnit).filter(GroovyQuickFixPlugin::isGroovyProject).isPresent();
    }

    public static IProblemLocation[] getJavaProblems(IProblemLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return locations;
        }
        return (IProblemLocation[])Arrays.stream(locations).filter(location -> location.getMarkerType() == "org.eclipse.jdt.core.problem").toArray(IProblemLocation[]::new);
    }
}

