/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.quickfix.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.eclipse.quickfix.GroovyQuickFixPlugin;
import org.codehaus.groovy.eclipse.quickfix.templates.GroovyContext;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;

public class TemplateProposalComputer
implements IJavaCompletionProposalComputer {
    private static final int EMPTY_PREFIX_TEMPLATE_RELEVANCE = 20;

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    public String getErrorMessage() {
        return null;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        try {
            JavaContentAssistInvocationContext javaContext;
            if (context instanceof JavaContentAssistInvocationContext && (javaContext = (JavaContentAssistInvocationContext)context).getCompilationUnit() instanceof GroovyCompilationUnit) {
                TemplateContextType contextType = GroovyQuickFixPlugin.getDefault().getTemplateContextRegistry().getContextType("groovy");
                GroovyContext templateContext = new GroovyContext(contextType, context.getDocument(), context.getInvocationOffset(), 0, javaContext.getCompilationUnit());
                templateContext.setForceEvaluation(true);
                templateContext.setVariable("selection", "");
                String templatePrefix = context.computeIdentifierPrefix().toString();
                int offset = context.getInvocationOffset() - templatePrefix.length();
                while (--offset >= 0) {
                    if (!Character.isWhitespace(context.getDocument().getChar(offset))) break;
                }
                if (offset > 0 && (context.getDocument().getChar(offset) == '@' || context.getDocument().getChar(offset) == '&')) {
                    --offset;
                }
                if (offset == -1 || context.getDocument().getChar(offset) != '.') {
                    return this.computeCompletionProposals(templateContext, templatePrefix);
                }
            }
        }
        catch (BadLocationException e) {
            GroovyQuickFixPlugin.log(e);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(GroovyContext context, String prefix) throws BadLocationException {
        ArrayList<ICompletionProposal> templates = new ArrayList<ICompletionProposal>();
        Region region = new Region(context.getCompletionOffset(), context.getCompletionLength());
        Template[] templateArray = GroovyQuickFixPlugin.getDefault().getTemplateStore().getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (template.getName().startsWith(prefix)) {
                TemplateProposal templateProposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null);
                if (prefix.length() == 0) {
                    templateProposal.setRelevance(20);
                }
                templates.add((ICompletionProposal)templateProposal);
            }
            ++n2;
        }
        return templates;
    }
}

