/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.dialog;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.dialog.NewProjectDialog;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.handler.AnalyticsAuthorizationHandler;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KatalonTestOpsIntegrationDialog
extends AbstractDialog {
    public static final int REFRESH_ID = 4;
    public static final int GO_TO_PROJECT_ID = 3;
    public static final int OK_ID = 2;
    public static final int NAME_LENGTH_LIMIT = 53;
    private Composite container;
    private Button btnOk;
    private Button btnGoToProject;
    private Button btnRefresh;
    private Button btnNewProject;
    private Text txtOrganization;
    private Combo cbbProjects;
    private Link lnkStatus;
    private List<AnalyticsOrganization> organizations = new ArrayList<AnalyticsOrganization>();
    private List<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
    private List<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
    private AnalyticsSettingStore analyticsSettingStore;
    private AnalyticsOrganization organization;
    private Combo cbbTeams;
    private String token;
    private GridData gdStatus;
    private Composite subContainer;
    private boolean isOnPremUser = TestOpsService.getInstance().isOnPremUser();

    public KatalonTestOpsIntegrationDialog(Shell parentShell) {
        super(parentShell);
        this.analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        try {
            this.organization = this.analyticsSettingStore.getOrganization();
            this.token = AnalyticsAuthorizationHandler.getTokenNew((TestOpsService)TestOpsService.getActiveInstance(), (AnalyticsSettingStore)this.analyticsSettingStore);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerIntegrationAnalyticsMessageConstants.TITLE_DLG_QUICK_ANALYTICS_INTEGRATION);
    }

    public boolean checkConnection() {
        return StringUtils.isNotBlank((CharSequence)this.token);
    }

    public boolean close() {
        this.updateDataStore(false);
        return super.close();
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout();
        glContainer.verticalSpacing = 5;
        this.container.setLayout((Layout)glContainer);
        Label lblNote = new Label(this.container, 0);
        lblNote.setImage(ImageManager.getImage((String)"katalon_platform/modern_quality_management.png"));
        Composite recommendComposite = new Composite(this.container, 0);
        recommendComposite.setLayout((Layout)new GridLayout(2, false));
        recommendComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Group grpSelect = new Group(this.container, 0);
        grpSelect.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glGrpSelect = new GridLayout(4, false);
        grpSelect.setLayout((Layout)glGrpSelect);
        grpSelect.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_SELECT_GROUP);
        Label lblOrganization = new Label((Composite)grpSelect, 0);
        lblOrganization.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ORGANIZATION);
        this.txtOrganization = new Text((Composite)grpSelect, 8);
        this.txtOrganization.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.createTeamComposite(grpSelect);
        Label lblProject = new Label((Composite)grpSelect, 0);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        this.cbbProjects = new Combo((Composite)grpSelect, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnNewProject = new Button((Composite)grpSelect, 0);
        this.btnNewProject.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnNewProject.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_NEW_PROJECT);
        this.subContainer = new Composite(this.container, 0);
        this.subContainer.setLayout((Layout)new GridLayout());
        this.subContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lnkStatus = new Link(this.subContainer, 64);
        this.gdStatus = new GridData(4, 4, true, false, 1, 1);
        this.gdStatus.heightHint = 0;
        this.lnkStatus.setLayoutData((Object)this.gdStatus);
        this.createPlatformInstructionContent();
        this.initialize();
        return this.container;
    }

    private void createTeamComposite(Group grpSelect) {
        if (this.isOnPremUser) {
            Label lblTeam = new Label((Composite)grpSelect, 0);
            lblTeam.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEAM);
            this.cbbTeams = new Combo((Composite)grpSelect, 8);
            this.cbbTeams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        }
    }

    private void initialize() {
        if (StringUtils.isNotBlank((CharSequence)this.token)) {
            this.fillData();
        }
    }

    private void createPlatformInstructionContent() {
        Composite platformInstructionComposite = new Composite(this.subContainer, 0);
        platformInstructionComposite.setLayout((Layout)new GridLayout(1, false));
        platformInstructionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        new Label(platformInstructionComposite, 0).setText(ComposerIntegrationAnalyticsMessageConstants.INSTRUCTION_CAN_EXPLORE_PLATFORM_CAPABILITIES);
        Label fistIdea = new Label(platformInstructionComposite, 64);
        fistIdea.setText(ComposerIntegrationAnalyticsMessageConstants.INSTRUCTION_START_TEST_SUITE_EXECUTION);
        Label secondLabel = new Label(platformInstructionComposite, 64);
        secondLabel.setText(ComposerIntegrationAnalyticsMessageConstants.INSTRUCTION_START_EXECUTING_WITH_TC);
        Composite exploreComposite = new Composite(platformInstructionComposite, 0);
        exploreComposite.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        GridLayout glExplore = new GridLayout(2, false);
        glExplore.marginWidth = 0;
        glExplore.horizontalSpacing = 0;
        glExplore.marginHeight = 0;
        exploreComposite.setLayout((Layout)glExplore);
        CLabel book = new CLabel(exploreComposite, 0);
        book.setImage(this.getBookImage());
        book.setMargins(0, 0, 5, 0);
        StyledText text = new StyledText(exploreComposite, 8);
        text.setEditable(false);
        text.setCaret(null);
        text.setCursor(this.getShell().getDisplay().getSystemCursor(21));
        text.setText(ComposerIntegrationAnalyticsMessageConstants.EXPLORE_FULL_CAPABILITES_OF_PLATFORM);
        text.setBackground(book.getBackground());
        StyleRange style1 = new StyleRange();
        style1.start = 0;
        style1.length = text.getText().length();
        style1.underline = true;
        text.setStyleRange(style1);
        text.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)ComposerIntegrationAnalyticsMessageConstants.EXPLORE_PLATFORM_DOC_LINK);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyledText text = (StyledText)e.widget;
                text.setSelection(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StyledText text = (StyledText)e.widget;
                text.setSelection(0);
            }
        });
    }

    private Image getBookImage() {
        if (ComponentBundleActivator.isDarkTheme((Display)this.getShell().getDisplay())) {
            return ImageManager.getImage((String)"book_dark.png");
        }
        return ImageManager.getImage((String)"book.png");
    }

    private void fillData() {
        this.teams.clear();
        this.projects.clear();
        this.organizations.clear();
        this.txtOrganization.setText(StringUtils.abbreviate((String)this.organization.getName(), (int)53));
        this.txtOrganization.setEnabled(false);
        this.enableObject(false);
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false));
            UISynchronizeService.syncExec(() -> {
                this.getTeam(this.organization.getId());
                boolean isNotEmptyProjects = false;
                if (this.isOnPremUser) {
                    if (this.teams != null && this.teams.size() > 0) {
                        this.fetchOnPremProjects();
                        isNotEmptyProjects = true;
                    } else {
                        this.throwEmptyProjectsOnTheOnPremTeam();
                    }
                } else {
                    this.fetchOnCloudProjects();
                    if (!this.projects.isEmpty()) {
                        isNotEmptyProjects = true;
                    } else {
                        this.throwEmptyProjectsOnTheOnCloudOrg();
                    }
                }
                if (isNotEmptyProjects) {
                    if (this.isOnPremUser) {
                        this.cbbTeams.setItems(AnalyticsAuthorizationHandler.getTeamNames(this.teams).toArray(new String[this.teams.size()]));
                    }
                    int indexSelectTeam = AnalyticsAuthorizationHandler.getDefaultTeamIndex((AnalyticsSettingStore)this.analyticsSettingStore, this.teams);
                    if (this.isOnPremUser) {
                        this.cbbTeams.select(indexSelectTeam);
                    }
                    this.enableObject(true);
                    this.setProjectsBasedOnTeam(this.projects);
                }
            });
        });
    }

    private void throwEmptyProjectsOnTheOnPremTeam() {
        this.enableObject(false);
        String message = MessageFormat.format(this.getErrorStringPatternWhenReturnEmptyProjects(), ApplicationInfo.getTestOpsServer(), Long.toString(this.organization.getId()));
        this.setProgressMessage(message, true);
    }

    private void throwEmptyProjectsOnTheOnCloudOrg() {
        this.enableObject(false);
        String message = MessageFormat.format(this.getErrorStringPatternWhenReturnEmptyProjects(), Long.toString(this.organization.getId()));
        this.setProgressMessage(message, true);
    }

    private String getErrorStringPatternWhenReturnEmptyProjects() {
        if (this.isOnPremUser) {
            return ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_TEAM;
        }
        return ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_PROJECTS_ON_CLOUD_ORG;
    }

    private void enableObject(boolean isEnable) {
        if (this.isOnPremUser) {
            this.cbbTeams.setEnabled(isEnable);
        }
        this.cbbProjects.setEnabled(isEnable);
        if (this.btnOk != null) {
            this.btnOk.setEnabled(isEnable);
        }
    }

    private void getTeam(Long orgId) {
        try {
            this.teams = AnalyticsAuthorizationHandler.getTeams((TestOpsService)TestOpsService.getActiveInstance(), (Long)orgId);
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void fetchOnPremProjects() {
        try {
            this.projects = AnalyticsAuthorizationHandler.getOnPremProjects((TestOpsService)TestOpsService.getActiveInstance(), (AnalyticsTeam)this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex((AnalyticsSettingStore)this.analyticsSettingStore, this.teams)));
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void fetchOnCloudProjects() {
        try {
            this.projects = AnalyticsAuthorizationHandler.getOnCloudProjects((TestOpsService)TestOpsService.getActiveInstance(), (AnalyticsOrganization)this.organization);
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void repackSubContainer(int heightHint) {
        this.gdStatus.heightHint = heightHint;
        this.lnkStatus.setLayoutData((Object)this.gdStatus);
        this.subContainer.layout(true);
    }

    private void setProgressMessage(String message, boolean isError) {
        this.repackSubContainer(message.length() == 0 ? 0 : 30);
        this.lnkStatus.setText(message);
        if (isError) {
            this.lnkStatus.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lnkStatus.setForeground(ColorUtil.getTextRunningColor());
        }
    }

    private void setProjectsBasedOnTeam(List<AnalyticsProject> projects) {
        if (projects != null && !projects.isEmpty()) {
            this.cbbProjects.setEnabled(true);
            this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(projects).toArray(new String[projects.size()]));
            this.cbbProjects.select(AnalyticsAuthorizationHandler.getDefaultProjectIndex((AnalyticsSettingStore)this.analyticsSettingStore, projects));
            this.setProgressMessage("", false);
        } else {
            this.cbbProjects.clearSelection();
            this.cbbProjects.removeAll();
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_PROJECT, true);
        }
        String role = this.organization.getRole();
        if (role.equals("USER")) {
            this.btnNewProject.setEnabled(false);
        } else {
            this.btnNewProject.setEnabled(true);
        }
    }

    private void fetchProjectBasedOnTeam(AnalyticsTeam team) {
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> {
                this.cbbProjects.setEnabled(false);
                this.cbbProjects.setItems(new String[0]);
                this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_RETRIEVING_PROJECTS, false);
            });
            if (this.isOnPremUser) {
                this.fetchOnPremProjects();
            } else {
                this.fetchOnCloudProjects();
            }
            UISynchronizeService.syncExec(() -> {
                if (this.isOnPremUser) {
                    this.cbbTeams.setEnabled(true);
                }
                this.cbbProjects.setEnabled(true);
                this.setProjectsBasedOnTeam(this.projects);
            });
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnRefresh = this.createButton(parent, 4, "Refresh", true);
        this.btnGoToProject = this.createButton(parent, 3, "Go to Project", false);
        this.btnOk = this.createButton(parent, 2, "OK", true);
    }

    protected void registerControlModifyListeners() {
        this.btnGoToProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serverUrl;
                String url = serverUrl = TestOpsService.getActiveInstance().getTestOpsServer();
                if (!KatalonTestOpsIntegrationDialog.this.teams.isEmpty() && !KatalonTestOpsIntegrationDialog.this.teams.isEmpty()) {
                    if (KatalonTestOpsIntegrationDialog.this.projects.isEmpty()) {
                        String patternUrl = String.valueOf(serverUrl) + "/organization/{0}/home";
                        url = MessageFormat.format(patternUrl, KatalonTestOpsIntegrationDialog.this.organization.getId().toString());
                    } else {
                        AnalyticsProject project = KatalonTestOpsIntegrationDialog.this.projects.get(KatalonTestOpsIntegrationDialog.this.cbbProjects.getSelectionIndex());
                        if (StringUtils.isNotEmpty((CharSequence)project.getTeamId().toString())) {
                            String patternUrl = String.valueOf(serverUrl) + "/team/{0}/project/{1}";
                            url = MessageFormat.format(patternUrl, project.getTeamId().toString(), project.getId().toString());
                        }
                    }
                }
                Program.launch((String)url);
            }
        });
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KatalonTestOpsIntegrationDialog.this.updateDataStore(true);
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/RELOAD_DATA", (Object)true);
                EventBrokerSingleton.getInstance().getEventBroker().send("START_PAGE/RELOAD", null);
                KatalonTestOpsIntegrationDialog.this.okPressed();
            }
        });
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KatalonTestOpsIntegrationDialog.this.fillData();
            }
        });
        this.btnNewProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (KatalonTestOpsIntegrationDialog.this.isOnPremUser) {
                    AnalyticsProject createdProject;
                    NewProjectDialog dialog;
                    AnalyticsTeam team = null;
                    if (KatalonTestOpsIntegrationDialog.this.teams != null && KatalonTestOpsIntegrationDialog.this.teams.size() > 0) {
                        team = KatalonTestOpsIntegrationDialog.this.teams.get(0);
                    }
                    if ((dialog = new NewProjectDialog(KatalonTestOpsIntegrationDialog.this.btnNewProject.getDisplay().getActiveShell(), team)).open() == 0 && (createdProject = dialog.getAnalyticsProject()) != null) {
                        AnalyticsAuthorizationHandler.getToken((TestOpsService)TestOpsService.getActiveInstance(), (AnalyticsSettingStore)KatalonTestOpsIntegrationDialog.this.analyticsSettingStore);
                        KatalonTestOpsIntegrationDialog.this.fetchOnPremProjects();
                        if (KatalonTestOpsIntegrationDialog.this.projects == null) {
                            return;
                        }
                        KatalonTestOpsIntegrationDialog.this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(KatalonTestOpsIntegrationDialog.this.projects).toArray(new String[KatalonTestOpsIntegrationDialog.this.projects.size()]));
                        KatalonTestOpsIntegrationDialog.this.cbbProjects.select(AnalyticsAuthorizationHandler.getProjectIndex((AnalyticsProject)createdProject, KatalonTestOpsIntegrationDialog.this.projects));
                    }
                } else {
                    String url = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LINK_TO_PROJECTS_PAGE_BY_ORG_ID, KatalonTestOpsIntegrationDialog.this.organization.getId().toString());
                    Program.launch((String)url);
                }
            }
        });
        this.lnkStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
        if (this.isOnPremUser) {
            this.cbbTeams.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KatalonTestOpsIntegrationDialog.this.fetchProjectBasedOnTeam(KatalonTestOpsIntegrationDialog.this.teams.get(KatalonTestOpsIntegrationDialog.this.cbbTeams.getSelectionIndex()));
                }
            });
        }
    }

    private boolean updateDataStore(boolean enableIntegration) {
        block6: {
            block5: {
                try {
                    if (!this.isOnPremUser || this.cbbTeams.getSelectionIndex() != -1) break block5;
                    return false;
                }
                catch (IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
                    return false;
                }
            }
            if (this.cbbProjects.getSelectionIndex() != -1) break block6;
            return false;
        }
        if (enableIntegration) {
            this.analyticsSettingStore.enableIntegration(enableIntegration);
        }
        this.updateTeam();
        this.analyticsSettingStore.setProject(this.cbbProjects.getSelectionIndex() != -1 ? this.projects.get(this.cbbProjects.getSelectionIndex()) : null);
        this.analyticsSettingStore.setAutoSubmit(true);
        this.analyticsSettingStore.enableTestCloudIntegration(true);
        this.analyticsSettingStore.enableAutoUploadReport(true);
        return true;
    }

    private void updateTeam() throws IOException {
        if (this.teams != null && !this.teams.isEmpty()) {
            int index = 0;
            if (this.isOnPremUser) {
                index = this.cbbTeams.getSelectionIndex();
            }
            this.analyticsSettingStore.setTeam(this.teams.get(index));
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(500, initialSize.x), initialSize.y + 20);
    }

    protected void setInput() {
    }

    protected int getShellStyle() {
        return super.getShellStyle() & 0xFFFFFFEF;
    }
}

