/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.dialog.NewProjectDialog;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.handler.AnalyticsAuthorizationHandler;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Executors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UploadSelectionDialog
extends Dialog {
    public static final int UPLOAD_ID = 2;
    public static final int CANCEL_ID = 3;
    private Button btnUpload;
    private Button btnCancel;
    private Button btnCreate;
    private Combo cbbProjects;
    private Label lblStatus;
    private List<AnalyticsProject> projects;
    private AnalyticsSettingStore analyticsSettingStore;
    private AnalyticsOrganization organization;
    private boolean isOnPremUser = TestOpsService.getInstance().isOnPremUser();
    private Combo cbbTeams;
    private List<AnalyticsTeam> teams;

    public UploadSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        try {
            this.organization = this.analyticsSettingStore.getOrganization();
        }
        catch (Exception exception) {}
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridData bodyGridData = new GridData(4, 4, true, true);
        body.setLayoutData((Object)bodyGridData);
        GridLayout bodyGridLayout = new GridLayout(1, false);
        bodyGridLayout.marginWidth = 10;
        bodyGridLayout.marginHeight = 10;
        body.setLayout((Layout)bodyGridLayout);
        CLabel lblInformation = new CLabel(body, 64);
        lblInformation.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        lblInformation.setBottomMargin(2);
        String selectionInfo = this.isOnPremUser ? ComposerTestcaseMessageConstants.LBL_SELECTION_INFORMATION_FOR_ON_PREM_USER : ComposerTestcaseMessageConstants.LBL_SELECTION_INFORMATION_FOR_ON_CLOUD_USER;
        lblInformation.setText(selectionInfo);
        GridData gdLabel = new GridData(16384, 0x1000000, false, false);
        gdLabel.widthHint = 50;
        this.createTeamComposite(body, gdLabel);
        Composite projectComposite = new Composite(body, 0);
        projectComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout projectGridLayout = new GridLayout(3, false);
        projectGridLayout.marginWidth = 0;
        projectGridLayout.marginHeight = 0;
        projectComposite.setLayout((Layout)projectGridLayout);
        Label lblProject = new Label(projectComposite, 0);
        lblProject.setLayoutData((Object)gdLabel);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        this.cbbProjects = new Combo(projectComposite, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbProjects.setEnabled(false);
        this.btnCreate = new Button(projectComposite, 0);
        this.btnCreate.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_NEW_PROJECT);
        this.btnCreate.setEnabled(false);
        this.lblStatus = new Label(body, 0);
        this.connect();
        return body;
    }

    private void createTeamComposite(Composite body, GridData gdLabel) {
        if (this.isOnPremUser) {
            Composite teamComposite = new Composite(body, 0);
            teamComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            GridLayout teamGridLayout = new GridLayout(2, false);
            teamGridLayout.marginWidth = 0;
            teamGridLayout.marginHeight = 0;
            teamComposite.setLayout((Layout)teamGridLayout);
            Label lblTeam = new Label(teamComposite, 0);
            lblTeam.setLayoutData((Object)gdLabel);
            lblTeam.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEAM);
            this.cbbTeams = new Combo(teamComposite, 8);
            this.cbbTeams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.cbbTeams.setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnUpload = this.createButton(parent, 2, ComposerTestcaseMessageConstants.BTN_UPLOAD, true);
        this.btnUpload.setEnabled(false);
        this.btnCancel = this.createButton(parent, 3, ComposerTestcaseMessageConstants.BTN_CANCEL, false);
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnUpload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadSelectionDialog.this.handleUpload();
            }
        });
        this.btnCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadSelectionDialog.this.isOnPremUser) {
                    AnalyticsProject createdProject;
                    NewProjectDialog dialog;
                    AnalyticsTeam team = null;
                    if (UploadSelectionDialog.this.teams != null && UploadSelectionDialog.this.teams.size() > 0) {
                        AnalyticsTeam selectedTeam = UploadSelectionDialog.this.analyticsSettingStore.getManualTeam();
                        team = UploadSelectionDialog.this.teams.get(AnalyticsAuthorizationHandler.getTeamIndex(UploadSelectionDialog.this.teams, (AnalyticsTeam)selectedTeam));
                    }
                    if ((dialog = new NewProjectDialog(UploadSelectionDialog.this.btnCreate.getDisplay().getActiveShell(), team)).open() == 0 && (createdProject = dialog.getAnalyticsProject()) != null) {
                        try {
                            UploadSelectionDialog.this.analyticsSettingStore.setManualProject(createdProject);
                            UploadSelectionDialog.this.analyticsSettingStore.setManualTeam(team);
                            if (UploadSelectionDialog.this.projects == null) {
                                return;
                            }
                            UploadSelectionDialog.this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(UploadSelectionDialog.this.projects).toArray(new String[UploadSelectionDialog.this.projects.size()]));
                            UploadSelectionDialog.this.cbbProjects.select(AnalyticsAuthorizationHandler.getDefaultProjectIndex((AnalyticsSettingStore)UploadSelectionDialog.this.analyticsSettingStore, UploadSelectionDialog.this.projects));
                        }
                        catch (IOException ex) {
                            LoggerSingleton.logError((Throwable)ex);
                            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
                        }
                    }
                    UploadSelectionDialog.this.connect();
                } else {
                    String url = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LINK_TO_PROJECTS_PAGE_BY_ORG_ID, UploadSelectionDialog.this.organization.getId().toString());
                    Program.launch((String)url);
                }
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadSelectionDialog.this.cancelPressed();
            }
        });
        if (this.isOnPremUser) {
            this.cbbTeams.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UploadSelectionDialog.this.enableObject(false);
                    UploadSelectionDialog.this.cbbProjects.setItems(new String[0]);
                    Executors.newFixedThreadPool(1).submit(() -> {
                        UISynchronizeService.syncExec(() -> UploadSelectionDialog.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false));
                        UISynchronizeService.syncExec(() -> {
                            try {
                                AnalyticsTeam team = UploadSelectionDialog.this.teams.get(UploadSelectionDialog.this.cbbTeams.getSelectionIndex());
                                UploadSelectionDialog.this.analyticsSettingStore.setManualTeam(team);
                                AnalyticsAuthorizationHandler.getToken((TestOpsService)UploadSelectionDialog.this.getTestOpsService(), (AnalyticsSettingStore)UploadSelectionDialog.this.analyticsSettingStore);
                                UploadSelectionDialog.this.projects = AnalyticsAuthorizationHandler.getOnPremProjects((TestOpsService)UploadSelectionDialog.this.getTestOpsService(), (AnalyticsTeam)team);
                                UploadSelectionDialog.this.setProjectsBasedOnTeam(UploadSelectionDialog.this.projects);
                                UploadSelectionDialog.this.enableObject(true);
                                UploadSelectionDialog.this.enableCreateProject();
                                UploadSelectionDialog.this.setProgressMessage("", false);
                            }
                            catch (IOException ex) {
                                LoggerSingleton.logError((Throwable)ex);
                                MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
                            }
                        });
                    });
                }
            });
        }
    }

    private void enableCreateProject() {
        String role = "";
        role = this.isOnPremUser ? this.teams.get(this.cbbTeams.getSelectionIndex()).getRole() : this.organization.getRole();
        if (role.equals("USER")) {
            this.btnCreate.setEnabled(false);
        } else {
            this.btnCreate.setEnabled(true);
        }
    }

    private void setProjectsBasedOnTeam(List<AnalyticsProject> projects) {
        if (projects != null && !projects.isEmpty()) {
            this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(projects).toArray(new String[projects.size()]));
            AnalyticsProject selectedProject = this.analyticsSettingStore.getManualProject();
            this.cbbProjects.select(AnalyticsAuthorizationHandler.getProjectIndex((AnalyticsProject)selectedProject, projects));
        }
    }

    private void fetchProjects() {
        if (this.isOnPremUser) {
            this.teams = AnalyticsAuthorizationHandler.getTeams((TestOpsService)this.getTestOpsService(), (Long)this.organization.getId());
            AnalyticsTeam manualTeam = this.analyticsSettingStore.getManualTeam();
            AnalyticsTeam defaultTeam = this.teams.get(AnalyticsAuthorizationHandler.getTeamIndex(this.teams, (AnalyticsTeam)manualTeam));
            this.projects = AnalyticsAuthorizationHandler.getOnPremProjects((TestOpsService)this.getTestOpsService(), (AnalyticsTeam)defaultTeam);
        } else {
            this.projects = AnalyticsAuthorizationHandler.getOnCloudProjects((TestOpsService)this.getTestOpsService(), (AnalyticsOrganization)this.organization);
        }
    }

    private void connect() {
        AnalyticsAuthorizationHandler.getToken((TestOpsService)this.getTestOpsService(), (AnalyticsSettingStore)this.analyticsSettingStore);
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false));
            UISynchronizeService.syncExec(() -> {
                this.fetchProjects();
                this.fillData();
                this.enableObject(true);
                this.enableCreateProject();
                this.setProgressMessage("", false);
            });
        });
    }

    private void enableObject(boolean isEnable) {
        if (this.isOnPremUser) {
            this.cbbTeams.setEnabled(isEnable);
        }
        this.cbbProjects.setEnabled(isEnable);
        this.btnUpload.setEnabled(isEnable);
    }

    private void fillData() {
        try {
            if (this.isOnPremUser) {
                this.cbbTeams.setItems(AnalyticsAuthorizationHandler.getTeamNames(this.teams).toArray(new String[this.teams.size()]));
                AnalyticsTeam manualTeam = this.analyticsSettingStore.getManualTeam();
                this.cbbTeams.select(AnalyticsAuthorizationHandler.getTeamIndex(this.teams, (AnalyticsTeam)manualTeam));
            }
            this.setProjectsBasedOnTeam(this.projects);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void setProgressMessage(String message, boolean isError) {
        this.lblStatus.setText(message);
        if (isError) {
            this.lblStatus.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lblStatus.setForeground(ColorUtil.getTextRunningColor());
        }
        this.lblStatus.getParent().layout();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerTestcaseMessageConstants.SELECTION_DIALOG_TITLE);
    }

    private void closeDialog() {
        this.close();
    }

    protected boolean isResizable() {
        return true;
    }

    private void handleUpload() {
        try {
            if (this.isOnPremUser) {
                AnalyticsTeam team = null;
                if (this.teams != null && this.teams.size() > 0) {
                    team = this.teams.get(this.cbbTeams.getSelectionIndex());
                }
                this.analyticsSettingStore.setManualTeam(team);
            }
            this.analyticsSettingStore.setManualProject(this.cbbProjects.getSelectionIndex() != -1 ? this.projects.get(this.cbbProjects.getSelectionIndex()) : null);
        }
        catch (IOException e1) {
            LoggerSingleton.logError((Throwable)e1);
        }
        this.setReturnCode(2);
        this.closeDialog();
    }

    private TestOpsService getTestOpsService() {
        return TestOpsService.getActiveInstance();
    }

    static /* synthetic */ void access$0(UploadSelectionDialog uploadSelectionDialog, String string, boolean bl) {
        uploadSelectionDialog.setProgressMessage(string, bl);
    }

    static /* synthetic */ List access$1(UploadSelectionDialog uploadSelectionDialog) {
        return uploadSelectionDialog.teams;
    }

    static /* synthetic */ Combo access$2(UploadSelectionDialog uploadSelectionDialog) {
        return uploadSelectionDialog.cbbTeams;
    }

    static /* synthetic */ AnalyticsSettingStore access$3(UploadSelectionDialog uploadSelectionDialog) {
        return uploadSelectionDialog.analyticsSettingStore;
    }

    static /* synthetic */ TestOpsService access$4(UploadSelectionDialog uploadSelectionDialog) {
        return uploadSelectionDialog.getTestOpsService();
    }

    static /* synthetic */ void access$5(UploadSelectionDialog uploadSelectionDialog, List list) {
        uploadSelectionDialog.projects = list;
    }

    static /* synthetic */ List access$6(UploadSelectionDialog uploadSelectionDialog) {
        return uploadSelectionDialog.projects;
    }

    static /* synthetic */ void access$7(UploadSelectionDialog uploadSelectionDialog, List list) {
        uploadSelectionDialog.setProjectsBasedOnTeam(list);
    }

    static /* synthetic */ void access$8(UploadSelectionDialog uploadSelectionDialog, boolean bl) {
        uploadSelectionDialog.enableObject(bl);
    }

    static /* synthetic */ void access$9(UploadSelectionDialog uploadSelectionDialog) {
        uploadSelectionDialog.enableCreateProject();
    }
}

