/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.handlers;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsUploadInfo;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.util.ZipHelper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;

public class AnalyticsGridHandler {
    public static AnalyticsTestProject uploadProject(final String nameFileZip, final AnalyticsProject sellectProject, final String folderCurrentProject, ProgressMonitorDialog monitorDialog) {
        final AnalyticsTestProject testProject = new AnalyticsTestProject();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_TITLE_UPLOAD_CODE, 5);
                            monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_COMPRESSING_PROJECT);
                            String tempDir = ProjectController.getInstance().getTempDir();
                            File zipTeamFile = new File(tempDir, String.valueOf(nameFileZip) + ".zip");
                            try {
                                try {
                                    TestOpsService testOpsService = TestOpsService.getActiveInstance();
                                    ZipHelper.Compress((String)folderCurrentProject, (String)zipTeamFile.toString());
                                    monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_REQUEST_SERVER);
                                    monitor.worked(2);
                                    AnalyticsUploadInfo uploadInfo = testOpsService.getUploadInfo(sellectProject.getId().longValue());
                                    testOpsService.uploadFileWithRetry(uploadInfo.getUploadUrl(), zipTeamFile);
                                    monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_GET_TEAM_PROJECT);
                                    monitor.worked(1);
                                    long timestamp = System.currentTimeMillis();
                                    Long teamId = sellectProject.getTeamId();
                                    Long projectId = sellectProject.getId();
                                    monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_UPLOAD);
                                    monitor.worked(1);
                                    AnalyticsTestProject newTestProject = testOpsService.uploadTestProject(projectId.longValue(), teamId.longValue(), timestamp, nameFileZip, zipTeamFile.toString(), zipTeamFile.getName().toString(), uploadInfo.getPath());
                                    testProject.setId(newTestProject.getId());
                                    testProject.setName(newTestProject.getName());
                                    testProject.setDescription(newTestProject.getDescription());
                                    testProject.setTestSuiteCollections(newTestProject.getTestSuiteCollections());
                                }
                                catch (Exception exception) {
                                    throw new InvocationTargetException(exception);
                                }
                            }
                            finally {
                                zipTeamFile.deleteOnExit();
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {}
        return testProject;
    }

    public static AnalyticsTestProject updateProject(final AnalyticsTestProject testProject, final String nameFileZip, final AnalyticsProject sellectProject, final String folderCurrentProject, ProgressMonitorDialog monitorDialog) {
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_TITLE_UPLOAD_CODE, 5);
                            monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_COMPRESSING_PROJECT);
                            String tempDir = ProjectController.getInstance().getTempDir();
                            File zipTeamFile = new File(tempDir, String.valueOf(nameFileZip) + ".zip");
                            try {
                                try {
                                    TestOpsService testOpsService = TestOpsService.getActiveInstance();
                                    ZipHelper.Compress((String)folderCurrentProject, (String)zipTeamFile.toString());
                                    monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_REQUEST_SERVER);
                                    monitor.worked(2);
                                    AnalyticsUploadInfo uploadInfo = testOpsService.getUploadInfo(sellectProject.getId().longValue());
                                    testOpsService.uploadFile(uploadInfo.getUploadUrl(), zipTeamFile);
                                    monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_GET_TEAM_PROJECT);
                                    monitor.worked(1);
                                    long timestamp = System.currentTimeMillis();
                                    monitor.subTask(IntegrationAnalyticsMessages.STORE_CODE_UPLOAD);
                                    monitor.worked(1);
                                    testOpsService.updateTestProject(testProject.getId().longValue(), timestamp, "", zipTeamFile.getName().toString(), uploadInfo.getPath());
                                }
                                catch (Exception exception) {
                                    throw new InvocationTargetException(exception);
                                }
                            }
                            finally {
                                zipTeamFile.deleteOnExit();
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {}
        return testProject;
    }

    public static void createTestPlan(String testPlanName, final AnalyticsProject project, ProgressMonitorDialog monitorDialog) {
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_CREATE_TEST_PLAN, 1);
                            Long teamId = project.getTeamId();
                            Long projectId = project.getId();
                            URIBuilder builder = new URIBuilder(TestOpsService.getActiveInstance().getTestOpsServer());
                            builder.setPath(String.format("/team/%d/project/%d/test-planning", teamId, projectId));
                            builder.addParameter("isOpenScheduleTestRunDialog", "true");
                            Program.launch((String)builder.toString());
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }
}

