/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.utils;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.analytics.entity.AnalyticsPlan;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsRelease;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.text.MessageFormat;

public class TestOpsUtil {
    public static final String TEMPLATE_PAGE_EXECUTION_ALL = "{0}/team/{1}/project/{2}/executions";
    public static final String TEMPLATE_PAGE_PLAN_ALL = "{0}/team/{1}/project/{2}/grid";
    public static final String TEMPLATE_PAGE_RELEASE_ALL = "{0}/team/{1}/project/{2}/releases";
    public static final String TEMPLATE_PAGE_PLAN = "{0}/team/{1}/project/{2}/grid/plan/{3}/job";
    public static final String TEMPLATE_PAGE_RELEASE = "{0}/team/{1}/project/{2}/releases/{3}";

    private TestOpsUtil() {
    }

    public static String truncateURL(String url) {
        return url.replaceAll("/+$", "");
    }

    public static String getExecutionsPageURL() {
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = analyticsSettingStore.getProject();
        AnalyticsTeam team = analyticsSettingStore.getTeam();
        String serverUrl = TestOpsUtil.truncateURL(analyticsSettingStore.getServerEndpoint());
        return MessageFormat.format(TEMPLATE_PAGE_EXECUTION_ALL, serverUrl, String.valueOf(team.getId()), String.valueOf(project.getId()));
    }

    public static String getPlansPageURL() {
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = analyticsSettingStore.getProject();
        AnalyticsTeam team = analyticsSettingStore.getTeam();
        String serverUrl = TestOpsUtil.truncateURL(analyticsSettingStore.getServerEndpoint());
        return MessageFormat.format(TEMPLATE_PAGE_PLAN_ALL, serverUrl, String.valueOf(team.getId()), String.valueOf(project.getId()));
    }

    public static String getPlanUrl(AnalyticsPlan plan) {
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = analyticsSettingStore.getProject();
        AnalyticsTeam team = analyticsSettingStore.getTeam();
        String serverUrl = TestOpsUtil.truncateURL(analyticsSettingStore.getServerEndpoint());
        return MessageFormat.format(TEMPLATE_PAGE_PLAN, serverUrl, String.valueOf(team.getId()), String.valueOf(project.getId()), String.valueOf(plan.getId()));
    }

    public static String getReleaseUrl(AnalyticsRelease release) {
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = analyticsSettingStore.getProject();
        AnalyticsTeam team = analyticsSettingStore.getTeam();
        String serverUrl = TestOpsUtil.truncateURL(analyticsSettingStore.getServerEndpoint());
        return MessageFormat.format(TEMPLATE_PAGE_RELEASE, serverUrl, String.valueOf(team.getId()), String.valueOf(project.getId()), String.valueOf(release.getId()));
    }

    public static String getReleasesPageURL() {
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = analyticsSettingStore.getProject();
        AnalyticsTeam team = analyticsSettingStore.getTeam();
        String serverUrl = TestOpsUtil.truncateURL(analyticsSettingStore.getServerEndpoint());
        return MessageFormat.format(TEMPLATE_PAGE_RELEASE_ALL, serverUrl, String.valueOf(team.getId()), String.valueOf(project.getId()));
    }
}

