/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.authenticate.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Strings;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.authenticate.model.ValidateTokenRequest;

public class ValidateTokenRequestMarshaller
extends AbstractMarshaller<Request, ValidateTokenRequest> {
    @Override
    protected void validateRequest(ValidateTokenRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to call(...)");
        }
        if (Strings.isNullOrEmpty(in.getToken())) {
            throw new AuthClientException("Invalid token value passed to call(...)");
        }
    }

    @Override
    protected void build(Request request, ValidateTokenRequest in) {
        super.build(request, in);
        request.setHeader("Authorization", in.getToken());
    }

    @Override
    protected String getServiceName() {
        return "AuthenticateService";
    }

    @Override
    protected String getActionName() {
        return "ValidateToken";
    }

    @Override
    protected String getContent(ValidateTokenRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(ValidateTokenRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/re-evaluation");
    }
}

