/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.qas.qtest.api.internal.model.QTestBaseModel;

public final class Permissions
extends QTestBaseModel<Permissions> {
    @JsonIgnore
    private PermissionType type;

    public Permissions() {
    }

    public Permissions(Map<String, Object> permissions) {
        if (null != permissions) {
            this.properties.putAll(permissions);
        }
    }

    public boolean hasPermission(String name) {
        Object value = this.getProperty(name);
        if (value == null || !(value instanceof Boolean)) {
            return false;
        }
        return (Boolean)value;
    }

    public Permissions setPermission(String name, Boolean value) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            this.setProperty(name, value);
        }
        return this;
    }

    public Permissions withPermission(String name, Boolean value) {
        this.setPermission(name, value);
        return this;
    }

    public void setType(PermissionType type) {
        this.type = type;
    }

    public Permissions withType(PermissionType type) {
        this.setType(type);
        return this;
    }

    public PermissionType getType() {
        return this.type;
    }

    @Override
    public Permissions clone() {
        Permissions that = new Permissions();
        that.withType(this.type).setPropertiesFrom(this);
        return that;
    }

    public String getTypeName() {
        return this.type.typeName();
    }

    @Override
    public String elementName() {
        return this.type.typeName();
    }

    public static enum PermissionType {
        DEFECT("defect", 3),
        MODULE("module", 9),
        REQUIREMENT("requirement", 2),
        TEST_CASE("test_case", 1),
        TEST_RUN("test_run", 14),
        RELEASE("release", 8),
        BUILD("build", 7),
        TEST_CYCLE("test_cycle", 17),
        TEST_SUITE("test_suite", 12),
        PROJECT("project", 61),
        PROJECT_SETTING("project_setting", 62),
        QMAP("qmap", 63),
        SESSION("session", 64),
        UNKNOWN("unknown", 0);

        private String typeName;
        private int typeValue;

        private PermissionType(String typeName, int typeValue) {
            this.typeName = typeName;
            this.typeValue = typeValue;
        }

        public static PermissionType resolve(String typeName) {
            String lcType = typeName == null ? "" : typeName.toLowerCase();
            for (PermissionType value : PermissionType.values()) {
                if (!value.typeName.equals(lcType)) continue;
                return value;
            }
            return UNKNOWN;
        }

        public static PermissionType resolve(int typeValue) {
            for (PermissionType value : PermissionType.values()) {
                if (value.typeValue != typeValue) continue;
                return value;
            }
            return UNKNOWN;
        }

        public String typeName() {
            return this.typeName;
        }

        public int typeValue() {
            return this.typeValue;
        }
    }
}

