/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.CreateModuleRequest;
import org.qas.qtest.api.services.project.model.transform.AbstractModuleRequestMarshaller;

public final class CreateModuleRequestMarshaller
extends AbstractModuleRequestMarshaller<CreateModuleRequest> {
    @Override
    public Request marshall(CreateModuleRequest createModuleRequest) throws Exception {
        createModuleRequest = ApiPreconditions.notNull(createModuleRequest);
        CreateModuleRequestMarshaller.validateProjectId(createModuleRequest.getProjectId());
        ApiPreconditions.notNull(createModuleRequest.getModule(), "Invalid module passed to marshall(...)");
        ApiPreconditions.checkArgument(createModuleRequest.getParentId() == null || createModuleRequest.getParentId() > 0L, "Invalid parent identifier passed to marshall(...)");
        Request request = this.createJsonRequest(createModuleRequest, "CreateModule", HttpMethod.POST);
        request.setResourcePath(this.createApiPathBuilder(createModuleRequest.getProjectId()).toString());
        if (createModuleRequest.getParentId() != null && createModuleRequest.getParentId() > 0L) {
            request.addParameter("parentId", String.valueOf(createModuleRequest.getParentId()));
        }
        createModuleRequest.getModule().setParentId(createModuleRequest.getParentId());
        request.setContent(new StringInputStream(JsonMapper.toJson(createModuleRequest.getModule())));
        return request;
    }
}

